/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.wizards;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.wizards.SelectLanguageConfigurationWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public final class LanguageConfigurationImportWizard
extends Wizard
implements IImportWizard {
    private final ILanguageConfigurationRegistryManager.EditSession manager;
    private final boolean saveOnFinish;
    private SelectLanguageConfigurationWizardPage mainPage = (SelectLanguageConfigurationWizardPage)((Object)NullSafetyHelper.lateNonNull());
    private ILanguageConfigurationDefinition createdDefinition = (ILanguageConfigurationDefinition)NullSafetyHelper.lateNonNull();

    public LanguageConfigurationImportWizard(ILanguageConfigurationRegistryManager.EditSession manager, boolean saveOnFinish) {
        this.manager = manager;
        this.saveOnFinish = saveOnFinish;
    }

    public void addPages() {
        this.mainPage = new SelectLanguageConfigurationWizardPage(this.manager);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        ILanguageConfigurationDefinition definition = this.mainPage.getDefinition();
        this.manager.registerLanguageConfigurationDefinition(definition);
        if (this.saveOnFinish) {
            try {
                this.manager.save();
            }
            catch (BackingStoreException ex) {
                LanguageConfigurationPlugin.logError(ex);
                return false;
            }
        }
        this.createdDefinition = definition;
        return true;
    }

    public void init(@Nullable IWorkbench workbench, @Nullable IStructuredSelection selection) {
    }

    public ILanguageConfigurationDefinition getCreatedDefinition() {
        return this.createdDefinition;
    }
}

