/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.commonui;

import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASADefaultWrapper;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TypeOfDefault;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASADefaultWrapperImpl;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.ASASQLDataOfflineValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.commonui.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.ASADatatypeUtil;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColumnDefaultValueInputDialog
extends TitleAreaDialog {
    Button _noDefaultRadio;
    Button _defaultValueRadio;
    Button _computedValueRadio;
    Button _userDefinedDefaultRadio;
    Button _sysDefinedDefaultRadio;
    Text _defaultValueTxt;
    Button _isDefaultLiteralButton;
    Combo _sysDefinedValuesCombo;
    Text _partitionSizeTxt;
    Text _computedText;
    Label _partionSizeLabel;
    SybaseASABaseColumn _column;
    SybaseASADefaultWrapper _defaultWrapper;
    String _message;
    boolean _disableComputed = false;

    public ColumnDefaultValueInputDialog(Shell parentShell, SybaseASABaseColumn column) {
        super(parentShell);
        this._column = column;
        this._defaultWrapper = new SybaseASADefaultWrapperImpl(this._column.getDefaultValue(), this._column.isIsComputedColumn());
        this._message = Messages.ColumnDefaultValueInputDialog_default_value_for_ASA_table;
    }

    public ColumnDefaultValueInputDialog(Shell parentShell, SybaseASABaseColumn column, boolean disableComputed) {
        super(parentShell);
        this._column = column;
        this._defaultWrapper = new SybaseASADefaultWrapperImpl(this._column.getDefaultValue(), this._column.isIsComputedColumn());
        this._message = Messages.ColumnDefaultValueInputDialog_default_value_for_ASA_table;
        this._disableComputed = disableComputed;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ColumnDefaultValueInputDialog_default_value);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite outter = new Composite(parent, 0);
        outter.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        outter.setLayout((Layout)layout);
        this._noDefaultRadio = new Button(outter, 16);
        this._noDefaultRadio.setText(Messages.ColumnDefaultValueInputDialog_no_default);
        this._noDefaultRadio.setToolTipText(Messages.ColumnDefaultValueInputDialog_no_default_tip);
        this._noDefaultRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this.enableDefaultValue(ColumnDefaultValueInputDialog.this._defaultValueRadio.getSelection());
                ColumnDefaultValueInputDialog.this._computedText.setEnabled(ColumnDefaultValueInputDialog.this._computedValueRadio.getSelection());
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        this._defaultValueRadio = new Button(outter, 16);
        this._defaultValueRadio.setText(Messages.ColumnDefaultValueInputDialog_default_value_radio);
        this._defaultValueRadio.setToolTipText(Messages.ColumnDefaultValueInputDialog_default_tip);
        this._defaultValueRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this.enableDefaultValue(ColumnDefaultValueInputDialog.this._defaultValueRadio.getSelection());
                ColumnDefaultValueInputDialog.this._computedText.setEnabled(ColumnDefaultValueInputDialog.this._computedValueRadio.getSelection());
                if (ColumnDefaultValueInputDialog.this._defaultValueRadio.getSelection()) {
                    ColumnDefaultValueInputDialog.this._userDefinedDefaultRadio.notifyListeners(13, new Event());
                }
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        Composite comp = new Composite(outter, 0);
        layout = new GridLayout();
        layout.numColumns = 5;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Label blankLabel = new Label(comp, 0);
        GridData gd = new GridData();
        gd.widthHint = 50;
        blankLabel.setLayoutData((Object)gd);
        this._userDefinedDefaultRadio = new Button(comp, 16);
        this._userDefinedDefaultRadio.setSelection(true);
        this._userDefinedDefaultRadio.setText(Messages.ColumnDefaultValueInputDialog_user_defined);
        this._userDefinedDefaultRadio.setToolTipText(Messages.ColumnDefaultValueInputDialog_ud_default_tip);
        this._userDefinedDefaultRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this._defaultValueTxt.notifyListeners(24, new Event());
                ColumnDefaultValueInputDialog.this.enableUserDefinedPart(ColumnDefaultValueInputDialog.this._userDefinedDefaultRadio.getSelection());
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        this._defaultValueTxt = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 120;
        this._defaultValueTxt.setLayoutData((Object)gd);
        this._defaultValueTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        this._isDefaultLiteralButton = new Button(comp, 32);
        this._isDefaultLiteralButton.setText(Messages.ColumnDefaultValueInputDialog_literal_string);
        this._isDefaultLiteralButton.setToolTipText(Messages.ColumnDefaultValueInputDialog_literal_tip);
        this._isDefaultLiteralButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this._isDefaultLiteralButton.setLayoutData((Object)gd);
        blankLabel = new Label(comp, 0);
        gd = new GridData();
        gd.widthHint = 50;
        blankLabel.setLayoutData((Object)gd);
        this._sysDefinedDefaultRadio = new Button(comp, 16);
        this._sysDefinedDefaultRadio.setText(Messages.ColumnDefaultValueInputDialog_system_defined);
        this._sysDefinedDefaultRadio.setToolTipText(Messages.ColumnDefaultValueInputDialog_system_defined_default_tip);
        this._sysDefinedDefaultRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this.enableUserDefinedPart(ColumnDefaultValueInputDialog.this._userDefinedDefaultRadio.getSelection());
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        this._sysDefinedValuesCombo = new Combo(comp, 8);
        gd = new GridData();
        gd.widthHint = 101;
        this._sysDefinedValuesCombo.setLayoutData((Object)gd);
        this._sysDefinedValuesCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ColumnDefaultValueInputDialog.this._sysDefinedDefaultRadio.getSelection() && ColumnDefaultValueInputDialog.this._sysDefinedValuesCombo.getText().equals("global autoincrement")) {
                    ColumnDefaultValueInputDialog.this._partionSizeLabel.setEnabled(true);
                    ColumnDefaultValueInputDialog.this._partitionSizeTxt.setEnabled(true);
                    ColumnDefaultValueInputDialog.this._partitionSizeTxt.notifyListeners(24, new Event());
                } else {
                    ColumnDefaultValueInputDialog.this._partionSizeLabel.setEnabled(false);
                    ColumnDefaultValueInputDialog.this._partitionSizeTxt.setEnabled(false);
                    ColumnDefaultValueInputDialog.this.getButton(0).setEnabled(true);
                    ColumnDefaultValueInputDialog.this.setMessage(ColumnDefaultValueInputDialog.this._message);
                }
            }
        });
        this._partionSizeLabel = new Label(comp, 0);
        this._partionSizeLabel.setText(Messages.ColumnDefaultValueInputDialog_partition_size);
        this._partitionSizeTxt = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 120;
        this._partitionSizeTxt.setLayoutData((Object)gd);
        this._partitionSizeTxt.setToolTipText(Messages.ColumnDefaultValueInputDialog_partition_size_tip);
        this._partitionSizeTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block5: {
                    if (!ColumnDefaultValueInputDialog.this._partitionSizeTxt.getText().trim().equals("")) {
                        try {
                            int partitionSize = Integer.parseInt(ColumnDefaultValueInputDialog.this._partitionSizeTxt.getText().trim());
                            if (partitionSize > 0) {
                                ColumnDefaultValueInputDialog.this.setMessage(ColumnDefaultValueInputDialog.this._message);
                                ColumnDefaultValueInputDialog.this.getButton(0).setEnabled(true);
                                break block5;
                            }
                            ColumnDefaultValueInputDialog.this.setMessage(Messages.ColumnDefaultValueInputDialog_should_be_positive, 3);
                            ColumnDefaultValueInputDialog.this.getButton(0).setEnabled(false);
                        }
                        catch (Exception exception) {
                            ColumnDefaultValueInputDialog.this.setMessage(String.valueOf(Messages.ColumnDefaultValueInputDialog_not_valid_number) + ColumnDefaultValueInputDialog.this._partitionSizeTxt.getText(), 3);
                            ColumnDefaultValueInputDialog.this.getButton(0).setEnabled(false);
                        }
                    } else {
                        ColumnDefaultValueInputDialog.this.setMessage(ColumnDefaultValueInputDialog.this._message);
                        ColumnDefaultValueInputDialog.this.getButton(0).setEnabled(true);
                    }
                }
            }
        });
        this._computedValueRadio = new Button(outter, 16);
        this._computedValueRadio.setText(Messages.ColumnDefaultValueInputDialog_computed_value);
        this._computedValueRadio.setToolTipText(Messages.ColumnDefaultValueInputDialog_computed_value_tip);
        this._computedValueRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnDefaultValueInputDialog.this._computedText.setEnabled(ColumnDefaultValueInputDialog.this._computedValueRadio.getSelection());
                ColumnDefaultValueInputDialog.this.enableDefaultValue(ColumnDefaultValueInputDialog.this._defaultValueRadio.getSelection());
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        Composite computedTextComp = new Composite(outter, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        computedTextComp.setLayout((Layout)layout);
        computedTextComp.setLayoutData((Object)new GridData(768));
        blankLabel = new Label(computedTextComp, 0);
        gd = new GridData();
        gd.widthHint = 50;
        blankLabel.setLayoutData((Object)gd);
        this._computedText = new Text(computedTextComp, 2050);
        gd = new GridData(768);
        gd.heightHint = 60;
        this._computedText.setLayoutData((Object)gd);
        this._computedText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnDefaultValueInputDialog.this.validateDefaultAndUpdate();
            }
        });
        Label sep = new Label(outter, 258);
        sep.setLayoutData((Object)new GridData(768));
        Composite buttonComp = new Composite(outter, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(768));
        blankLabel = new Label(buttonComp, 0);
        blankLabel.setLayoutData((Object)new GridData(768));
        return outter;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.initialize();
        this.setTitle(Messages.ColumnDefaultValueInputDialog_default_value_2);
        this.setMessage(this._message);
        if (this._disableComputed) {
            this.setMessage(Messages.ColumnDefaultValueInputDialog_can_not_set_computed_value, 1);
        }
        return c;
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        String stringValue = "";
        this._column.setIsComputedColumn(false);
        if (this._noDefaultRadio.getSelection()) {
            stringValue = null;
        }
        if (this._defaultValueRadio.getSelection()) {
            if (this._userDefinedDefaultRadio.getSelection()) {
                stringValue = this._defaultValueTxt.getText();
                if (this._isDefaultLiteralButton.getSelection()) {
                    stringValue = SQLUtil.quote((String)stringValue, (String)"'");
                }
            }
            if (this._sysDefinedDefaultRadio.getSelection() && (stringValue = this._sysDefinedValuesCombo.getText()).equals("global autoincrement") && !this._partitionSizeTxt.getText().trim().equals("")) {
                stringValue = String.valueOf(stringValue) + "(" + Integer.parseInt(this._partitionSizeTxt.getText().trim()) + ")";
            }
        }
        if (this._computedValueRadio.getSelection()) {
            this._column.setIsComputedColumn(true);
            stringValue = this._computedText.getText();
        }
        if (stringValue != null && stringValue.equals("")) {
            stringValue = null;
        }
        this._column.setDefaultValue(stringValue);
        if (this._computedValueRadio.getSelection()) {
            this._column.setIsComputedColumn(true);
        } else {
            this._column.setIsComputedColumn(false);
        }
        super.okPressed();
    }

    private void validateDefaultAndUpdate() {
        if (this._noDefaultRadio.getSelection() || this._computedValueRadio.getSelection() && this._computedText.getText().trim().length() != 0) {
            this.setMessage(this._message);
            this.getButton(0).setEnabled(true);
            return;
        }
        if (this._defaultValueRadio.getSelection() && this._sysDefinedDefaultRadio.getSelection()) {
            if (this._sysDefinedValuesCombo.getText().equals("")) {
                this.setMessage(Messages.ColumnDefaultValueInputDialog_select_a_system_default, 1);
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
            return;
        }
        if (this._defaultValueRadio.getSelection() && this._userDefinedDefaultRadio.getSelection()) {
            if (this._defaultValueTxt.getText().trim().length() == 0) {
                this.setMessage(Messages.ColumnDefaultValueInputDialog_input_default, 1);
                this.getButton(0).setEnabled(false);
                return;
            }
            this.setMessage(this._message);
            this.getButton(0).setEnabled(true);
            ASASQLDataOfflineValidator validator = new ASASQLDataOfflineValidator();
            String errorMsg = validator.validate(this._column.getDataType(), this._isDefaultLiteralButton.getSelection() ? SQLUtil.quote((String)this._defaultValueTxt.getText(), (String)"'") : this._defaultValueTxt.getText());
            if (errorMsg != null) {
                this.setMessage(errorMsg, 3);
                this.getButton(0).setEnabled(false);
            } else {
                this.setMessage(this._message);
                this.getButton(0).setEnabled(true);
            }
        } else {
            this.setMessage(Messages.ColumnDefaultValueInputDialog_input_compute, 1);
            this.getButton(0).setEnabled(false);
            return;
        }
    }

    private void enableDefaultValue(boolean enabled) {
        this._userDefinedDefaultRadio.setEnabled(enabled);
        this._defaultValueTxt.setEnabled(enabled);
        this._isDefaultLiteralButton.setEnabled(enabled);
        this._sysDefinedDefaultRadio.setEnabled(enabled && this._column.getDataType() != null);
        this._sysDefinedValuesCombo.setEnabled(enabled && this._column.getDataType() != null);
        this._sysDefinedValuesCombo.notifyListeners(13, new Event());
        if (enabled) {
            this._userDefinedDefaultRadio.notifyListeners(13, new Event());
        }
    }

    private void enableUserDefinedPart(boolean enabled) {
        this._defaultValueTxt.setEnabled(enabled);
        this._isDefaultLiteralButton.setEnabled(enabled);
        this._sysDefinedValuesCombo.setEnabled(!enabled);
        this._sysDefinedValuesCombo.notifyListeners(13, new Event());
    }

    private void initialize() {
        if (this._disableComputed) {
            this._computedValueRadio.setEnabled(false);
            this._computedText.setEnabled(false);
        }
        if (this._column != null && this._column.getDataType() != null) {
            DataType dType = this._column.getDataType();
            if (ASADatatypeUtil.isStringType(dType)) {
                this._sysDefinedValuesCombo.setItems(SybaseASADefaultWrapper.STRING_TYPE_SYSTEM_DEFAULTS);
                this._isDefaultLiteralButton.setSelection(true);
            } else if (ASADatatypeUtil.isNumericType(dType)) {
                this._sysDefinedValuesCombo.setItems(SybaseASADefaultWrapper.NUMERIC_TYPE_SYSTEM_DEFAULTS);
            } else if (ASADatatypeUtil.isTimeType(dType)) {
                this._sysDefinedValuesCombo.setItems(SybaseASADefaultWrapper.TIME_TYPE_SYSTEM_DEFAULTS);
                this._isDefaultLiteralButton.setSelection(true);
            } else if (ASADatatypeUtil.isDateType(dType)) {
                this._sysDefinedValuesCombo.setItems(SybaseASADefaultWrapper.DATE_TYPE_SYSTEM_DEFAULTS);
                this._isDefaultLiteralButton.setSelection(true);
            } else if (ASADatatypeUtil.isTSType(dType)) {
                this._sysDefinedValuesCombo.setItems(SybaseASADefaultWrapper.TS_TYPE_SYSTEM_DEFAULTS);
                this._isDefaultLiteralButton.setSelection(true);
            } else if (ASADatatypeUtil.isBinaryType(dType)) {
                this._sysDefinedValuesCombo.setItems(SybaseASADefaultWrapper.BINARY_TYPE_SYSTEM_DEFAULTS);
            }
        }
        if (this._column.getDefaultValue() == null) {
            this._noDefaultRadio.setSelection(true);
            this._noDefaultRadio.notifyListeners(13, new Event());
            return;
        }
        if (this._defaultWrapper.getType() == TypeOfDefault.SYSTEM_DEFINED_LITERAL) {
            this._defaultValueRadio.setSelection(true);
            this._sysDefinedDefaultRadio.setSelection(true);
            this._userDefinedDefaultRadio.setSelection(false);
            int index = this.getIndex(this._defaultWrapper.getRawValue(), this._sysDefinedValuesCombo.getItems());
            if (index > -1) {
                this._sysDefinedValuesCombo.select(index);
            }
            if (this._defaultWrapper.getRawValue().equals("global autoincrement") && this._defaultWrapper.getPartitionSize() > 0) {
                this._partitionSizeTxt.setText(Integer.toString(this._defaultWrapper.getPartitionSize()));
            }
            this._defaultValueRadio.notifyListeners(13, new Event());
            this._sysDefinedDefaultRadio.notifyListeners(13, new Event());
            return;
        }
        if (this._defaultWrapper.getType() == TypeOfDefault.USER_DEFINED_LITERAL) {
            this._defaultValueRadio.setSelection(true);
            this._sysDefinedDefaultRadio.setSelection(false);
            this._userDefinedDefaultRadio.setSelection(true);
            this._defaultValueRadio.notifyListeners(13, new Event());
            this._userDefinedDefaultRadio.notifyListeners(13, new Event());
            this._defaultValueTxt.setText(this._defaultWrapper.getRawValue());
            this._isDefaultLiteralButton.setSelection(this._defaultWrapper.isIsLiteral());
            this.validateDefaultAndUpdate();
            return;
        }
        if (this._defaultWrapper.getType() == TypeOfDefault.COMPUTED_VALUE_LITERAL) {
            this._computedValueRadio.setSelection(true);
            this._computedValueRadio.notifyListeners(13, new Event());
            this._computedText.setText(this._column.getDefaultValue());
            return;
        }
    }

    private int getIndex(String item, String[] items) {
        if (items == null || item == null) {
            return -1;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

