/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.util;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.builds.ui.util.Messages;
import org.eclipse.mylyn.internal.builds.ui.util.TestResultManager;
import org.eclipse.osgi.util.NLS;

class TestResultSession
extends TestRunSession {
    TestResultSession(IBuild build) {
        super(NLS.bind((String)Messages.TestResultSession_testResultsForBuild, (Object)(build.getPlan() == null ? Messages.TestResultSession_unknownPlan : build.getPlan().getLabel()), (Object)build.getLabel()), null);
    }

    public boolean rerunTest(String testId, String className, String testName, String launchMode) throws CoreException {
        return this.rerunTest(testId, className, testName, launchMode, false);
    }

    public boolean rerunTest(String testId, String className, String testName, String launchMode, boolean buildBeforeLaunch) throws CoreException {
        AtomicReference result = new AtomicReference();
        WorkbenchUtil.busyCursorWhile(monitor -> {
            IType type = TestResultManager.Runner.findType(className, monitor);
            if (type == null) {
                return;
            }
            if (testName != null) {
                IMethod method = type.getMethod(testName, new String[0]);
                if (method != null && method.exists()) {
                    result.set(method);
                } else {
                    result.set(type);
                }
            }
        });
        if (result.get() == null) {
            Object typeName = className;
            if (testName != null) {
                typeName = (String)typeName + "." + testName + "()";
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)Messages.TestResultSession_launchFailedFor, (Object)typeName)));
        }
        JUnitLaunchShortcut shortcut = new JUnitLaunchShortcut();
        shortcut.launch((ISelection)new StructuredSelection(result.get()), launchMode);
        return true;
    }
}

