/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.ReplaceEdit;

public class RenameNonVirtualMethodProcessor
extends RenameMethodProcessor {
    public RenameNonVirtualMethodProcessor(IMethod method, TextChangeManager manager, GroupCategorySet categorySet) {
        super(method, manager, categorySet);
    }

    public RenameNonVirtualMethodProcessor(IMethod method) {
        super(method);
    }

    public RenameNonVirtualMethodProcessor(IMethod method, JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(method);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    @Override
    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isRenameNonVirtualMethodAvailable(this.getMethod());
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        try {
            IMethod[] hierarchyMethods;
            pm.beginTask("", 3);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(super.doCheckFinalConditions(Progress.subMonitor(pm, 1), checkContext));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IMethod method = this.getMethod();
            IType declaring = method.getDeclaringType();
            String name = this.getNewElementName();
            IMethod[] iMethodArray = hierarchyMethods = RenameNonVirtualMethodProcessor.hierarchyDeclaresMethodName(Progress.subMonitor(pm, 1), declaring.newTypeHierarchy(Progress.subMonitor(pm, 1)), method, name);
            int n = hierarchyMethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod hierarchyMethod = iMethodArray[n2];
                RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                if (Checks.compareParamTypes(method.getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                    message = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines, new String[]{BasicElementLabels.getJavaElementName(declaring.getFullyQualifiedName('.')), BasicElementLabels.getJavaElementName(name)});
                    result.addError(message, context);
                } else {
                    message = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines2, new String[]{BasicElementLabels.getJavaElementName(declaring.getFullyQualifiedName('.')), BasicElementLabels.getJavaElementName(name)});
                    result.addWarning(message, context);
                }
                ++n2;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 1);
        this.addDeclarationUpdate(manager);
        if (this.getUpdateReferences()) {
            this.addReferenceUpdates(manager, pm);
        }
        pm.worked(1);
    }

    private ICompilationUnit getDeclaringCU() {
        return this.getMethod().getCompilationUnit();
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        if (this.getDelegateUpdating()) {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.getDeclaringCU());
            rewrite.setResolveBindings(true);
            MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.getMethod(), rewrite.getRoot());
            DelegateMethodCreator creator = new DelegateMethodCreator();
            creator.setDeclaration((BodyDeclaration)methodDeclaration);
            creator.setDeclareDeprecated(this.getDeprecateDelegates());
            creator.setSourceRewrite(rewrite);
            creator.setCopy(true);
            creator.setNewElementName(this.getNewElementName());
            creator.prepareDelegate();
            creator.createEdit();
            CompilationUnitChange cuChange = rewrite.createChange(true);
            if (cuChange != null) {
                cuChange.setKeepPreviewEdits(true);
                manager.manage(this.getDeclaringCU(), (TextChange)cuChange);
            }
        }
        String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_declaration;
        ISourceRange nameRange = this.getMethod().getNameRange();
        ReplaceEdit replaceEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        this.addTextEdit(manager.get(this.getDeclaringCU()), editName, replaceEdit);
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        SearchResultGroup[] searchResultGroupArray = this.getOccurrences();
        int n = searchResultGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            ICompilationUnit cu = group.getCompilationUnit();
            TextChange change = manager.get(cu);
            SearchMatch[] searchMatchArray = group.getSearchResults();
            int n3 = searchMatchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchMatch match = searchMatchArray[n4];
                if (!(match instanceof MethodDeclarationMatch)) {
                    ReplaceEdit replaceEdit = this.createReplaceEdit(match, cu);
                    String editName = RefactoringCoreMessages.RenamePrivateMethodRefactoring_update;
                    this.addTextEdit(change, editName, replaceEdit);
                }
                ++n4;
            }
            ++n2;
        }
        pm.done();
    }

    @Override
    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

