/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures;

import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.TableConnection;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class FlatEndConnectionRouter
implements ConnectionRouter {
    private static final int INTERSECT = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    public int END_LENGTH = 20;

    public void setConstraint(IFigure figure, Object constraint) {
    }

    public void setConstraint(Connection connection, Object constraint) {
    }

    public Object getConstraint(IFigure figure) {
        return null;
    }

    public Object getConstraint(Connection connection) {
        return null;
    }

    protected Rectangle getChopRectangle(ConnectionAnchor anchor) {
        IFigure containerFig = this.getContainerFigure(anchor);
        return containerFig.getBounds().getCropped(containerFig.getInsets());
    }

    protected IFigure getContainerFigure(ConnectionAnchor anchor) {
        if (this.getOwnerFigure(anchor) != null) {
            if (this.getOwnerFigure(anchor).getParent() == null) {
                return this.getOwnerFigure(anchor);
            }
            return this.getOwnerFigure(anchor).getParent().getParent().getParent();
        }
        return null;
    }

    protected IFigure getOwnerFigure(ConnectionAnchor anchor) {
        return anchor.getOwner();
    }

    public void remove(Connection connection) {
    }

    public void route(Connection connection) {
        TableConnection conn = (TableConnection)connection;
        Figure startFigure = (Figure)this.getContainerFigure(conn.getSourceAnchor());
        Figure endFigure = (Figure)this.getContainerFigure(conn.getTargetAnchor());
        if (startFigure != null && endFigure != null) {
            Rectangle startContainerRect = startFigure.getBounds();
            Rectangle endContainerRect = endFigure.getBounds();
            Rectangle startOwnerRect = this.getOwnerFigure(conn.getSourceAnchor()).getBounds();
            Rectangle endOwnerRect = this.getOwnerFigure(conn.getTargetAnchor()).getBounds();
            Rectangle startChopRect = this.getChopRectangle(conn.getSourceAnchor());
            Rectangle endChopRect = this.getChopRectangle(conn.getTargetAnchor());
            int startY = startOwnerRect.y + startOwnerRect.height / 2;
            startY = Math.min(Math.max(startY, startChopRect.y), startChopRect.y + startChopRect.height);
            int endY = endOwnerRect.y + endOwnerRect.height / 2;
            endY = Math.min(Math.max(endY, endChopRect.y), endChopRect.y + endChopRect.height);
            conn.removeAllPoints();
            int position = this.getRelativeXPosition(startContainerRect, endContainerRect);
            if (position == 1) {
                conn.addPoint(new Point(startContainerRect.x + startContainerRect.width, startY));
                conn.addPoint(new Point(startContainerRect.x + startContainerRect.width + this.END_LENGTH, startY));
                conn.addPoint(new Point(endContainerRect.x - this.END_LENGTH, endY));
                conn.addPoint(new Point(endContainerRect.x - 1, endY));
            } else if (position == 2) {
                conn.addPoint(new Point(startContainerRect.x - 1, startY));
                conn.addPoint(new Point(startContainerRect.x - this.END_LENGTH, startY));
                conn.addPoint(new Point(endContainerRect.x + endContainerRect.width + this.END_LENGTH, endY));
                conn.addPoint(new Point(endContainerRect.x + endContainerRect.width, endY));
            } else {
                int xpos = Math.min(startContainerRect.x, endContainerRect.x) - this.END_LENGTH;
                conn.addPoint(new Point(startContainerRect.x, startY));
                conn.addPoint(new Point(xpos, startY));
                conn.addPoint(new Point(xpos, endY));
                conn.addPoint(new Point(endContainerRect.x, endY));
            }
        }
    }

    public Dimension getMinimumSize(IFigure parent) {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(IFigure parent) {
        return this.getMinimumSize(parent);
    }

    public void invalidate(Connection connection) {
    }

    private int getRelativeXPosition(Rectangle r1, Rectangle r2) {
        if (r2.x + r2.width < r1.x) {
            return 2;
        }
        if (r1.x + r1.width < r2.x) {
            return 1;
        }
        return 0;
    }

    public Point getStartPoint(Connection conn) {
        Rectangle rec = conn.getTargetAnchor().getOwner().getBounds();
        return conn.getSourceAnchor().getLocation(rec.getCenter());
    }

    public Point getEndPoint(Connection conn) {
        Rectangle rec = conn.getSourceAnchor().getOwner().getBounds();
        return conn.getTargetAnchor().getLocation(rec.getCenter());
    }
}

