/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.client;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import org.apache.wsil.Description;
import org.apache.wsil.Link;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.util.Util;
import org.apache.wsil.util.WSDLDocument;
import org.apache.wsil.util.WSILDocBuilder;
import org.apache.wsil.util.WSILProperties;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.ServiceKey;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSILProxy {
    private WSILDocument wsilDocument = null;
    private Vector wsilDocVector = new Vector();

    public WSILProxy() throws WSILException {
        String wsilDocumentURL = Util.formatURL(WSILProperties.WSIL_HOSTNAME, WSILProperties.WSIL_PORT, WSILProperties.WSIL_DOCUMENT_NAME);
        this.init(wsilDocumentURL);
    }

    public WSILProxy(String wsilDocumentURL) throws WSILException {
        this.init(wsilDocumentURL);
    }

    public WSILProxy(Element inspectionElement) throws WSILException {
        try {
            StringWriter swriter = new StringWriter();
            DOM2Writer.serializeAsXML((Node)inspectionElement, (Writer)swriter);
            StringReader sreader = new StringReader(swriter.toString());
            this.wsilDocument = WSILDocument.newInstance();
            this.wsilDocument.read(sreader);
            this.wsilDocVector.add(this.wsilDocument);
        }
        catch (Exception e) {
            throw new WSILException("Invalid inspection element", e);
        }
    }

    private void init(String wsilDocumentURL) throws WSILException {
        this.wsilDocument = WSILDocument.newInstance();
        try {
            URL inURL = new URL(wsilDocumentURL);
            this.wsilDocument.read(inURL);
            this.wsilDocVector.add(this.wsilDocument);
        }
        catch (MalformedURLException e) {
            throw new WSILException("Invalid inspection.wsil document URL", e);
        }
    }

    public WSILDocument getWSILDocument() {
        return this.wsilDocument;
    }

    public WSDLDocument[] getWSDLDocumentByServiceName(String serviceName) throws WSILException {
        WSDLDocument[] wsdlDocArray = null;
        String[] wsdlDocLocationArray = this.getWSDLDocumentLocations(serviceName);
        if (wsdlDocLocationArray != null) {
            wsdlDocArray = new WSDLDocument[wsdlDocLocationArray.length];
            int i = 0;
            while (i < wsdlDocLocationArray.length) {
                wsdlDocArray[i] = this.readWSDLDocument(wsdlDocLocationArray[i]);
                ++i;
            }
        }
        return wsdlDocArray;
    }

    public WSDLDocument[] getWSDLDocumentByName(String wsdlDocName) throws WSILException {
        Object[] wsdlDocArray = null;
        Vector<WSDLDocument> wsdlDocVector = new Vector<WSDLDocument>();
        this.handleLinks(this.wsilDocument);
        int k = 0;
        while (k < this.wsilDocVector.size()) {
            WSILDocument currentWSILDoc = (WSILDocument)this.wsilDocVector.elementAt(k);
            Service[] serviceArray = currentWSILDoc.getInspection().getServices();
            String wsdlDocLocation = null;
            int i = 0;
            while (i < serviceArray.length) {
                Description[] descriptionArray = serviceArray[i].getDescriptions();
                int j = 0;
                while (j < descriptionArray.length) {
                    wsdlDocLocation = descriptionArray[j].getLocation();
                    if (wsdlDocLocation != null && wsdlDocLocation.indexOf(wsdlDocName) != -1) {
                        wsdlDocVector.add(this.readWSDLDocument(currentWSILDoc.resolveURL(wsdlDocLocation)));
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        if (wsdlDocVector.size() != 0) {
            wsdlDocArray = new WSDLDocument[wsdlDocVector.size()];
            wsdlDocVector.copyInto(wsdlDocArray);
        }
        return wsdlDocArray;
    }

    public WSDLDocument[] getWSDLDocumentByBinding(QName bindingName) throws WSILException {
        Object[] wsdlDocArray = null;
        Vector<WSDLDocument> wsdlDocVector = new Vector<WSDLDocument>();
        this.handleLinks(this.wsilDocument);
        int l = 0;
        while (l < this.wsilDocVector.size()) {
            WSILDocument currentWSILDoc = (WSILDocument)this.wsilDocVector.elementAt(l);
            Service[] serviceArray = currentWSILDoc.getInspection().getServices();
            Object wsdlDocLocation = null;
            int i = 0;
            while (i < serviceArray.length) {
                Description[] descriptionArray = serviceArray[i].getDescriptions();
                int j = 0;
                while (j < descriptionArray.length) {
                    Reference reference = (Reference)descriptionArray[j].getExtensionElement();
                    if (reference != null) {
                        ImplementedBinding[] implementedBindingArray = reference.getImplementedBindings();
                        int k = 0;
                        while (k < implementedBindingArray.length) {
                            QName tmpQName = implementedBindingArray[k].getBindingName();
                            if (tmpQName.equals(bindingName)) {
                                wsdlDocVector.add(this.readWSDLDocument(currentWSILDoc.resolveURL(descriptionArray[j].getLocation())));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        if (wsdlDocVector.size() != 0) {
            wsdlDocArray = new WSDLDocument[wsdlDocVector.size()];
            wsdlDocVector.copyInto(wsdlDocArray);
        }
        return wsdlDocArray;
    }

    public WSDLDocument[] getWSDLDocumentByPortType(QName portTypeName) throws WSILException {
        Object[] wsdlDocArray = null;
        Vector<WSDLDocument> wsdlDocVector = new Vector<WSDLDocument>();
        this.handleLinks(this.wsilDocument);
        int l = 0;
        while (l < this.wsilDocVector.size()) {
            WSILDocument currentWSILDoc = (WSILDocument)this.wsilDocVector.elementAt(l);
            Service[] serviceArray = currentWSILDoc.getInspection().getServices();
            Object wsdlDocLocation = null;
            int i = 0;
            while (i < serviceArray.length) {
                Description[] descriptionArray = serviceArray[i].getDescriptions();
                int j = 0;
                while (j < descriptionArray.length) {
                    Description description = descriptionArray[j];
                    Reference reference = (Reference)description.getExtensionElement();
                    if (reference != null) {
                        ImplementedBinding[] implementedBindingArray = reference.getImplementedBindings();
                        WSDLDocument definition = null;
                        try {
                            definition = this.readWSDLDocument(currentWSILDoc.resolveURL(description.getLocation()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (definition != null) {
                            int k = 0;
                            while (k < implementedBindingArray.length) {
                                if (!wsdlDocVector.contains(definition)) {
                                    PortType portType;
                                    QName tmpQName = implementedBindingArray[k].getBindingName();
                                    javax.xml.namespace.QName nqname = new javax.xml.namespace.QName(tmpQName.getNamespaceURI(), tmpQName.getLocalName());
                                    Binding binding = definition.getDefinitions().getBinding(nqname);
                                    if (binding != null && (portType = binding.getPortType()) != null && portType.getQName().getLocalPart().equals(portTypeName.getLocalName()) && portType.getQName().getNamespaceURI().equals(portTypeName.getNamespaceURI())) {
                                        wsdlDocVector.add(definition);
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        if (wsdlDocVector.size() != 0) {
            wsdlDocArray = new WSDLDocument[wsdlDocVector.size()];
            wsdlDocVector.copyInto(wsdlDocArray);
        }
        return wsdlDocArray;
    }

    public BusinessService[] getBusinessServiceByServiceName(String serviceName) throws WSILException {
        Vector<BusinessService> businessServiceVector = new Vector<BusinessService>();
        Object[] businessServiceArray = null;
        this.handleLinks(this.wsilDocument);
        int l = 0;
        while (l < this.wsilDocVector.size()) {
            WSILDocument currentWSILDoc = (WSILDocument)this.wsilDocVector.elementAt(l);
            Service[] serviceArray = currentWSILDoc.getInspection().getServices();
            int i = 0;
            while (i < serviceArray.length) {
                if (serviceArray[i].getServiceNames()[0].getText().equals(serviceName)) {
                    Description[] descriptionArray = serviceArray[i].getDescriptions();
                    int j = 0;
                    while (j < descriptionArray.length) {
                        ServiceDescription serviceDescription = (ServiceDescription)descriptionArray[j].getExtensionElement();
                        if (serviceDescription != null) {
                            String location = serviceDescription.getLocation();
                            ServiceKey serviceKey = serviceDescription.getServiceKey();
                            try {
                                Properties p = new Properties();
                                p.setProperty("org.uddi4j.TransportClassName", WSILProperties.TRANSPORT_CLASS);
                                p.setProperty("org.uddi4j.inquiryURL", new URL(location).toString());
                                UDDIProxy up = new UDDIProxy(p);
                                ServiceDetail serviceDetail = up.get_serviceDetail(serviceKey.getText());
                                Vector bServiceVector = serviceDetail.getBusinessServiceVector();
                                if (bServiceVector.size() > 0) {
                                    BusinessService businessService = (BusinessService)bServiceVector.firstElement();
                                    businessServiceVector.add(businessService);
                                }
                            }
                            catch (MalformedURLException e) {
                                throw new WSILException("Problems connecting to registry", e);
                            }
                            catch (UDDIException e) {
                                throw new WSILException("Unable to find service " + serviceName, e);
                            }
                            catch (TransportException e) {
                                throw new WSILException("SOAP transport problems", e);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++l;
        }
        if (businessServiceVector.size() != 0) {
            businessServiceArray = new BusinessService[businessServiceVector.size()];
            businessServiceVector.copyInto(businessServiceArray);
        }
        return businessServiceArray;
    }

    public void print(OutputStream out) throws WSILException {
        this.wsilDocument.write(new PrintWriter(out));
    }

    public String[] getWSDLDocumentLocations(String serviceName) throws WSILException {
        Object[] wsdlDocLocationArray = null;
        Vector<String> wsdlDocLocationVector = new Vector<String>();
        this.handleLinks(this.wsilDocument);
        int l = 0;
        while (l < this.wsilDocVector.size()) {
            WSILDocument currentWSILDoc = (WSILDocument)this.wsilDocVector.elementAt(l);
            Service[] serviceArray = currentWSILDoc.getInspection().getServices();
            int i = 0;
            while (i < serviceArray.length) {
                ServiceName[] serviceNameArray = serviceArray[i].getServiceNames();
                int j = 0;
                while (j < serviceNameArray.length) {
                    if (serviceNameArray[j].getText().equals(serviceName)) {
                        Description[] descriptionArray = serviceArray[i].getDescriptions();
                        String currentLocation = null;
                        int k = 0;
                        while (k < descriptionArray.length) {
                            String location = descriptionArray[k].getLocation();
                            if ((currentLocation == null || !currentLocation.equals(location)) && descriptionArray[k].getReferencedNamespace().equals("http://schemas.xmlsoap.org/wsdl/")) {
                                currentLocation = location;
                                wsdlDocLocationVector.add(currentWSILDoc.resolveURL(location));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        if (wsdlDocLocationVector.size() != 0) {
            wsdlDocLocationArray = new String[wsdlDocLocationVector.size()];
            wsdlDocLocationVector.copyInto(wsdlDocLocationArray);
        }
        return wsdlDocLocationArray;
    }

    private WSDLDocument readWSDLDocument(String wsdlDocLocation) throws WSILException {
        WSDLDocument wsdlDoc = null;
        try {
            wsdlDoc = new WSDLDocument(new URL(wsdlDocLocation));
        }
        catch (MalformedURLException e) {
            throw new WSILException("Invalid WSDL document URL", e);
        }
        catch (WSDLException e) {
            throw new WSILException("Problems creating WSDL document", e);
        }
        return wsdlDoc;
    }

    private void handleLinks(WSILDocument wsilDocument) throws WSILException {
        Link[] linkArray = wsilDocument.getInspection().getLinks();
        int i = 0;
        while (i < linkArray.length) {
            String linkNamespace = linkArray[i].getReferencedNamespace();
            String linkLocation = wsilDocument.resolveURL(linkArray[i].getLocation());
            ExtensionElement linkExtensionElem = linkArray[i].getExtensionElement();
            if (linkNamespace.equals("http://schemas.xmlsoap.org/ws/2001/10/inspection/")) {
                WSILDocument wsilDoc = WSILDocument.newInstance();
                try {
                    URL inURL = new URL(linkLocation);
                    wsilDoc.read(inURL);
                }
                catch (MalformedURLException e) {
                    throw new WSILException("Invalid wsil document URL", e);
                }
                this.wsilDocVector.add(wsilDoc);
                this.handleLinks(wsilDoc);
            } else if (linkNamespace.equals("urn:uddi-org:api") || linkNamespace.equals("urn:uddi-org:api_v2")) {
                BusinessDescription businessDescription = (BusinessDescription)linkArray[i].getExtensionElement();
                if (businessDescription != null) {
                    String location = businessDescription.getLocation();
                    String businessKey = businessDescription.getBusinessKey().getText();
                    try {
                        WSILDocBuilder wsilDocBuilder = new WSILDocBuilder(new URL(location), businessKey);
                        this.wsilDocVector.add(wsilDocBuilder.getWSILDocument());
                    }
                    catch (MalformedURLException e) {
                        throw new WSILException("Problems creating WSIL document", e);
                    }
                }
            } else {
                throw new WSILException("Invalid wsil link namespace: " + linkNamespace);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Vector wsdlList = new Vector();
        try {
            if (args.length > 0 && args[0].equals("-?")) {
                throw new IllegalArgumentException("Usage: WSILProxy <wsinspectionURL>");
            }
            WSILProxy proxy = args.length == 0 ? new WSILProxy() : new WSILProxy(args[0]);
            System.out.println(proxy.getWSILDocument().toString());
        }
        catch (Exception e) {
            System.out.println("EXCEPTION: " + e.getMessage());
            e.printStackTrace();
        }
        System.exit(0);
    }
}

