/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.JSFUIPlugin;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelGridDeleteColumnCommand
extends DesignerCommand {
    private int _columnIndex;
    private Element _panelGridEle;

    public PanelGridDeleteColumnCommand(IHTMLGraphicalViewer viewer, Element panelGrid, int columnIndex) {
        super(CommandResources.getString("PanelGridDeleteColumnCommand.Label.DeleteColumn"), viewer);
        this._panelGridEle = panelGrid;
        this._columnIndex = columnIndex;
    }

    public boolean canExecute() {
        if (this._columnIndex < 0) {
            return false;
        }
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGridEle, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        return columns > 1;
    }

    protected void doExecute() {
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGridEle, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        if (this._columnIndex >= columns) {
            JSFUIPlugin.log(4, "Should not happen", new Throwable());
            return;
        }
        List children = JSFDOMUtil.getUIComponentChildren(this._panelGridEle);
        ArrayList toRemove = new ArrayList();
        int i = this._columnIndex;
        while (i < children.size()) {
            toRemove.add(children.get(i));
            i += columns;
        }
        i = 0;
        int size = toRemove.size();
        while (i < size) {
            this._panelGridEle.removeChild((Node)toRemove.get(i));
            ++i;
        }
        this._panelGridEle.setAttribute("columns", String.valueOf(columns - 1));
        this.formatNode(this._panelGridEle);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._panelGridEle);
    }
}

