/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleDeclarationAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HTMLElementFormatter
extends HTMLFormatter {
    protected HTMLElementFormatter() {
    }

    private void compressTailingSpaces(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = region.getTextEnd();
        int count = region.getEnd() - offset;
        if (count == 1) {
            String source = flatNode.getFullText(region);
            int start = region.getStart();
            if (source != null && source.charAt(offset - start) == ' ') {
                return;
            }
        }
        this.replaceSource(flatNode, offset, count, " ");
    }

    private void formatEndTag(IDOMElement element, HTMLFormatContraints contraints) {
        Node lastChild = element.getLastChild();
        if (lastChild != null && lastChild instanceof IDOMElement && lastChild.getNodeName().equals("jsp:scriptlet")) {
            this.insertBreakAfter((IDOMNode)((IDOMElement)lastChild), contraints);
            return;
        }
        IStructuredDocumentRegion endStructuredDocumentRegion = element.getEndStructuredDocumentRegion();
        if (endStructuredDocumentRegion == null) {
            return;
        }
        if (element.isJSPTag() || element.isCommentTag()) {
            String endTag = endStructuredDocumentRegion.getText();
            if (endTag != null && endTag.length() > 0) {
                this.setWidth(contraints, endTag);
            }
            return;
        }
        ITextRegion prevRegion = null;
        ITextRegionList regions = endStructuredDocumentRegion.getRegions();
        for (ITextRegion region : regions) {
            if (region == null) continue;
            String regionType = region.getType();
            if (regionType == "XML_TAG_NAME" || this.isNestedTag(regionType)) {
                if (prevRegion != null && prevRegion.getType() == "XML_END_TAG_OPEN") {
                    this.removeTailingSpaces(endStructuredDocumentRegion, prevRegion);
                }
            } else if (regionType == "XML_TAG_CLOSE" && prevRegion != null && (prevRegion.getType() == "XML_TAG_NAME" || this.isNestedRootTag(prevRegion.getType()))) {
                this.removeTailingSpaces(endStructuredDocumentRegion, prevRegion);
            }
            prevRegion = region;
        }
        if (prevRegion != null && (prevRegion.getType() == "XML_TAG_NAME" || this.isNestedRootTag(prevRegion.getType()))) {
            this.removeTailingSpaces(endStructuredDocumentRegion, prevRegion);
        }
    }

    @Override
    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        IDOMElement element = (IDOMElement)node;
        this.formatStartTag(element, contraints);
        this.formatChildNodes((IDOMNode)element, contraints);
        this.formatEndTag(element, contraints);
    }

    private void formatStartTag(IDOMElement element, HTMLFormatContraints contraints) {
        NamedNodeMap attributes;
        Attr attr;
        if (element.getNodeName().equals("jsp:scriptlet")) {
            this.insertBreakBefore((IDOMNode)element, contraints);
            return;
        }
        IStructuredDocumentRegion startStructuredDocumentRegion = element.getStartStructuredDocumentRegion();
        if (startStructuredDocumentRegion == null) {
            return;
        }
        if (element.isCommentTag()) {
            String startTag = startStructuredDocumentRegion.getText();
            if (startTag != null && startTag.length() > 0) {
                this.setWidth(contraints, startTag);
            }
            return;
        }
        if (element.isGlobalTag() && (attr = element.getAttributeNode("style")) != null) {
            this.formatStyleAttr(attr);
        }
        boolean insertBreak = false;
        insertBreak = ((StructuredFormatPreferencesXML)this.getFormatPreferences()).getSplitMultiAttrs();
        boolean alignEndBracket = ((StructuredFormatPreferencesXML)this.getFormatPreferences()).isAlignEndBracket();
        boolean attributesSplitted = false;
        if (insertBreak && ((attributes = element.getAttributes()) == null || attributes.getLength() < 2)) {
            insertBreak = false;
        }
        Object breakSpaces = this.getBreakSpaces((Node)element);
        String originalBreakSpaces = breakSpaces;
        String indent = this.getIndent();
        if (indent != null && indent.length() > 0) {
            breakSpaces = (String)breakSpaces + indent;
        }
        ITextRegion lastBreakRegion = null;
        ITextRegion prevRegion = null;
        ITextRegionList regions = startStructuredDocumentRegion.getRegions();
        for (ITextRegion region : regions) {
            if (region == null) continue;
            ITextRegion breakRegion = null;
            String regionType = region.getType();
            if (regionType == "XML_TAG_NAME" || this.isNestedTag(regionType)) {
                if (prevRegion != null && prevRegion.getType() == "XML_TAG_OPEN") {
                    this.removeTailingSpaces(startStructuredDocumentRegion, prevRegion);
                }
                breakRegion = region;
            } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                if (prevRegion != null && (prevRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || prevRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS")) {
                    breakRegion = prevRegion;
                }
            } else if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
                if (prevRegion != null && prevRegion.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                    this.removeTailingSpaces(startStructuredDocumentRegion, prevRegion);
                }
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                if (prevRegion != null && prevRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
                    this.removeTailingSpaces(startStructuredDocumentRegion, prevRegion);
                }
                breakRegion = region;
            } else if (!(regionType != "XML_TAG_CLOSE" && regionType != "XML_EMPTY_TAG_CLOSE" || prevRegion == null || prevRegion.getType() != "XML_TAG_ATTRIBUTE_NAME" && prevRegion.getType() != "XML_TAG_ATTRIBUTE_EQUALS")) {
                breakRegion = prevRegion;
            }
            if (breakRegion != null) {
                int end = breakRegion.getTextEnd();
                if (lastBreakRegion != null) {
                    int offset = lastBreakRegion.getEnd();
                    int count = end - offset;
                    if (insertBreak || !this.isWidthAvailable(contraints, count + 1)) {
                        this.replaceTailingSpaces(startStructuredDocumentRegion, lastBreakRegion, (String)breakSpaces);
                        this.setWidth(contraints, (String)breakSpaces);
                        attributesSplitted = true;
                    } else {
                        this.compressTailingSpaces(startStructuredDocumentRegion, lastBreakRegion);
                        this.addWidth(contraints, 1);
                    }
                    this.addWidth(contraints, count);
                } else {
                    this.addWidth(contraints, end);
                }
                lastBreakRegion = breakRegion;
            }
            prevRegion = region;
        }
        if (prevRegion != null && (prevRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || prevRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS")) {
            int end = prevRegion.getTextEnd();
            if (lastBreakRegion != null) {
                int offset = lastBreakRegion.getEnd();
                int count = end - offset;
                if (insertBreak || !this.isWidthAvailable(contraints, count + 1)) {
                    this.replaceTailingSpaces(startStructuredDocumentRegion, lastBreakRegion, (String)breakSpaces);
                    this.setWidth(contraints, (String)breakSpaces);
                    attributesSplitted = true;
                } else {
                    this.compressTailingSpaces(startStructuredDocumentRegion, lastBreakRegion);
                    this.addWidth(contraints, 1);
                }
                this.addWidth(contraints, count);
            } else {
                this.addWidth(contraints, end);
            }
            lastBreakRegion = prevRegion;
        }
        if (lastBreakRegion != null) {
            int offset = lastBreakRegion.getTextEnd();
            int count = startStructuredDocumentRegion.getLength() - offset;
            if (prevRegion != null && prevRegion.getType() == "XML_EMPTY_TAG_CLOSE") {
                this.compressTailingSpaces(startStructuredDocumentRegion, lastBreakRegion);
                ++count;
            } else {
                this.removeTailingSpaces(startStructuredDocumentRegion, lastBreakRegion);
                count += element.getTagName().length() + 3;
            }
            this.addWidth(contraints, count);
        } else {
            this.addWidth(contraints, startStructuredDocumentRegion.getLength());
        }
        if (alignEndBracket && attributesSplitted) {
            this.removeTailingSpaces(startStructuredDocumentRegion, lastBreakRegion);
            this.replaceTailingSpaces(startStructuredDocumentRegion, lastBreakRegion, originalBreakSpaces);
            contraints.setAvailableLineWidth(this.getLineWidth() - originalBreakSpaces.length() - 1);
        }
    }

    private boolean isNestedTag(String regionType) {
        boolean result = regionType.equals("JSP_ROOT_TAG_NAME") || regionType.equals("JSP_DIRECTIVE_NAME");
        return result;
    }

    private boolean isNestedRootTag(String regionType) {
        boolean result = regionType.equals("JSP_ROOT_TAG_NAME");
        return result;
    }

    private void formatStyleAttr(Attr attr) {
        if (attr == null) {
            return;
        }
        String oldValue = ((IDOMNode)attr).getValueSource();
        if (oldValue != null && oldValue.indexOf("#{") > -1) {
            return;
        }
        if (((IDOMNode)attr).getValueRegion() instanceof ITextRegionContainer) {
            return;
        }
        String value = this.getCSSValue(attr);
        if (value == null) {
            return;
        }
        if (oldValue != null && value.equals(oldValue)) {
            return;
        }
        attr.setValue(value);
    }

    private ICSSModel getCSSModel(Attr attr) {
        if (attr == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)attr.getOwnerElement();
        if (notifier == null) {
            return null;
        }
        INodeAdapter adapter = notifier.getAdapterFor(IStyleDeclarationAdapter.class);
        if (adapter == null) {
            return null;
        }
        if (!(adapter instanceof IStyleDeclarationAdapter)) {
            return null;
        }
        IStyleDeclarationAdapter styleAdapter = (IStyleDeclarationAdapter)adapter;
        return styleAdapter.getModel();
    }

    private String getCSSValue(Attr attr) {
        ICSSModel model = this.getCSSModel(attr);
        if (model == null) {
            return null;
        }
        ICSSDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)document;
        CSSSourceFormatter formatter = (CSSSourceFormatter)notifier.getAdapterFor(CSSSourceFormatter.class);
        if (formatter == null) {
            formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter(notifier);
        }
        if (formatter == null) {
            return null;
        }
        StringBuffer buffer = formatter.format((ICSSNode)document);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    private void removeTailingSpaces(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = region.getTextEnd();
        int count = region.getEnd() - offset;
        if (count <= 0) {
            return;
        }
        this.replaceSource(flatNode, offset, count, null);
    }

    private void replaceTailingSpaces(IStructuredDocumentRegion flatNode, ITextRegion region, String spaces) {
        String source;
        int offset = region.getTextEnd();
        int count = region.getEnd() - offset;
        if (count == spaces.length() && (source = flatNode.getFullText(region)) != null && source.endsWith(spaces)) {
            return;
        }
        this.replaceSource(flatNode, offset, count, spaces);
    }
}

