/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.context;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.context.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyContextHandler
extends AbstractTaskHandler {
    private static final String TITLE_DIALOG = Messages.CopyContextHandler_Copy_Context;

    @Override
    protected void execute(ExecutionEvent event, ITask sourceTask) throws ExecutionException {
        CopyContextHandler.run(sourceTask);
    }

    public static void run(ITask sourceTask) {
        if (sourceTask == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)Messages.CopyContextHandler_No_source_task_selected);
            return;
        }
        TaskSelectionDialog dialog = new TaskSelectionDialog(WorkbenchUtil.getShell());
        dialog.setNeedsCreateTask(false);
        dialog.setTitle(Messages.CopyContextHandler_Select_Target_Task);
        dialog.setMessage(Messages.CopyContextHandler_Select_the_target_task__);
        if (dialog.open() != 0) {
            return;
        }
        Object result = dialog.getFirstResult();
        if (result instanceof ITask) {
            ITask targetTask = (ITask)result;
            TasksUi.getTaskActivityManager().deactivateActiveTask();
            if (targetTask.equals(sourceTask)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)Messages.CopyContextHandler_TARGET_TASK_CON_NOT_BE_THE_SAME_AS_SOURCE_TASK);
            } else {
                boolean REPLACE = false;
                boolean MERGE = true;
                int CANCEL = 2;
                int action = 0;
                if (TasksUiPlugin.getContextStore().hasContext(targetTask)) {
                    MessageDialog dialog2 = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TITLE_DIALOG, null, Messages.CopyContextHandler_SELECTED_TASK_ALREADY_HAS_CONTEXT, 3, new String[]{Messages.CopyContextHandler_Replace, Messages.CopyContextHandler_Merge, IDialogConstants.CANCEL_LABEL}, 1);
                    action = dialog2.open();
                }
                switch (action) {
                    case 0: {
                        IAdaptable context = TasksUiPlugin.getContextStore().copyContext(sourceTask, targetTask);
                        if (context != null) break;
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)Messages.CopyContextHandler_SOURCE_TASK_DOES_HAVE_A_CONTEXT);
                        return;
                    }
                    case 1: {
                        TasksUiPlugin.getContextStore().mergeContext(sourceTask, targetTask);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
                TasksUiInternal.activateTaskThroughCommand(targetTask);
            }
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)Messages.CopyContextHandler_No_target_task_selected);
        }
    }
}

