/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.List;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class ServerTargetComboHelper {
    private List targets;
    public String[] items;
    public static final String defaultId = "com.ibm.etools.websphere.serverTarget.base.v51";
    public static final String defaultExpressId = "com.ibm.etools.websphere.serverTarget.express.v51";

    ServerTargetComboHelper(List targets, String[] items) {
        this.targets = targets;
        this.items = items;
    }

    public IRuntime getSelectedTarget(int itemIndex) {
        return (IRuntime)this.targets.get(itemIndex);
    }

    public boolean isCompatible(IRuntime target) {
        return this.targets.contains(target);
    }

    public int getDefaultServerTargetIndex() {
        IRuntime v51TargetServer = null;
        v51TargetServer = J2EEPlugin.isEJBSupportAvailable() ? ResourceManager.getInstance().getRuntime(defaultId) : ResourceManager.getInstance().getRuntime(defaultExpressId);
        if (v51TargetServer != null && this.targets.contains(v51TargetServer)) {
            return this.targets.indexOf(v51TargetServer) + 1;
        }
        return -1;
    }

    public int getServerTargetIndexFromItems(IRuntime serverTarget) {
        if (this.items != null && this.items.length > 0) {
            String serverTargetLabel = serverTarget.getName() + " (" + serverTarget.getRuntimeType().getName() + ")";
            int i = 0;
            while (i < this.items.length) {
                String label = this.items[i];
                if (label.equals(serverTargetLabel)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public List getValidTargets() {
        return this.targets;
    }
}

