/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class InjectEs6RuntimeLibrary
implements CompilerPass {
    private AbstractCompiler compiler;

    public InjectEs6RuntimeLibrary(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (String forced : this.compiler.getOptions().forceLibraryInjection) {
            this.compiler.ensureLibraryInjected(forced, false);
        }
        if (this.compiler.needsEs6Runtime) {
            this.compiler.ensureLibraryInjected("es6_runtime", false);
            for (String name : new String[]{"window", "global"}) {
                this.compiler.getSynthesizedExternsInputAtEnd().getAstRoot(this.compiler).addChildToBack(IR.var(IR.name(name)));
            }
        }
        if (this.compiler.needsEs6DartRuntime) {
            this.compiler.ensureLibraryInjected("es6_dart_runtime", false);
        }
    }
}

