/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class LanguageServersView
extends ViewPart {
    public static final String ID = "org.eclipse.lsp4e.ui.LanguageServersView";
    private static final String EMPTY = "";
    private static final String NOT_AVAILABLE = "n/a";
    private TableViewer viewer = (TableViewer)NullSafetyHelper.lateNonNull();
    private @Nullable Job viewerRefreshJob;
    private final Map<LanguageServerWrapper, ToolBar> actionButtons = new HashMap<LanguageServerWrapper, ToolBar>();
    private final List<ColumnLabelProvider> columnLabelProviders = new ArrayList<ColumnLabelProvider>();
    private @Nullable TableCursor tableCursor;
    private int tableSortColumn = 1;
    private int tableSortDirection = 1;
    private final ViewerComparator tableSorter = new ViewerComparator(){

        private int compare(int columnIndex, @Nullable Object e1, @Nullable Object e2) {
            ColumnLabelProvider labelProvider = LanguageServersView.this.columnLabelProviders.get(columnIndex);
            return this.getComparator().compare(Objects.toString(e1 == null ? null : labelProvider.getText(e1), LanguageServersView.EMPTY), Objects.toString(e2 == null ? null : labelProvider.getText(e2), LanguageServersView.EMPTY));
        }

        public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
            int sortResult = this.compare(LanguageServersView.this.tableSortColumn, e1, e2);
            if (sortResult == 0 && LanguageServersView.this.tableSortColumn != 1) {
                sortResult = this.compare(1, e1, e2);
            }
            return sortResult * LanguageServersView.this.tableSortDirection;
        }
    };

    private void copyCurrentCellToClipboard() {
        String cellContent;
        TableCursor cursor = this.tableCursor;
        if (cursor == null) {
            return;
        }
        Table table = this.viewer.getTable();
        TableItem currentRow = cursor.getRow();
        int currentColumn = cursor.getColumn();
        if (currentRow != null && currentColumn >= 0 && (cellContent = currentRow.getText(currentColumn)) != null && !cellContent.isEmpty()) {
            Clipboard clipboard = new Clipboard(table.getDisplay());
            try {
                clipboard.setContents(new Object[]{cellContent}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private void createColumn(String name, int width, ColumnLabelProvider labelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        final TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setText(name);
        tableColumn.setWidth(width);
        tableColumn.setResizable(true);
        final int columnIndex = this.columnLabelProviders.size();
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (columnIndex == 0) {
                    return;
                }
                if (LanguageServersView.this.tableSortColumn == columnIndex) {
                    LanguageServersView.this.tableSortDirection *= -1;
                }
                LanguageServersView.this.tableSortColumn = columnIndex;
                Table table = LanguageServersView.this.viewer.getTable();
                table.setSortDirection(LanguageServersView.this.tableSortDirection == 1 ? 1024 : 128);
                table.setSortColumn(tableColumn);
                LanguageServersView.this.viewer.refresh();
            }
        });
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        this.columnLabelProviders.add(labelProvider);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.setComparator(this.tableSorter);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumn(EMPTY, 26, new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                Object object = cell.getElement();
                if (object instanceof LanguageServerWrapper) {
                    final LanguageServerWrapper lsWrapper = (LanguageServerWrapper)object;
                    TableItem item = (TableItem)cell.getItem();
                    ToolBar buttons = LanguageServersView.this.actionButtons.computeIfAbsent(lsWrapper, unused -> {
                        ToolBar toolBar = new ToolBar((Composite)cell.getViewerRow().getControl(), 0x800000);
                        toolBar.setBackground(cell.getBackground());
                        ToolItem terminateButton = new ToolItem(toolBar, 8);
                        terminateButton.setImage(LSPImages.getImage("IMG_TERMINATE_CO"));
                        terminateButton.setToolTipText("Terminate this language server");
                        terminateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent ev) {
                                lsWrapper.stop();
                                LanguageServersView.this.updateViewerInput();
                            }
                        });
                        return toolBar;
                    });
                    TableEditor editor = new TableEditor(item.getParent());
                    editor.setEditor((Control)buttons, item, cell.getColumnIndex());
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    editor.layout();
                }
            }
        });
        this.createColumn("Initial Project", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                LanguageServerWrapper lsWrapper = (LanguageServerWrapper)element;
                IProject p = lsWrapper.initialProject;
                return p == null ? LanguageServersView.NOT_AVAILABLE : p.getName();
            }
        });
        this.createColumn("Name", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                LanguageServerWrapper lsWrapper = (LanguageServerWrapper)element;
                return lsWrapper.serverDefinition.label;
            }
        });
        this.createColumn("Executable", 100, new ColumnLabelProvider(){

            public String getText(Object element) {
                String exe;
                ProcessHandle ph = ((LanguageServerWrapper)element).getProcessHandle();
                String string = exe = ph == null ? null : (String)ph.info().command().orElse(null);
                if (exe == null) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
                int backslash = exe.lastIndexOf(92);
                int slash = exe.lastIndexOf(47);
                int lastDirSep = Math.max(slash, backslash);
                return exe.substring(lastDirSep + 1);
            }
        });
        this.createColumn("PID", 50, new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessHandle ph = ((LanguageServerWrapper)element).getProcessHandle();
                if (ph == null) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
                try {
                    return Long.toString(ph.pid());
                }
                catch (UnsupportedOperationException ex) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
            }
        });
        this.createColumn("Command Line", 400, new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessHandle ph = ((LanguageServerWrapper)element).getProcessHandle();
                if (ph == null) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
                ProcessHandle.Info pi = ph.info();
                return pi.commandLine().orElse(pi.command().orElse(LanguageServersView.NOT_AVAILABLE));
            }
        });
        this.createColumn("ID", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                LanguageServerWrapper lsWrapper = (LanguageServerWrapper)element;
                return lsWrapper.serverDefinition.id;
            }
        });
        table.setSortDirection(this.tableSortDirection == 1 ? 1024 : 128);
        table.setSortColumn(table.getColumn(this.tableSortColumn));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.initContextMenu();
        this.scheduleRefreshJob();
    }

    public void dispose() {
        Job viewerRefreshJob = this.viewerRefreshJob;
        if (viewerRefreshJob != null) {
            viewerRefreshJob.cancel();
        }
        super.dispose();
    }

    private void initContextMenu() {
        Table table = this.viewer.getTable();
        Menu contextMenu = new Menu((Control)table);
        MenuItem copyValueMenuItem = new MenuItem(contextMenu, 0);
        copyValueMenuItem.setText("Copy Cell Value");
        copyValueMenuItem.addListener(13, event -> this.copyCurrentCellToClipboard());
        table.addListener(3, event -> {
            if (event.button == 3 && this.viewer.getCell(new Point(event.x, event.y)) != null) {
                contextMenu.setVisible(true);
            }
        });
    }

    private void initTableCursor() {
        TableCursor cursorOld = this.tableCursor;
        if (cursorOld != null && !cursorOld.isDisposed()) {
            cursorOld.dispose();
        }
        final Table table = this.viewer.getTable();
        final TableCursor cursor = this.tableCursor = new TableCursor(table, 0);
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageServersView.this.selectCell(table.indexOf(cursor.getRow()), cursor.getColumn());
            }
        });
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 99) {
                    LanguageServersView.this.copyCurrentCellToClipboard();
                }
            }
        });
    }

    private void selectCell(int rowIdx, int colIdx) {
        TableCursor cursor = this.tableCursor;
        if (cursor == null) {
            return;
        }
        Table table = this.viewer.getTable();
        if (table.getItemCount() == 0) {
            return;
        }
        rowIdx = Math.max(0, Math.min(rowIdx, table.getItemCount() - 1));
        colIdx = Math.max(1, Math.min(colIdx, table.getColumnCount() - 1));
        table.setSelection(rowIdx);
        cursor.setSelection(rowIdx, colIdx);
        cursor.setVisible(true);
        cursor.setFocus();
    }

    private void scheduleRefreshJob() {
        Job viewerRefreshJob = this.viewerRefreshJob = new Job("Refresh Language Server Processes view"){

            protected IStatus run(IProgressMonitor monitor) {
                if (LanguageServersView.this.getSite().getPage().isPartVisible((IWorkbenchPart)LanguageServersView.this)) {
                    LanguageServersView.this.updateViewerInput();
                }
                this.schedule(2000L);
                return Status.OK_STATUS;
            }
        };
        viewerRefreshJob.setPriority(50);
        viewerRefreshJob.setSystem(true);
        viewerRefreshJob.schedule();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void updateViewerInput() {
        Object[] newElements;
        Object[] currentElements = (Object[])this.viewer.getInput();
        if (!Arrays.equals(currentElements, newElements = LanguageServiceAccessor.getStartedWrappers(capability -> true, true).toArray())) {
            UI.getDisplay().execute(() -> {
                this.actionButtons.values().forEach(Widget::dispose);
                this.actionButtons.clear();
                Table table = this.viewer.getTable();
                int selectedRow = Math.max(0, table.getSelectionIndex());
                int selectedCol = 1;
                TableCursor cursor = this.tableCursor;
                if (cursor != null) {
                    selectedCol = cursor.getColumn();
                }
                this.viewer.setInput((Object)newElements);
                this.initTableCursor();
                if (table.getSelectionIndex() > -1) {
                    selectedRow = table.getSelectionIndex();
                }
                this.selectCell(selectedRow, selectedCol);
            });
        }
    }
}

