/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.range.DesignEdit;
import org.eclipse.jst.pagedesigner.commands.range.WorkNode;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CopyEdit
extends DesignEdit {
    private static Logger _log = PDPlugin.getLogger(CopyEdit.class);
    private Stack result = new Stack();

    public CopyEdit(DOMRange range, GraphicalViewer viewer) {
        super(range, viewer);
    }

    @Override
    protected boolean operate() {
        WorkNode root = this.getRootWorkNode();
        Node rootNode = root.getNode();
        this.result = this.getProcessedResult();
        this.collectOtherStyles(rootNode, this.result);
        this.setClipboard(this.result);
        return true;
    }

    @Override
    protected Node processContainer(WorkNode node) {
        return node.getNode().cloneNode(false);
    }

    @Override
    protected Node processNode(WorkNode node) {
        int[] pos = node.getPosOffsets();
        Assert.isTrue((pos[0] <= pos[1] ? 1 : 0) != 0);
        if (pos[0] == pos[1]) {
            return null;
        }
        return node.getNode().cloneNode(true);
    }

    @Override
    protected Text processText(WorkNode node) {
        Text currentNode = (Text)node.getNode();
        int left = EditModelQuery.getNodeStartIndex(currentNode);
        int right = EditModelQuery.getNodeEndIndex(currentNode);
        int location1 = EditHelper.getInstance().getLocation(currentNode, node.getPosOffsets()[0], true);
        int location2 = EditHelper.getInstance().getLocation(currentNode, node.getPosOffsets()[1], true);
        int start = 0;
        int end = right - left;
        if (location1 > 3 || location2 < 3) {
            return null;
        }
        if (location1 <= 3) {
            start = node.getQualifiedOffsets()[0];
        }
        if (location2 >= 3) {
            end = node.getQualifiedOffsets()[1];
        }
        if (start == end) {
            return null;
        }
        try {
            String text = currentNode.getData().substring(start, end);
            return EditModelQuery.getDocumentNode(currentNode).createTextNode(text);
        }
        catch (DOMException e) {
            _log.error("Exception", (Throwable)e);
            return null;
        }
    }
}

