/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tableedit;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.jst.pagedesigner.tableedit.EmptyLocator;
import org.eclipse.jst.pagedesigner.tableedit.TableSideItemDragTracker;

public abstract class TableSideItemHandle
extends AbstractHandle {
    private boolean _isRow;
    private int _index;

    public TableSideItemHandle(GraphicalEditPart owner, boolean isRow, int index) {
        super(owner, (Locator)new EmptyLocator());
        this._isRow = isRow;
        this._index = index;
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        LineBorder border1 = new LineBorder(ColorConstants.green, 1);
        this.setBorder((Border)border1);
        this.setCursor(Cursors.ARROW);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setXORMode(true);
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.fillRectangle(this.getBounds());
    }

    protected DragTracker createDragTracker() {
        return new TableSideItemDragTracker((EditPart)this.getOwner(), this._isRow, this._index);
    }

    public int getIndex() {
        return this._index;
    }

    public boolean isRow() {
        return this._isRow;
    }
}

