/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class JpaFacetActionDelegate
implements IDelegate,
JpaFacetDataModelProperties {
    public final void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.execute_(project, fv, config, monitor);
    }

    protected void execute_(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        IDataModel dataModel = (IDataModel)config;
        JpaPlatform.Config platformConfig = (JpaPlatform.Config)dataModel.getProperty("JpaFacetDataModelProperties.PLATFORM");
        JpaPreferences.setJpaPlatformID(project, platformConfig.getId());
        subMonitor.worked(1);
        JpaPreferences.setConnectionProfileName(project, (String)dataModel.getProperty("JpaFacetDataModelProperties.CONNECTION"));
        subMonitor.worked(1);
        if (dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            JpaPreferences.setUserOverrideDefaultCatalog(project, dataModel.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG"));
        }
        subMonitor.worked(1);
        if (dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            JpaPreferences.setUserOverrideDefaultSchema(project, dataModel.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA"));
        }
        subMonitor.worked(1);
        JpaPreferences.setDiscoverAnnotatedClasses(project, dataModel.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"));
        subMonitor.worked(1);
        JpaPlatformManager jpaPlatformManager = this.getJpaPlatformManager(project);
        if (jpaPlatformManager != null) {
            jpaPlatformManager.setDefaultJpaPlatformConfig(fv, platformConfig);
        }
        subMonitor.worked(1);
        ((LibraryInstallDelegate)dataModel.getProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)subMonitor.newChild(1));
    }

    protected JpaPlatformManager getJpaPlatformManager(IProject project) {
        JpaWorkspace jpaWorkspace = this.getJpaWorkspace(project);
        return jpaWorkspace == null ? null : jpaWorkspace.getJpaPlatformManager();
    }

    protected JpaWorkspace getJpaWorkspace(IProject project) {
        return (JpaWorkspace)project.getWorkspace().getAdapter(JpaWorkspace.class);
    }
}

