/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.classid;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.log.SdkLog;

public final class ClassIds {
    public static final Collection<Function<String, String>> STORE = new CopyOnWriteArrayList<Function<String, String>>();
    private static volatile boolean automaticallyCreateClassIdAnnotation;

    private ClassIds() {
    }

    public static String next(String ownerTypeFqn) {
        for (Function<String, String> gen : STORE) {
            try {
                String newId = gen.apply(ownerTypeFqn);
                if (newId == null) continue;
                return newId;
            }
            catch (RuntimeException e) {
                SdkLog.warning((CharSequence)"Exception in ClassIdProvider '{}'.", (Object[])new Object[]{gen.getClass().getName(), e});
            }
        }
        return null;
    }

    public static String nextIfEnabled(String context) {
        if (ClassIds.isAutomaticallyCreateClassIdAnnotation()) {
            return ClassIds.next(context);
        }
        return null;
    }

    public static boolean isAutomaticallyCreateClassIdAnnotation() {
        return automaticallyCreateClassIdAnnotation;
    }

    public static void setAutomaticallyCreateClassIdAnnotation(boolean newValue) {
        automaticallyCreateClassIdAnnotation = newValue;
    }

    static {
        STORE.add(context -> UUID.randomUUID().toString());
    }
}

