/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FindExportableNodes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class GenerateExports
implements CompilerPass {
    private static final String PROTOTYPE_PROPERTY = "prototype";
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;
    private final boolean allowNonGlobalExports;
    private final Set<String> exportedVariables = new HashSet<String>();

    GenerateExports(AbstractCompiler compiler, boolean allowNonGlobalExports, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        Preconditions.checkNotNull((Object)exportSymbolFunction);
        Preconditions.checkNotNull((Object)exportPropertyFunction);
        this.compiler = compiler;
        this.allowNonGlobalExports = allowNonGlobalExports;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node externs, Node root) {
        FindExportableNodes findExportableNodes = new FindExportableNodes(this.compiler, this.allowNonGlobalExports);
        NodeTraversal.traverseEs6(this.compiler, root, findExportableNodes);
        LinkedHashMap<String, Node> exports = findExportableNodes.getExports();
        LinkedHashSet<String> localExports = findExportableNodes.getLocalExports();
        for (Map.Entry entry : exports.entrySet()) {
            String export = (String)entry.getKey();
            Node context = (Node)entry.getValue();
            this.addExportMethod(exports, export, context);
        }
        for (String export : localExports) {
            this.addExtern(export);
        }
    }

    private void addExtern(String export) {
        Node propstmt = IR.exprResult(IR.getprop(NodeUtil.newQName(this.compiler, "Object.prototype"), IR.string(export)));
        NodeUtil.setDebugInformation(propstmt, this.getSynthesizedExternsRoot(), export);
        this.getSynthesizedExternsRoot().addChildToBack(propstmt);
        this.compiler.reportCodeChange();
    }

    private void recordExportSymbol(String qname) {
        int dot = qname.indexOf(46);
        if (dot == -1) {
            this.exportedVariables.add(qname);
        } else {
            this.exportedVariables.add(qname.substring(0, dot));
        }
    }

    private void addExportMethod(Map<String, Node> exports, String export, Node context) {
        Node call;
        String parent = null;
        String grandparent = null;
        Node node = context.getFirstChild();
        if (node.isGetProp()) {
            Node parentNode = node.getFirstChild();
            parent = parentNode.getQualifiedName();
            if (parentNode.isGetProp() && parentNode.getLastChild().getString().equals(PROTOTYPE_PROPERTY)) {
                grandparent = parentNode.getFirstChild().getQualifiedName();
            }
        } else if (node.getParent().isMemberFunctionDef()) {
            Node classNode = node.getGrandparent().getParent();
            parent = NodeUtil.getName(classNode);
            parent = parent + (node.getParent().isStaticMember() ? "" : ".prototype");
            export = parent + "." + export;
        }
        boolean useExportSymbol = true;
        if (grandparent != null) {
            useExportSymbol = false;
        } else if (parent != null && exports.containsKey(parent)) {
            useExportSymbol = false;
        } else if (node.getParent().isMemberFunctionDef()) {
            useExportSymbol = false;
        }
        if (useExportSymbol) {
            this.recordExportSymbol(export);
            call = IR.call(NodeUtil.newQName(this.compiler, this.exportSymbolFunction, context, export), IR.string(export), NodeUtil.newQName(this.compiler, export, context, export));
        } else {
            String property = GenerateExports.getPropertyName(node);
            call = IR.call(NodeUtil.newQName(this.compiler, this.exportPropertyFunction, context, this.exportPropertyFunction), NodeUtil.newQName(this.compiler, parent, context, this.exportPropertyFunction), IR.string(property), NodeUtil.newQName(this.compiler, export, context, this.exportPropertyFunction));
        }
        Node expression = IR.exprResult(call).useSourceInfoIfMissingFromForTree(node);
        this.annotate(expression);
        this.addStatement(context, expression);
        this.compiler.reportCodeChange();
    }

    private void addStatement(Node context, Node stmt) {
        Node next;
        Node n;
        CodingConvention convention = this.compiler.getCodingConvention();
        Node exprRoot = n = context;
        while (!NodeUtil.isStatementBlock(exprRoot.getParent())) {
            exprRoot = exprRoot.getParent();
        }
        while ((next = exprRoot.getNext()) != null && NodeUtil.isExprCall(next) && convention.getClassesDefinedByCall(next.getFirstChild()) != null) {
            exprRoot = next;
        }
        Node block = exprRoot.getParent();
        block.addChildAfter(stmt, exprRoot);
    }

    private void annotate(Node node) {
        NodeTraversal.traverseEs6(this.compiler, node, new PrepareAst.PrepareAnnotations());
    }

    private static String getPropertyName(Node node) {
        Preconditions.checkArgument((node.isGetProp() || node.getParent().isMemberFunctionDef() ? 1 : 0) != 0);
        if (node.isGetProp()) {
            return node.getLastChild().getString();
        }
        return node.getParent().getString();
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }
}

