/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class BP1203
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1203(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        boolean qualifiedAttributes = false;
        if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else if (entryContext.getMessageEntry().getType().equalsIgnoreCase("response")) {
            NodeList faultList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (faultList == null || faultList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    int i = 0;
                    while (i < faultList.getLength()) {
                        Element soapFault = (Element)faultList.item(i);
                        NodeList detailList = soapFault.getElementsByTagName("detail");
                        if (detailList != null) {
                            int j = 0;
                            while (j < detailList.getLength()) {
                                NamedNodeMap detailAttribs = detailList.item(j).getAttributes();
                                if (detailAttribs != null) {
                                    int k = 0;
                                    while (k < detailAttribs.getLength()) {
                                        Attr nextAttr = (Attr)detailAttribs.item(k);
                                        if (nextAttr.getNamespaceURI() != null) {
                                            qualifiedAttributes = true;
                                            if (nextAttr.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                                                throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                                            }
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (!qualifiedAttributes) {
                        this.result = "notApplicable";
                    }
                }
                catch (AssertionFailException e) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
                }
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

