/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.image.SVGRasterizer;

public class JSVGRasterizer
implements SVGRasterizer {
    private static final SVGLoader SVG_LOADER = new SVGLoader();
    private static final Map<RenderingHints.Key, Object> RENDERING_HINTS = Map.of(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY, RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY, RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE, RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON, RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC, RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE, RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

    public ImageData rasterizeSVG(InputStream inputStream, int zoom) {
        if (zoom < 0) {
            SWT.error((int)5);
        }
        SVGDocument svgDocument = this.loadAndValidateSVG(inputStream);
        BufferedImage rasterizedImage = this.renderSVG(svgDocument, zoom);
        return this.convertToSWTImageData(rasterizedImage);
    }

    public ImageData rasterizeSVG(InputStream inputStream, int width, int height) {
        SVGDocument svgDocument = this.loadAndValidateSVG(inputStream);
        BufferedImage rasterizedImage = this.renderSVG(svgDocument, width, height);
        return this.convertToSWTImageData(rasterizedImage);
    }

    private SVGDocument loadAndValidateSVG(InputStream inputStream) {
        SVGDocument svgDocument = SVG_LOADER.load(inputStream, null, LoaderContext.createDefault());
        if (svgDocument == null) {
            SWT.error((int)40);
        }
        return svgDocument;
    }

    private BufferedImage renderSVG(SVGDocument svgDocument, int zoom) {
        FloatSize sourceImageSize = svgDocument.size();
        float scalingFactor = (float)zoom / 100.0f;
        int targetImageWidth = this.calculateTargetWidth(scalingFactor, sourceImageSize);
        int targetImageHeight = this.calculateTargetHeight(scalingFactor, sourceImageSize);
        return this.renderSVG(svgDocument, targetImageWidth, targetImageHeight);
    }

    private BufferedImage renderSVG(SVGDocument svgDocument, int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error((int)5);
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        float widthScalingFactor = (float)width / svgDocument.size().width;
        float heightScalingFactor = (float)height / svgDocument.size().height;
        Graphics2D g = this.configureRenderingOptions(widthScalingFactor, heightScalingFactor, image);
        svgDocument.render(null, g);
        g.dispose();
        return image;
    }

    private int calculateTargetWidth(float scalingFactor, FloatSize sourceImageSize) {
        double sourceImageWidth = sourceImageSize.getWidth();
        return (int)Math.round(sourceImageWidth * (double)scalingFactor);
    }

    private int calculateTargetHeight(float scalingFactor, FloatSize sourceImageSize) {
        double sourceImageHeight = sourceImageSize.getHeight();
        return (int)Math.round(sourceImageHeight * (double)scalingFactor);
    }

    private Graphics2D configureRenderingOptions(float widthScalingFactor, float heightScalingFactor, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        g.setRenderingHints(RENDERING_HINTS);
        g.scale(widthScalingFactor, heightScalingFactor);
        return g;
    }

    private ImageData convertToSWTImageData(BufferedImage rasterizedImage) {
        int width = rasterizedImage.getWidth();
        int height = rasterizedImage.getHeight();
        int[] pixels = ((DataBufferInt)rasterizedImage.getRaster().getDataBuffer()).getData();
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(width, height, 24, paletteData);
        int index = 0;
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                int alpha = pixels[index] >> 24 & 0xFF;
                imageData.setAlpha(x, y, alpha);
                imageData.setPixel(x, y, pixels[index++] & 0xFFFFFF);
                ++x;
            }
            ++y;
        }
        return imageData;
    }
}

