/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Reference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractFileSetTest {
    private Project project;
    private AbstractFileSet f;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.project = new Project();
        this.project.setBasedir(".");
        this.f = this.getInstance();
    }

    protected abstract AbstractFileSet getInstance();

    protected final Project getProject() {
        return this.project;
    }

    @Test
    public final void testCannotSetIncludesThenRefid() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.setIncludes("**/*.java");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
    }

    @Test
    public final void testCannotAddPatternSetThenRefid() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify nested elements when using refid");
        this.f.createPatternSet();
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
    }

    @Test
    public final void testCannotAddIncludeThenRefid() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.createInclude();
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
    }

    @Test
    public final void testCannotSetRefidThenIncludes() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.setIncludes("**/*.java");
    }

    @Test
    public final void testCannotSetRefidThenIncludesfile() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.setIncludesfile(new File("/a"));
    }

    @Test
    public final void testCannotSetRefidThenExcludes() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.setExcludes("**/*.java");
    }

    @Test
    public final void testCannotSetRefidThenExcludesfile() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.setExcludesfile(new File("/a"));
    }

    @Test
    public final void testCannotSetRefidThenDir() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify more than one attribute when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.setDir(this.project.resolveFile("."));
    }

    @Test
    public final void testCannotSetRefidThenAddInclude() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify nested elements when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.createInclude();
    }

    @Test
    public final void testCannotSetRefidThenAddExclude() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify nested elements when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.createExclude();
    }

    @Test
    public final void testCannotSetRefidThenAddIncludesfile() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify nested elements when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.createIncludesFile();
    }

    @Test
    public final void testCannotSetRefidThenAddExcludesFile() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify nested elements when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.createExcludesFile();
    }

    @Test
    public final void testCannotSetRefidThenAddPatternset() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("You must not specify nested elements when using refid");
        this.f.setRefid(new Reference(this.getProject(), "dummyref"));
        this.f.createPatternSet();
    }

    @Test
    public void testCircularReferenceCheckGetDir() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("This data type contains a circular reference.");
        this.project.addReference("dummy", (Object)this.f);
        this.f.setRefid(new Reference(this.getProject(), "dummy"));
        this.f.getDir(this.project);
    }

    @Test
    public void testCircularReferenceCheckGetDirScanner() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("This data type contains a circular reference.");
        this.project.addReference("dummy", (Object)this.f);
        this.f.setRefid(new Reference(this.getProject(), "dummy"));
        this.f.getDirectoryScanner(this.project);
    }

    @Test
    public void testLoopReferenceCheckGetDir() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("This data type contains a circular reference.");
        this.project.addReference("dummy1", (Object)this.f);
        this.f.setRefid(new Reference(this.getProject(), "dummy2"));
        AbstractFileSet fa = this.getInstance();
        this.project.addReference("dummy2", (Object)fa);
        fa.setRefid(new Reference(this.getProject(), "dummy3"));
        AbstractFileSet fb = this.getInstance();
        this.project.addReference("dummy3", (Object)fb);
        fb.setRefid(new Reference(this.getProject(), "dummy1"));
        this.f.getDir(this.project);
    }

    @Test
    public void testLoopReferenceCheckGetDirScanner() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("This data type contains a circular reference.");
        this.project.addReference("dummy1", (Object)this.f);
        this.f.setRefid(new Reference(this.getProject(), "dummy2"));
        AbstractFileSet fa = this.getInstance();
        this.project.addReference("dummy2", (Object)fa);
        fa.setRefid(new Reference(this.getProject(), "dummy3"));
        AbstractFileSet fb = this.getInstance();
        this.project.addReference("dummy3", (Object)fb);
        fb.setRefid(new Reference(this.getProject(), "dummy1"));
        this.f.getDirectoryScanner(this.project);
    }

    @Test
    public void testLoopReferenceCheck() {
        this.project.addReference("dummy1", (Object)this.f);
        this.f.setRefid(new Reference(this.getProject(), "dummy2"));
        AbstractFileSet fa = this.getInstance();
        this.project.addReference("dummy2", (Object)fa);
        fa.setRefid(new Reference(this.getProject(), "dummy3"));
        AbstractFileSet fb = this.getInstance();
        this.project.addReference("dummy3", (Object)fb);
        fb.setDir(this.project.resolveFile("."));
        File dir = this.f.getDir(this.project);
        Assert.assertEquals((String)"Dir is basedir", (Object)dir, (Object)this.project.getBaseDir());
    }

    @Test
    public void canCallSetFileTwiceWithSameArgument() {
        this.f.setFile(new File("/a"));
        this.f.setFile(new File("/a"));
    }

    @Test
    public void cannotCallSetFileTwiceWithDifferentArguments() {
        this.thrown.expect(BuildException.class);
        this.thrown.expectMessage("setFile cannot be called twice with different arguments");
        this.f.setFile(new File("/a"));
        this.f.setFile(new File("/b"));
    }
}

