/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.io.File;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CompilationDirectorySourceContainerDialog
extends TitleAreaDialog {
    private static final String LAST_PATH_SETTING = "EXT_FOLDER_LAST_PATH_SETTING";
    private static final String LAST_SUBDIR_SETTING = "EXT_FOLDER_LAST_SUBDIR_SETTING";
    private String fDirectory;
    private boolean fCompilationSubfolders;
    private Text fDirText;
    private Button fSubfoldersButton;
    private boolean fNewContainer;

    public CompilationDirectorySourceContainerDialog(Shell shell) {
        this(shell, "", CDebugUIPlugin.getDefault().getDialogSettings().getBoolean(LAST_SUBDIR_SETTING));
        this.fNewContainer = true;
    }

    public CompilationDirectorySourceContainerDialog(Shell shell, String directory, boolean compilationSubfolders) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDirectory = directory;
        this.fCompilationSubfolders = compilationSubfolders;
        this.fNewContainer = false;
    }

    public String getDirectory() {
        return this.fDirectory;
    }

    public boolean isCompilationSubfolders() {
        return this.fCompilationSubfolders;
    }

    protected Control createDialogArea(Composite parent) {
        Image image = this.fNewContainer ? CDebugImages.get("IMG_ADD_SRC_DIRECTORY") : CDebugImages.get("IMG_EDIT_SRC_DIRECTORY");
        this.setTitle(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_2);
        this.setMessage(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_3);
        this.setTitleImage(image);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        Composite dirComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        dirComposite.setLayout((Layout)layout);
        dirComposite.setLayoutData((Object)new GridData(768));
        dirComposite.setFont(font);
        Label label = new Label(dirComposite, 0);
        label.setText(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_4);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.fDirText = new Text(dirComposite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fDirText.setLayoutData((Object)data);
        this.fDirText.setFont(font);
        this.fDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilationDirectorySourceContainerDialog.this.validate();
            }
        });
        Button button = new Button(dirComposite, 8);
        button.setText(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_5);
        data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CompilationDirectorySourceContainerDialog.this.browse();
            }
        });
        this.fSubfoldersButton = new Button(dirComposite, 32);
        this.fSubfoldersButton.setText(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_6);
        data = new GridData(768);
        data.verticalIndent = layout.verticalSpacing;
        this.fSubfoldersButton.setLayoutData((Object)data);
        this.fSubfoldersButton.setFont(font);
        return parentComposite;
    }

    protected void configureShell(Shell newShell) {
        String title = null;
        title = this.fNewContainer ? SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_7 : SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_8;
        newShell.setText(title);
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.fDirText.setText(this.fDirectory);
        this.fSubfoldersButton.setSelection(this.fCompilationSubfolders);
        this.validate();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, ICDebugHelpContextIds.COMPILATION_DIRECTORY_SOURCE_CONTAINER_DIALOG);
        return c;
    }

    protected void okPressed() {
        this.fDirectory = this.fDirText.getText().trim();
        this.fCompilationSubfolders = this.fSubfoldersButton.getSelection();
        CDebugUIPlugin.getDefault().getDialogSettings().put(LAST_PATH_SETTING, this.fDirectory);
        CDebugUIPlugin.getDefault().getDialogSettings().put(LAST_SUBDIR_SETTING, this.fCompilationSubfolders);
        super.okPressed();
    }

    private void browse() {
        String last = this.fDirText.getText().trim();
        if (last.length() == 0) {
            last = CDebugUIPlugin.getDefault().getDialogSettings().get(LAST_PATH_SETTING);
        }
        if (last == null) {
            last = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4);
        dialog.setText(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_0);
        dialog.setMessage(SourceLookupUIMessages.CompilationDirectorySourceContainerDialog_1);
        dialog.setFilterPath(last);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        this.fDirText.setText(result);
    }

    private void validate() {
        File file = new File(this.fDirText.getText().trim());
        this.getButton(0).setEnabled(file.isDirectory() && file.exists());
    }
}

