/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.typesystem;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.typesystem.computation.EnumLiteralImporter;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.XbaseTypeComputer;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XbaseWithAnnotationsTypeComputer
extends XbaseTypeComputer {
    @Override
    public void computeTypes(XExpression expression, ITypeComputationState state) {
        if (expression instanceof XAnnotation) {
            this._computeTypes((XAnnotation)expression, state);
        } else {
            super.computeTypes(expression, state);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _computeTypes(XAnnotation object, ITypeComputationState state) {
        JvmType annotationType = object.getAnnotationType();
        if (annotationType != null && !annotationType.eIsProxy()) {
            if (annotationType instanceof JvmAnnotationType) {
                XExpression expression = object.getValue();
                if (expression != null) {
                    Iterable iterable = ((JvmAnnotationType)annotationType).findAllFeaturesByName("value");
                    JvmFeature value = (JvmFeature)Iterables.getOnlyElement((Iterable)iterable, null);
                    if (value != null) {
                        if (!(value instanceof JvmOperation)) throw new IllegalStateException("Unexpected feature type " + String.valueOf(value));
                        this.computeTypes(object, (JvmOperation)value, expression, state);
                    } else {
                        state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.no_attribute_value", "The attribute value is undefined for the annotation type " + annotationType.getSimpleName(), (EObject)object, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__VALUE, -1, null));
                        state.withNonVoidExpectation().computeTypes(expression);
                    }
                } else {
                    EList<XAnnotationElementValuePair> valuePairs = object.getElementValuePairs();
                    if (valuePairs.isEmpty()) {
                        Iterable iterable = ((JvmAnnotationType)annotationType).findAllFeaturesByName("value");
                        JvmFeature value = (JvmFeature)Iterables.getOnlyElement((Iterable)iterable, null);
                        if (value != null) {
                            if (!(value instanceof JvmOperation)) throw new IllegalStateException("Unexpected feature type " + String.valueOf(value));
                            this.computeTypes(object, (JvmOperation)value, null, state);
                        }
                    } else {
                        for (XAnnotationElementValuePair pair : valuePairs) {
                            this.computeTypes(object, pair.getElement(), pair.getValue(), state);
                        }
                    }
                }
            } else {
                state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from %s to Annotation", annotationType.getSimpleName()), (EObject)object, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, null));
                this.computeChildTypesForUnknownAnnotation(object, state);
            }
            state.acceptActualType(state.getReferenceOwner().newParameterizedTypeReference(annotationType));
            return;
        } else {
            this.computeChildTypesForUnknownAnnotation(object, state);
        }
    }

    protected void computeChildTypesForUnknownAnnotation(XAnnotation object, ITypeComputationState state) {
        XExpression expression = object.getValue();
        if (expression != null) {
            state.withNonVoidExpectation().computeTypes(expression);
        } else {
            EList<XAnnotationElementValuePair> valuePairs = object.getElementValuePairs();
            for (XAnnotationElementValuePair pair : valuePairs) {
                this.computeTypes(object, pair.getElement(), pair.getValue(), state);
            }
        }
    }

    protected void computeTypes(XAnnotation annotation, JvmOperation operation, XExpression value, ITypeComputationState state) {
        LightweightTypeReference expectation;
        LightweightTypeReference lightweightTypeReference = expectation = operation == null || operation.eIsProxy() ? null : state.getReferenceOwner().toLightweightTypeReference(operation.getReturnType());
        if (expectation != null && expectation.isArray()) {
            LightweightTypeReference componentType = expectation.getComponentType();
            if (componentType == null) {
                throw new IllegalStateException("Array without component type: " + expectation.getIdentifier());
            }
            LightweightTypeReference actualExpectation = value instanceof XListLiteral ? expectation : componentType;
            ITypeComputationState expectationState = this.addEnumImportsIfNecessary(state, actualExpectation, componentType.getType());
            expectationState.withinScope(annotation);
            if (value == null) {
                return;
            }
            ITypeComputationResult result = expectationState.computeTypes(value);
            LightweightTypeReference resultType = result.getActualExpressionType();
            if (resultType != null && !actualExpectation.isAssignableFrom(resultType)) {
                if (value instanceof XListLiteral) {
                    state.refineExpectedType(value, resultType);
                } else {
                    CompoundTypeReference bothExpectations = state.getReferenceOwner().newCompoundTypeReference(true);
                    bothExpectations.addComponent(componentType);
                    bothExpectations.addComponent(expectation);
                    state.refineExpectedType(value, bothExpectations);
                }
            }
        } else if (expectation == null) {
            state.withNonVoidExpectation().computeTypes(value);
        } else {
            ArrayTypeReference array;
            ITypeComputationState expectationState = this.addEnumImportsIfNecessary(state, expectation, expectation.getType());
            expectationState.withinScope(annotation);
            if (value == null) {
                return;
            }
            ITypeComputationResult valueResult = expectationState.computeTypes(value);
            LightweightTypeReference valueResultType = valueResult.getActualExpressionType();
            if (valueResultType != null && !expectation.isAssignableFrom(valueResultType) && value instanceof XListLiteral && (array = valueResultType.tryConvertToArray()) != null) {
                LightweightTypeReference primitiveComponentType = array.getComponentType().getPrimitiveIfWrapperType();
                state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", "Type mismatch: cannot convert from " + String.valueOf(primitiveComponentType) + "[] to " + expectation.getHumanReadableName(), (EObject)value, null, -1, null));
                state.refineExpectedType(value, array.getOwner().newArrayTypeReference(primitiveComponentType));
            }
        }
    }

    private ITypeComputationState addEnumImportsIfNecessary(ITypeComputationState state, LightweightTypeReference expectedType, JvmType enumTypeCandidate) {
        ITypeComputationState expectationState = state.withExpectation(expectedType);
        if (enumTypeCandidate != null && enumTypeCandidate.eClass() == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            expectationState.addImports(new EnumLiteralImporter((JvmDeclaredType)enumTypeCandidate));
        }
        return expectationState;
    }
}

