/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.quickfix;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.BundleId;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.result.Result;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.pde.bnd.ui.autocomplete.AddBundleCompletionProposal;

public class BuildpathQuickFixProcessor
implements IQuickFixProcessor {
    Project project;
    IInvocationContext context;
    private boolean test;
    private Workspace workspace;
    Map<BundleId, Map<String, Boolean>> proposals;
    Set<ITypeBinding> visited;
    IProblemLocation location;
    final ASTVisitor TYPE_VISITOR = new ASTVisitor(){

        public void preVisit(ASTNode node) {
            if (node instanceof Type) {
                ITypeBinding binding = ((Type)node).resolveBinding();
                try {
                    BuildpathQuickFixProcessor.this.visitBindingHierarchy(binding);
                }
                catch (Exception e) {
                    throw Exceptions.duck((Throwable)e);
                }
            }
        }
    };

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 0x1000140: {
                return true;
            }
            case 0x1000118: {
                return true;
            }
            case 16777543: {
                return true;
            }
            case 16777372: {
                return true;
            }
            case 0x1000144: {
                return true;
            }
            case 268435846: {
                return true;
            }
            case 67108979: {
                return true;
            }
            case 16777742: {
                return true;
            }
            case 0x1000011: {
                return true;
            }
            case 0x8000082: {
                return true;
            }
            case 33554502: {
                return true;
            }
            case 0x4000064: {
                return true;
            }
            case 0x1000002: {
                return true;
            }
            case 0x22000032: {
                return true;
            }
            case 16777384: {
                return true;
            }
            case 33554515: {
                return true;
            }
        }
        return false;
    }

    void visitExpressionHierarchy(Expression expression) {
        if (expression == null) {
            return;
        }
        this.visitBindingHierarchy(expression.resolveTypeBinding());
    }

    void visitBindingHierarchy(ITypeBinding binding) {
        try {
            if (binding == null) {
                return;
            }
            String qualifiedName = binding.getQualifiedName();
            if (!this.visited.add(binding)) {
                return;
            }
            if (binding.isRecovered()) {
                this.addProposals(binding);
            }
            ITypeBinding[] iTypeBindingArray = binding.getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeParam = iTypeBindingArray[n2];
                this.visitBindingHierarchy(typeParam);
                ++n2;
            }
            if (qualifiedName.startsWith("java.")) {
                return;
            }
            this.visitBindingHierarchy(binding.getSuperclass());
            iTypeBindingArray = binding.getInterfaces();
            n = iTypeBindingArray.length;
            n2 = 0;
            while (n2 < n) {
                ITypeBinding iface = iTypeBindingArray[n2];
                this.visitBindingHierarchy(iface);
                ++n2;
            }
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    void visitSuperclassBindingHierarchy(ITypeBinding binding) {
        try {
            if (binding == null) {
                return;
            }
            String qualifiedName = binding.getQualifiedName();
            if (qualifiedName.startsWith("java.")) {
                return;
            }
            if (!this.visited.add(binding)) {
                return;
            }
            if (binding.isRecovered()) {
                this.addProposals(binding);
            }
            this.visitSuperclassBindingHierarchy(binding.getSuperclass());
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    void visitType(Type node) {
        if (node == null) {
            return;
        }
        this.visitBindingHierarchy(node.resolveBinding());
    }

    void visitTypeDeclaration(TypeDeclaration node) {
        this.visitType(node.getSuperclassType());
        List superInterfaceTypes = node.superInterfaceTypes();
        for (Type iface : superInterfaceTypes) {
            this.visitType(iface);
        }
    }

    void visitEnclosingTypeDeclaration(ASTNode node) {
        if (node == null) {
            return;
        }
        TypeDeclaration td = this.findFirstParentOfType(node, TypeDeclaration.class);
        if (td != null) {
            this.visitTypeDeclaration(td);
            this.visitEnclosingTypeDeclaration(td.getParent());
        }
    }

    void visitNodeAncestry(ASTNode node) throws Exception {
        while (node != null) {
            if (node instanceof Type) {
                this.visitType((Type)node);
                break;
            }
            if (node instanceof TypeDeclaration) {
                this.visitTypeDeclaration((TypeDeclaration)node);
                break;
            }
            node = node.getParent();
        }
    }

    @SafeVarargs
    final ASTNode findFirstParentWithOneOfTypes(ASTNode node, Class<? extends ASTNode> ... types) {
        while (node != null) {
            Class<? extends ASTNode>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends ASTNode> type = classArray[n2];
                if (type.isAssignableFrom(node.getClass())) {
                    return node;
                }
                ++n2;
            }
            node = node.getParent();
        }
        return null;
    }

    <N extends ASTNode> N findFirstParentOfType(ASTNode node, Class<N> type) {
        while (node != null) {
            if (type.isAssignableFrom(node.getClass())) {
                ASTNode retval = node;
                return (N)retval;
            }
            node = node.getParent();
        }
        return null;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        Stream<Object> results;
        Set testpath;
        block53: {
            ICompilationUnit compUnit;
            block52: {
                IJavaProject java;
                block51: {
                    this.context = context;
                    this.proposals = new HashMap<BundleId, Map<String, Boolean>>();
                    this.visited = new HashSet<ITypeBinding>();
                    compUnit = context.getCompilationUnit();
                    java = compUnit.getJavaProject();
                    if (java != null) break block51;
                    return null;
                }
                this.project = (Project)Adapters.adapt((Object)java.getProject(), Project.class);
                if (this.project != null) break block52;
                return null;
            }
            try {
                this.test = this.isInDir(this.project.getTestSrc(), compUnit.getResource());
                this.workspace = this.project.getWorkspace();
                IProblemLocation[] iProblemLocationArray = locations;
                int n = locations.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblemLocation location;
                    this.location = location = iProblemLocationArray[n2];
                    block4 : switch (location.getProblemId()) {
                        case 0x1000118: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            Type type = this.findFirstParentOfType(node, Type.class);
                            if (type == null) {
                                ImportDeclaration importDec = this.findFirstParentOfType(node, ImportDeclaration.class);
                                this.addProposalsForImport(importDec);
                                break;
                            }
                            ITypeBinding binding = type.resolveBinding();
                            this.addProposals(binding.getPackage().getName(), BuildpathQuickFixProcessor.getClassName(binding));
                            break;
                        }
                        case 16777384: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            ASTNode e = this.findFirstParentWithOneOfTypes(node, Expression.class, SuperConstructorInvocation.class);
                            if (e == null) break;
                            IMethodBinding mb = null;
                            if (e instanceof MethodInvocation) {
                                mb = ((MethodInvocation)e).resolveMethodBinding();
                            } else if (e instanceof SuperMethodInvocation) {
                                mb = ((SuperMethodInvocation)e).resolveMethodBinding();
                            } else if (e instanceof ClassInstanceCreation) {
                                mb = ((ClassInstanceCreation)e).resolveConstructorBinding();
                            } else if (e instanceof SuperConstructorInvocation) {
                                mb = ((SuperConstructorInvocation)e).resolveConstructorBinding();
                            }
                            if (mb == null) break;
                            ITypeBinding[] iTypeBindingArray = mb.getExceptionTypes();
                            int n3 = iTypeBindingArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ITypeBinding exceptionType = iTypeBindingArray[n4];
                                this.visitSuperclassBindingHierarchy(exceptionType);
                                ++n4;
                            }
                            break;
                        }
                        case 0x1000140: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            Type type = this.findFirstParentOfType(node, Type.class);
                            if (type == null) break;
                            this.visitSuperclassBindingHierarchy(type.resolveBinding());
                            break;
                        }
                        case 16777543: 
                        case 16777742: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            this.visitNodeAncestry(node);
                            break;
                        }
                        case 16777372: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            if (!(node instanceof CastExpression)) break;
                            CastExpression cast = (CastExpression)node;
                            this.visitBindingHierarchy(cast.getType().resolveBinding());
                            break;
                        }
                        case 0x1000011: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            node.accept(this.TYPE_VISITOR);
                            break;
                        }
                        case 0x8000082: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            this.visitEnclosingTypeDeclaration(node);
                            break;
                        }
                        case 33554502: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            ASTNode parent = node.getParent();
                            if (parent == null) break;
                            switch (parent.getNodeType()) {
                                case 40: {
                                    QualifiedName n5 = (QualifiedName)parent;
                                    IBinding binding = n5.getQualifier().resolveBinding();
                                    if (!(binding instanceof IVariableBinding)) break;
                                    this.visitBindingHierarchy(((IVariableBinding)binding).getType());
                                    break;
                                }
                                case 22: {
                                    FieldAccess access = (FieldAccess)parent;
                                    this.visitExpressionHierarchy(access.getExpression());
                                    break;
                                }
                                case 47: {
                                    this.visitEnclosingTypeDeclaration(parent);
                                }
                            }
                            break;
                        }
                        case 0x4000064: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            ASTNode parent = node.getParent();
                            while (parent != null) {
                                switch (parent.getNodeType()) {
                                    case 32: {
                                        Expression leftOfTheDot = ((MethodInvocation)parent).getExpression();
                                        if (leftOfTheDot == null) {
                                            this.visitEnclosingTypeDeclaration(parent);
                                            break block4;
                                        }
                                        this.visitExpressionHierarchy(leftOfTheDot);
                                        break block4;
                                    }
                                    case 48: {
                                        SuperMethodInvocation invocation = (SuperMethodInvocation)parent;
                                        Name qualifier = invocation.getQualifier();
                                        if (qualifier == null) {
                                            TypeDeclaration type = this.findFirstParentOfType(parent, TypeDeclaration.class);
                                            this.visitBindingHierarchy(type.getSuperclassType().resolveBinding());
                                            break block4;
                                        }
                                        this.visitBindingHierarchy(qualifier.resolveTypeBinding());
                                        break block4;
                                    }
                                }
                                parent = parent.getParent();
                            }
                            break;
                        }
                        case 67108979: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            MethodInvocation invocation = this.findFirstParentOfType(node, MethodInvocation.class);
                            List args = invocation.arguments();
                            args.forEach(this::visitExpressionHierarchy);
                            this.visitExpressionHierarchy(invocation.getExpression());
                            break;
                        }
                        case 268435846: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            ImportDeclaration importDec = this.findFirstParentOfType(node, ImportDeclaration.class);
                            if (importDec == null) break;
                            this.addProposalsForImport(importDec);
                            break;
                        }
                        case 0x22000032: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            this.visitEnclosingTypeDeclaration(node);
                            String partialClassName = this.getPartialClassName(node);
                            if (partialClassName == null) break;
                            this.addProposals(partialClassName);
                            break;
                        }
                        case 33554515: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            this.visitEnclosingTypeDeclaration(node);
                            this.addProposals(this.getCoveringName(node));
                            break;
                        }
                        case 0x1000002: {
                            ASTNode node = location.getCoveredNode(context.getASTRoot());
                            if (node instanceof Name) {
                                while (node != null && node instanceof Name) {
                                    node = node.getParent();
                                }
                                if (node == null) break;
                                if (node instanceof Type) {
                                    this.addProposalsForType((Type)node);
                                    break;
                                }
                                if (!(node instanceof Annotation)) break;
                                this.addProposals(((Annotation)node).getTypeName());
                                break;
                            }
                            if (!(node instanceof TypeLiteral)) break;
                            TypeLiteral tl = (TypeLiteral)node;
                            this.addProposalsForType(tl.getType());
                            break;
                        }
                        case 0x1000144: {
                            String partialClassName = null;
                            if (location.getProblemArguments().length > 0) {
                                partialClassName = location.getProblemArguments()[0];
                            }
                            if (partialClassName == null) {
                                partialClassName = this.getPartialClassName(location.getCoveringNode(context.getASTRoot()));
                            }
                            if (partialClassName == null) break;
                            this.addProposals(partialClassName);
                        }
                    }
                    ++n2;
                }
                if (!this.proposals.isEmpty()) break block53;
                return null;
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }
        Set buildpath = this.getBundleIds(this.project.getBuildpath()).stream().map(BundleId::getBsn).collect(Collectors.toSet());
        Set set = testpath = this.test ? this.getBundleIds(this.project.getTestpath()).stream().map(BundleId::getBsn).collect(Collectors.toSet()) : Collections.emptySet();
        if (this.test) {
            HashSet testBundlesAdded = new HashSet();
            results = this.proposals.entrySet().stream().filter(entry -> !testpath.contains(((BundleId)entry.getKey()).getBsn())).filter(entry -> testBundlesAdded.add(((BundleId)entry.getKey()).getBsn())).map(entry -> new AddBundleCompletionProposal((BundleId)entry.getKey(), (Map)entry.getValue(), 15 + ((Map)entry.getValue()).size(), context, this.project, "-testpath"));
        } else {
            results = Stream.empty();
        }
        HashSet bundlesAdded = new HashSet();
        IJavaCompletionProposal[] retval = (IJavaCompletionProposal[])Stream.concat(results, this.proposals.entrySet().stream().filter(entry -> !buildpath.contains(((BundleId)entry.getKey()).getBsn())).filter(entry -> bundlesAdded.add(((BundleId)entry.getKey()).getBsn())).map(entry -> new AddBundleCompletionProposal((BundleId)entry.getKey(), (Map)entry.getValue(), 14 + ((Map)entry.getValue()).size(), context, this.project, "-buildpath"))).toArray(IJavaCompletionProposal[]::new);
        return retval.length == 0 ? null : retval;
    }

    private void addProposalsForImport(ImportDeclaration importDec) throws Exception {
        if (importDec == null) {
            return;
        }
        Name name = importDec.getName();
        if (importDec.isStatic() && !importDec.isOnDemand()) {
            if (name instanceof QualifiedName) {
                this.addProposals(((QualifiedName)name).getQualifier().getFullyQualifiedName());
            }
        } else if (importDec.isOnDemand() || name instanceof QualifiedName) {
            this.addProposals(name.getFullyQualifiedName());
        }
    }

    private void addProposalsForType(Type type) throws CoreException, Exception {
        if (type == null) {
            return;
        }
        switch (type.getNodeType()) {
            case 88: {
                NameQualifiedType nqt = (NameQualifiedType)type;
                this.addProposals(nqt.getQualifier().getFullyQualifiedName().toString(), nqt.getName().toString());
                this.addProposals(nqt.getQualifier());
                return;
            }
            case 75: {
                QualifiedType qt = (QualifiedType)type;
                this.addProposalsForType(qt.getQualifier());
                return;
            }
            case 43: {
                SimpleType st = (SimpleType)type;
                this.addProposals(st.getName());
            }
        }
    }

    private void addProposals(ITypeBinding typeBinding) throws CoreException, Exception {
        if (typeBinding == null) {
            throw new NullPointerException();
        }
        ITypeBinding erasure = typeBinding.getErasure();
        String className = BuildpathQuickFixProcessor.getClassName(erasure);
        if (erasure.getPackage() != null) {
            String packageName = erasure.getPackage().getName();
            if (!Stream.of(this.context.getCompilationUnit().getPackageDeclarations()).filter(Objects::nonNull).map(IPackageDeclaration::getElementName).anyMatch(packageName::equals)) {
                this.doAddProposals((Result<Map<String, List<BundleId>>>)this.workspace.search(packageName, className), true);
                return;
            }
        }
        this.addProposals(className);
    }

    private static String getClassName(ITypeBinding typeBinding) {
        StringBuilder className = new StringBuilder(128);
        BuildpathQuickFixProcessor.getClassName(typeBinding, className);
        return className.toString();
    }

    private static void getClassName(ITypeBinding typeBinding, StringBuilder buffer) {
        ITypeBinding parent = typeBinding.getDeclaringClass();
        if (parent != null) {
            BuildpathQuickFixProcessor.getClassName(parent, buffer);
            buffer.append('.');
        }
        buffer.append(typeBinding.getName());
    }

    private void addProposals(Name name) throws CoreException, Exception {
        if (name == null) {
            return;
        }
        if (name instanceof SimpleName) {
            this.addProposals(null, name.toString());
        } else if (name instanceof QualifiedName) {
            QualifiedName qualified = (QualifiedName)name;
            Name qualifier = qualified.getQualifier();
            this.addProposals(qualifier.toString(), qualified.getName().toString());
            this.addProposals(qualifier);
        }
    }

    private void addProposals(String partialClassName) throws CoreException, Exception {
        boolean doImport = (Boolean)Descriptors.determine((String)partialClassName).map(sa -> sa[0] == null).orElse((Object)false);
        this.doAddProposals((Result<Map<String, List<BundleId>>>)this.workspace.search(partialClassName), doImport);
    }

    private void addProposals(String packageName, String className) throws CoreException, Exception {
        this.doAddProposals((Result<Map<String, List<BundleId>>>)this.workspace.search(packageName, className), packageName == null || packageName.length() == 0);
    }

    private void doAddProposals(Result<Map<String, List<BundleId>>> wrappedResult, boolean doImport) throws CoreException, Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ProjectBuilder pb = new ProjectBuilder(this.project);){
            if (this.test) {
                pb.includeTestpath();
            }
            Map result = (Map)wrappedResult.orElseThrow(s -> new CoreException((IStatus)new Status(4, this.getClass(), s)));
            result.entrySet().stream().filter(e -> !this.isOnBuildOrTestPath(pb, (String)e.getKey())).forEach(e -> {
                for (BundleId id : (List)e.getValue()) {
                    this.proposals.computeIfAbsent(id, newBundleId -> new HashMap()).merge((String)e.getKey(), doImport, (oldVal, newVal) -> oldVal != false || newVal != false);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean isOnBuildOrTestPath(ProjectBuilder pb, String fqn) {
        Descriptors.TypeRef type;
        block3: {
            try {
                type = pb.getTypeRefFromFQN(fqn);
                if (type != null) break block3;
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        String pack = type.getPackageRef().getPath();
        boolean result = pb.getClasspath().stream().filter(jar -> jar.getResource(type.getPath()) != null).anyMatch(jar -> {
            Manifest m;
            block3: {
                try {
                    m = jar.getManifest();
                    if (m != null) break block3;
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return new Parameters(m.getMainAttributes().getValue("Export-Package"), null, true).containsKey(pack);
        });
        return result;
    }

    private boolean isInDir(File dir, IResource resource) {
        if (resource == null || dir == null) {
            return false;
        }
        IPath location = resource.getLocation();
        if (location != null) {
            File file = location.toFile();
            return this.isInDir(dir, file);
        }
        return false;
    }

    private boolean isInDir(File dir, File file) {
        Path d = dir.toPath();
        Path f = file.toPath();
        return f.startsWith(d);
    }

    private Set<BundleId> getBundleIds(Collection<Container> collection) throws Exception {
        return collection.stream().filter(c -> c.getError() == null).map(Container::getBundleId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Name getCoveringName(ASTNode node) {
        Name name = null;
        while (node instanceof Name) {
            name = (Name)node;
            node = node.getParent();
        }
        return name;
    }

    private String getPartialClassName(ASTNode node) {
        Name name = this.getCoveringName(node);
        return name == null ? null : name.toString();
    }
}

