/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors;

import java.util.ArrayList;
import org.eclipse.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.cdt.autotools.ui.editors.AutoconfMacro;
import org.eclipse.cdt.autotools.ui.editors.AutoconfMacroParameterListValidator;
import org.eclipse.cdt.autotools.ui.editors.AutoconfMacroProposalContextInformation;
import org.eclipse.cdt.internal.autotools.ui.text.hover.AutoconfTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class AutoconfMacroContentAssistProcessor
implements IContentAssistProcessor {
    protected AutoconfEditor editor;

    public AutoconfMacroContentAssistProcessor(AutoconfEditor editor) {
        this.editor = editor;
    }

    private int computeMacroStart(IDocument document, int offset) {
        try {
            while (Character.isJavaIdentifierPart(document.getChar(offset - 1))) {
                --offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return offset;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        Object prefix = "";
        AutoconfMacro[] macros = AutoconfTextHover.getMacroList(this.editor);
        try {
            int macroStart = this.computeMacroStart(document, offset);
            if (macroStart < offset) {
                prefix = (String)prefix + document.get(macroStart, offset - macroStart);
            }
        }
        catch (BadLocationException macroStart) {
            // empty catch block
        }
        ICompletionProposal[] result = null;
        if (macros != null) {
            ArrayList<CompletionProposal> validList = new ArrayList<CompletionProposal>();
            int i = 0;
            while (i < macros.length) {
                String name = macros[i].getName();
                if (name.length() >= ((String)prefix).length() && name.startsWith((String)prefix)) {
                    String template = macros[i].getTemplate();
                    int cursorPos = template.length();
                    int prefixLen = ((String)prefix).length();
                    if (template.charAt(template.length() - 1) == ')') {
                        --cursorPos;
                    }
                    AutoconfMacroProposalContextInformation ci = null;
                    if (macros[i].hasParms()) {
                        ci = new AutoconfMacroProposalContextInformation(macros[i].getParms(), macros[i].getParms());
                        ci.setContextInformationPosition(offset - prefixLen + cursorPos - 1);
                    }
                    CompletionProposal cp = new CompletionProposal(template, offset - prefixLen, prefixLen, cursorPos, null, name, (IContextInformation)ci, AutoconfTextHover.getIndexedInfo(name, this.editor));
                    validList.add(cp);
                }
                ++i;
            }
            result = new ICompletionProposal[validList.size()];
            result = validList.toArray(result);
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new AutoconfMacroParameterListValidator();
    }

    public String getErrorMessage() {
        return null;
    }
}

