/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.util.Objects;
import org.eclipse.swt.graphics.RGB;

public class FontState {
    public static final int STATE_BOLD = 1;
    public static final int STATE_ITALIC = 2;
    public static final int STATE_STRIKETHROUGH = 4;
    public static final int STATE_UNDERLINE = 8;
    public static final int STATE_SUPERSCRIPT = 16;
    public static final int STATE_SUBSCRIPT = 32;
    public static final int STATE_FIXED_WIDTH = 64;
    public RGB foreground;
    public RGB background;
    public int state;
    public float sizeFactor = 1.0f;

    public FontState() {
    }

    public FontState(FontState copy) {
        this.foreground = copy.foreground;
        this.background = copy.background;
        this.state = copy.state;
        this.sizeFactor = copy.sizeFactor;
    }

    public boolean isBold() {
        return this.isSet(1);
    }

    public boolean isItalic() {
        return this.isSet(2);
    }

    public boolean isStrikethrough() {
        return this.isSet(4);
    }

    public boolean isUnderline() {
        return this.isSet(8);
    }

    public boolean isSuperscript() {
        return this.isSet(16);
    }

    public boolean isSubscript() {
        return this.isSet(32);
    }

    public boolean isFixedWidth() {
        return this.isSet(64);
    }

    public void setBold(boolean bold) {
        this.set(bold, 1);
    }

    public void setItalic(boolean value) {
        this.set(value, 2);
    }

    public void setStrikethrough(boolean value) {
        this.set(value, 4);
    }

    public void setUnderline(boolean value) {
        this.set(value, 8);
    }

    public void setSuperscript(boolean value) {
        this.set(value, 16);
    }

    public void setSubscript(boolean value) {
        this.set(value, 32);
    }

    public void setFixedWidth(boolean value) {
        this.set(value, 64);
    }

    private boolean isSet(int bits) {
        return (this.state & bits) == bits;
    }

    private void set(boolean value, int bits) {
        this.state = value ? (this.state |= bits) : (this.state &= ~bits);
    }

    public RGB getForeground() {
        return this.foreground;
    }

    public void setForeground(RGB foreground) {
        this.foreground = foreground;
    }

    public RGB getBackground() {
        return this.background;
    }

    public void setBackground(RGB background) {
        this.background = background;
    }

    public float getSizeFactor() {
        return this.sizeFactor;
    }

    public void setSizeFactor(float sizeFactor) {
        this.sizeFactor = sizeFactor;
    }

    public int hashCode() {
        return Objects.hash(this.background, this.foreground, Float.valueOf(this.sizeFactor), this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FontState other = (FontState)obj;
        if (!Objects.equals(this.background, other.background)) {
            return false;
        }
        if (!Objects.equals(this.foreground, other.foreground)) {
            return false;
        }
        if (Float.floatToIntBits(this.sizeFactor) != Float.floatToIntBits(other.sizeFactor)) {
            return false;
        }
        return this.state == other.state;
    }
}

