/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.egit.core.internal.hosts.GitHosts;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.commands.shared.AbstractFetchFromHostCommand;
import org.eclipse.egit.ui.internal.fetch.FetchChangeFromServerWizard;
import org.eclipse.egit.ui.internal.fetch.GitServer;
import org.eclipse.egit.ui.internal.gerrit.FilteredSelectRepositoryPage;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class FetchChangeFromServerCommandFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private GitServer server;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.server = GitServer.valueOf(data.toString());
    }

    public Object create() throws CoreException {
        return new AbstractFetchFromHostCommand(){

            @Override
            protected GitSelectRepositoryPage createSelectionPage() {
                return new FilteredSelectRepositoryPage(MessageFormat.format(UIText.GitSelectRepositoryPage_PageTitleServer, FetchChangeFromServerCommandFactory.this.server.getName()), UIIcons.WIZBAN_FETCH){

                    @Override
                    protected boolean includeRepository(Repository repo) {
                        try {
                            return GitHosts.hasServerConfig((Config)SelectionRepositoryStateCache.INSTANCE.getConfig(repo), (GitHosts.ServerType)(this).FetchChangeFromServerCommandFactory.this.server.getType());
                        }
                        catch (URISyntaxException e) {
                            return false;
                        }
                    }
                };
            }

            @Override
            protected Wizard createFetchWizard(Repository repository, String clipText) {
                return new FetchChangeFromServerWizard(FetchChangeFromServerCommandFactory.this.server, repository, clipText);
            }
        };
    }
}

