/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.connector;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TerminalToRemoteInjectionOutputStream
extends FilterOutputStream {
    private Interceptor fInterceptor;
    private TerminalFilterOutputStream fInjection;

    public TerminalToRemoteInjectionOutputStream(OutputStream out) {
        super(out);
    }

    protected synchronized void ungrabOutput() throws IOException {
        if (this.fInterceptor != null) {
            this.fInterceptor.close();
            this.fInterceptor = null;
            this.fInjection = null;
        }
    }

    public synchronized OutputStream grabOutput(Interceptor interceptor) throws IOException {
        if (this.fInjection != null) {
            throw new IOException("Buffer in use");
        }
        this.fInterceptor = interceptor;
        this.fInterceptor.begin(this.out);
        this.fInjection = new TerminalFilterOutputStream();
        return this.fInjection;
    }

    public synchronized OutputStream grabOutput() throws IOException {
        return this.grabOutput(new BufferInterceptor());
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fInjection != null) {
            this.fInjection.close();
        }
        super.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.fInterceptor != null) {
            this.fInterceptor.flush();
        }
        this.out.flush();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.fInterceptor != null) {
            this.fInterceptor.write(b, off, len);
        } else {
            this.out.write(b, off, len);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.fInterceptor != null) {
            this.fInterceptor.write(b);
        } else {
            this.out.write(b);
        }
    }

    public static class BufferInterceptor
    extends Interceptor {
        private final ByteArrayOutputStream fBuffer = new ByteArrayOutputStream();

        @Override
        public void close() throws IOException {
            this.fOriginal.write(this.fBuffer.toByteArray());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.fBuffer.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.fBuffer.write(b);
        }
    }

    public static abstract class Interceptor {
        protected OutputStream fOriginal;

        public void begin(OutputStream original) throws IOException {
            this.fOriginal = original;
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void close() throws IOException {
        }

        public void flush() {
        }
    }

    private class TerminalFilterOutputStream
    extends OutputStream {
        private final Object fLock;

        private TerminalFilterOutputStream() {
            this.fLock = TerminalToRemoteInjectionOutputStream.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.fLock;
            synchronized (object) {
                if (TerminalToRemoteInjectionOutputStream.this.fInjection == this) {
                    this.flush();
                    TerminalToRemoteInjectionOutputStream.this.ungrabOutput();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = this.fLock;
            synchronized (object) {
                this.checkStream();
                TerminalToRemoteInjectionOutputStream.this.out.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b) throws IOException {
            Object object = this.fLock;
            synchronized (object) {
                this.checkStream();
                TerminalToRemoteInjectionOutputStream.this.out.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = this.fLock;
            synchronized (object) {
                this.checkStream();
                TerminalToRemoteInjectionOutputStream.this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = this.fLock;
            synchronized (object) {
                this.checkStream();
                TerminalToRemoteInjectionOutputStream.this.out.write(b);
            }
        }

        private void checkStream() throws IOException {
            if (TerminalToRemoteInjectionOutputStream.this.fInjection != this) {
                throw new IOException("Stream is closed");
            }
        }
    }
}

