/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTPlotRenderer;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

class CommitGraphTableHoverManager
extends AbstractHoverInformationControlManager {
    private final GitDateFormatter dateFormatter = new GitDateFormatter(GitDateFormatter.Format.ISO);
    private final TableViewer tableViewer;
    private final SWTPlotRenderer renderer;

    CommitGraphTableHoverManager(TableViewer tableViewer, SWTPlotRenderer renderer) {
        super((IInformationControlCreator)new RefHoverInformationControlCreator());
        this.tableViewer = tableViewer;
        this.renderer = renderer;
    }

    protected void computeInformation() {
        SWTCommit commit;
        MouseEvent e = this.getHoverEvent();
        Information information = null;
        ViewerCell cell = this.tableViewer.getCell(new Point(e.x, e.y));
        if (cell != null && (commit = (SWTCommit)((Object)cell.getElement())) != null) {
            information = this.computeInformationForCommit(commit, cell, e);
        }
        if (information != null) {
            this.setInformation(information.information, information.subjectArea);
        } else {
            this.setInformation(null, null);
        }
    }

    private Information computeInformationForCommit(SWTCommit commit, ViewerCell cell, MouseEvent e) {
        int columnIndex = cell.getColumnIndex();
        switch (columnIndex) {
            case 0: {
                return this.computeInformationForHash(commit, cell);
            }
            case 1: {
                return this.computeInformationForRef(commit, cell, e);
            }
            case 2: {
                return this.computeInformationForName(commit.getAuthorIdent(), cell);
            }
            case 3: {
                return this.computeInformationForDate(commit.getAuthorIdent(), cell);
            }
            case 4: {
                return this.computeInformationForName(commit.getCommitterIdent(), cell);
            }
            case 5: {
                return this.computeInformationForDate(commit.getCommitterIdent(), cell);
            }
        }
        return null;
    }

    private Information computeInformationForHash(SWTCommit commit, ViewerCell cell) {
        return new Information(commit.getName() + "\n" + commit.getShortMessage(), cell.getBounds());
    }

    private Information computeInformationForRef(SWTCommit commit, ViewerCell cell, MouseEvent e) {
        Rectangle itemBounds = cell.getBounds();
        int minRefX = -1;
        int maxRefX = itemBounds.x;
        int relativeX = e.x - itemBounds.x;
        int i = 0;
        while (i < commit.getRefCount()) {
            Ref ref = commit.getRef(i);
            Point textSpan = this.renderer.getRefHSpan(ref);
            if (textSpan != null) {
                if (relativeX >= textSpan.x && relativeX <= textSpan.y) {
                    String hoverText = this.getHoverText(ref, i, commit);
                    int x = itemBounds.x + textSpan.x;
                    int width = textSpan.y - textSpan.x;
                    Rectangle rectangle = new Rectangle(x, itemBounds.y, width, itemBounds.height);
                    return new Information(hoverText, rectangle);
                }
                minRefX = minRefX < 0 ? itemBounds.x + textSpan.x : Math.min(minRefX, itemBounds.x + textSpan.x);
                maxRefX = Math.max(maxRefX, itemBounds.x + textSpan.y);
            }
            ++i;
        }
        if (minRefX < 0) {
            if (relativeX > itemBounds.width / 2) {
                return new Information(commit.getShortMessage(), new Rectangle(itemBounds.x + itemBounds.width / 2, itemBounds.y, itemBounds.width / 2, itemBounds.height));
            }
            int left = Math.max(itemBounds.x, e.x - 10);
            return new Information(commit.getShortMessage(), new Rectangle(left, itemBounds.y, itemBounds.x + itemBounds.width - left, itemBounds.height));
        }
        if (e.x > maxRefX) {
            return new Information(commit.getShortMessage(), new Rectangle(maxRefX, itemBounds.y, itemBounds.x + itemBounds.width - maxRefX, itemBounds.height));
        }
        if (e.x < minRefX) {
            return new Information(commit.getShortMessage(), new Rectangle(itemBounds.x, itemBounds.y, minRefX - itemBounds.x, itemBounds.height));
        }
        return null;
    }

    private Information computeInformationForName(PersonIdent ident, ViewerCell cell) {
        String nameWithEmail = ident.getName() + " <" + ident.getEmailAddress() + ">";
        return new Information(nameWithEmail, cell.getBounds());
    }

    private Information computeInformationForDate(PersonIdent ident, ViewerCell cell) {
        String formattedDate = this.dateFormatter.formatDate(ident);
        return new Information(formattedDate, cell.getBounds());
    }

    private String getHoverText(Ref ref, int refIndex, SWTCommit commit) {
        if (ref.getName().startsWith("refs/tags/") && this.renderer.isShownAsEllipsis(ref)) {
            StringBuilder sb = new StringBuilder(UIText.CommitGraphTable_HoverAdditionalTags);
            int i = refIndex;
            while (i < commit.getRefCount()) {
                Ref tag = commit.getRef(i);
                String name = tag.getName();
                if (name.startsWith("refs/tags/")) {
                    sb.append('\n');
                    sb.append(name.substring("refs/tags/".length()));
                }
                ++i;
            }
            return sb.toString();
        }
        return this.getHoverTextForSingleRef(ref);
    }

    private String getHoverTextForSingleRef(Ref r) {
        String description;
        StringBuilder sb = new StringBuilder();
        String name = r.getName();
        sb.append(name);
        if (r.isSymbolic()) {
            sb.append(": ");
            sb.append(r.getLeaf().getName());
        }
        if ((description = GitLabels.getRefDescription(r)) != null) {
            sb.append("\n");
            sb.append(description);
        }
        return sb.toString();
    }

    private static class Information {
        final Object information;
        final Rectangle subjectArea;

        private Information(Object information, Rectangle subjectArea) {
            this.information = information;
            this.subjectArea = subjectArea;
        }
    }

    private static final class RefHoverInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private RefHoverInformationControlCreator() {
        }

        protected IInformationControl doCreateInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    }
}

