/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilerExtension;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.ui.internal.genericeditor.CompositeReconcilerStrategy;

public class CompositeReconciler
implements IReconciler,
IReconcilerExtension {
    private final List<IReconciler> fReconcilers;

    public CompositeReconciler(List<IReconciler> reconcilers) {
        this.fReconcilers = reconcilers.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getDocumentPartitioning() {
        String[] types;
        boolean defaultFound = false;
        String[] stringArray = types = (String[])this.fReconcilers.stream().filter(IReconcilerExtension.class::isInstance).map(IReconcilerExtension.class::cast).map(IReconcilerExtension::getDocumentPartitioning).filter(Objects::nonNull).toArray();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (!type.equals("__dftl_partitioning")) {
                return type;
            }
            defaultFound = true;
            ++n2;
        }
        return defaultFound ? "__dftl_partitioning" : null;
    }

    public void install(ITextViewer textViewer) {
        for (IReconciler iReconciler : this.fReconcilers) {
            iReconciler.install(textViewer);
        }
    }

    public void uninstall() {
        for (IReconciler iReconciler : this.fReconcilers) {
            iReconciler.uninstall();
        }
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        ArrayList<IReconcilingStrategy> strategies = new ArrayList<IReconcilingStrategy>();
        for (IReconciler iReconciler : this.fReconcilers) {
            IReconcilingStrategy strategy = iReconciler.getReconcilingStrategy(contentType);
            if (strategy == null) continue;
            strategies.add(strategy);
        }
        if (strategies.size() == 1) {
            return (IReconcilingStrategy)strategies.get(0);
        }
        return new CompositeReconcilerStrategy(strategies);
    }
}

