/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import lpg.lpgjavaruntime.Differ;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;

public class DifferTokens
extends Differ {
    protected DifferTokens() {
    }

    public DifferTokens(PrsStream newStream, PrsStream oldStream) {
        super(newStream, oldStream);
    }

    @Override
    public Differ.ILine[] getBuffer(PrsStream stream) {
        Differ.ILine[] buffer = new Token[stream.getStreamLength()];
        int i = 1;
        while (i < stream.getStreamLength()) {
            buffer[i] = new Token(stream, i);
            ++i;
        }
        return buffer;
    }

    void printLines(PrsStream prs_stream, int first_token, int last_token) {
        int start_line = prs_stream.getLine(first_token);
        int end_line = prs_stream.getLine(last_token);
        LexStream lex_stream = prs_stream.getLexStream();
        char[] buffer = lex_stream.getInputChars();
        int start = lex_stream.getLineOffset(start_line - 1) + 1;
        int end = lex_stream.getLineOffset(start_line);
        if (start_line == end_line) {
            String num = "" + start_line;
            int i = 0;
            while (i < 6 - num.length()) {
                System.out.print(' ');
                ++i;
            }
            System.out.println(String.valueOf(start_line) + " " + new String(buffer, start, end - start));
            System.out.print("       ");
            i = 0;
            while (i < prs_stream.getColumn(first_token) - 1) {
                System.out.print(' ');
                ++i;
            }
            int length = prs_stream.getEndColumn(last_token) - prs_stream.getColumn(first_token);
            if (length < 2) {
                System.out.println('^');
            } else {
                System.out.print('<');
                int i2 = 1;
                while (i2 < length) {
                    System.out.print('-');
                    ++i2;
                }
                System.out.println('>');
            }
        } else {
            System.out.print("       ");
            int i = 0;
            while (i < prs_stream.getColumn(first_token) - 1) {
                System.out.print(' ');
                ++i;
            }
            int last_column = lex_stream.getColumn(lex_stream.getPrevious(end));
            System.out.print('<');
            int i3 = prs_stream.getColumn(first_token) + 1;
            while (i3 < last_column) {
                System.out.print('-');
                ++i3;
            }
            System.out.println();
            int line_no = start_line;
            while (line_no <= end_line) {
                start = lex_stream.getLineOffset(line_no - 1) + 1;
                end = lex_stream.getLineOffset(line_no);
                String num = "" + line_no;
                int i4 = 0;
                while (i4 < 6 - num.length()) {
                    System.out.print(' ');
                    ++i4;
                }
                System.out.println(String.valueOf(line_no) + " " + new String(buffer, start, end - start));
                ++line_no;
            }
            System.out.print("       ");
            i3 = 0;
            while (i3 < prs_stream.getEndColumn(last_token) - 1) {
                System.out.print('-');
                ++i3;
            }
            System.out.println('>');
        }
    }

    @Override
    void outputInsert(Differ.Change element) {
        this.insertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Insert after " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + " " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
    }

    @Override
    void outputDelete(Differ.Change element) {
        this.deleteCount += element.getOlde() - element.getOlds() + 1;
        System.out.println("Delete after " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + " " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + ":");
        this.printLines(this.oldStream, element.getOlds(), element.getOlde());
    }

    @Override
    void outputReplace(Differ.Change element) {
        this.replaceDeleteCount += element.getOlde() - element.getOlds() + 1;
        this.replaceInsertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Replace " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + ":");
        this.printLines(this.oldStream, element.getOlds(), element.getOlde());
        System.out.println("With " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
    }

    @Override
    void outputMove(Differ.Change element) {
        this.moveCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
    }

    @Override
    void outputMoveDelete(Differ.Change element) {
        int bound = element.getNewe() - element.getNews();
        this.moveCount += bound + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlds() + bound) + ":" + this.oldStream.getEndColumn(element.getOlds() + bound) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
        int oldi = element.getOlds() + bound + 1;
        this.deleteCount += element.getOlde() - oldi + 1;
        System.out.println("... And delete " + this.oldStream.getFileName() + "," + this.oldStream.getLine(oldi) + ":" + this.oldStream.getColumn(oldi) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()));
        this.printLines(this.oldStream, oldi, element.getOlde());
    }

    @Override
    void outputMoveInsert(Differ.Change element) {
        int bound = element.getOlde() - element.getOlds();
        this.moveCount += element.getOlde() - element.getOlds() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNews() + bound) + ":" + this.newStream.getEndColumn(element.getNews() + bound) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNews() + bound);
        int newi = element.getNews() + bound + 1;
        this.insertCount += element.getNewe() - newi + 1;
        System.out.println("... And insert " + this.newStream.getFileName() + "," + this.newStream.getLine(newi) + ":" + this.newStream.getColumn(newi) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, newi, element.getNewe());
    }

    public class Token
    implements Differ.ILine {
        private int kind;
        private int start_line;
        private int start_column;
        private int end_line;
        private int end_column;
        private String name;
        private int hash_code;

        public Token(PrsStream stream, int token) {
            this.kind = stream.getKind(token);
            this.name = stream.getName(token);
            this.start_line = stream.getLine(token);
            this.start_column = stream.getColumn(token);
            this.end_line = stream.getEndLine(token);
            this.end_column = stream.getEndColumn(token);
            this.hash_code = this.name.hashCode();
        }

        @Override
        public final int size() {
            return this.name.length();
        }

        @Override
        public final int hashCode() {
            return this.hash_code;
        }

        @Override
        public final boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Token) {
                Token another_token = (Token)anObject;
                return this.kind == another_token.kind && this.name.equals(another_token.name);
            }
            return false;
        }

        @Override
        public final int getStartLine() {
            return this.start_line;
        }

        @Override
        public final int getStartColumn() {
            return this.start_column;
        }

        @Override
        public final int getEndLine() {
            return this.end_line;
        }

        @Override
        public final int getEndColumn() {
            return this.end_column;
        }

        public final String toString() {
            return this.name;
        }
    }
}

