/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleMessages;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsole;

public class TracingConsole
extends IOConsole {
    private ILaunch fLaunch;
    private OutputStream fTracingStream = null;
    private DsfSession fSession = null;
    private String fLabel = "";

    public TracingConsole(ILaunch launch, String label) {
        super("", null, null, false);
        this.fLaunch = launch;
        this.fTracingStream = this.newOutputStream();
        this.fSession = ((GdbLaunch)launch).getSession();
        this.fLabel = label;
        this.resetName();
        new InputReadJob().schedule();
        this.setStreamInService();
    }

    protected void init() {
        super.init();
        this.fSession.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                TracingConsole.this.fSession.addServiceEventListener((Object)TracingConsole.this, null);
            }
        });
    }

    protected void dispose() {
        try {
            this.fTracingStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fSession.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    TracingConsole.this.fSession.removeServiceEventListener((Object)TracingConsole.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        super.dispose();
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setStreamInService() {
        try {
            this.fSession.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), TracingConsole.this.fSession.getId());
                    IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                    tracker.dispose();
                    if (control != null) {
                        control.setTracingStream(TracingConsole.this.fTracingStream);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected String computeName() {
        String label = this.fLabel;
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        if (config != null && !DebugUITools.isPrivate((ILaunchConfiguration)config)) {
            String type = null;
            try {
                type = config.getType().getName();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(config.getName());
            if (type != null) {
                buffer.append(" [");
                buffer.append(type);
                buffer.append("] ");
            }
            buffer.append(label);
            label = buffer.toString();
        }
        if (this.fLaunch.isTerminated()) {
            return ConsoleMessages.ConsoleMessages_console_terminated + label;
        }
        return label;
    }

    public void resetName() {
        Display display;
        String newName = this.computeName();
        String name = this.getName();
        if (!name.equals(newName) && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed()) {
            display.asyncExec(() -> this.setName(newName));
        }
    }

    @DsfServiceEventHandler
    public final void eventDispatched(ICommandControlService.ICommandControlInitializedDMEvent event) {
        this.setStreamInService();
    }

    private class InputReadJob
    extends Job {
        InputReadJob() {
            super("Traces Input Job");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                while (TracingConsole.this.getInputStream() != null && read >= 0) {
                    read = TracingConsole.this.getInputStream().read(b);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }
}

