/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

public class LoadTagsRequest
extends CDOClientRequest<Integer> {
    private String name;
    private Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler;

    public LoadTagsRequest(CDOClientProtocol protocol, String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
        super(protocol, (short)63);
        this.name = name;
        this.handler = handler;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeString(this.name);
    }

    @Override
    protected Integer confirming(CDODataInput in) throws IOException {
        if (this.name != null) {
            if (in.readBoolean()) {
                this.readTag(in, this.name);
                return 1;
            }
            return 0;
        }
        int count = in.readXInt();
        int i = 0;
        while (i < count) {
            String name = in.readString();
            this.readTag(in, name);
            ++i;
        }
        return count;
    }

    private void readTag(CDODataInput in, String name) throws IOException {
        CDOBranchPoint branchPoint = in.readCDOBranchPoint();
        this.handler.accept(new InternalCDOBranchManager.BranchLoader.BranchInfo(name, branchPoint.getBranch().getID(), branchPoint.getTimeStamp()));
    }
}

