/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.FlavorListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.sirius.business.api.image.ImageManager;
import org.eclipse.sirius.business.api.image.ImageManagerProvider;
import org.eclipse.sirius.diagram.ui.business.api.image.WorkspaceImageHelper;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.style.SetStyleToWorkspaceImageAction;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class PasteImageAction
extends Action
implements IDisposableAction {
    private Clipboard awtClipboard;
    private FlavorListener clipboardListener;
    private boolean isDisposed = true;
    private Optional<IPropertyChangeListener> changeListenerOpt = Optional.empty();

    public PasteImageAction() {
        this.setId("pasteImageAction");
        this.setText(org.eclipse.sirius.diagram.ui.provider.Messages.PasteImageAction_text);
        this.setToolTipText(org.eclipse.sirius.diagram.ui.provider.Messages.PasteImageAction_toolTipText);
        if ("win32".equals(SWT.getPlatform())) {
            this.setAccelerator(327766);
        } else {
            this.setAccelerator(0);
        }
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteImage.gif"));
    }

    public void init() {
        this.awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.updateState();
        this.clipboardListener = e -> Display.getDefault().syncExec(() -> this.updateState());
        this.awtClipboard.addFlavorListener(this.clipboardListener);
        this.changeListenerOpt.ifPresent(changeListener -> this.addPropertyChangeListener((IPropertyChangeListener)changeListener));
        this.isDisposed = false;
    }

    public void dispose() {
        this.awtClipboard.removeFlavorListener(this.clipboardListener);
        this.clipboardListener = null;
        this.awtClipboard = null;
        this.changeListenerOpt.ifPresent(changeListener -> this.removePropertyChangeListener((IPropertyChangeListener)changeListener));
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void onChangeState(Optional<IPropertyChangeListener> listener) {
        if (!this.isDisposed()) {
            throw new IllegalStateException("onChangeState must be called before action is initialized");
        }
        this.changeListenerOpt = listener;
    }

    public void updateState() {
        this.setEnabled(this.canBeEnabled());
    }

    public void run() {
        List<BasicLabelStyle> selectedStyles = SetStyleToWorkspaceImageAction.getStyles();
        ImageData imgData = this.fetchImageFromClipboard();
        if (imgData != null && !selectedStyles.isEmpty()) {
            BasicLabelStyle firstStyle = (BasicLabelStyle)selectedStyles.stream().findFirst().orElseThrow();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)firstStyle);
            if (domain != null) {
                String filename = ImageManager.generateName((String)"png");
                ImageManager imageManager = ImageManagerProvider.getImageManager();
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (ByteArrayInputStream imageStream = this.getImageStream(imgData);){
                        ImageManager.CreateImageFileProvider createFileFunc = imageManager.getCreateFileFunc((EObject)firstStyle, filename, (InputStream)imageStream);
                        CompoundCommand command = new CompoundCommand();
                        command.append((Command)createFileFunc.asRecordingCommand(domain));
                        for (BasicLabelStyle style : selectedStyles) {
                            command.append(WorkspaceImageHelper.INSTANCE.getWorkspacePathChangeCommand(domain, style, createFileFunc.getFileName()));
                        }
                        domain.getCommandStack().execute((Command)command);
                        WorkspaceImageHelper.INSTANCE.refreshStyle();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ImageManager_imageCreationFailure, filename), e);
                }
            } else {
                SiriusPlugin.getDefault().error(Messages.PastImage_TransactionalEditingDomainIsNull, null);
            }
        } else {
            SiriusPlugin.getDefault().error(Messages.PastImage_RunWhenDisabled, null);
        }
    }

    private ImageData fetchImageFromClipboard() {
        ImageTransfer imgTransfer = ImageTransfer.getInstance();
        org.eclipse.swt.dnd.Clipboard clipboard = new org.eclipse.swt.dnd.Clipboard(Display.getCurrent());
        ImageData imgData = (ImageData)clipboard.getContents((Transfer)imgTransfer);
        clipboard.dispose();
        return imgData;
    }

    private ByteArrayInputStream getImageStream(ImageData imgData) {
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{imgData};
        ByteArrayOutputStream imgStreamOut = new ByteArrayOutputStream();
        saver.save((OutputStream)imgStreamOut, 5);
        return new ByteArrayInputStream(imgStreamOut.toByteArray());
    }

    private boolean canBeEnabled() {
        ImageData imgData = this.fetchImageFromClipboard();
        return imgData != null && SetStyleToWorkspaceImageAction.selectionCanHaveWorkspaceImage();
    }

    public boolean isEnabled() {
        this.updateState();
        return super.isEnabled();
    }
}

