/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.jetty.http.ComplianceUtils;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.ComplianceViolationException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Response
extends Content.Sink {
    public Request getRequest();

    public int getStatus();

    public void setStatus(int var1);

    public HttpFields.Mutable getHeaders();

    public Supplier<HttpFields> getTrailersSupplier();

    public void setTrailersSupplier(Supplier<HttpFields> var1);

    public boolean isCommitted();

    public boolean hasLastWrite();

    public boolean isCompletedSuccessfully();

    public void reset();

    public CompletableFuture<Void> writeInterim(int var1, HttpFields var2);

    public void write(boolean var1, ByteBuffer var2, Callback var3);

    public static Content.Chunk.Processor newTrailersChunkProcessor(Response response) {
        Supplier<HttpFields> supplier = response.getTrailersSupplier();
        if (supplier == null) {
            return (chunk, callback) -> false;
        }
        return (chunk, callback) -> {
            HttpFields responseTrailers;
            Trailers trailers;
            HttpFields requestTrailers;
            if (chunk instanceof Trailers && (requestTrailers = (trailers = (Trailers)chunk).getTrailers()) != null && (responseTrailers = (HttpFields)supplier.get()) instanceof HttpFields.Mutable) {
                HttpFields.Mutable mutable = (HttpFields.Mutable)responseTrailers;
                mutable.add(requestTrailers);
                callback.succeeded();
                return true;
            }
            return false;
        };
    }

    public static <T extends Response> T asInContext(Response response, Class<T> type) {
        Context context;
        Context context2 = response == null ? null : (context = response.getRequest() == null ? null : response.getRequest().getContext());
        if (context == null) {
            return (T)((Response)Response.as(response, type));
        }
        while (response != null) {
            Response response2;
            if (response.getRequest() == null) {
                return null;
            }
            if (response.getRequest().getContext() != context) {
                return null;
            }
            if (type.isInstance(response)) {
                return (T)response;
            }
            if (response instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)response;
                response2 = wrapper.getWrapped();
            } else {
                response2 = null;
            }
            response = response2;
        }
        return null;
    }

    public static <T> T as(Response response, Class<T> type) {
        while (response != null) {
            Response response2;
            if (type.isInstance(response)) {
                return (T)response;
            }
            if (response instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)response;
                response2 = wrapper.getWrapped();
            } else {
                response2 = null;
            }
            response = response2;
        }
        return null;
    }

    public static void sendRedirect(Request request, Response response, Callback callback, String location) {
        Response.sendRedirect(request, response, callback, location, false);
    }

    public static void sendRedirect(Request request, Response response, Callback callback, String location, boolean consumeAvailable) {
        Response.sendRedirect(request, response, callback, 0, location, consumeAvailable);
    }

    public static void sendRedirect(Request request, Response response, Callback callback, int code, String location, boolean consumeAvailable) {
        Response.sendRedirect(request, response, callback, code, location, consumeAvailable, null);
    }

    public static void sendRedirect(Request request, Response response, Callback callback, int code, String location, boolean consumeAvailable, ByteBuffer content) {
        if (response.isCommitted()) {
            callback.failed((Throwable)new IllegalStateException("Committed"));
            return;
        }
        if (code <= 0) {
            int n = code = HttpMethod.GET.is(request.getMethod()) || request.getConnectionMetaData().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
        }
        if (!HttpStatus.isRedirectionWithLocation((int)code)) {
            callback.failed((Throwable)new IllegalArgumentException("Not a 3xx redirect code"));
            return;
        }
        if (location == null) {
            callback.failed((Throwable)new IllegalArgumentException("No location"));
            return;
        }
        try {
            location = Response.toRedirectURI(request, location);
            if (consumeAvailable) {
                Content.Chunk chunk;
                do {
                    if ((chunk = response.getRequest().read()) == null) {
                        response.getHeaders().put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                        break;
                    }
                    chunk.release();
                } while (!chunk.isLast());
            }
            if (content == null && request.getConnectionMetaData().getHttpConfiguration().isGenerateRedirectBody()) {
                response.getHeaders().put(MimeTypes.Type.TEXT_HTML_8859_1.getContentTypeField());
                String body = "<!DOCTYPE html>\n<html lang=\"en\">\n<head><meta charset=\"ISO-8859-1\"/><meta http-equiv=\"refresh\" content=\"0; URL=%s\"/><title>Redirecting...</title></head>\n<body><p>If you are not redirected, <a href=\"%s\">click here</a>.</p></body>\n</html>\n".formatted(location, location);
                content = BufferUtil.toBuffer((String)body, (Charset)StandardCharsets.ISO_8859_1);
            }
            response.getHeaders().put(HttpHeader.LOCATION, location);
            response.setStatus(code);
            response.write(true, content, callback);
        }
        catch (Throwable failure) {
            callback.failed(failure);
        }
    }

    public static String toRedirectURI(Request request, String location) {
        UriCompliance redirectCompliance;
        HttpConfiguration httpConfiguration = request.getConnectionMetaData().getHttpConfiguration();
        if (!URIUtil.hasScheme((String)location)) {
            HttpURI uri = request.getHttpURI();
            if (!location.startsWith("/")) {
                String path = uri.getPath();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath((String)path);
                location = URIUtil.addEncodedPaths((String)parent, (String)location);
            }
            if ((location = URIUtil.normalizePathQuery((String)location)) == null) {
                throw new IllegalStateException("redirect path cannot be above root");
            }
            if (!httpConfiguration.isRelativeRedirectAllowed()) {
                location = URIUtil.newURI((String)uri.getScheme(), (String)Request.getServerName(request), (int)Request.getServerPort(request), (String)location, null);
            }
        }
        if ((redirectCompliance = httpConfiguration.getRedirectUriCompliance()) != null) {
            HttpChannel httpChannel = HttpChannel.from(request);
            HttpURI.Immutable uri = HttpURI.from((String)location);
            ComplianceViolation.Listener listener = httpChannel.getComplianceViolationListener();
            ComplianceUtils.verify((UriCompliance)redirectCompliance, (HttpURI)uri, (ComplianceViolation.Listener)listener, IllegalArgumentException::new);
        }
        return location;
    }

    public static void addCookie(Response response, HttpCookie cookie) {
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        Request request = response.getRequest();
        CookieCompliance compliance = request.getConnectionMetaData().getHttpConfiguration().getResponseCookieCompliance();
        try {
            response.getHeaders().add((HttpField)new HttpCookieUtils.SetCookieHttpField(HttpCookieUtils.checkSameSite(cookie, request.getContext()), compliance));
        }
        catch (ComplianceViolationException e) {
            HttpChannel.from(request).getComplianceViolationListener().onComplianceViolation(e.getEvent());
            throw e;
        }
        if (!response.getHeaders().contains(HttpHeader.EXPIRES)) {
            response.getHeaders().add(HttpFields.EXPIRES_01JAN1970);
        }
    }

    public static void putCookie(Response response, HttpCookie cookie) {
        HttpCookieUtils.SetCookieHttpField setCookie;
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        Request request = response.getRequest();
        HttpConfiguration httpConfiguration = request.getConnectionMetaData().getHttpConfiguration();
        CookieCompliance compliance = httpConfiguration.getResponseCookieCompliance();
        try {
            setCookie = new HttpCookieUtils.SetCookieHttpField(HttpCookieUtils.checkSameSite(cookie, request.getContext()), compliance);
        }
        catch (ComplianceViolationException e) {
            HttpChannel.from(request).getComplianceViolationListener().onComplianceViolation(e.getEvent());
            throw e;
        }
        boolean expires = false;
        ListIterator i = response.getHeaders().listIterator();
        while (i.hasNext()) {
            HttpField field = (HttpField)i.next();
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case SET_COOKIE: {
                    HttpCookieUtils.SetCookieHttpField setCookieHttpField;
                    if (!(field instanceof HttpCookieUtils.SetCookieHttpField) ? !HttpCookieUtils.match(field.getValue(), cookie.getName(), cookie.getDomain(), cookie.getPath()) : !HttpCookieUtils.match((setCookieHttpField = (HttpCookieUtils.SetCookieHttpField)field).getHttpCookie(), cookie.getName(), cookie.getDomain(), cookie.getPath())) break;
                    if (setCookie == null) {
                        i.remove();
                        break;
                    }
                    i.set(setCookie);
                    setCookie = null;
                    break;
                }
                case EXPIRES: {
                    expires = true;
                }
            }
        }
        if (setCookie != null) {
            response.getHeaders().add((HttpField)setCookie);
        }
        if (!expires) {
            response.getHeaders().add(HttpFields.EXPIRES_01JAN1970);
        }
    }

    @Deprecated
    public static void replaceCookie(Response response, HttpCookie cookie) {
        Response.putCookie(response, cookie);
    }

    public static void writeError(Request request, Response response, Callback callback, Throwable cause) {
        if (cause == null) {
            cause = new Throwable("unknown cause");
        }
        int status = 500;
        String message = cause.toString();
        if (cause instanceof HttpException) {
            HttpException httpException = (HttpException)cause;
            status = httpException.getCode();
            message = httpException.getReason();
        }
        Response.writeError(request, response, callback, status, message, cause);
    }

    public static void writeError(Request request, Response response, Callback callback, int status) {
        Response.writeError(request, response, callback, status, null, null);
    }

    public static void writeError(Request request, Response response, Callback callback, int status, String message) {
        Response.writeError(request, response, callback, status, message, null);
    }

    public static void writeError(Request request, Response response, Callback callback, int status, String message, Throwable cause) {
        block12: {
            Logger logger = LoggerFactory.getLogger(Response.class);
            if (logger.isDebugEnabled()) {
                logger.debug("writeError: status={}, message={}, response={}", new Object[]{status, message, response, cause});
            } else if (cause instanceof QuietException || cause instanceof TimeoutException) {
                logger.debug("writeError: status={}, message={}, response={} {}", new Object[]{status, message, response, cause.toString()});
            } else if (cause != null) {
                logger.warn("writeError: status={}, message={}, response={}", new Object[]{status, message, response, cause});
            }
            if (response.isCommitted()) {
                callback.failed(cause == null ? new IllegalStateException(message == null ? "Committed" : message) : cause);
                return;
            }
            request.consumeAvailable();
            if (status <= 0) {
                status = 500;
            }
            if (message == null) {
                message = HttpStatus.getMessage((int)status);
            }
            response.setStatus(status);
            Context context = request.getContext();
            Request.Handler errorHandler = context.getErrorHandler();
            if (errorHandler != null) {
                ErrorHandler.ErrorRequest errorRequest = new ErrorHandler.ErrorRequest(request, status, message, cause);
                try {
                    if (errorHandler.handle(errorRequest, response, callback)) {
                        return;
                    }
                }
                catch (Throwable e) {
                    if (cause == null || cause == e) break block12;
                    cause.addSuppressed(e);
                }
            }
        }
        response.getHeaders().put(ErrorHandler.ERROR_CACHE_CONTROL);
        response.write(true, null, callback);
    }

    public static Response getOriginalResponse(Response response) {
        while (response instanceof Wrapper) {
            Wrapper wrapped = (Wrapper)response;
            response = wrapped.getWrapped();
        }
        return response;
    }

    public static long getContentBytesWritten(Response response) {
        Response originalResponse = Response.getOriginalResponse(response);
        if (originalResponse instanceof HttpChannelState.ChannelResponse) {
            HttpChannelState.ChannelResponse channelResponse = (HttpChannelState.ChannelResponse)originalResponse;
            return channelResponse.getContentBytesWritten();
        }
        return -1L;
    }

    public static OutputStream asBufferedOutputStream(Request request, Response response) {
        return Content.Sink.asOutputStream((Content.Sink)Response.asBufferedSink(request, response));
    }

    public static Content.Sink asBufferedSink(Request request, Response response) {
        ConnectionMetaData connectionMetaData = request.getConnectionMetaData();
        ByteBufferPool bufferPool = connectionMetaData.getConnector().getByteBufferPool();
        HttpConfiguration httpConfiguration = connectionMetaData.getHttpConfiguration();
        int bufferSize = httpConfiguration.getOutputBufferSize();
        boolean useOutputDirectByteBuffers = httpConfiguration.isUseOutputDirectByteBuffers();
        int outputAggregationSize = httpConfiguration.getOutputAggregationSize();
        return Content.Sink.asBuffered((Content.Sink)response, (ByteBufferPool)bufferPool, (boolean)useOutputDirectByteBuffers, (int)outputAggregationSize, (int)bufferSize);
    }

    public static class Wrapper
    implements Response {
        private final Request _request;
        private final Response _wrapped;

        public Wrapper(Request request, Response wrapped) {
            this._request = request;
            this._wrapped = wrapped;
        }

        public Response getWrapped() {
            return this._wrapped;
        }

        @Override
        public Request getRequest() {
            return this._request;
        }

        @Override
        public int getStatus() {
            return this.getWrapped().getStatus();
        }

        @Override
        public void setStatus(int code) {
            this.getWrapped().setStatus(code);
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return this.getWrapped().getHeaders();
        }

        @Override
        public Supplier<HttpFields> getTrailersSupplier() {
            return this.getWrapped().getTrailersSupplier();
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
            this.getWrapped().setTrailersSupplier(trailers);
        }

        @Override
        public boolean isCommitted() {
            return this.getWrapped().isCommitted();
        }

        @Override
        public boolean hasLastWrite() {
            return this.getWrapped().hasLastWrite();
        }

        @Override
        public boolean isCompletedSuccessfully() {
            return this.getWrapped().isCompletedSuccessfully();
        }

        @Override
        public void reset() {
            this.getWrapped().reset();
        }

        @Override
        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            return this.getWrapped().writeInterim(status, headers);
        }

        @Override
        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            this.getWrapped().write(last, byteBuffer, callback);
        }
    }
}

