/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtext.ui.wizard.template.AbstractTemplate;
import org.eclipse.xtext.ui.wizard.template.IParameterPage;
import org.eclipse.xtext.ui.wizard.template.TemplateVariable;

public class ParameterComposite
extends Composite {
    private final AbstractTemplate template;
    private final IParameterPage parameterPage;
    private boolean inUserAction = true;

    public ParameterComposite(Composite parent, int style, AbstractTemplate template, IParameterPage parameterPage) {
        super(parent, style);
        this.template = template;
        this.parameterPage = parameterPage;
        this.setLayout((Layout)new GridLayout(2, false));
        for (TemplateVariable variable : template.getVariables()) {
            ParameterComposite varParent;
            ParameterComposite parameterComposite = varParent = variable.getContainer() == null ? this : variable.getContainer().getWidget();
            if (variable.isLabeled()) {
                Label label = new Label((Composite)varParent, 0);
                label.setText(variable.getLabel());
                label.setToolTipText(variable.getDescription());
                label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                variable.createWidget(this, varParent);
                variable.getWidget().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            } else {
                variable.createWidget(this, varParent);
                variable.getWidget().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            }
            if (variable.getDescription() == null) continue;
            ControlDecoration decorator = new ControlDecoration(variable.getWidget(), 131200, (Composite)varParent);
            decorator.setDescriptionText(variable.getDescription());
            decorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        }
        this.update();
    }

    public void update() {
        if (this.inUserAction) {
            this.inUserAction = false;
            this.refreshVariables();
            this.validate();
            this.inUserAction = true;
        }
    }

    protected void validate() {
        this.parameterPage.setStatus(this.template.validate());
    }

    private void refreshVariables() {
        this.template.updateVariables();
        for (TemplateVariable variable : this.template.getVariables()) {
            variable.refresh();
        }
    }
}

