/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.common.types.ui.trace.AbstractTraceWithoutStorage;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;

public class FolderAwareTrace
extends AbstractTraceWithoutStorage {
    private String folder;

    public void setRootFolder(String folder) {
        if (!((String)folder).endsWith("/")) {
            folder = (String)folder + "/";
        }
        this.folder = folder;
    }

    protected File findFile(File container, String candiadate) {
        File[] files = container.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File result;
                File child = fileArray[n2];
                if (child.isFile()) {
                    if (child.getAbsolutePath().replace("\\", "/").endsWith(candiadate)) {
                        return child;
                    }
                } else if (child.isDirectory() && (result = this.findFile(child, candiadate)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public InputStream getContents(SourceRelativeURI uri, IProject project) throws IOException {
        File container = new File(this.folder);
        if (!container.exists()) {
            return null;
        }
        File file = this.findFile(container, uri.getURI().toString());
        if (file == null) {
            return null;
        }
        return new FileInputStream(file);
    }

    protected Reader getContentsAsText(SourceRelativeURI uri, IProject project) throws IOException {
        InputStream contents = this.getContents(uri, project);
        return new InputStreamReader(contents, this.getEncoding());
    }
}

