/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.command;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;

public class ViewDeleteCommand
extends DeleteCommand {
    public ViewDeleteCommand(TransactionalEditingDomain editingDomain, View view) {
        super(editingDomain, view);
    }

    public ViewDeleteCommand(View view) {
        super(view);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        boolean prefRemoveAttachedPGE = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_REMOVE_HIDE_NOTE_WHEN_ANNOTED_ELEMENT_HIDDEN_OR_REMOVE.name());
        List<Edge> attachedEdge = GMFHelper.getAttachedEdgesRecursively(Collections.singleton(this.getView()));
        List<Node> attachedPGE = null;
        if (prefRemoveAttachedPGE) {
            attachedPGE = Stream.concat(GMFHelper.getAttachedPGE(this.getView()).stream(), GMFHelper.getAttachedPGE(attachedEdge).stream()).toList();
        }
        for (Edge edge : attachedEdge) {
            if (!ViewType.NOTEATTACHMENT.equals(edge.getType())) continue;
            EcoreUtil.remove((EObject)edge);
        }
        EcoreUtil.remove((EObject)this.getView());
        if (prefRemoveAttachedPGE) {
            GMFHelper.deleteDetachedPGE(attachedPGE);
        }
        return CommandResult.newOKCommandResult();
    }
}

