/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit;

import com.google.inject.Inject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.edit.EditCommand;
import org.eclipse.emf.parsley.edit.EditingDomainFinder;
import org.eclipse.emf.parsley.edit.IEditingStrategy;
import org.eclipse.emf.parsley.edit.NotificationBuffer;
import org.eclipse.emf.parsley.util.EObjectState;
import org.eclipse.jface.viewers.ILabelProvider;

public class UndoableEditingStrategy
implements IEditingStrategy {
    @Inject
    private EditingDomainFinder editingDomainFinder;
    @Inject
    private ILabelProvider labelProvider;
    private EObjectState state;
    private NotificationBuffer notificationBuffer;

    @Override
    public void prepare(EObject original) {
        this.state = new EObjectState(original);
        this.notificationBuffer = new NotificationBuffer(original);
        this.disableNotifications(original);
    }

    @Override
    public EditingDomain getEditingDomain(EObject edited) {
        return null;
    }

    @Override
    public void update(EObject edited) {
        this.enableNotifications(edited);
        EditingDomain domain = this.editingDomainFinder.getEditingDomainFor(edited);
        EditCommand editCommand = new EditCommand(domain, "Edit " + this.labelProvider.getText((Object)edited), edited, this.state);
        domain.getCommandStack().execute((Command)editCommand);
        this.triggerViewerNotification(edited);
    }

    protected void triggerViewerNotification(EObject edited) {
        this.notificationBuffer.propagateBufferedNotifications();
    }

    @Override
    public void rollback(EObject edited) {
        this.state.copyStateTo(edited);
        this.enableNotifications(edited);
    }

    protected void disableNotifications(EObject edited) {
        this.notificationBuffer.startBuffering();
    }

    protected void enableNotifications(EObject edited) {
        this.notificationBuffer.stopBuffering();
    }
}

