/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.IDragDropListenerProvider;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.IDragListenerContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.IDropListenerContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.IDragSourceListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDPlugin;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.GetDragListenerOperation;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.GetDropListenerOperation;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.ListenerOperation;

public class DragDropListenerService
extends Service
implements IDragDropListenerProvider {
    private static final DragDropListenerService instance = new DragDropListenerService();

    static {
        instance.configureProviders(CommonUIServicesDNDPlugin.getPluginId(), "dragDropListenerProviders");
    }

    protected DragDropListenerService() {
        super(false);
    }

    public static DragDropListenerService getInstance() {
        return instance;
    }

    private Object execute(ListenerOperation operation) {
        List results = this.execute(ExecutionStrategy.FORWARD, operation);
        if (operation instanceof GetDragListenerOperation) {
            return results.isEmpty() ? null : this.combineArraysInList(results, new IDragSourceListener[0]);
        }
        if (operation instanceof GetDropListenerOperation) {
            return results.isEmpty() ? null : this.combineArraysInList(results, new IDropTargetListener[0]);
        }
        return null;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element, this.getDragDropListenerProviderInfo(element));
    }

    private Hashtable getDragDropListenerProviderInfo(IConfigurationElement element) {
        Hashtable providerInfo = new Hashtable();
        try {
            IConfigurationElement[] viewChildren = element.getChildren("ViewId");
            int i = 0;
            while (i < viewChildren.length) {
                IConfigurationElement viewConfig = viewChildren[i];
                String id = viewConfig.getAttribute("id");
                if (id == null) {
                    this.handleInvalidElement(viewConfig);
                } else {
                    providerInfo.put(id, new Hashtable());
                    IConfigurationElement[] elementTypeChildren = viewConfig.getChildren();
                    int j = 0;
                    while (j < elementTypeChildren.length) {
                        IConfigurationElement elementTypeConfig = elementTypeChildren[j];
                        String elementTypeClass = elementTypeConfig.getAttribute("class");
                        if (elementTypeClass == null) {
                            this.handleInvalidElement(elementTypeConfig);
                        } else {
                            Hashtable table = (Hashtable)providerInfo.get(id);
                            table.put(elementTypeClass, new Hashtable());
                            IConfigurationElement[] operationTypeChildren = elementTypeConfig.getChildren();
                            int k = 0;
                            while (k < operationTypeChildren.length) {
                                IConfigurationElement operationTypeConfig = operationTypeChildren[k];
                                String operationType = operationTypeConfig.getAttribute("operation");
                                if (operationType == null) {
                                    this.handleInvalidElement(operationTypeConfig);
                                } else {
                                    Vector<String> listOftransferId = new Vector<String>();
                                    IConfigurationElement[] transferTypeChildren = operationTypeConfig.getChildren();
                                    int l = 0;
                                    while (l < transferTypeChildren.length) {
                                        IConfigurationElement transferIdConfig = transferTypeChildren[l];
                                        String transferId = transferIdConfig.getAttribute("transferId");
                                        if (transferId == null) {
                                            this.handleInvalidElement(transferIdConfig);
                                        } else {
                                            listOftransferId.addElement(transferId);
                                        }
                                        ++l;
                                    }
                                    table = (Hashtable)((Hashtable)providerInfo.get(id)).get(elementTypeClass);
                                    table.put(operationType, listOftransferId);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getDragDropListenerProviderInfo", (Throwable)e);
            Log.error((Plugin)CommonUIServicesDNDPlugin.getDefault(), (int)1, (String)MessageFormat.format("Invalid XML element ({0}).", element.getName()), (Throwable)e);
        }
        return providerInfo;
    }

    private void handleInvalidElement(IConfigurationElement element) {
        String message = MessageFormat.format("Invalid XML element ({0}).", element.getDeclaringExtension().toString() + ":" + element.getName());
        Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.SERVICES_CONFIG, (String)message);
        Log.error((Plugin)CommonUIServicesDNDPlugin.getDefault(), (int)1, (String)message);
    }

    public String[] getAllTransferIds(String partId, String operationType) {
        assert (partId != null) : "partId cannot be null";
        assert (operationType != null) : "operationType cannot be null";
        List list = this.getAllProviders();
        ArrayList<String> transferIds = new ArrayList<String>();
        for (ProviderDescriptor descriptor : list) {
            Hashtable elementTypeTable = (Hashtable)descriptor.getPartInfo().get(partId);
            if (elementTypeTable == null) continue;
            Enumeration e = elementTypeTable.elements();
            while (e.hasMoreElements()) {
                Hashtable operationTypeTable = (Hashtable)e.nextElement();
                if (!operationTypeTable.containsKey(operationType)) continue;
                List transferIdList = (List)operationTypeTable.get(operationType);
                for (String transferId : transferIdList) {
                    if (transferIds.contains(transferId)) continue;
                    transferIds.add(transferId);
                }
            }
        }
        return !transferIds.isEmpty() ? transferIds.toArray(new String[transferIds.size()]) : null;
    }

    @Override
    public IDragSourceListener[] getDragSourceListeners(IDragListenerContext context) {
        assert (context != null) : "context cannot be null";
        return (IDragSourceListener[])this.execute(new GetDragListenerOperation(context));
    }

    @Override
    public IDropTargetListener[] getDropTargetListeners(IDropListenerContext context) {
        assert (context != null) : "context cannot be null";
        return (IDropTargetListener[])this.execute(new GetDropListenerOperation(context));
    }

    private final Object[] combineArraysInList(List list, Object[] resultingArrayType) {
        List<Object> listEntry = null;
        Iterator it = list.iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        while (it.hasNext()) {
            Object[] array = (Object[])it.next();
            if (array == null || array.length <= 0) continue;
            listEntry = Arrays.asList(array);
            results.addAll(listEntry);
        }
        return results.toArray(resultingArrayType);
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private Hashtable partInfo = null;

        protected ProviderDescriptor(IConfigurationElement element, Hashtable aPartInfo) {
            super(element);
            assert (aPartInfo != null) : "aPartInfo cannot be null";
            this.partInfo = aPartInfo;
        }

        public boolean provides(IOperation operation) {
            Hashtable elementTypeTable;
            if (!(operation instanceof GetDragListenerOperation) && !(operation instanceof GetDropListenerOperation)) {
                return false;
            }
            Class elementType = null;
            String partId = null;
            String operationType = null;
            String transferId = null;
            boolean isCompatible = false;
            if (operation instanceof GetDragListenerOperation) {
                elementType = ((IDragListenerContext)((GetDragListenerOperation)operation).getContext()).getSelectedElementType();
                partId = ((IDragListenerContext)((GetDragListenerOperation)operation).getContext()).getActivePart().getSite().getId();
                operationType = ((GetDragListenerOperation)operation).getContext().getOperationType();
                transferId = ((IDragListenerContext)((GetDragListenerOperation)operation).getContext()).getTransferId();
                isCompatible = ((IDragListenerContext)((GetDragListenerOperation)operation).getContext()).isCompatible();
            }
            if (operation instanceof GetDropListenerOperation) {
                elementType = ((IDropListenerContext)((GetDropListenerOperation)operation).getContext()).getTargetElementType();
                partId = ((IDropListenerContext)((GetDropListenerOperation)operation).getContext()).getActivePart().getSite().getId();
                operationType = ((GetDropListenerOperation)operation).getContext().getOperationType();
                transferId = ((IDropListenerContext)((GetDropListenerOperation)operation).getContext()).getTransferId();
                isCompatible = ((IDropListenerContext)((GetDropListenerOperation)operation).getContext()).isCompatible();
            }
            if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DNDS:provides::Element Type is " + elementType.getName()));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DNDS:provides::Part Id is " + partId));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DNDS:provides::Operation Type is " + operationType));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DNDS:provides::Transfer id is " + transferId));
                Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("DNDS:provides::Compatible is " + isCompatible));
            }
            if ((elementTypeTable = (Hashtable)this.getPartInfo().get(partId)) == null) {
                return false;
            }
            Hashtable operationTypeTable = (Hashtable)elementTypeTable.get(isCompatible ? this.getCompatibleType(elementTypeTable, elementType).getName() : elementType.getName());
            if (operationTypeTable == null) {
                return false;
            }
            List transferIdList = (List)operationTypeTable.get(operationType);
            if (transferIdList == null) {
                return false;
            }
            return transferId.equals("ALL_TRANSFERS") ? true : transferIdList.contains(transferId);
        }

        private Hashtable getPartInfo() {
            return this.partInfo;
        }

        private Class getCompatibleType(Hashtable elementTypeTable, Class elementType) {
            Class<?> newClass = null;
            String className = null;
            Enumeration enumeration = elementTypeTable.keys();
            while (enumeration.hasMoreElements()) {
                className = (String)enumeration.nextElement();
                try {
                    newClass = Class.forName(className, false, elementType.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getCompatibleType", (Throwable)e);
                }
                if (newClass == null || !newClass.isAssignableFrom(elementType)) continue;
                return newClass;
            }
            return elementType;
        }
    }
}

