/*
 * Copyright (c) 2012, 2013, 2023 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.common.security;

/**
 * Describes the possible protection levels a protectable object may have.
 *
 * @author Eike Stepper
 * @since 4.1
 */
public enum CDOPermission
{
  NONE(0x00), READ(0x01), WRITE(0x03);

  private byte bits;

  private CDOPermission(int bits)
  {
    this.bits = (byte)bits;
  }

  public byte getBits()
  {
    return bits;
  }

  /**
   * @since 4.1
   */
  public boolean isReadable()
  {
    return this != CDOPermission.NONE;
  }

  /**
   * @since 4.1
   */
  public boolean isWritable()
  {
    return this == CDOPermission.WRITE;
  }

  public static CDOPermission get(int bits)
  {
    bits &= WRITE.getBits();

    switch (bits)
    {
    case 0x00:
      return NONE;
    case 0x01:
      return READ;
    case 0x03:
      return WRITE;
    default:
      throw new IllegalArgumentException("Invalid bits: " + bits);
    }
  }

  /**
   * @since 4.22
   */
  public static CDOPermission parse(String str)
  {
    return str == null ? null : valueOf(str.toUpperCase());
  }
}
