/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.ui.internal.AddDependencyJavaCompletionProposal;

public class AddDependencyQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 0x1000002: 
            case 33554515: 
            case 67108984: 
            case 0x8000081: 
            case 268435846: 
            case 0x22000032: {
                IJavaProject project;
                IJavaElement parent = unit.getParent();
                if (parent == null || (project = parent.getJavaProject()) == null) break;
                return MavenPlugin.isMavenProject((IProject)project.getProject());
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        HashMap<IMavenProjectFacade, Set<ArtifactKey>> possibleKeys = new HashMap<IMavenProjectFacade, Set<ArtifactKey>>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation location = iProblemLocationArray[n2];
            switch (location.getProblemId()) {
                case 0x1000002: 
                case 33554515: 
                case 67108984: 
                case 0x8000081: 
                case 268435846: 
                case 0x22000032: {
                    this.handleImportNotFound(context, location, possibleKeys);
                }
            }
            ++n2;
        }
        int relevance = AddDependencyQuickFixProcessor.getRelevance();
        return (IJavaCompletionProposal[])possibleKeys.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(key -> new AddDependencyJavaCompletionProposal((ArtifactKey)key, ((IMavenProjectFacade)entry.getKey()).getPom(), relevance))).toArray(IJavaCompletionProposal[]::new);
    }

    private void handleImportNotFound(IInvocationContext context, IProblemLocation problemLocation, Map<IMavenProjectFacade, Set<ArtifactKey>> possibleKeys) throws CoreException {
        Set<ArtifactKey> artifacts;
        IMavenProjectFacade currentFacade;
        String className;
        CompilationUnit cu = context.getASTRoot();
        ASTNode selectedNode = problemLocation.getCoveringNode(cu);
        if (selectedNode != null && (className = this.getClassName(selectedNode)) != null && (currentFacade = (IMavenProjectFacade)Adapters.adapt((Object)cu.getJavaElement().getJavaProject(), IMavenProjectFacade.class)) != null && !(artifacts = AddDependencyQuickFixProcessor.findMatchingArtifacts(className, currentFacade)).isEmpty()) {
            possibleKeys.computeIfAbsent(currentFacade, x -> new HashSet()).addAll(artifacts);
        }
    }

    static Set<ArtifactKey> findMatchingArtifacts(String className, final IMavenProjectFacade currentFacade) throws CoreException {
        final HashSet<ArtifactKey> possibleKey = new HashSet<ArtifactKey>();
        if (AddDependencyQuickFixProcessor.isResolveMissingWorkspaceProject()) {
            SearchPattern typePattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)8);
            IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();
            SearchEngine searchEngine = new SearchEngine();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch aMatch) {
                    ArtifactKey artifactKey;
                    IType type;
                    IMavenProjectFacade facade;
                    Object element = aMatch.getElement();
                    if (element instanceof IType && (facade = (IMavenProjectFacade)Adapters.adapt((Object)(type = (IType)element).getJavaProject(), IMavenProjectFacade.class)) != null && !(artifactKey = facade.getArtifactKey()).equals((Object)currentFacade.getArtifactKey())) {
                        possibleKey.add(artifactKey);
                    }
                }
            };
            searchEngine.search(typePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, workspaceScope, requestor, null);
        }
        return possibleKey;
    }

    private String getClassName(ASTNode selectedNode) {
        String className = null;
        if (selectedNode instanceof Name) {
            ITypeBinding typeBinding = ((Name)selectedNode).resolveTypeBinding();
            if (typeBinding != null) {
                className = typeBinding.getBinaryName();
            }
            if (className == null && selectedNode instanceof SimpleName) {
                className = ((SimpleName)selectedNode).getIdentifier();
            }
        }
        return className;
    }

    private static boolean isResolveMissingWorkspaceProject() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core").getBoolean("eclipse.m2.resolveMissingWorkspaceProjects", true);
    }

    private static int getRelevance() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core").getInt("eclipse.m2.defaultCompletionRelevance", 100);
    }
}

