/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.archetype;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchetypeCatalogFactory {
    private static final Logger log = LoggerFactory.getLogger(ArchetypeCatalogFactory.class);
    private final String id;
    private final String description;
    private final boolean editable;
    private boolean enabled;

    protected ArchetypeCatalogFactory(String id, String description, boolean editable) {
        this(id, description, editable, true);
    }

    protected ArchetypeCatalogFactory(String id, String description, boolean editable, boolean enabled) {
        this.id = id;
        this.description = description;
        this.editable = editable;
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract ArchetypeCatalog getArchetypeCatalog() throws CoreException;

    public String toString() {
        return this.getId();
    }

    public static class DefaultLocalCatalogFactory
    extends ArchetypeCatalogFactory {
        public static final String ID = "defaultLocal";
        private ArchetypeDataSource source;
        private IMaven maven;

        DefaultLocalCatalogFactory(IMaven maven, ArchetypeDataSource source) {
            super(ID, Messages.ArchetypeCatalogFactory_default_local, false);
            this.maven = maven;
            this.source = source;
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() throws CoreException {
            return (ArchetypeCatalog)this.maven.createExecutionContext().execute((ctx, m) -> {
                ProjectBuildingRequest buildingRequest = ctx.newProjectBuildingRequest();
                try {
                    return this.source.getArchetypeCatalog(buildingRequest);
                }
                catch (ArchetypeDataSourceException e) {
                    return new ArchetypeCatalog();
                }
            }, null);
        }
    }

    public static class InternalCatalogFactory
    extends ArchetypeCatalogFactory {
        public static final String ID = "internal";
        private ArchetypeDataSource source;

        InternalCatalogFactory(ArchetypeDataSource source) {
            super(ID, Messages.ArchetypeCatalogFactory_internal, false);
            this.source = source;
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() {
            try {
                return this.source.getArchetypeCatalog(null);
            }
            catch (ArchetypeDataSourceException e) {
                return new ArchetypeCatalog();
            }
        }
    }

    public static class LocalCatalogFactory
    extends ArchetypeCatalogFactory {
        private IMaven maven;
        private ArchetypeDataSource source;

        public LocalCatalogFactory(String path, String description, boolean editable, boolean enabled, IMaven maven, ArchetypeDataSource source) {
            super(path, description == null || description.trim().length() == 0 ? NLS.bind((String)Messages.ArchetypeCatalogFactory_local, (Object)path) : description, editable, enabled);
            this.maven = maven;
            this.source = source;
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() throws CoreException {
            ArchetypeCatalog catalog = this.getEmbeddedCatalog();
            if (catalog == null) {
                IMavenExecutionContext context = this.maven.createExecutionContext();
                MavenArtifactRepository localRepository = new MavenArtifactRepository();
                localRepository.setUrl(this.getLocalRepositoryURL());
                context.getExecutionRequest().setLocalRepository((ArtifactRepository)localRepository);
                return (ArchetypeCatalog)context.execute((arg_0, arg_1) -> this.lambda$0((ArtifactRepository)localRepository, arg_0, arg_1), null);
            }
            return catalog;
        }

        private String getLocalRepositoryURL() {
            Path path;
            try {
                path = Path.of(this.getId(), new String[0]);
            }
            catch (Exception e1) {
                try {
                    path = Path.of(new URI(this.getId()));
                }
                catch (Exception e2) {
                    return this.getId();
                }
            }
            path = path.toAbsolutePath();
            if (Files.isRegularFile(path, new LinkOption[0])) {
                path = path.getParent();
            }
            return path.toUri().toString();
        }

        private ArchetypeCatalog getEmbeddedCatalog() throws CoreException {
            URL url = this.getEmbeddedUrl();
            if (url == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream is = url.openStream();){
                    return new ArchetypeCatalogXpp3Reader().read(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                String msg = NLS.bind((String)Messages.ArchetypeCatalogFactory_error_missing_catalog, (Object)ex.getMessage());
                log.error(msg, (Throwable)ex);
                throw new CoreException(Status.error((String)msg, (Throwable)ex));
            }
        }

        private URL getEmbeddedUrl() {
            String path = this.getId();
            if (path != null && path.startsWith("bundleentry://")) {
                try {
                    return new URL(path);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }

        private /* synthetic */ ArchetypeCatalog lambda$0(ArtifactRepository artifactRepository, IMavenExecutionContext ctx, IProgressMonitor m) throws CoreException {
            ProjectBuildingRequest buildingRequest = ctx.newProjectBuildingRequest();
            buildingRequest.setLocalRepository(artifactRepository);
            try {
                return this.source.getArchetypeCatalog(buildingRequest);
            }
            catch (ArchetypeDataSourceException e) {
                return new ArchetypeCatalog();
            }
        }
    }

    public static class RemoteCatalogFactory
    extends ArchetypeCatalogFactory {
        private String repositoryUrl = null;
        private IMaven maven;
        private ArchetypeDataSource source;

        RemoteCatalogFactory(String url, String description, boolean editable, boolean enabled, IMaven maven, ArchetypeDataSource source) {
            super(url, description == null || description.trim().length() == 0 ? NLS.bind((String)Messages.ArchetypeCatalogFactory_remote, (Object)url) : description, editable, enabled);
            this.maven = maven;
            this.source = source;
            this.repositoryUrl = this.parseCatalogUrl(url);
        }

        private String parseCatalogUrl(String url) {
            if (url == null) {
                return null;
            }
            int length = url.length();
            if (length > 1 && url.endsWith("/")) {
                return url.substring(0, url.length() - 1);
            }
            int idx = Math.max(url.lastIndexOf("/"), 0);
            return url.lastIndexOf(".") >= idx ? url.substring(0, idx) : url;
        }

        @Override
        public ArchetypeCatalog getArchetypeCatalog() throws CoreException {
            String url = this.getId();
            int idx = url.lastIndexOf("/archetype-catalog.xml");
            if (idx > -1) {
                url = url.substring(0, idx);
            }
            final String remoteUrl = url;
            final ArchetypeCatalog catalog = (ArchetypeCatalog)this.maven.createExecutionContext().execute((ctx, m) -> {
                ProjectBuildingRequest buildingRequest = ctx.newProjectBuildingRequest();
                try {
                    MavenArtifactRepository archeTypeRepo = new MavenArtifactRepository();
                    archeTypeRepo.setUrl(remoteUrl);
                    archeTypeRepo.setId("archetype");
                    buildingRequest.getRemoteRepositories().add(archeTypeRepo);
                    return this.source.getArchetypeCatalog(buildingRequest);
                }
                catch (ArchetypeDataSourceException e) {
                    return new ArchetypeCatalog();
                }
            }, null);
            ArchetypeCatalog catalogWrapper = new ArchetypeCatalog(){

                public void addArchetype(Archetype archetype) {
                    catalog.addArchetype(archetype);
                }

                public List<Archetype> getArchetypes() {
                    ArrayList<Archetype> archetypes = new ArrayList<Archetype>(catalog.getArchetypes());
                    for (Archetype arch : archetypes) {
                        if (arch.getRepository() != null && !arch.getRepository().trim().isEmpty()) continue;
                        arch.setRepository(remoteUrl);
                    }
                    return archetypes;
                }

                public String getModelEncoding() {
                    return catalog.getModelEncoding();
                }

                public void removeArchetype(Archetype archetype) {
                    catalog.removeArchetype(archetype);
                }

                public void setModelEncoding(String modelEncoding) {
                    catalog.setModelEncoding(modelEncoding);
                }

                public void setArchetypes(List<Archetype> archetypes) {
                    catalog.setArchetypes(archetypes);
                }

                public String toString() {
                    return catalog.toString();
                }
            };
            return catalogWrapper;
        }

        public String getRepositoryUrl() {
            return this.repositoryUrl;
        }
    }
}

