/// <reference types="node" />
/// <reference types="node" />
/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { AttachRequestArguments, LaunchRequestArguments } from '../../types/session';
import { ChildProcess } from 'child_process';
import { IStdioProcess } from '../../types/gdb';
export declare class GDBFileSystemProcessManagerBase {
    protected proc?: ChildProcess;
    protected token: number;
    protected requestArgs?: LaunchRequestArguments | AttachRequestArguments;
    constructor();
    protected getEnvironment(additionalEnvironment?: Record<string, string | null>): NodeJS.ProcessEnv;
    protected getCwd(requestArgs: LaunchRequestArguments | AttachRequestArguments): string;
    spawn(executable: string, args: string[] | undefined, options: {
        cwd?: string;
        additionalEnvironment?: Record<string, string | null>;
    }): Promise<IStdioProcess>;
    kill(): Promise<void>;
    onStop(callback: (code: number | null, signal: NodeJS.Signals | null) => void): void;
    onError(callback: (err: Error) => void): void;
}
