"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_plugin-dev_lib_browser_plugin-dev-frontend-module_js"],{

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-controller.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-controller.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var HostedPluginController_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HostedPluginController = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const status_bar_1 = __webpack_require__(/*! @theia/core/lib/browser/status-bar/status-bar */ "../../node_modules/@theia/core/lib/browser/status-bar/status-bar.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const commands_1 = __webpack_require__(/*! @theia/core/shared/@lumino/commands */ "../../node_modules/@theia/core/shared/@lumino/commands/index.js");
const widgets_1 = __webpack_require__(/*! @theia/core/shared/@lumino/widgets */ "../../node_modules/@theia/core/shared/@lumino/widgets/index.js");
const frontend_application_state_1 = __webpack_require__(/*! @theia/core/lib/browser/frontend-application-state */ "../../node_modules/@theia/core/lib/browser/frontend-application-state.js");
const connection_status_service_1 = __webpack_require__(/*! @theia/core/lib/browser/connection-status-service */ "../../node_modules/@theia/core/lib/browser/connection-status-service.js");
const plugin_dev_protocol_1 = __webpack_require__(/*! ../common/plugin-dev-protocol */ "../../node_modules/@theia/plugin-dev/lib/common/plugin-dev-protocol.js");
const hosted_plugin_manager_client_1 = __webpack_require__(/*! ./hosted-plugin-manager-client */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-manager-client.js");
const hosted_plugin_log_viewer_1 = __webpack_require__(/*! ./hosted-plugin-log-viewer */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-log-viewer.js");
const hosted_plugin_preferences_1 = __webpack_require__(/*! ./hosted-plugin-preferences */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-preferences.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
/**
 * Adds a status bar element displaying the state of secondary Theia instance with hosted plugin and
 * allows controlling the instance by simple clicking on the status bar element.
 */
let HostedPluginController = HostedPluginController_1 = class HostedPluginController {
    constructor() {
        this.pluginState = hosted_plugin_manager_client_1.HostedInstanceState.STOPPED;
    }
    initialize() {
        this.hostedPluginServer.getHostedPlugin().then(pluginMetadata => {
            if (!pluginMetadata) {
                this.frontendApplicationStateService.reachedState('ready').then(() => {
                    // handles status bar item
                    this.hostedPluginManagerClient.onStateChanged(e => {
                        if (e.state === hosted_plugin_manager_client_1.HostedInstanceState.STARTING) {
                            this.onHostedPluginStarting();
                        }
                        else if (e.state === hosted_plugin_manager_client_1.HostedInstanceState.RUNNING) {
                            this.onHostedPluginRunning();
                        }
                        else if (e.state === hosted_plugin_manager_client_1.HostedInstanceState.STOPPED) {
                            this.onHostedPluginStopped();
                        }
                        else if (e.state === hosted_plugin_manager_client_1.HostedInstanceState.FAILED) {
                            this.onHostedPluginFailed();
                        }
                    });
                    // handles watch compilation
                    this.hostedPluginManagerClient.onStateChanged(e => this.handleWatchers(e));
                    // updates status bar if page is loading when hosted instance is already running
                    this.hostedPluginServer.isHostedPluginInstanceRunning().then(running => {
                        if (running) {
                            this.onHostedPluginRunning();
                        }
                    });
                });
                this.connectionStatusService.onStatusChange(() => this.onConnectionStatusChanged());
                this.preferenceService.onPreferenceChanged(preference => this.onPreferencesChanged(preference));
            }
            else {
                console.error(`Need to load plugin ${pluginMetadata.model.id}`);
            }
        });
    }
    /**
     * Display status bar element for stopped plugin.
     */
    async onHostedPluginStopped() {
        this.pluginState = hosted_plugin_manager_client_1.HostedInstanceState.STOPPED;
        this.entry = {
            text: `${nls_1.nls.localize('theia/plugin-dev/hostedPluginStopped', 'Hosted Plugin: Stopped')} $(angle-up)`,
            alignment: browser_1.StatusBarAlignment.LEFT,
            priority: 100,
            onclick: e => {
                this.showMenu(e.clientX, e.clientY);
            }
        };
        this.entry.className = HostedPluginController_1.HOSTED_PLUGIN;
        await this.statusBar.setElement(HostedPluginController_1.HOSTED_PLUGIN, this.entry);
    }
    /**
     * Display status bar element for starting plugin.
     */
    async onHostedPluginStarting() {
        this.pluginState = hosted_plugin_manager_client_1.HostedInstanceState.STARTING;
        this.hostedPluginLogViewer.showLogConsole();
        this.entry = {
            text: `$(cog~spin) ${nls_1.nls.localize('theia/plugin-dev/hostedPluginStarting', 'Hosted Plugin: Starting')}`,
            alignment: browser_1.StatusBarAlignment.LEFT,
            priority: 100
        };
        this.entry.className = HostedPluginController_1.HOSTED_PLUGIN;
        await this.statusBar.setElement(HostedPluginController_1.HOSTED_PLUGIN, this.entry);
    }
    /**
     * Display status bar element for running plugin.
     */
    async onHostedPluginRunning() {
        this.pluginState = hosted_plugin_manager_client_1.HostedInstanceState.RUNNING;
        let entryText;
        if (this.hostedPluginPreferences['hosted-plugin.watchMode'] && this.watcherSuccess) {
            entryText = `$(cog~spin) ${nls_1.nls.localize('theia/plugin-dev/hostedPluginWatching', 'Hosted Plugin: Watching')}$(angle-up)`;
        }
        else {
            entryText = `$(cog~spin) ${nls_1.nls.localize('theia/plugin-dev/hostedPluginRunning', 'Hosted Plugin: Running')} $(angle-up)`;
        }
        this.entry = {
            text: entryText,
            alignment: browser_1.StatusBarAlignment.LEFT,
            priority: 100,
            onclick: e => {
                this.showMenu(e.clientX, e.clientY);
            }
        };
        this.entry.className = HostedPluginController_1.HOSTED_PLUGIN;
        await this.statusBar.setElement(HostedPluginController_1.HOSTED_PLUGIN, this.entry);
    }
    /**
     * Display status bar element for failed plugin.
     */
    async onHostedPluginFailed() {
        this.pluginState = hosted_plugin_manager_client_1.HostedInstanceState.FAILED;
        this.entry = {
            text: `${nls_1.nls.localize('theia/plugin-dev/hostedPluginStopped', 'Hosted Plugin: Stopped')} $(angle-up)`,
            alignment: browser_1.StatusBarAlignment.LEFT,
            priority: 100,
            onclick: e => {
                this.showMenu(e.clientX, e.clientY);
            }
        };
        this.entry.className = HostedPluginController_1.HOSTED_PLUGIN_FAILED;
        await this.statusBar.setElement(HostedPluginController_1.HOSTED_PLUGIN, this.entry);
    }
    async onPreferencesChanged(preference) {
        if (preference.preferenceName === 'hosted-plugin.watchMode') {
            if (await this.hostedPluginServer.isHostedPluginInstanceRunning()) {
                const pluginLocation = await this.hostedPluginServer.getHostedPluginURI();
                const isWatchCompilationRunning = await this.hostedPluginServer.isWatchCompilationRunning(pluginLocation);
                if (preference.newValue === true) {
                    if (!isWatchCompilationRunning) {
                        await this.runWatchCompilation(pluginLocation.toString());
                    }
                }
                else {
                    if (isWatchCompilationRunning) {
                        await this.hostedPluginServer.stopWatchCompilation(pluginLocation.toString());
                    }
                }
                // update status bar
                this.onHostedPluginRunning();
            }
        }
    }
    /**
     * Starts / stops watchers on hosted instance state change.
     *
     * @param event hosted instance state change event
     */
    async handleWatchers(event) {
        if (event.state === hosted_plugin_manager_client_1.HostedInstanceState.RUNNING) {
            if (this.hostedPluginPreferences['hosted-plugin.watchMode']) {
                await this.runWatchCompilation(event.pluginLocation.toString());
                // update status bar
                this.onHostedPluginRunning();
            }
        }
        else if (event.state === hosted_plugin_manager_client_1.HostedInstanceState.STOPPING) {
            if (this.hostedPluginPreferences['hosted-plugin.watchMode']) {
                const isRunning = await this.hostedPluginServer.isWatchCompilationRunning(event.pluginLocation.toString());
                if (isRunning) {
                    try {
                        await this.hostedPluginServer.stopWatchCompilation(event.pluginLocation.toString());
                    }
                    catch (error) {
                        this.messageService.error(this.getErrorMessage(error));
                    }
                }
            }
        }
    }
    async runWatchCompilation(pluginLocation) {
        try {
            await this.hostedPluginServer.runWatchCompilation(pluginLocation);
            this.watcherSuccess = true;
        }
        catch (error) {
            this.messageService.error(this.getErrorMessage(error));
            this.watcherSuccess = false;
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    getErrorMessage(error) {
        var _a;
        return ((_a = error === null || error === void 0 ? void 0 : error.message) === null || _a === void 0 ? void 0 : _a.substring(error.message.indexOf(':') + 1)) || '';
    }
    /**
     * Updating status bar element when changing connection status.
     */
    onConnectionStatusChanged() {
        if (this.connectionStatusService.currentStatus === connection_status_service_1.ConnectionStatus.OFFLINE) {
            // Re-set the element only if it's visible on status bar
            if (this.entry) {
                const offlineElement = {
                    text: nls_1.nls.localize('theia/plugin-dev/hostedPluginStopped', 'Hosted Plugin: Stopped'),
                    alignment: browser_1.StatusBarAlignment.LEFT,
                    priority: 100
                };
                this.entry.className = HostedPluginController_1.HOSTED_PLUGIN_OFFLINE;
                this.statusBar.setElement(HostedPluginController_1.HOSTED_PLUGIN, offlineElement);
            }
        }
        else {
            // ask state of hosted plugin when switching to Online
            if (this.entry) {
                this.hostedPluginServer.isHostedPluginInstanceRunning().then(running => {
                    if (running) {
                        this.onHostedPluginRunning();
                    }
                    else {
                        this.onHostedPluginStopped();
                    }
                });
            }
        }
    }
    /**
     * Show menu containing actions to start/stop/restart hosted plugin.
     */
    showMenu(x, y) {
        const commands = new commands_1.CommandRegistry();
        const menu = new widgets_1.Menu({
            commands
        });
        if (this.pluginState === hosted_plugin_manager_client_1.HostedInstanceState.RUNNING) {
            this.addCommandsForRunningPlugin(commands, menu);
        }
        else if (this.pluginState === hosted_plugin_manager_client_1.HostedInstanceState.STOPPED || this.pluginState === hosted_plugin_manager_client_1.HostedInstanceState.FAILED) {
            this.addCommandsForStoppedPlugin(commands, menu);
        }
        menu.open(x, y);
    }
    /**
     * Adds commands to the menu for running plugin.
     */
    addCommandsForRunningPlugin(commands, menu) {
        commands.addCommand(hosted_plugin_manager_client_1.HostedPluginCommands.STOP.id, {
            label: nls_1.nls.localize('theia/plugin-dev/stopInstance', 'Stop Instance'),
            iconClass: (0, browser_1.codicon)('debug-stop'),
            execute: () => setTimeout(() => this.hostedPluginManagerClient.stop(), 100)
        });
        menu.addItem({
            type: 'command',
            command: hosted_plugin_manager_client_1.HostedPluginCommands.STOP.id
        });
        commands.addCommand(hosted_plugin_manager_client_1.HostedPluginCommands.RESTART.id, {
            label: nls_1.nls.localize('theia/plugin-dev/restartInstance', 'Restart Instance'),
            iconClass: (0, browser_1.codicon)('debug-restart'),
            execute: () => setTimeout(() => this.hostedPluginManagerClient.restart(), 100)
        });
        menu.addItem({
            type: 'command',
            command: hosted_plugin_manager_client_1.HostedPluginCommands.RESTART.id
        });
    }
    /**
     * Adds command to the menu for stopped plugin.
     */
    addCommandsForStoppedPlugin(commands, menu) {
        commands.addCommand(hosted_plugin_manager_client_1.HostedPluginCommands.START.id, {
            label: nls_1.nls.localize('theia/plugin-dev/startInstance', 'Start Instance'),
            iconClass: (0, browser_1.codicon)('play'),
            execute: () => setTimeout(() => this.hostedPluginManagerClient.start(), 100)
        });
        menu.addItem({
            type: 'command',
            command: hosted_plugin_manager_client_1.HostedPluginCommands.START.id
        });
        commands.addCommand(hosted_plugin_manager_client_1.HostedPluginCommands.DEBUG.id, {
            label: nls_1.nls.localize('theia/plugin-dev/debugInstance', 'Debug Instance'),
            iconClass: (0, browser_1.codicon)('debug'),
            execute: () => setTimeout(() => this.hostedPluginManagerClient.debug(), 100)
        });
        menu.addItem({
            type: 'command',
            command: hosted_plugin_manager_client_1.HostedPluginCommands.DEBUG.id
        });
    }
};
exports.HostedPluginController = HostedPluginController;
HostedPluginController.HOSTED_PLUGIN = 'hosted-plugin';
HostedPluginController.HOSTED_PLUGIN_OFFLINE = 'hosted-plugin-offline';
HostedPluginController.HOSTED_PLUGIN_FAILED = 'hosted-plugin-failed';
tslib_1.__decorate([
    (0, inversify_1.inject)(status_bar_1.StatusBar),
    tslib_1.__metadata("design:type", Object)
], HostedPluginController.prototype, "statusBar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    tslib_1.__metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], HostedPluginController.prototype, "frontendApplicationStateService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(plugin_dev_protocol_1.PluginDevServer),
    tslib_1.__metadata("design:type", Object)
], HostedPluginController.prototype, "hostedPluginServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(hosted_plugin_manager_client_1.HostedPluginManagerClient),
    tslib_1.__metadata("design:type", hosted_plugin_manager_client_1.HostedPluginManagerClient)
], HostedPluginController.prototype, "hostedPluginManagerClient", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(connection_status_service_1.ConnectionStatusService),
    tslib_1.__metadata("design:type", Object)
], HostedPluginController.prototype, "connectionStatusService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(hosted_plugin_log_viewer_1.HostedPluginLogViewer),
    tslib_1.__metadata("design:type", hosted_plugin_log_viewer_1.HostedPluginLogViewer)
], HostedPluginController.prototype, "hostedPluginLogViewer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(hosted_plugin_preferences_1.HostedPluginPreferences),
    tslib_1.__metadata("design:type", Object)
], HostedPluginController.prototype, "hostedPluginPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceServiceImpl),
    tslib_1.__metadata("design:type", browser_1.PreferenceServiceImpl)
], HostedPluginController.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MessageService),
    tslib_1.__metadata("design:type", common_1.MessageService)
], HostedPluginController.prototype, "messageService", void 0);
exports.HostedPluginController = HostedPluginController = HostedPluginController_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HostedPluginController);


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-frontend-contribution.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-frontend-contribution.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HostedPluginFrontendContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const hosted_plugin_manager_client_1 = __webpack_require__(/*! ./hosted-plugin-manager-client */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-manager-client.js");
let HostedPluginFrontendContribution = class HostedPluginFrontendContribution {
    registerCommands(commands) {
        commands.registerCommand(hosted_plugin_manager_client_1.HostedPluginCommands.START, {
            execute: () => this.hostedPluginManagerClient.start()
        });
        commands.registerCommand(hosted_plugin_manager_client_1.HostedPluginCommands.DEBUG, {
            execute: () => this.hostedPluginManagerClient.debug()
        });
        commands.registerCommand(hosted_plugin_manager_client_1.HostedPluginCommands.STOP, {
            execute: () => this.hostedPluginManagerClient.stop()
        });
        commands.registerCommand(hosted_plugin_manager_client_1.HostedPluginCommands.RESTART, {
            execute: () => this.hostedPluginManagerClient.restart()
        });
        commands.registerCommand(hosted_plugin_manager_client_1.HostedPluginCommands.SELECT_PATH, {
            execute: () => this.hostedPluginManagerClient.selectPluginPath()
        });
    }
};
exports.HostedPluginFrontendContribution = HostedPluginFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(hosted_plugin_manager_client_1.HostedPluginManagerClient),
    tslib_1.__metadata("design:type", hosted_plugin_manager_client_1.HostedPluginManagerClient)
], HostedPluginFrontendContribution.prototype, "hostedPluginManagerClient", void 0);
exports.HostedPluginFrontendContribution = HostedPluginFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HostedPluginFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-informer.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-informer.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var HostedPluginInformer_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HostedPluginInformer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const status_bar_1 = __webpack_require__(/*! @theia/core/lib/browser/status-bar/status-bar */ "../../node_modules/@theia/core/lib/browser/status-bar/status-bar.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const plugin_dev_protocol_1 = __webpack_require__(/*! ../common/plugin-dev-protocol */ "../../node_modules/@theia/plugin-dev/lib/common/plugin-dev-protocol.js");
const connection_status_service_1 = __webpack_require__(/*! @theia/core/lib/browser/connection-status-service */ "../../node_modules/@theia/core/lib/browser/connection-status-service.js");
const frontend_application_state_1 = __webpack_require__(/*! @theia/core/lib/browser/frontend-application-state */ "../../node_modules/@theia/core/lib/browser/frontend-application-state.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const window_title_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-title-service */ "../../node_modules/@theia/core/lib/browser/window/window-title-service.js");
/**
 * Informs the user whether Theia is running with hosted plugin.
 * Adds 'Development Host' status bar element and appends the same prefix to window title.
 */
let HostedPluginInformer = HostedPluginInformer_1 = class HostedPluginInformer {
    initialize() {
        this.hostedPluginServer.getHostedPlugin().then(pluginMetadata => {
            if (pluginMetadata) {
                this.windowTitleService.update({
                    developmentHost: HostedPluginInformer_1.DEVELOPMENT_HOST_TITLE
                });
                this.entry = {
                    text: `$(cube) ${HostedPluginInformer_1.DEVELOPMENT_HOST_TITLE}`,
                    tooltip: `${nls_1.nls.localize('theia/plugin-dev/hostedPlugin', 'Hosted Plugin')} '${pluginMetadata.model.name}'`,
                    alignment: browser_1.StatusBarAlignment.LEFT,
                    priority: 100
                };
                this.frontendApplicationStateService.reachedState('ready').then(() => {
                    this.updateStatusBarElement();
                });
                this.connectionStatusService.onStatusChange(() => this.updateStatusBarElement());
            }
        });
    }
    updateStatusBarElement() {
        if (this.connectionStatusService.currentStatus === connection_status_service_1.ConnectionStatus.OFFLINE) {
            this.entry.className = HostedPluginInformer_1.DEVELOPMENT_HOST_OFFLINE;
        }
        else {
            this.entry.className = HostedPluginInformer_1.DEVELOPMENT_HOST;
        }
        this.statusBar.setElement(HostedPluginInformer_1.DEVELOPMENT_HOST, this.entry);
    }
};
exports.HostedPluginInformer = HostedPluginInformer;
HostedPluginInformer.DEVELOPMENT_HOST_TITLE = nls_1.nls.localize('theia/plugin-dev/devHost', 'Development Host');
HostedPluginInformer.DEVELOPMENT_HOST = 'development-host';
HostedPluginInformer.DEVELOPMENT_HOST_OFFLINE = 'development-host-offline';
tslib_1.__decorate([
    (0, inversify_1.inject)(status_bar_1.StatusBar),
    tslib_1.__metadata("design:type", Object)
], HostedPluginInformer.prototype, "statusBar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], HostedPluginInformer.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(plugin_dev_protocol_1.PluginDevServer),
    tslib_1.__metadata("design:type", Object)
], HostedPluginInformer.prototype, "hostedPluginServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(connection_status_service_1.ConnectionStatusService),
    tslib_1.__metadata("design:type", Object)
], HostedPluginInformer.prototype, "connectionStatusService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    tslib_1.__metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], HostedPluginInformer.prototype, "frontendApplicationStateService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(window_title_service_1.WindowTitleService),
    tslib_1.__metadata("design:type", window_title_service_1.WindowTitleService)
], HostedPluginInformer.prototype, "windowTitleService", void 0);
exports.HostedPluginInformer = HostedPluginInformer = HostedPluginInformer_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HostedPluginInformer);


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-log-viewer.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-log-viewer.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var HostedPluginLogViewer_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HostedPluginLogViewer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const output_channel_1 = __webpack_require__(/*! @theia/output/lib/browser/output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
const output_contribution_1 = __webpack_require__(/*! @theia/output/lib/browser/output-contribution */ "../../node_modules/@theia/output/lib/browser/output-contribution.js");
const hosted_plugin_watcher_1 = __webpack_require__(/*! @theia/plugin-ext/lib/hosted/browser/hosted-plugin-watcher */ "../../node_modules/@theia/plugin-ext/lib/hosted/browser/hosted-plugin-watcher.js");
let HostedPluginLogViewer = HostedPluginLogViewer_1 = class HostedPluginLogViewer {
    showLogConsole() {
        this.outputContribution.openView({ reveal: true }).then(view => {
            view.activate();
        });
    }
    init() {
        this.channel = this.outputChannelManager.getChannel(HostedPluginLogViewer_1.OUTPUT_CHANNEL_NAME);
        this.watcher.onLogMessageEvent(event => this.logMessageEventHandler(event));
    }
    logMessageEventHandler(event) {
        this.channel.appendLine(event.data);
    }
};
exports.HostedPluginLogViewer = HostedPluginLogViewer;
HostedPluginLogViewer.OUTPUT_CHANNEL_NAME = 'hosted-instance-log';
tslib_1.__decorate([
    (0, inversify_1.inject)(hosted_plugin_watcher_1.HostedPluginWatcher),
    tslib_1.__metadata("design:type", hosted_plugin_watcher_1.HostedPluginWatcher)
], HostedPluginLogViewer.prototype, "watcher", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    tslib_1.__metadata("design:type", output_channel_1.OutputChannelManager)
], HostedPluginLogViewer.prototype, "outputChannelManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(output_contribution_1.OutputContribution),
    tslib_1.__metadata("design:type", output_contribution_1.OutputContribution)
], HostedPluginLogViewer.prototype, "outputContribution", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], HostedPluginLogViewer.prototype, "init", null);
exports.HostedPluginLogViewer = HostedPluginLogViewer = HostedPluginLogViewer_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HostedPluginLogViewer);


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-manager-client.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-manager-client.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HostedPluginManagerClient = exports.HostedInstanceState = exports.HostedPluginCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const path_1 = __webpack_require__(/*! @theia/core/lib/common/path */ "../../node_modules/@theia/core/lib/common/path.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const window_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const browser_3 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const plugin_dev_protocol_1 = __webpack_require__(/*! ../common/plugin-dev-protocol */ "../../node_modules/@theia/plugin-dev/lib/common/plugin-dev-protocol.js");
const debug_session_manager_1 = __webpack_require__(/*! @theia/debug/lib/browser/debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const hosted_plugin_preferences_1 = __webpack_require__(/*! ./hosted-plugin-preferences */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-preferences.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
/**
 * Commands to control Hosted plugin instances.
 */
var HostedPluginCommands;
(function (HostedPluginCommands) {
    const HOSTED_PLUGIN_CATEGORY_KEY = 'theia/plugin-dev/hostedPlugin';
    const HOSTED_PLUGIN_CATEGORY = 'Hosted Plugin';
    HostedPluginCommands.START = common_1.Command.toLocalizedCommand({
        id: 'hosted-plugin:start',
        category: HOSTED_PLUGIN_CATEGORY,
        label: 'Start Instance'
    }, 'theia/plugin-dev/startInstance', HOSTED_PLUGIN_CATEGORY_KEY);
    HostedPluginCommands.DEBUG = common_1.Command.toLocalizedCommand({
        id: 'hosted-plugin:debug',
        category: HOSTED_PLUGIN_CATEGORY,
        label: 'Debug Instance'
    }, 'theia/plugin-dev/debugInstance', HOSTED_PLUGIN_CATEGORY_KEY);
    HostedPluginCommands.STOP = common_1.Command.toLocalizedCommand({
        id: 'hosted-plugin:stop',
        category: HOSTED_PLUGIN_CATEGORY,
        label: 'Stop Instance'
    }, 'theia/plugin-dev/stopInstance', HOSTED_PLUGIN_CATEGORY_KEY);
    HostedPluginCommands.RESTART = common_1.Command.toLocalizedCommand({
        id: 'hosted-plugin:restart',
        category: HOSTED_PLUGIN_CATEGORY,
        label: 'Restart Instance'
    }, 'theia/plugin-dev/restartInstance', HOSTED_PLUGIN_CATEGORY_KEY);
    HostedPluginCommands.SELECT_PATH = common_1.Command.toLocalizedCommand({
        id: 'hosted-plugin:select-path',
        category: HOSTED_PLUGIN_CATEGORY,
        label: 'Select Path'
    }, 'theia/plugin-dev/selectPath', HOSTED_PLUGIN_CATEGORY_KEY);
})(HostedPluginCommands || (exports.HostedPluginCommands = HostedPluginCommands = {}));
/**
 * Available states of hosted plugin instance.
 */
var HostedInstanceState;
(function (HostedInstanceState) {
    HostedInstanceState["STOPPED"] = "stopped";
    HostedInstanceState["STARTING"] = "starting";
    HostedInstanceState["RUNNING"] = "running";
    HostedInstanceState["STOPPING"] = "stopping";
    HostedInstanceState["FAILED"] = "failed";
})(HostedInstanceState || (exports.HostedInstanceState = HostedInstanceState = {}));
/**
 * Responsible for UI to set up and control Hosted Plugin Instance.
 */
let HostedPluginManagerClient = class HostedPluginManagerClient {
    constructor() {
        this.isDebug = false;
        this.stateChanged = new common_1.Emitter();
    }
    get onStateChanged() {
        return this.stateChanged.event;
    }
    init() {
        this.doInit();
    }
    async doInit() {
        this.openNewTabAskDialog = new OpenHostedInstanceLinkDialog(this.windowService);
        // is needed for case when page is loaded when hosted instance is already running.
        if (await this.hostedPluginServer.isHostedPluginInstanceRunning()) {
            this.pluginLocation = new uri_1.default(await this.hostedPluginServer.getHostedPluginURI());
        }
    }
    get lastPluginLocation() {
        if (this.pluginLocation) {
            return this.pluginLocation.toString();
        }
        return undefined;
    }
    async start(debugConfig) {
        if (await this.hostedPluginServer.isHostedPluginInstanceRunning()) {
            this.messageService.warn(nls_1.nls.localize('theia/plugin-dev/alreadyRunning', 'Hosted instance is already running.'));
            return;
        }
        if (!this.pluginLocation) {
            await this.selectPluginPath();
            if (!this.pluginLocation) {
                // selection was cancelled
                return;
            }
        }
        try {
            this.stateChanged.fire({ state: HostedInstanceState.STARTING, pluginLocation: this.pluginLocation });
            this.messageService.info(nls_1.nls.localize('theia/plugin-dev/starting', 'Starting hosted instance server ...'));
            if (debugConfig) {
                this.isDebug = true;
                this.pluginInstanceURL = await this.hostedPluginServer.runDebugHostedPluginInstance(this.pluginLocation.toString(), debugConfig);
            }
            else {
                this.isDebug = false;
                this.pluginInstanceURL = await this.hostedPluginServer.runHostedPluginInstance(this.pluginLocation.toString());
            }
            await this.openPluginWindow();
            this.messageService.info(`${nls_1.nls.localize('theia/plugin-dev/running', 'Hosted instance is running at:')} ${this.pluginInstanceURL}`);
            this.stateChanged.fire({ state: HostedInstanceState.RUNNING, pluginLocation: this.pluginLocation });
        }
        catch (error) {
            this.messageService.error(nls_1.nls.localize('theia/plugin-dev/failed', 'Failed to run hosted plugin instance: {0}', this.getErrorMessage(error)));
            this.stateChanged.fire({ state: HostedInstanceState.FAILED, pluginLocation: this.pluginLocation });
            this.stop();
        }
    }
    async debug(config) {
        await this.start(this.setDebugConfig(config));
        await this.startDebugSessionManager();
        return this.pluginInstanceURL;
    }
    async startDebugSessionManager() {
        let outFiles = undefined;
        if (this.pluginLocation && this.hostedPluginPreferences['hosted-plugin.launchOutFiles'].length > 0) {
            const fsPath = await this.fileService.fsPath(this.pluginLocation);
            if (fsPath) {
                outFiles = this.hostedPluginPreferences['hosted-plugin.launchOutFiles'].map(outFile => outFile.replace('${pluginPath}', new path_1.Path(fsPath).toString()));
            }
        }
        const name = nls_1.nls.localize('theia/plugin-dev/hostedPlugin', 'Hosted Plugin');
        await this.debugSessionManager.start({
            name,
            configuration: {
                type: 'node',
                request: 'attach',
                timeout: 30000,
                name,
                smartStep: true,
                sourceMaps: !!outFiles,
                outFiles
            }
        });
    }
    async stop(checkRunning = true) {
        if (checkRunning && !await this.hostedPluginServer.isHostedPluginInstanceRunning()) {
            this.messageService.warn(nls_1.nls.localize('theia/plugin-dev/notRunning', 'Hosted instance is not running.'));
            return;
        }
        try {
            this.stateChanged.fire({ state: HostedInstanceState.STOPPING, pluginLocation: this.pluginLocation });
            await this.hostedPluginServer.terminateHostedPluginInstance();
            this.messageService.info((this.pluginInstanceURL
                ? nls_1.nls.localize('theia/plugin-dev/instanceTerminated', '{0} has been terminated', this.pluginInstanceURL)
                : nls_1.nls.localize('theia/plugin-dev/unknownTerminated', 'The instance has been terminated')));
            this.stateChanged.fire({ state: HostedInstanceState.STOPPED, pluginLocation: this.pluginLocation });
        }
        catch (error) {
            this.messageService.error(this.getErrorMessage(error));
        }
    }
    async restart() {
        if (await this.hostedPluginServer.isHostedPluginInstanceRunning()) {
            await this.stop(false);
            this.messageService.info(nls_1.nls.localize('theia/plugin-dev/starting', 'Starting hosted instance server ...'));
            // It takes some time before OS released all resources e.g. port.
            // Keep trying to run hosted instance with delay.
            this.stateChanged.fire({ state: HostedInstanceState.STARTING, pluginLocation: this.pluginLocation });
            let lastError;
            for (let tries = 0; tries < 15; tries++) {
                try {
                    if (this.isDebug) {
                        this.pluginInstanceURL = await this.hostedPluginServer.runDebugHostedPluginInstance(this.pluginLocation.toString(), {
                            debugMode: this.hostedPluginPreferences['hosted-plugin.debugMode'],
                            debugPort: [...this.hostedPluginPreferences['hosted-plugin.debugPorts']]
                        });
                        await this.startDebugSessionManager();
                    }
                    else {
                        this.pluginInstanceURL = await this.hostedPluginServer.runHostedPluginInstance(this.pluginLocation.toString());
                    }
                    await this.openPluginWindow();
                    this.messageService.info(`${nls_1.nls.localize('theia/plugin-dev/running', 'Hosted instance is running at:')} ${this.pluginInstanceURL}`);
                    this.stateChanged.fire({
                        state: HostedInstanceState.RUNNING,
                        pluginLocation: this.pluginLocation
                    });
                    return;
                }
                catch (error) {
                    lastError = error;
                    await new Promise(resolve => setTimeout(resolve, 500));
                }
            }
            this.messageService.error(nls_1.nls.localize('theia/plugin-dev/failed', 'Failed to run hosted plugin instance: {0}', this.getErrorMessage(lastError)));
            this.stateChanged.fire({ state: HostedInstanceState.FAILED, pluginLocation: this.pluginLocation });
            this.stop();
        }
        else {
            this.messageService.warn(nls_1.nls.localize('theia/plugin-dev/notRunning', 'Hosted instance is not running.'));
            this.start();
        }
    }
    /**
     * Creates directory choose dialog and set selected folder into pluginLocation field.
     */
    async selectPluginPath() {
        const workspaceFolder = (await this.workspaceService.roots)[0] || await this.fileService.resolve(new uri_1.default(await this.environments.getHomeDirUri()));
        if (!workspaceFolder) {
            throw new Error('Unable to find the root');
        }
        const result = await this.fileDialogService.showOpenDialog({
            title: HostedPluginCommands.SELECT_PATH.label,
            openLabel: nls_1.nls.localize('theia/plugin-dev/select', 'Select'),
            canSelectFiles: false,
            canSelectFolders: true,
            canSelectMany: false
        }, workspaceFolder);
        if (result) {
            if (await this.hostedPluginServer.isPluginValid(result.toString())) {
                this.pluginLocation = result;
                this.messageService.info(nls_1.nls.localize('theia/plugin-dev/pluginFolder', 'Plugin folder is set to: {0}', this.labelProvider.getLongName(result)));
            }
            else {
                this.messageService.error(nls_1.nls.localize('theia/plugin-dev/noValidPlugin', 'Specified folder does not contain valid plugin.'));
            }
        }
    }
    register(configType, connection) {
        if (configType === 'pwa-extensionHost') {
            this.connection = connection;
            this.connection.onRequest('launchVSCode', (request) => this.launchVSCode(request));
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            this.connection.on('exited', async (args) => {
                await this.stop();
            });
        }
    }
    /**
     * Opens window with URL to the running plugin instance.
     */
    async openPluginWindow() {
        // do nothing for electron browser
        if (browser_1.isNative) {
            return;
        }
        if (this.pluginInstanceURL) {
            try {
                this.windowService.openNewWindow(this.pluginInstanceURL);
            }
            catch (err) {
                // browser blocked opening of a new tab
                this.openNewTabAskDialog.showOpenNewTabAskDialog(this.pluginInstanceURL);
            }
        }
    }
    async launchVSCode({ arguments: { args } }) {
        let result = {};
        let instanceURI;
        const sessions = this.debugSessionManager.sessions.filter(session => session.id !== this.connection.sessionId);
        /* if `launchVSCode` is invoked and sessions do not exist - it means that `start` debug was invoked.
           if `launchVSCode` is invoked and sessions do exist - it means that `restartSessions()` was invoked,
           which invoked `this.sendRequest('restart', {})`, which restarted `vscode-builtin-js-debug` plugin which is
           connected to first session (sessions[0]), which means that other existing (child) sessions need to be terminated
           and new ones will be created by running `startDebugSessionManager()`
         */
        if (sessions.length > 0) {
            sessions.forEach(session => this.debugSessionManager.terminateSession(session));
            await this.startDebugSessionManager();
            instanceURI = this.pluginInstanceURL;
        }
        else {
            instanceURI = await this.debug(this.getDebugPluginConfig(args));
        }
        if (instanceURI) {
            const instanceURL = new URL(instanceURI);
            if (instanceURL.port) {
                result = Object.assign(result, { rendererDebugPort: instanceURL.port });
            }
        }
        return result;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    getErrorMessage(error) {
        var _a;
        return ((_a = error === null || error === void 0 ? void 0 : error.message) === null || _a === void 0 ? void 0 : _a.substring(error.message.indexOf(':') + 1)) || '';
    }
    setDebugConfig(config) {
        config = Object.assign(config || {}, { debugMode: this.hostedPluginPreferences['hosted-plugin.debugMode'] });
        if (config.pluginLocation) {
            this.pluginLocation = new uri_1.default((!config.pluginLocation.startsWith('/') ? '/' : '') + config.pluginLocation.replace(/\\/g, '/')).withScheme('file');
        }
        if (config.debugPort === undefined) {
            config.debugPort = [...this.hostedPluginPreferences['hosted-plugin.debugPorts']];
        }
        return config;
    }
    getDebugPluginConfig(args) {
        let pluginLocation;
        for (const arg of args) {
            if ((arg === null || arg === void 0 ? void 0 : arg.prefix) === '--extensionDevelopmentPath=') {
                pluginLocation = arg.path;
            }
        }
        return {
            pluginLocation
        };
    }
};
exports.HostedPluginManagerClient = HostedPluginManagerClient;
tslib_1.__decorate([
    (0, inversify_1.inject)(plugin_dev_protocol_1.PluginDevServer),
    tslib_1.__metadata("design:type", Object)
], HostedPluginManagerClient.prototype, "hostedPluginServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MessageService),
    tslib_1.__metadata("design:type", common_1.MessageService)
], HostedPluginManagerClient.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], HostedPluginManagerClient.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    tslib_1.__metadata("design:type", Object)
], HostedPluginManagerClient.prototype, "windowService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], HostedPluginManagerClient.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], HostedPluginManagerClient.prototype, "environments", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], HostedPluginManagerClient.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], HostedPluginManagerClient.prototype, "debugSessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(hosted_plugin_preferences_1.HostedPluginPreferences),
    tslib_1.__metadata("design:type", Object)
], HostedPluginManagerClient.prototype, "hostedPluginPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.FileDialogService),
    tslib_1.__metadata("design:type", Object)
], HostedPluginManagerClient.prototype, "fileDialogService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], HostedPluginManagerClient.prototype, "init", null);
exports.HostedPluginManagerClient = HostedPluginManagerClient = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HostedPluginManagerClient);
class OpenHostedInstanceLinkDialog extends browser_1.AbstractDialog {
    constructor(windowService) {
        super({
            title: nls_1.nls.localize('theia/plugin-dev/preventedNewTab', 'Your browser prevented opening of a new tab')
        });
        this.windowService = windowService;
        this.linkNode = document.createElement('a');
        this.linkNode.target = '_blank';
        this.linkNode.setAttribute('style', 'color: var(--theia-editorWidget-foreground);');
        this.contentNode.appendChild(this.linkNode);
        const messageNode = document.createElement('div');
        messageNode.innerText = nls_1.nls.localize('theia/plugin-dev/running', 'Hosted instance is running at:') + ' ';
        messageNode.appendChild(this.linkNode);
        this.contentNode.appendChild(messageNode);
        this.appendCloseButton();
        this.openButton = this.appendAcceptButton(nls_1.nls.localizeByDefault('Open'));
    }
    showOpenNewTabAskDialog(uri) {
        this.value = uri;
        this.linkNode.textContent = uri;
        this.linkNode.href = uri;
        this.openButton.onclick = () => {
            this.windowService.openNewWindow(uri);
        };
        this.open();
    }
}


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-preferences.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-preferences.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindHostedPluginPreferences = exports.createNavigatorPreferences = exports.HostedPluginPreferences = exports.HostedPluginPreferenceContribution = exports.HostedPluginConfigSchema = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.HostedPluginConfigSchema = {
    'type': 'object',
    properties: {
        'hosted-plugin.watchMode': {
            type: 'boolean',
            description: nls_1.nls.localize('theia/plugin-dev/watchMode', 'Run watcher on plugin under development'),
            default: true
        },
        'hosted-plugin.debugMode': {
            type: 'string',
            description: nls_1.nls.localize('theia/plugin-dev/debugMode', 'Using inspect or inspect-brk for Node.js debug'),
            default: 'inspect',
            enum: ['inspect', 'inspect-brk']
        },
        'hosted-plugin.launchOutFiles': {
            type: 'array',
            items: {
                type: 'string'
            },
            markdownDescription: nls_1.nls.localize('theia/plugin-dev/launchOutFiles', 'Array of glob patterns for locating generated JavaScript files (`${pluginPath}` will be replaced by plugin actual path).'),
            default: ['${pluginPath}/out/**/*.js']
        },
        'hosted-plugin.debugPorts': {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    'serverName': {
                        type: 'string',
                        description: nls_1.nls.localize('theia/plugin-dev/debugPorts/serverName', 'The plugin host server name, e.g. "hosted-plugin" as in "--hosted-plugin-inspect=" ' +
                            'or "headless-hosted-plugin" as in "--headless-hosted-plugin-inspect="'),
                    },
                    'debugPort': {
                        type: 'number',
                        minimum: 0,
                        maximum: 65535,
                        description: nls_1.nls.localize('theia/plugin-dev/debugPorts/debugPort', 'Port to use for this server\'s Node.js debug'),
                    }
                },
            },
            default: undefined,
            description: nls_1.nls.localize('theia/plugin-dev/debugPorts', 'Port configuration per server for Node.js debug'),
        }
    }
};
exports.HostedPluginPreferenceContribution = Symbol('HostedPluginPreferenceContribution');
exports.HostedPluginPreferences = Symbol('HostedPluginPreferences');
function createNavigatorPreferences(preferences, schema = exports.HostedPluginConfigSchema) {
    return (0, browser_1.createPreferenceProxy)(preferences, schema);
}
exports.createNavigatorPreferences = createNavigatorPreferences;
function bindHostedPluginPreferences(bind) {
    bind(exports.HostedPluginPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(browser_1.PreferenceService);
        const contribution = ctx.container.get(exports.HostedPluginPreferenceContribution);
        return createNavigatorPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.HostedPluginPreferenceContribution).toConstantValue({ schema: exports.HostedPluginConfigSchema });
    bind(browser_1.PreferenceContribution).toService(exports.HostedPluginPreferenceContribution);
}
exports.bindHostedPluginPreferences = bindHostedPluginPreferences;


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/browser/plugin-dev-frontend-module.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/browser/plugin-dev-frontend-module.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const hosted_plugin_log_viewer_1 = __webpack_require__(/*! ./hosted-plugin-log-viewer */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-log-viewer.js");
const hosted_plugin_manager_client_1 = __webpack_require__(/*! ./hosted-plugin-manager-client */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-manager-client.js");
const hosted_plugin_informer_1 = __webpack_require__(/*! ./hosted-plugin-informer */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-informer.js");
const hosted_plugin_preferences_1 = __webpack_require__(/*! ./hosted-plugin-preferences */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-preferences.js");
const hosted_plugin_controller_1 = __webpack_require__(/*! ./hosted-plugin-controller */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-controller.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const hosted_plugin_frontend_contribution_1 = __webpack_require__(/*! ./hosted-plugin-frontend-contribution */ "../../node_modules/@theia/plugin-dev/lib/browser/hosted-plugin-frontend-contribution.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "../../node_modules/@theia/core/lib/common/command.js");
const plugin_dev_protocol_1 = __webpack_require__(/*! ../common/plugin-dev-protocol */ "../../node_modules/@theia/plugin-dev/lib/common/plugin-dev-protocol.js");
const debug_contribution_1 = __webpack_require__(/*! @theia/debug/lib/browser/debug-contribution */ "../../node_modules/@theia/debug/lib/browser/debug-contribution.js");
exports["default"] = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    (0, hosted_plugin_preferences_1.bindHostedPluginPreferences)(bind);
    bind(hosted_plugin_log_viewer_1.HostedPluginLogViewer).toSelf().inSingletonScope();
    bind(hosted_plugin_manager_client_1.HostedPluginManagerClient).toSelf().inSingletonScope();
    bind(debug_contribution_1.DebugContribution).toService(hosted_plugin_manager_client_1.HostedPluginManagerClient);
    bind(browser_1.FrontendApplicationContribution).to(hosted_plugin_informer_1.HostedPluginInformer).inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).to(hosted_plugin_controller_1.HostedPluginController).inSingletonScope();
    bind(hosted_plugin_frontend_contribution_1.HostedPluginFrontendContribution).toSelf().inSingletonScope();
    bind(command_1.CommandContribution).toService(hosted_plugin_frontend_contribution_1.HostedPluginFrontendContribution);
    bind(plugin_dev_protocol_1.PluginDevServer).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.WebSocketConnectionProvider);
        return connection.createProxy(plugin_dev_protocol_1.pluginDevServicePath);
    }).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/plugin-dev/lib/common/plugin-dev-protocol.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-dev/lib/common/plugin-dev-protocol.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PluginDevServer = exports.pluginDevServicePath = void 0;
exports.pluginDevServicePath = '/services/plugin-dev';
exports.PluginDevServer = Symbol('PluginDevServer');


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext/lib/hosted/browser/hosted-plugin-watcher.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext/lib/hosted/browser/hosted-plugin-watcher.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HostedPluginWatcher = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
let HostedPluginWatcher = class HostedPluginWatcher {
    constructor() {
        this.onPostMessage = new event_1.Emitter();
        this.onLogMessage = new event_1.Emitter();
        this.onDidDeployEmitter = new event_1.Emitter();
        this.onDidDeploy = this.onDidDeployEmitter.event;
    }
    getHostedPluginClient() {
        const messageEmitter = this.onPostMessage;
        const logEmitter = this.onLogMessage;
        return {
            postMessage(pluginHostId, message) {
                messageEmitter.fire({ pluginHostId, message });
                return Promise.resolve();
            },
            log(logPart) {
                logEmitter.fire(logPart);
                return Promise.resolve();
            },
            onDidDeploy: () => this.onDidDeployEmitter.fire(undefined)
        };
    }
    get onPostMessageEvent() {
        return this.onPostMessage.event;
    }
    get onLogMessageEvent() {
        return this.onLogMessage.event;
    }
};
exports.HostedPluginWatcher = HostedPluginWatcher;
exports.HostedPluginWatcher = HostedPluginWatcher = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], HostedPluginWatcher);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_plugin-dev_lib_browser_plugin-dev-frontend-module_js.js.map