/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.handler.ClasspathUpdateHandler;
import com.microsoft.java.test.plugin.model.Option;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class JUnitPlugin
implements BundleActivator {
    private static final String JAVA_TEST_ASK_CLIENT_FOR_INPUT = "_java.test.askClientForInput";
    private static final String JAVA_TEST_ASK_CLIENT_FOR_CHOICE = "_java.test.askClientForChoice";
    private static final String JAVA_TEST_ADVANCED_ASK_CLIENT_FOR_CHOICE = "_java.test.advancedAskClientForChoice";
    public static final String PLUGIN_ID = "java.test.runner";
    private static ClasspathUpdateHandler handler = new ClasspathUpdateHandler();
    private static BundleContext context;

    public void start(BundleContext context) throws Exception {
        handler.addElementChangeListener();
        JUnitPlugin.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        handler.removeElementChangeListener();
        JUnitPlugin.context = null;
    }

    public static void log(IStatus status) {
        if (context != null) {
            Platform.getLog((Bundle)context.getBundle()).log(status);
        }
    }

    public static void log(CoreException e) {
        JUnitPlugin.log(e.getStatus());
    }

    public static void logError(String message) {
        if (context != null) {
            JUnitPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logInfo(String message) {
        if (context != null) {
            JUnitPlugin.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logException(String message, Throwable ex) {
        if (context != null) {
            JUnitPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message, ex));
        }
    }

    public static Object askClientForChoice(String placeHolder, List<Option> choices) {
        return JUnitPlugin.askClientForChoice(placeHolder, choices, false);
    }

    public static Object askClientForChoice(String placeHolder, List<Option> choices, boolean canPickMany) {
        return JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(JAVA_TEST_ASK_CLIENT_FOR_CHOICE, new Object[]{placeHolder, choices, canPickMany});
    }

    public static Object advancedAskClientForChoice(String placeHolder, List<Option> choices, String advancedAction, boolean canPickMany) {
        return JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(JAVA_TEST_ADVANCED_ASK_CLIENT_FOR_CHOICE, new Object[]{placeHolder, choices, advancedAction, canPickMany});
    }

    public static Object askClientForInput(String prompt, String defaultValue) {
        return JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(JAVA_TEST_ASK_CLIENT_FOR_INPUT, new Object[]{prompt, defaultValue});
    }
}

