/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.reporter;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TaskStartParams;
import ch.epfl.scala.bsp4j.TestReport;
import ch.epfl.scala.bsp4j.TestStatus;
import ch.epfl.scala.bsp4j.extended.TestFinishEx;
import ch.epfl.scala.bsp4j.extended.TestName;
import ch.epfl.scala.bsp4j.extended.TestStartEx;
import com.microsoft.java.bs.core.internal.reporter.ProgressReporter;
import java.util.ArrayList;
import org.gradle.tooling.TestFailure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFailureResult;
import org.gradle.tooling.events.test.TestSkippedResult;
import org.gradle.tooling.events.test.TestSuccessResult;

public class TestReportReporter
extends ProgressReporter {
    private final BuildTargetIdentifier btId;
    private int successCount;
    private int skippedCount;
    private int failureCount;
    private String exception;
    private long testDuration;

    public TestReportReporter(BuildTargetIdentifier btId, BuildClient client, String originId) {
        super(client, originId);
        this.btId = btId;
        this.successCount = 0;
        this.skippedCount = 0;
        this.failureCount = 0;
        this.exception = null;
        this.testDuration = 0L;
    }

    private TestName getTestName(JvmTestOperationDescriptor eventDescriptor) {
        ArrayList<JvmTestOperationDescriptor> fullStack = new ArrayList<JvmTestOperationDescriptor>();
        fullStack.add(eventDescriptor);
        for (OperationDescriptor descriptor = eventDescriptor.getParent(); descriptor != null; descriptor = descriptor.getParent()) {
            if (!(descriptor instanceof JvmTestOperationDescriptor)) continue;
            JvmTestOperationDescriptor jvmTestOperationDescriptor = (JvmTestOperationDescriptor)descriptor;
            fullStack.add(jvmTestOperationDescriptor);
        }
        int i = fullStack.size() - 1;
        boolean classNameFound = false;
        while (i >= 0 && !classNameFound) {
            if (((JvmTestOperationDescriptor)fullStack.get(i)).getClassName() != null) {
                classNameFound = true;
                continue;
            }
            --i;
        }
        TestName testName = null;
        while (i >= 0) {
            String displayName;
            JvmTestOperationDescriptor desc = (JvmTestOperationDescriptor)fullStack.get(i);
            try {
                displayName = desc.getTestDisplayName();
            }
            catch (AbstractMethodError | NoSuchMethodError e) {
                displayName = desc.getDisplayName();
            }
            TestName currentTestName = new TestName(displayName, desc.getSuiteName(), desc.getClassName(), desc.getMethodName());
            currentTestName.setParent(testName);
            testName = currentTestName;
            --i;
        }
        return testName;
    }

    public void statusChanged(ProgressEvent event) {
        JvmTestOperationDescriptor descriptor;
        TestName testName;
        OperationDescriptor operationDescriptor;
        if (this.client != null && (operationDescriptor = event.getDescriptor()) instanceof JvmTestOperationDescriptor && (testName = this.getTestName(descriptor = (JvmTestOperationDescriptor)operationDescriptor)) != null) {
            String taskPath = this.getTaskPath(event.getDescriptor());
            TaskId taskId = this.getTaskId(taskPath);
            if (event instanceof StartEvent) {
                TaskStartParams startParam = new TaskStartParams(taskId);
                startParam.setMessage("Start test");
                startParam.setDataKind("test-start");
                startParam.setEventTime(Long.valueOf(event.getEventTime()));
                TestStartEx testStart = new TestStartEx(event.getDisplayName(), testName);
                startParam.setData((Object)testStart);
                this.client.onBuildTaskStart(startParam);
            } else if (event instanceof FinishEvent) {
                FinishEvent finishEvent = (FinishEvent)event;
                OperationResult result = finishEvent.getResult();
                this.testDuration += result.getEndTime() - result.getStartTime();
                StatusCode statusCode = StatusCode.OK;
                TestStatus testStatus = TestStatus.PASSED;
                String stackTrace = null;
                if (result instanceof TestFailureResult) {
                    TestFailureResult testFailureResult = (TestFailureResult)result;
                    statusCode = StatusCode.ERROR;
                    testStatus = TestStatus.FAILED;
                    stackTrace = testFailureResult.getFailures().stream().filter(f -> f instanceof TestFailure).map(f -> (TestFailure)f).map(TestFailure::getStacktrace).findFirst().orElse(null);
                    if (descriptor.getJvmTestKind() == JvmTestKind.ATOMIC) {
                        ++this.failureCount;
                    }
                } else if (result instanceof TestSkippedResult) {
                    testStatus = TestStatus.SKIPPED;
                    if (descriptor.getJvmTestKind() == JvmTestKind.ATOMIC) {
                        ++this.skippedCount;
                    }
                } else if (result instanceof TestSuccessResult && descriptor.getJvmTestKind() == JvmTestKind.ATOMIC) {
                    ++this.successCount;
                }
                TaskFinishParams finishParam = new TaskFinishParams(taskId, statusCode);
                finishParam.setMessage("Finish test");
                finishParam.setDataKind("test-finish");
                finishParam.setEventTime(Long.valueOf(event.getEventTime()));
                TestFinishEx testFinish = new TestFinishEx(event.getDisplayName(), testStatus, testName);
                testFinish.setStackTrace(stackTrace);
                finishParam.setData((Object)testFinish);
                this.client.onBuildTaskFinish(finishParam);
            }
        }
    }

    public void addException(String exception) {
        this.exception = exception;
    }

    public void sendResult() {
        if (this.client != null) {
            TestReport testReport = new TestReport(this.btId, Integer.valueOf(this.successCount), Integer.valueOf(this.failureCount), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(this.skippedCount));
            testReport.setOriginId(this.originId);
            testReport.setTime(Long.valueOf(this.testDuration));
            StatusCode statusCode = StatusCode.OK;
            if (this.failureCount > 0 || this.exception != null) {
                statusCode = StatusCode.ERROR;
            }
            TaskFinishParams finishParam = new TaskFinishParams(this.taskId, statusCode);
            if (this.exception != null) {
                finishParam.setMessage("Exception in tests " + this.exception);
            } else {
                finishParam.setMessage("Finish test");
            }
            finishParam.setEventTime(Long.valueOf(System.currentTimeMillis()));
            finishParam.setDataKind("test-report");
            finishParam.setData((Object)testReport);
            this.client.onBuildTaskFinish(finishParam);
        }
    }
}

