/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.DOMCodeSelector;
import org.eclipse.jdt.internal.codeassist.DOMCompletionContext;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineBuilder;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineJavadocUtil;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineMethodDeclHandler;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineRecoveredNodeScanner;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineVariableDeclHandler;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtil;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.codeassist.impl.Keywords;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ModuleSourcePathManager;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.util.Messages;

public class DOMCompletionEngine
implements Runnable {
    private static final String FAKE_IDENTIFIER = new String(RecoveryScanner.FAKE_IDENTIFIER);
    private static final char[] VOID = PrimitiveType.VOID.toString().toCharArray();
    private static final List<char[]> TYPE_KEYWORDS_EXCEPT_VOID = List.of(PrimitiveType.BOOLEAN.toString().toCharArray(), PrimitiveType.BYTE.toString().toCharArray(), PrimitiveType.SHORT.toString().toCharArray(), PrimitiveType.INT.toString().toCharArray(), PrimitiveType.LONG.toString().toCharArray(), PrimitiveType.DOUBLE.toString().toCharArray(), PrimitiveType.FLOAT.toString().toCharArray(), PrimitiveType.CHAR.toString().toCharArray());
    private final int offset;
    private final CompilationUnit unit;
    private final CompletionRequestor requestor;
    private final ICompilationUnit modelUnit;
    private final SearchableEnvironment nameEnvironment;
    private final AssistOptions assistOptions;
    private final SearchPattern pattern;
    private final CompletionEngine nestedEngine;
    private ExpectedTypes expectedTypes;
    private String prefix;
    private String qualifiedPrefix;
    private ASTNode toComplete;
    private IBuffer cuBuffer;
    private final DOMCompletionEngineVariableDeclHandler variableDeclHandler;
    private final DOMCompletionEngineRecoveredNodeScanner recoveredNodeScanner;
    private final IProgressMonitor monitor;
    private static final char[] LAMBDA = new char[]{'-', '>'};

    public DOMCompletionEngine(int offset, CompilationUnit domUnit, ICompilationUnit modelUnit, WorkingCopyOwner workingCopyOwner, CompletionRequestor requestor, IProgressMonitor monitor) {
        this.offset = offset;
        this.unit = domUnit;
        this.modelUnit = modelUnit;
        this.requestor = requestor;
        SearchableEnvironment env = null;
        IJavaProject iJavaProject = this.modelUnit.getJavaProject();
        if (iJavaProject instanceof JavaProject) {
            JavaProject p = (JavaProject)iJavaProject;
            if (requestor != null) {
                try {
                    env = p.newSearchableNameEnvironment(workingCopyOwner, requestor.isTestCodeExcluded());
                }
                catch (JavaModelException e) {
                    ILog.get().error(e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
        this.nameEnvironment = env;
        this.assistOptions = new AssistOptions(this.modelUnit.getOptions(true));
        this.pattern = new SearchPattern(1 | (this.assistOptions.camelCaseMatch ? 128 : 0) | (this.assistOptions.substringMatch ? 512 : 0) | (this.assistOptions.subwordMatch ? 1024 : 0)){

            @Override
            public SearchPattern getBlankPattern() {
                return null;
            }
        };
        this.nestedEngine = new CompletionEngine(this.nameEnvironment, this.requestor, this.modelUnit.getOptions(true), this.modelUnit.getJavaProject(), workingCopyOwner, monitor);
        this.variableDeclHandler = new DOMCompletionEngineVariableDeclHandler();
        this.recoveredNodeScanner = new DOMCompletionEngineRecoveredNodeScanner(modelUnit, offset);
        this.monitor = monitor;
        try {
            this.cuBuffer = this.modelUnit.getBuffer();
        }
        catch (JavaModelException e) {
            ILog.get().error("unable to access buffer for completion", (Throwable)((Object)e));
        }
    }

    private Collection<? extends IBinding> visibleBindings(ASTNode node) {
        ASTNode aSTNode;
        Statement ifStatement;
        ArrayList<IBinding> visibleBindings = new ArrayList<IBinding>();
        if (node instanceof MethodDeclaration) {
            MethodDeclaration m = (MethodDeclaration)node;
            visibleBindings.addAll(m.parameters().stream().filter(decl -> !FAKE_IDENTIFIER.equals(decl.getName().toString())).map(VariableDeclaration::resolveBinding).toList());
        }
        if (node instanceof LambdaExpression) {
            LambdaExpression le = (LambdaExpression)node;
            visibleBindings.addAll(le.parameters().stream().filter(decl -> !FAKE_IDENTIFIER.equals(decl.getName().toString())).map(VariableDeclaration::resolveBinding).toList());
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)node;
            visibleBindings.add(typeDecl.resolveBinding());
        }
        if (node instanceof Block) {
            Block block = (Block)node;
            if (node.getStartPosition() + node.getLength() > this.offset) {
                List<IVariableBinding> bindings = block.statements().stream().filter(statement -> statement.getStartPosition() < this.offset).filter(VariableDeclarationStatement.class::isInstance).map(VariableDeclarationStatement.class::cast).flatMap(decl -> decl.fragments().stream()).filter(frag -> !FAKE_IDENTIFIER.equals(frag.getName().toString())).map(VariableDeclaration::resolveBinding).toList();
                visibleBindings.addAll(bindings);
                for (Statement statement2 : block.statements()) {
                    if (statement2.getStartPosition() >= this.offset || statement2.getStartPosition() + statement2.getLength() >= this.offset) break;
                    if (!(statement2 instanceof IfStatement) || ((IfStatement)(ifStatement = (IfStatement)statement2)).getElseStatement() != null) continue;
                    visibleBindings.addAll(this.collectTrueFalseBindings(((IfStatement)ifStatement).getExpression()).falseBindings());
                }
            }
        }
        if ((aSTNode = node.getParent()) instanceof IfStatement) {
            IfStatement ifStatement2 = (IfStatement)aSTNode;
            if (node.getStartPosition() + node.getLength() > this.offset) {
                TrueFalseBindings leftRightBindings = this.collectTrueFalseBindings(ifStatement2.getExpression());
                if (ifStatement2.getThenStatement() == node) {
                    visibleBindings.addAll(leftRightBindings.trueBindings());
                } else {
                    visibleBindings.addAll(leftRightBindings.falseBindings());
                }
            }
        }
        if (node instanceof SwitchStatement) {
            SwitchStatement switchStatement = (SwitchStatement)node;
            int i = 0;
            while (i < switchStatement.statements().size()) {
                if (((Statement)switchStatement.statements().get(i)).getStartPosition() >= this.offset) break;
                ifStatement = (Statement)switchStatement.statements().get(i);
                if (ifStatement instanceof SwitchCase) {
                    SwitchCase switchCase = (SwitchCase)ifStatement;
                    DOMCompletionUtil.visitChildren(switchCase, 106, e -> visibleBindings.add(e.getPatternVariable().resolveBinding()));
                }
                ++i;
            }
        }
        if (node instanceof SwitchExpression) {
            SwitchExpression switchExpression = (SwitchExpression)node;
            int i = 0;
            while (i < switchExpression.statements().size()) {
                if (((Statement)switchExpression.statements().get(i)).getStartPosition() >= this.offset) break;
                Statement statement3 = (Statement)switchExpression.statements().get(i);
                if (statement3 instanceof SwitchCase) {
                    SwitchCase switchCase = (SwitchCase)statement3;
                    DOMCompletionUtil.visitChildren(switchCase, 106, e -> visibleBindings.add(e.getPatternVariable().resolveBinding()));
                }
                ++i;
            }
        }
        return visibleBindings;
    }

    private TrueFalseBindings collectTrueFalseBindings(Expression e) {
        InfixExpression infixExpression;
        InfixExpression infixExpression2;
        PrefixExpression prefixExpression;
        if (e instanceof PrefixExpression && (prefixExpression = (PrefixExpression)e).getOperator() == PrefixExpression.Operator.NOT) {
            TrueFalseBindings notBindings = this.collectTrueFalseBindings(prefixExpression.getOperand());
            return new TrueFalseBindings(notBindings.falseBindings(), notBindings.trueBindings());
        }
        if (e instanceof InfixExpression && (infixExpression2 = (InfixExpression)e).getOperator() == InfixExpression.Operator.AND) {
            TrueFalseBindings left = this.collectTrueFalseBindings(infixExpression2.getLeftOperand());
            TrueFalseBindings right = this.collectTrueFalseBindings(infixExpression2.getRightOperand());
            ArrayList<IVariableBinding> combined = new ArrayList<IVariableBinding>();
            combined.addAll(left.trueBindings());
            combined.addAll(right.trueBindings());
            return new TrueFalseBindings(combined, Collections.emptyList());
        }
        if (e instanceof InfixExpression && (infixExpression = (InfixExpression)e).getOperator() == InfixExpression.Operator.OR) {
            TrueFalseBindings left = this.collectTrueFalseBindings(infixExpression.getLeftOperand());
            TrueFalseBindings right = this.collectTrueFalseBindings(infixExpression.getRightOperand());
            ArrayList<IVariableBinding> combined = new ArrayList<IVariableBinding>();
            combined.addAll(left.falseBindings());
            combined.addAll(right.falseBindings());
            return new TrueFalseBindings(Collections.emptyList(), combined);
        }
        ArrayList<IVariableBinding> typePatternBindings = new ArrayList<IVariableBinding>();
        DOMCompletionUtil.visitChildren(e, 106, patt -> typePatternBindings.add(patt.getPatternVariable().resolveBinding()));
        return new TrueFalseBindings(typePatternBindings, Collections.emptyList());
    }

    private Collection<? extends ITypeBinding> visibleTypeBindings(ASTNode node) {
        ArrayList<? extends ITypeBinding> visibleBindings = new ArrayList<ITypeBinding>();
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
            visibleBindings.add(typeDeclaration.resolveBinding());
            for (ASTNode bodyDeclaration : typeDeclaration.bodyDeclarations()) {
                visibleBindings.addAll(this.visibleTypeBindings(bodyDeclaration));
            }
        }
        if (node instanceof Block) {
            Block block = (Block)node;
            List<ITypeBinding> bindings = block.statements().stream().filter(statement -> statement.getStartPosition() < this.offset).filter(TypeDeclaration.class::isInstance).map(TypeDeclaration.class::cast).map(AbstractTypeDeclaration::resolveBinding).toList();
            visibleBindings.addAll(bindings);
        }
        return visibleBindings;
    }

    @Override
    public void run() {
        if (this.monitor != null) {
            this.monitor.beginTask(Messages.engine_completing, -1);
        }
        this.requestor.beginReporting();
        try {
            SimpleName simple;
            ITypeBinding qualifierBinding;
            QualifiedType qType;
            Type qualifier;
            ASTNode aSTNode;
            Object localTypeBindings;
            boolean suggestDefaultCompletions;
            ASTNode context;
            String completeAfter;
            DOMCompletionContext completionContext;
            Bindings defaultCompletionBindings;
            block212: {
                block214: {
                    TagElement tagElement;
                    ASTNode importDeclaration;
                    block213: {
                        ITypeBinding typeBinding;
                        IBinding typeDeclBinding;
                        VariableDeclaration declaration;
                        Object potentialLambda;
                        ASTNode aSTNode2;
                        Object object;
                        ASTNode aSTNode3;
                        defaultCompletionBindings = new Bindings();
                        Bindings specificCompletionBindings = new Bindings();
                        completionContext = new DOMCompletionContext(this.unit, this.modelUnit, this.cuBuffer, this.offset, this.assistOptions, defaultCompletionBindings);
                        this.nestedEngine.completionToken = completionContext.getToken();
                        this.requestor.acceptContext(completionContext);
                        this.expectedTypes = completionContext.expectedTypes;
                        char[] token = completionContext.getToken();
                        completeAfter = token == null ? new String() : new String(token);
                        context = completionContext.node;
                        this.toComplete = completionContext.node;
                        completionContext.setInJavadoc(DOMCompletionUtil.findParent(this.toComplete, new int[]{29}) != null);
                        ASTNode potentialTagElement = DOMCompletionUtil.findParent(this.toComplete, new int[]{65, 67, 68});
                        if (potentialTagElement != null) {
                            context = potentialTagElement;
                        } else if (completionContext.node instanceof SimpleName) {
                            SimpleName simpleName = (SimpleName)completionContext.node;
                            if ((simpleName.getParent() instanceof FieldAccess || simpleName.getParent() instanceof MethodInvocation || simpleName.getParent() instanceof VariableDeclaration || simpleName.getParent() instanceof QualifiedName || simpleName.getParent() instanceof SuperFieldAccess || simpleName.getParent() instanceof SingleMemberAnnotation || simpleName.getParent() instanceof ExpressionMethodReference || simpleName.getParent() instanceof TagElement) && !this.toComplete.getLocationInParent().getId().equals(QualifiedName.QUALIFIER_PROPERTY.getId())) {
                                context = this.toComplete.getParent();
                            }
                            if ((var10_9 = simpleName.getParent()) instanceof SimpleType && (simpleType = (SimpleType)var10_9).getParent() instanceof ClassInstanceCreation) {
                                context = simpleName.getParent().getParent();
                            }
                        } else {
                            var10_9 = this.toComplete;
                            if (var10_9 instanceof SimpleType) {
                                simpleType = (SimpleType)var10_9;
                                if (FAKE_IDENTIFIER.equals(simpleType.getName().toString())) {
                                    context = this.toComplete.getParent();
                                } else {
                                    var12_11 = simpleType.getName();
                                    if (var12_11 instanceof QualifiedName) {
                                        QualifiedName qualifiedName = (QualifiedName)var12_11;
                                        context = qualifiedName;
                                    }
                                }
                            } else {
                                Block block;
                                var12_11 = this.toComplete;
                                if (var12_11 instanceof Block && this.offset == (block = (Block)var12_11).getStartPosition()) {
                                    context = this.toComplete.getParent();
                                } else {
                                    StringLiteral stringLiteral;
                                    ASTNode aSTNode4 = this.toComplete;
                                    if (aSTNode4 instanceof StringLiteral && (this.offset <= (stringLiteral = (StringLiteral)aSTNode4).getStartPosition() || stringLiteral.getStartPosition() + stringLiteral.getLength() <= this.offset)) {
                                        context = stringLiteral.getParent();
                                    } else {
                                        ASTNode aSTNode5;
                                        ASTNode aSTNode6 = this.toComplete;
                                        if (aSTNode6 instanceof VariableDeclaration) {
                                            VariableDeclaration vd = (VariableDeclaration)aSTNode6;
                                            context = vd.getInitializer();
                                        } else if (this.toComplete instanceof QualifiedName && (aSTNode5 = this.toComplete.getParent()) instanceof TagElement) {
                                            TagElement tagElement2 = (TagElement)aSTNode5;
                                            context = tagElement2;
                                        }
                                    }
                                }
                            }
                        }
                        this.qualifiedPrefix = this.prefix = token == null ? new String() : new String(token);
                        ASTNode aSTNode7 = this.toComplete;
                        if (aSTNode7 instanceof QualifiedName) {
                            QualifiedName qualifiedName = (QualifiedName)aSTNode7;
                            this.qualifiedPrefix = qualifiedName.getQualifier().toString();
                        } else if (this.toComplete != null && (aSTNode3 = this.toComplete.getParent()) instanceof QualifiedName) {
                            QualifiedName qualifiedName = (QualifiedName)aSTNode3;
                            this.qualifiedPrefix = qualifiedName.getQualifier().toString();
                        } else {
                            SimpleType simpleType;
                            Name name2;
                            ASTNode aSTNode8 = this.toComplete;
                            if (aSTNode8 instanceof SimpleType && (name2 = (simpleType = (SimpleType)aSTNode8).getName()) instanceof QualifiedName) {
                                QualifiedName qualifiedName = (QualifiedName)name2;
                                this.qualifiedPrefix = qualifiedName.getQualifier().toString();
                            } else {
                                ASTNode aSTNode9 = this.toComplete;
                                if (aSTNode9 instanceof TextElement) {
                                    String packageName;
                                    TextElement textElement = (TextElement)aSTNode9;
                                    if (context instanceof TagElement && !(packageName = textElement.getText().trim()).isEmpty()) {
                                        if (packageName.charAt(packageName.length() - 1) == '.') {
                                            packageName = packageName.substring(0, packageName.length() - 1);
                                        }
                                        this.qualifiedPrefix = packageName;
                                    }
                                }
                            }
                        }
                        suggestDefaultCompletions = true;
                        this.checkCancelled();
                        if (context instanceof StringLiteral || context instanceof TextBlock || context instanceof Comment || context instanceof Javadoc || context instanceof NumberLiteral) {
                            return;
                        }
                        if (context instanceof FieldAccess) {
                            FieldAccess fieldAccess = (FieldAccess)context;
                            Expression fieldAccessExpr = fieldAccess.getExpression();
                            ITypeBinding fieldAccessType = fieldAccessExpr.resolveTypeBinding();
                            if (fieldAccessType != null) {
                                this.processMembers(fieldAccess, fieldAccessExpr.resolveTypeBinding(), specificCompletionBindings, false);
                                this.publishFromScope(specificCompletionBindings);
                            } else if (DOMCompletionUtil.findParent(fieldAccessExpr, new int[]{32}) == null) {
                                Object parentFieldAccess;
                                String packageName = "";
                                Expression expression = fieldAccess.getExpression();
                                if (expression instanceof FieldAccess && (object = ((FieldAccess)(parentFieldAccess = (FieldAccess)expression)).getName().resolveBinding()) instanceof IPackageBinding) {
                                    IPackageBinding packageBinding = (IPackageBinding)object;
                                    packageName = packageBinding.getName();
                                } else {
                                    SimpleName name3;
                                    IBinding iBinding;
                                    aSTNode2 = fieldAccess.getExpression();
                                    if (aSTNode2 instanceof SimpleName && (iBinding = (name3 = (SimpleName)aSTNode2).resolveBinding()) instanceof IPackageBinding) {
                                        IPackageBinding packageBinding = (IPackageBinding)iBinding;
                                        packageName = packageBinding.getName();
                                    }
                                }
                                this.suggestPackages(fieldAccess);
                                this.suggestTypesInPackage(packageName);
                            }
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof MethodInvocation) {
                            MethodInvocation invocation = (MethodInvocation)context;
                            if (this.offset <= invocation.getName().getStartPosition() + invocation.getName().getLength()) {
                                Expression expression = invocation.getExpression();
                                if (expression == null) {
                                    return;
                                }
                                ITypeBinding type2 = expression.resolveTypeBinding();
                                if (type2 != null) {
                                    this.processMembers(expression, type2, specificCompletionBindings, false);
                                    specificCompletionBindings.all().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).filter(IMethodBinding.class::isInstance).map(binding -> this.toProposal((IBinding)binding)).forEach(this.requestor::accept);
                                }
                                suggestDefaultCompletions = false;
                            } else if (invocation.getStartPosition() + invocation.getLength() <= this.offset && this.prefix.isEmpty()) {
                                methodBinding = invocation.resolveMethodBinding();
                                if (methodBinding != null) {
                                    ITypeBinding returnType = methodBinding.getReturnType();
                                    this.processMembers(invocation, returnType, specificCompletionBindings, false);
                                    specificCompletionBindings.all().map(binding -> this.toProposal((IBinding)binding)).forEach(this.requestor::accept);
                                }
                                suggestDefaultCompletions = false;
                            } else {
                                methodBinding = invocation.resolveMethodBinding();
                                if (methodBinding == null && this.toComplete == invocation) {
                                    suggestDefaultCompletions = false;
                                } else {
                                    for (ITypeBinding param : this.expectedTypes.getExpectedTypes()) {
                                        potentialLambda = param.getFunctionalInterfaceMethod();
                                        if (potentialLambda == null) continue;
                                        this.requestor.accept(this.createLambdaExpressionProposal((IMethodBinding)potentialLambda));
                                    }
                                }
                            }
                        }
                        if (context instanceof VariableDeclaration && (declaration = (VariableDeclaration)context).getName() == this.toComplete) {
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof ModuleDeclaration) {
                            ModuleDeclaration mod = (ModuleDeclaration)context;
                            this.findModules(this.prefix.toCharArray(), this.modelUnit.getJavaProject(), this.assistOptions, Set.of(mod.getName().toString()));
                        }
                        if (context instanceof SimpleName) {
                            Object localBindings;
                            IBinding incorrectBinding;
                            SimpleType simpleType;
                            ASTNode other;
                            ASTNode normalAnnotation;
                            Object extendsOrImplementsInfo;
                            FieldDeclaration fieldDeclaration;
                            SimpleType simpleType2;
                            potentialLambda = context.getParent();
                            if (potentialLambda instanceof SimpleType && (object = (simpleType2 = (SimpleType)potentialLambda).getParent()) instanceof FieldDeclaration && (aSTNode2 = (fieldDeclaration = (FieldDeclaration)object).getParent()) instanceof AbstractTypeDeclaration) {
                                AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)aSTNode2;
                                ITypeBinding typeDeclBinding2 = typeDecl.resolveBinding();
                                this.findOverridableMethods(typeDeclBinding2, this.modelUnit.getJavaProject(), context);
                                extendsOrImplementsInfo = DOMCompletionEngine.isInExtendsOrImplements(this.toComplete);
                                this.suggestTypeKeywords(true);
                                if (!this.requestor.isIgnored(9)) {
                                    this.findTypes(this.prefix, 0, null).filter(type -> {
                                        try {
                                            return !type.isAnnotation();
                                        }
                                        catch (JavaModelException e) {
                                            return true;
                                        }
                                    }).filter(type -> defaultCompletionBindings.all().map(typeBinding -> typeBinding.getJavaElement()).noneMatch(elt -> type.equals(elt))).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).filter(arg_0 -> this.lambda$28((ExtendsOrImplementsInfo)extendsOrImplementsInfo, arg_0)).map(this::toProposal).forEach(this.requestor::accept);
                                }
                                if (!this.requestor.isIgnored(11)) {
                                    String potentialModifier;
                                    int cursorStart = this.offset - this.prefix.length() - 1;
                                    while (cursorStart > 0 && Character.isWhitespace(this.cuBuffer.getChar(cursorStart))) {
                                        --cursorStart;
                                    }
                                    int cursorEnd = cursorStart;
                                    while (cursorEnd > 0 && Character.isJavaIdentifierPart(this.cuBuffer.getChar(cursorEnd - 1))) {
                                        --cursorEnd;
                                    }
                                    boolean suggest = true;
                                    if (cursorStart != cursorEnd && DOMCompletionUtil.isJavaFieldOrMethodModifier(potentialModifier = this.cuBuffer.getText(cursorEnd, cursorStart - cursorEnd + 1))) {
                                        suggest = false;
                                    }
                                    if (suggest) {
                                        this.requestor.accept(this.toNewMethodProposal(typeDeclBinding2, this.prefix));
                                    }
                                }
                                suggestDefaultCompletions = false;
                            }
                            if (context.getParent() instanceof MarkerAnnotation) {
                                this.completeMarkerAnnotation(completeAfter);
                                suggestDefaultCompletions = false;
                            }
                            if (context.getLocationInParent() == MemberValuePair.NAME_PROPERTY && (extendsOrImplementsInfo = context.getParent()) instanceof MemberValuePair) {
                                MemberValuePair memberValuePair = (MemberValuePair)extendsOrImplementsInfo;
                                HashSet<String> names = new HashSet<String>();
                                ASTNode cursorStart = memberValuePair.getParent();
                                if (cursorStart instanceof NormalAnnotation) {
                                    normalAnnotation = (NormalAnnotation)cursorStart;
                                    for (Object o : ((NormalAnnotation)normalAnnotation).values()) {
                                        if (!(o instanceof MemberValuePair) || (other = (MemberValuePair)o) == memberValuePair) continue;
                                        names.add(((MemberValuePair)other).getName().getIdentifier());
                                    }
                                }
                                Arrays.stream(((Annotation)memberValuePair.getParent()).resolveTypeBinding().getDeclaredMethods()).filter(this::isVisible).filter(method -> !names.contains(method.getName())).map(this::toAnnotationAttributeRefProposal).forEach(this.requestor::accept);
                                suggestDefaultCompletions = false;
                            }
                            if (context.getParent() instanceof MemberValuePair) {
                                suggestDefaultCompletions = false;
                            }
                            if ((context.getLocationInParent() == SwitchCase.EXPRESSIONS2_PROPERTY || context.getLocationInParent() == SwitchCase.EXPRESSION_PROPERTY) && (normalAnnotation = context.getParent()) instanceof SwitchCase) {
                                SwitchCase switchCase = (SwitchCase)normalAnnotation;
                                completionContext.expectedTypes.getExpectedTypes().stream().map(ITypeBinding::getDeclaredFields).flatMap(Arrays::stream).filter(IVariableBinding::isEnumConstant).filter(constant -> this.pattern.matchesName(this.prefix.toCharArray(), constant.getName().toCharArray())).map(this::toProposal).forEach(this.requestor::accept);
                                suggestDefaultCompletions = false;
                            }
                            if (context.getParent() instanceof MethodDeclaration) {
                                suggestDefaultCompletions = false;
                            }
                            if ((other = context.getParent()) instanceof SimpleType && (simpleType = (SimpleType)other).getParent() instanceof MethodDeclaration && simpleType.getLocationInParent().getId().equals(MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY.getId())) {
                                this.findTypes(completeAfter, null).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).filter(type -> {
                                    try {
                                        return !type.isAnnotation() && !type.isInterface();
                                    }
                                    catch (JavaModelException e) {
                                        return true;
                                    }
                                }).map(this::toProposal).forEach(this.requestor::accept);
                                suggestDefaultCompletions = false;
                            }
                            if (context.getParent() instanceof AnnotationTypeMemberDeclaration) {
                                suggestDefaultCompletions = false;
                            }
                            if (context.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY && context.getParent() instanceof QualifiedName && (incorrectBinding = ((SimpleName)context).resolveBinding()) != null) {
                                localBindings = new Bindings();
                                this.scrapeAccessibleBindings((Bindings)localBindings);
                                Optional<IVariableBinding> realBinding = ((Bindings)localBindings).all().filter(IVariableBinding.class::isInstance).map(IVariableBinding.class::cast).filter(varBind -> varBind.getName().equals(incorrectBinding.getName())).findFirst();
                                if (realBinding.isPresent()) {
                                    this.processMembers(context, realBinding.get().getType(), specificCompletionBindings, false);
                                    this.prefix = "";
                                    this.publishFromScope(specificCompletionBindings);
                                    suggestDefaultCompletions = false;
                                }
                            }
                            if ((localBindings = context.getParent()) instanceof ImportDeclaration) {
                                importDeclaration = (ImportDeclaration)localBindings;
                                if (context.getAST().apiLevel() >= 23 && this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true).equals("enabled")) {
                                    for (Modifier modifier : importDeclaration.modifiers()) {
                                        if (modifier.getKeyword() != Modifier.ModifierKeyword.MODULE_KEYWORD) continue;
                                        this.findModules(this.qualifiedPrefix.toCharArray(), this.modelUnit.getJavaProject(), this.assistOptions, Collections.emptySet());
                                        suggestDefaultCompletions = false;
                                        break;
                                    }
                                }
                            }
                        }
                        if (context instanceof AbstractTypeDeclaration) {
                            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)context;
                            if (this.cuBuffer != null) {
                                int nameEndOffset;
                                int bodyStart = nameEndOffset = typeDecl.getName().getStartPosition() + typeDecl.getName().getLength();
                                while (bodyStart < this.cuBuffer.getLength() && this.cuBuffer.getChar(bodyStart) != '{') {
                                    ++bodyStart;
                                }
                                int prefixCursor = this.offset;
                                while (prefixCursor > 0 && !Character.isWhitespace(this.cuBuffer.getChar(prefixCursor - 1))) {
                                    --prefixCursor;
                                }
                                this.prefix = this.cuBuffer.getText(prefixCursor, this.offset - prefixCursor);
                                if (nameEndOffset < this.offset && this.offset <= bodyStart) {
                                    String extendsOrImplementsContent = this.cuBuffer.getText(nameEndOffset, this.offset - nameEndOffset);
                                    if (extendsOrImplementsContent.indexOf("implements") < 0 && extendsOrImplementsContent.indexOf("extends") < 0) {
                                        TypeDeclaration realTypeDecl;
                                        boolean isInterface;
                                        boolean bl = isInterface = typeDecl instanceof TypeDeclaration && (realTypeDecl = (TypeDeclaration)typeDecl).isInterface();
                                        if (CharOperation.prefixEquals((char[])this.prefix.toCharArray(), (char[])Keywords.EXTENDS)) {
                                            this.requestor.accept(this.createKeywordProposal(Keywords.EXTENDS, this.offset, this.offset));
                                        }
                                        if (!isInterface && CharOperation.prefixEquals((char[])this.prefix.toCharArray(), (char[])Keywords.IMPLEMENTS)) {
                                            this.requestor.accept(this.createKeywordProposal(Keywords.IMPLEMENTS, this.offset, this.offset));
                                        }
                                    } else if (extendsOrImplementsContent.indexOf("implements") < 0 && (Character.isWhitespace(this.cuBuffer.getChar(this.offset - 1)) || this.cuBuffer.getChar(this.offset - 1) == ',')) {
                                        this.requestor.accept(this.createKeywordProposal(Keywords.IMPLEMENTS, this.offset, this.offset));
                                    }
                                } else if (bodyStart < this.offset) {
                                    typeDeclBinding = typeDecl.resolveBinding();
                                    this.findOverridableMethods((ITypeBinding)typeDeclBinding, this.modelUnit.getJavaProject(), null);
                                }
                                suggestDefaultCompletions = false;
                            }
                        }
                        if (context instanceof QualifiedName) {
                            QualifiedName qualifiedName = (QualifiedName)context;
                            ImportDeclaration importDecl = (ImportDeclaration)DOMCompletionUtil.findParent(context, new int[]{26});
                            if (importDecl != null) {
                                if (importDecl.getAST().apiLevel() >= 23 && this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true).equals("enabled") && importDecl.modifiers().stream().anyMatch(node -> {
                                    Modifier modifier;
                                    return node instanceof Modifier && (modifier = (Modifier)node).getKeyword() == Modifier.ModifierKeyword.MODULE_KEYWORD;
                                })) {
                                    this.findModules((this.qualifiedPrefix + "." + this.prefix).toCharArray(), this.modelUnit.getJavaProject(), this.assistOptions, Collections.emptySet());
                                    suggestDefaultCompletions = false;
                                } else {
                                    this.suggestPackages(context);
                                    this.suggestTypesInPackage(qualifiedName.toString());
                                    this.suggestTypesInPackage(qualifiedName.getQualifier().toString());
                                    if (importDecl.isStatic() && (typeDeclBinding = qualifiedName.getQualifier().resolveBinding()) instanceof ITypeBinding) {
                                        ITypeBinding type3 = (ITypeBinding)typeDeclBinding;
                                        Stream.of(type3.getDeclaredFields(), type3.getDeclaredMethods(), type3.getDeclaredTypes()).flatMap(Arrays::stream).filter(binding -> Modifier.isStatic(binding.getModifiers())).map(this::toProposal).forEach(this.requestor::accept);
                                    }
                                    suggestDefaultCompletions = false;
                                }
                            } else {
                                ITypeBinding qualifierTypeBinding;
                                IBinding qualifiedNameBinding = qualifiedName.getQualifier().resolveBinding();
                                if (qualifiedNameBinding instanceof ITypeBinding && !(qualifierTypeBinding = (ITypeBinding)qualifiedNameBinding).isRecovered()) {
                                    AbstractTypeDeclaration parentTypeDeclaration;
                                    this.processMembers(qualifiedName, qualifierTypeBinding, specificCompletionBindings, true);
                                    this.publishFromScope(specificCompletionBindings);
                                    int startPos = this.offset;
                                    int endPos = this.offset;
                                    if ((qualifiedName.getName().getFlags() & 1) != 0) {
                                        startPos = qualifiedName.getName().getStartPosition();
                                        endPos = startPos + qualifiedName.getName().getLength();
                                    }
                                    if (!(this.toComplete instanceof Type) && (parentTypeDeclaration = DOMCompletionUtil.findParentTypeDeclaration(context)) != null) {
                                        ITypeBinding currentTypeBinding = parentTypeDeclaration.resolveBinding();
                                        if (currentTypeBinding.isSubTypeCompatible(qualifierTypeBinding)) {
                                            if (!this.isFailedMatch(this.prefix.toCharArray(), Keywords.THIS)) {
                                                this.requestor.accept(this.createKeywordProposal(Keywords.THIS, startPos, endPos));
                                            }
                                            if (!this.isFailedMatch(this.prefix.toCharArray(), Keywords.SUPER)) {
                                                this.requestor.accept(this.createKeywordProposal(Keywords.SUPER, startPos, endPos));
                                            }
                                        }
                                        if (!this.isFailedMatch(this.prefix.toCharArray(), Keywords.CLASS)) {
                                            this.requestor.accept(this.createClassKeywordProposal(qualifierTypeBinding, startPos, endPos));
                                        }
                                    }
                                    suggestDefaultCompletions = false;
                                } else if (qualifiedNameBinding instanceof IPackageBinding) {
                                    IPackageBinding qualifierPackageBinding = (IPackageBinding)qualifiedNameBinding;
                                    if (!qualifierPackageBinding.isRecovered()) {
                                        this.suggestPackages(null);
                                        this.suggestTypesInPackage(qualifierPackageBinding.getName());
                                        suggestDefaultCompletions = false;
                                    } else {
                                        Bindings tempScope = new Bindings();
                                        this.scrapeAccessibleBindings(tempScope);
                                        Optional<ITypeBinding> potentialBinding = tempScope.all().filter(binding -> {
                                            IJavaElement elt = binding.getJavaElement();
                                            if (elt == null) {
                                                return false;
                                            }
                                            return elt.getElementName().equals(qualifiedName.getQualifier().toString());
                                        }).map(binding -> {
                                            if (binding instanceof IVariableBinding) {
                                                IVariableBinding variableBinding = (IVariableBinding)binding;
                                                return variableBinding.getType();
                                            }
                                            if (binding instanceof ITypeBinding) {
                                                ITypeBinding typeBinding = (ITypeBinding)binding;
                                                return typeBinding;
                                            }
                                            throw new IllegalStateException("method, type var, etc. are likely not interpreted as a package");
                                        }).map(ITypeBinding.class::cast).findFirst();
                                        if (potentialBinding.isPresent()) {
                                            this.processMembers(qualifiedName, potentialBinding.get(), specificCompletionBindings, false);
                                            this.publishFromScope(specificCompletionBindings);
                                            suggestDefaultCompletions = false;
                                        } else {
                                            if (this.shouldSuggestPackages(context)) {
                                                this.suggestPackages(context);
                                            }
                                            this.suggestTypesInPackage(qualifierPackageBinding.getName());
                                            suggestDefaultCompletions = false;
                                        }
                                    }
                                } else if (qualifiedNameBinding instanceof IVariableBinding) {
                                    IVariableBinding variableBinding = (IVariableBinding)qualifiedNameBinding;
                                    typeBinding = variableBinding.getType();
                                    this.processMembers(qualifiedName, typeBinding, specificCompletionBindings, false);
                                    this.publishFromScope(specificCompletionBindings);
                                    suggestDefaultCompletions = false;
                                } else {
                                    List<IType> foundTypes = this.findTypes(qualifiedName.getQualifier().toString(), null).toList();
                                    if (!(foundTypes = foundTypes.stream().filter(type -> type.getElementName().equals(qualifiedName.getQualifier().toString())).toList()).isEmpty()) {
                                        IType firstType = foundTypes.get(0);
                                        ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
                                        parser.setProject(this.modelUnit.getJavaProject());
                                        IBinding[] descendantBindings = parser.createBindings(new IType[]{firstType}, (IProgressMonitor)new NullProgressMonitor());
                                        if (descendantBindings.length == 1) {
                                            ITypeBinding qualifierTypeBinding2 = (ITypeBinding)descendantBindings[0];
                                            this.processMembers(qualifiedName, qualifierTypeBinding2, specificCompletionBindings, true);
                                            this.publishFromScope(specificCompletionBindings);
                                            int startPos = this.offset;
                                            int endPos = this.offset;
                                            if ((qualifiedName.getName().getFlags() & 1) != 0) {
                                                startPos = qualifiedName.getName().getStartPosition();
                                                endPos = startPos + qualifiedName.getName().getLength();
                                            }
                                            if (!(this.toComplete instanceof Type) && !this.isFailedMatch(this.prefix.toCharArray(), Keywords.CLASS)) {
                                                this.requestor.accept(this.createClassKeywordProposal(qualifierTypeBinding2, startPos, endPos));
                                            }
                                        }
                                    }
                                    suggestDefaultCompletions = false;
                                }
                            }
                        }
                        if (context instanceof SuperFieldAccess) {
                            SuperFieldAccess superFieldAccess = (SuperFieldAccess)context;
                            ITypeBinding superTypeBinding = superFieldAccess.resolveTypeBinding();
                            this.processMembers(superFieldAccess, superTypeBinding, specificCompletionBindings, false);
                            this.publishFromScope(specificCompletionBindings);
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof MarkerAnnotation) {
                            this.completeMarkerAnnotation(completeAfter);
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof SingleMemberAnnotation) {
                            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)context;
                            if (singleMemberAnnotation.getTypeName().getStartPosition() + singleMemberAnnotation.getTypeName().getLength() > this.offset) {
                                this.completeMarkerAnnotation(completeAfter);
                            } else if (!this.requestor.isIgnored(13)) {
                                this.completeAnnotationParams(singleMemberAnnotation, Collections.emptySet(), specificCompletionBindings);
                            }
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof NormalAnnotation) {
                            NormalAnnotation normalAnnotation = (NormalAnnotation)context;
                            if (normalAnnotation.getTypeName().getStartPosition() + normalAnnotation.getTypeName().getLength() > this.offset) {
                                this.completeMarkerAnnotation(completeAfter);
                            } else if (!this.requestor.isIgnored(13)) {
                                this.completeNormalAnnotationParams(normalAnnotation, specificCompletionBindings);
                            }
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof MethodDeclaration) {
                            MethodDeclaration methodDeclaration = (MethodDeclaration)context;
                            if (this.offset < methodDeclaration.getName().getStartPosition()) {
                                this.completeMethodModifiers(methodDeclaration);
                                if (methodDeclaration.getReturnType2() == null) {
                                    ASTNode current = this.toComplete;
                                    while (current != null) {
                                        specificCompletionBindings.addAll(this.visibleTypeBindings(current));
                                        current = current.getParent();
                                    }
                                    this.publishFromScope(specificCompletionBindings);
                                }
                                suggestDefaultCompletions = false;
                            } else if (methodDeclaration.getBody() == null || methodDeclaration.getBody() != null && this.offset <= methodDeclaration.getBody().getStartPosition()) {
                                this.completeThrowsClause(methodDeclaration, specificCompletionBindings);
                                suggestDefaultCompletions = false;
                            }
                        }
                        if (context instanceof ClassInstanceCreation) {
                            if (this.expectedTypes.getExpectedTypes() != null && !this.expectedTypes.getExpectedTypes().isEmpty() && !this.expectedTypes.getExpectedTypes().get(0).isRecovered()) {
                                this.completeConstructor(this.expectedTypes.getExpectedTypes().get(0), context, this.modelUnit.getJavaProject());
                            } else if (!this.requestor.isIgnored(9) && !this.requestor.isIgnored(26)) {
                                String packageName = "";
                                try {
                                    IPackageDeclaration[] packageDecls = this.modelUnit.getPackageDeclarations();
                                    if (packageDecls != null && packageDecls.length > 0) {
                                        packageName = packageDecls[0].getElementName();
                                    }
                                }
                                catch (JavaModelException packageDecls) {
                                }
                                this.findTypes(this.prefix, 0, packageName).filter(type -> {
                                    try {
                                        return !type.isAnnotation();
                                    }
                                    catch (JavaModelException e) {
                                        return true;
                                    }
                                }).flatMap(type -> {
                                    if (this.prefix.isEmpty()) {
                                        return Stream.of(this.toProposal((IType)type));
                                    }
                                    return this.toConstructorProposals((IType)type, this.toComplete, false).stream();
                                }).forEach(this.requestor::accept);
                            }
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof Javadoc) {
                            suggestDefaultCompletions = false;
                        }
                        if (context instanceof ExpressionMethodReference) {
                            ExpressionMethodReference emr = (ExpressionMethodReference)context;
                            typeBinding = emr.getExpression().resolveTypeBinding();
                            if (typeBinding != null && !this.requestor.isIgnored(12)) {
                                this.processMembers(emr, typeBinding, specificCompletionBindings, false);
                                specificCompletionBindings.methods().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).map(this::toProposal).forEach(this.requestor::accept);
                            }
                            suggestDefaultCompletions = false;
                        }
                        if (!(context instanceof TagElement)) break block212;
                        tagElement = (TagElement)context;
                        boolean isTagName = true;
                        ASTNode cursor = this.toComplete;
                        while (cursor != null && cursor != tagElement) {
                            int index = tagElement.fragments().indexOf(cursor);
                            if (index >= 0) {
                                isTagName = false;
                                break;
                            }
                            cursor = cursor.getParent();
                        }
                        if (!isTagName && (tagElement.getTagName() == null || tagElement.getTagName().length() != 1) && (tagElement.getTagName() == null || this.offset != tagElement.getStartPosition() + tagElement.getTagName().length())) break block213;
                        this.completeJavadocBlockTags(tagElement);
                        this.completeJavadocInlineTags(tagElement);
                        suggestDefaultCompletions = false;
                        break block212;
                    }
                    if (tagElement.getTagName() == null) break block214;
                    Javadoc javadoc = (Javadoc)DOMCompletionUtil.findParent(tagElement, new int[]{29});
                    switch (tagElement.getTagName()) {
                        case "@param": {
                            IBinding typeBinding;
                            int start;
                            int endPos = start = tagElement.getStartPosition() + "@param".length() + 1;
                            if (this.cuBuffer != null) {
                                while (endPos < this.cuBuffer.getLength() && !Character.isWhitespace(this.cuBuffer.getChar(endPos))) {
                                    ++endPos;
                                }
                            }
                            String paramPrefix = this.cuBuffer.getText(start, endPos - start);
                            importDeclaration = javadoc.getParent();
                            if (importDeclaration instanceof MethodDeclaration) {
                                MethodDeclaration methodDecl = (MethodDeclaration)importDeclaration;
                                Set<String> alreadyDocumentedParameters = this.findAlreadyDocumentedParameters(javadoc);
                                methodBinding = methodDecl.resolveBinding();
                                Stream.of(methodBinding.getParameterNames()).filter(name -> !alreadyDocumentedParameters.contains(name)).filter(name -> this.pattern.matchesName(paramPrefix.toCharArray(), name.toCharArray())).map(paramName -> this.toAtParamProposal((String)paramName, tagElement)).forEach(this.requestor::accept);
                                Stream.of(methodBinding.getTypeParameters()).map(typeParam -> "<" + typeParam.getName() + ">").filter(name -> !alreadyDocumentedParameters.contains(name)).filter(name -> this.pattern.matchesName(paramPrefix.toCharArray(), name.toCharArray())).map(paramName -> this.toAtParamProposal((String)paramName, tagElement)).forEach(this.requestor::accept);
                            } else {
                                methodBinding = javadoc.getParent();
                                if (methodBinding instanceof AbstractTypeDeclaration) {
                                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)methodBinding;
                                    Set<String> alreadyDocumentedParameters = this.findAlreadyDocumentedParameters(javadoc);
                                    typeBinding = typeDecl.resolveBinding().getTypeDeclaration();
                                    Stream.of(typeBinding.getTypeParameters()).map(typeParam -> "<" + typeParam.getName() + ">").filter(name -> !alreadyDocumentedParameters.contains(name)).filter(name -> this.pattern.matchesName(paramPrefix.toCharArray(), name.toCharArray())).map(name -> this.toAtParamProposal((String)name, tagElement)).forEach(this.requestor::accept);
                                }
                            }
                            suggestDefaultCompletions = false;
                            break;
                        }
                        case "@see": 
                        case "@link": {
                            int endPos;
                            IBinding typeBinding;
                            String paramPrefix;
                            if (this.qualifiedPrefix.indexOf(35) >= 0) {
                                String classToComplete = this.qualifiedPrefix.substring(0, this.qualifiedPrefix.indexOf(35));
                                if (classToComplete.isEmpty()) {
                                    ITypeBinding typeBinding2 = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding();
                                    Bindings javadocScope = new Bindings();
                                    this.processMembers(this.toComplete, typeBinding2, javadocScope, false);
                                    this.publishFromScope(javadocScope);
                                    this.suggestAccessibleConstructorsForType(typeBinding2);
                                } else {
                                    String packageName;
                                    String string = packageName = classToComplete.lastIndexOf(46) < 0 ? null : classToComplete.substring(0, classToComplete.lastIndexOf(46));
                                    if (packageName != null) {
                                        classToComplete = classToComplete.substring(classToComplete.lastIndexOf(46) + 1);
                                    } else {
                                        CompilationUnit cu = (CompilationUnit)DOMCompletionUtil.findParent(this.toComplete, new int[]{15});
                                        packageName = cu.getPackage() != null ? cu.getPackage().getName().toString() : "";
                                    }
                                    List<IType> potentialTypes = this.findTypes(classToComplete, 0, packageName).toList();
                                    List<IType> sourceTypes = potentialTypes.stream().filter(type -> type instanceof SourceType).toList();
                                    if (!potentialTypes.isEmpty()) {
                                        IType typeToComplete = potentialTypes.size() > 1 && !sourceTypes.isEmpty() ? sourceTypes.get(0) : potentialTypes.get(0);
                                        ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
                                        parser.setProject(this.modelUnit.getJavaProject());
                                        IBinding[] createdBindings = parser.createBindings(new IType[]{typeToComplete}, (IProgressMonitor)new NullProgressMonitor());
                                        if (createdBindings.length > 0 && (typeBinding = createdBindings[0]) instanceof ITypeBinding) {
                                            IBinding typeBinding3 = typeBinding;
                                            Bindings javadocScope = new Bindings();
                                            this.processMembers(this.toComplete, (ITypeBinding)typeBinding3, javadocScope, false);
                                            this.publishFromScope(javadocScope);
                                            this.suggestAccessibleConstructorsForType((ITypeBinding)typeBinding3);
                                        }
                                    }
                                }
                                suggestDefaultCompletions = false;
                                break;
                            }
                            int startPos = endPos = this.offset;
                            if (this.cuBuffer != null) {
                                while (startPos > 0 && !Character.isWhitespace(this.cuBuffer.getChar(startPos - 1))) {
                                    --startPos;
                                }
                            }
                            if ((paramPrefix = this.cuBuffer.getText(startPos, endPos - startPos)).indexOf(47) >= 0) {
                                suggestDefaultCompletions = false;
                                break;
                            }
                            String currentPackage = "";
                            CompilationUnit cuNode = (CompilationUnit)DOMCompletionUtil.findParent(tagElement, new int[]{15});
                            if (cuNode.getPackage() != null) {
                                currentPackage = cuNode.getPackage().getName().toString();
                            }
                            String finalizedCurrentPackage = currentPackage;
                            localTypeBindings = new Bindings();
                            this.scrapeAccessibleBindings((Bindings)localTypeBindings);
                            ((Bindings)localTypeBindings).all().filter(binding -> binding instanceof ITypeBinding).filter(type -> (this.qualifiedPrefix.equals(this.prefix) || this.qualifiedPrefix.equals(finalizedCurrentPackage)) && this.pattern.matchesName(this.prefix.toCharArray(), type.getName().toCharArray())).map(this::toProposal).forEach(this.requestor::accept);
                            this.findTypes(completeAfter, 0, completeAfter.equals(this.qualifiedPrefix) ? null : this.qualifiedPrefix).filter(arg_0 -> DOMCompletionEngine.lambda$82((Bindings)localTypeBindings, arg_0)).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).map(this::toProposal).forEach(this.requestor::accept);
                            suggestDefaultCompletions = false;
                        }
                    }
                    break block212;
                }
                suggestDefaultCompletions = false;
            }
            if (context instanceof ImportDeclaration && context.getAST().apiLevel() >= 23 && this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true).equals("enabled")) {
                this.findModules(this.qualifiedPrefix.toCharArray(), this.modelUnit.getJavaProject(), this.assistOptions, Collections.emptySet());
                suggestDefaultCompletions = false;
            }
            if (context instanceof CompilationUnit) {
                CompilationUnit unit = (CompilationUnit)context;
                if (CharOperation.prefixEquals((char[])completionContext.getToken(), (char[])Keywords.PACKAGE) && unit.getPackage() == null && this.offset <= unit.imports().stream().mapToInt(ASTNode::getStartPosition).filter(n -> n >= 0).min().orElse(Integer.MAX_VALUE) && this.offset <= unit.types().stream().mapToInt(ASTNode::getStartPosition).filter(n -> n >= 0).min().orElse(Integer.MAX_VALUE)) {
                    this.requestor.accept(this.createKeywordProposal(Keywords.PACKAGE, completionContext.getTokenStart(), completionContext.getTokenEnd()));
                }
            }
            if (context instanceof MethodRef) {
                MethodRef methodRef = (MethodRef)context;
                JavadocMethodReferenceParseState state = JavadocMethodReferenceParseState.BEFORE_IDENTIFIER;
                int minNumParams = 0;
                int cursor = methodRef.getName().getStartPosition() + methodRef.getName().toString().length() + 1;
                while (cursor < this.offset) {
                    if (this.cuBuffer.getChar(cursor) == ',') {
                        ++minNumParams;
                        state = JavadocMethodReferenceParseState.BEFORE_IDENTIFIER;
                    } else {
                        switch (state) {
                            case BEFORE_IDENTIFIER: {
                                char cursorCharacter = this.cuBuffer.getChar(cursor);
                                if (Character.isWhitespace(cursorCharacter) || cursorCharacter == ')') break;
                                if (minNumParams == 0) {
                                    ++minNumParams;
                                }
                                state = JavadocMethodReferenceParseState.IN_IDENTIFIER;
                                break;
                            }
                            case IN_IDENTIFIER: {
                                if (!Character.isWhitespace(this.cuBuffer.getChar(cursor))) break;
                                state = JavadocMethodReferenceParseState.AFTER_IDENTIFIER;
                                break;
                            }
                        }
                    }
                    ++cursor;
                }
                if (state == JavadocMethodReferenceParseState.BEFORE_IDENTIFIER) {
                    String expectedMethodName = methodRef.getName().toString();
                    int finalizedMinNumParams = minNumParams;
                    List<IMethodBinding> potentialMethodCompletions = null;
                    if (potentialMethodCompletions == null) {
                        Name qualifier2 = methodRef.getQualifier();
                        if (qualifier2 == null) {
                            ITypeBinding parentTypeBinding = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding();
                            potentialMethodCompletions = Stream.of(parentTypeBinding.getDeclaredMethods()).filter(methodCandidate -> {
                                if (!expectedMethodName.equals(methodCandidate.getName())) {
                                    return false;
                                }
                                return methodCandidate.getParameterTypes().length >= finalizedMinNumParams;
                            }).toList();
                        } else {
                            localTypeBindings = qualifier2.resolveBinding();
                            if (localTypeBindings instanceof ITypeBinding) {
                                ITypeBinding javadocResolvedTypeBinding = (ITypeBinding)localTypeBindings;
                                potentialMethodCompletions = Stream.of(javadocResolvedTypeBinding.getDeclaredMethods()).filter(methodCandidate -> {
                                    if (!expectedMethodName.equals(methodCandidate.getName())) {
                                        return false;
                                    }
                                    return methodCandidate.getParameterTypes().length >= finalizedMinNumParams;
                                }).toList();
                            } else {
                                String packageName;
                                String classToComplete = qualifier2.toString();
                                String string = packageName = classToComplete.lastIndexOf(46) < 0 ? null : classToComplete.substring(0, classToComplete.lastIndexOf(46));
                                if (packageName != null) {
                                    classToComplete = classToComplete.substring(classToComplete.lastIndexOf(46) + 1);
                                } else {
                                    CompilationUnit cu = (CompilationUnit)DOMCompletionUtil.findParent(this.toComplete, new int[]{15});
                                    packageName = cu.getPackage() != null ? cu.getPackage().getName().toString() : "";
                                }
                                List<IType> potentialTypes = this.findTypes(classToComplete, 0, packageName).toList();
                                List<IType> sourceTypes = potentialTypes.stream().filter(type -> type instanceof SourceType).toList();
                                if (!potentialTypes.isEmpty()) {
                                    IBinding iBinding;
                                    IType typeToComplete = potentialTypes.size() > 1 && !sourceTypes.isEmpty() ? sourceTypes.get(0) : potentialTypes.get(0);
                                    ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
                                    parser.setProject(this.modelUnit.getJavaProject());
                                    IBinding[] createdBindings = parser.createBindings(new IType[]{typeToComplete}, (IProgressMonitor)new NullProgressMonitor());
                                    if (createdBindings.length > 0 && (iBinding = createdBindings[0]) instanceof ITypeBinding) {
                                        ITypeBinding typeBinding = (ITypeBinding)iBinding;
                                        potentialMethodCompletions = Stream.of(typeBinding.getDeclaredMethods()).filter(methodCandidate -> {
                                            if (!expectedMethodName.equals(methodCandidate.getName())) {
                                                return false;
                                            }
                                            return methodCandidate.getParameterTypes().length >= finalizedMinNumParams;
                                        }).toList();
                                    }
                                }
                            }
                        }
                    }
                    if (potentialMethodCompletions != null) {
                        for (IMethodBinding potentialMethodCompletion : potentialMethodCompletions) {
                            CompletionProposal proposal = this.toProposal(potentialMethodCompletion);
                            proposal.setReplaceRange(methodRef.getName().getStartPosition(), methodRef.getStartPosition() + methodRef.getLength());
                            proposal.setTokenRange(methodRef.getName().getStartPosition(), methodRef.getStartPosition() + methodRef.getLength());
                            proposal.setRelevance(56);
                            this.requestor.accept(proposal);
                        }
                    }
                    suggestDefaultCompletions = false;
                } else if (state == JavadocMethodReferenceParseState.AFTER_IDENTIFIER) {
                    suggestDefaultCompletions = false;
                }
            }
            if (context instanceof MemberRef) {
                MemberRef memberRef = (MemberRef)context;
                IBinding bindingToComplete = memberRef.getQualifier() != null ? memberRef.getQualifier().resolveBinding() : DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding();
                if (bindingToComplete instanceof ITypeBinding) {
                    ITypeBinding typeBinding = (ITypeBinding)bindingToComplete;
                    Bindings javadocScope = new Bindings();
                    this.processMembers(this.toComplete, typeBinding, javadocScope, false);
                    this.publishFromScope(javadocScope);
                    this.suggestAccessibleConstructorsForType(typeBinding);
                }
                suggestDefaultCompletions = false;
            }
            if (context != null && context.getLocationInParent() == QualifiedType.NAME_PROPERTY && (aSTNode = context.getParent()) instanceof QualifiedType && (qualifier = (qType = (QualifiedType)aSTNode).getQualifier()) != null && (qualifierBinding = qualifier.resolveBinding()) != null) {
                ITypeBinding[] iTypeBindingArray = qualifierBinding.getDeclaredTypes();
                int n2 = iTypeBindingArray.length;
                int potentialMethodCompletion = 0;
                while (potentialMethodCompletion < n2) {
                    ITypeBinding nestedType = iTypeBindingArray[potentialMethodCompletion];
                    this.requestor.accept(this.toProposal(nestedType));
                    ++potentialMethodCompletion;
                }
            }
            this.scrapeAccessibleBindings(defaultCompletionBindings);
            if (this.shouldSuggestPackages(this.toComplete)) {
                this.suggestPackages(this.toComplete);
            }
            if (context instanceof SimpleName && !((simple = (SimpleName)context).getParent() instanceof Name)) {
                for (ImportDeclaration importDecl : this.unit.imports()) {
                    if (!importDecl.isStatic()) continue;
                    if (!importDecl.isOnDemand()) {
                        defaultCompletionBindings.add(importDecl.resolveBinding());
                        continue;
                    }
                    IBinding iBinding = importDecl.resolveBinding();
                    if (!(iBinding instanceof ITypeBinding)) continue;
                    ITypeBinding staticallyImportedAll = (ITypeBinding)iBinding;
                    Stream.of(staticallyImportedAll.getDeclaredFields(), staticallyImportedAll.getDeclaredMethods()).flatMap(Arrays::stream).filter(binding -> Modifier.isStatic(binding.getModifiers())).filter(this::isVisible).forEach(defaultCompletionBindings::add);
                }
            }
            if (suggestDefaultCompletions) {
                ExtendsOrImplementsInfo extendsOrImplementsInfo = DOMCompletionEngine.isInExtendsOrImplements(this.toComplete);
                this.statementLikeKeywords();
                if (!this.prefix.isEmpty() && extendsOrImplementsInfo == null) {
                    this.suggestTypeKeywords(DOMCompletionUtil.findParent(this.toComplete, new int[]{8}) == null);
                }
                this.publishFromScope(defaultCompletionBindings);
                if (!completeAfter.isBlank()) {
                    int typeMatchRule;
                    int n3 = typeMatchRule = this.toComplete.getParent() instanceof Annotation ? 8 : 0;
                    if (!this.requestor.isIgnored(9) && completionContext.getExpectedTypesSignatures() != null) {
                        this.findTypes(completeAfter, typeMatchRule, null).filter(type -> defaultCompletionBindings.all().map(typeBinding -> typeBinding.getJavaElement()).noneMatch(elt -> type.equals(elt))).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).filter(type -> this.filterBasedOnExtendsOrImplementsInfo((IType)type, extendsOrImplementsInfo)).map(this::toProposal).forEach(this.requestor::accept);
                    }
                }
                this.checkCancelled();
                if (this.shouldSuggestPackages(this.toComplete)) {
                    this.suggestPackages(this.toComplete);
                }
            }
            this.checkCancelled();
        }
        finally {
            this.requestor.endReporting();
            if (this.monitor != null) {
                this.monitor.done();
            }
        }
    }

    private void suggestAccessibleConstructorsForType(ITypeBinding typeBinding) {
        ITypeBinding parentTypeBinding = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding();
        Stream.of(typeBinding.getDeclaredMethods()).filter(IMethodBinding::isConstructor).filter(method -> CharOperation.prefixEquals((char[])this.prefix.toCharArray(), (char[])method.getName().toCharArray()) || this.assistOptions.camelCaseMatch && CharOperation.camelCaseMatch((char[])this.prefix.toCharArray(), (char[])method.getName().toCharArray())).filter(method -> {
            boolean includeProtected = DOMCompletionEngine.findInSupers(parentTypeBinding, typeBinding);
            if (!((method.getModifiers() & 2) == 0 || parentTypeBinding != null && method.getDeclaringClass().getKey().equals(parentTypeBinding.getKey()))) {
                return false;
            }
            if ((method.getModifiers() & 7) == 0) {
                if (parentTypeBinding == null) {
                    return false;
                }
                return method.getDeclaringClass().getPackage().getName().equals(parentTypeBinding.getPackage().getName());
            }
            if ((method.getModifiers() & 4) != 0) {
                return includeProtected;
            }
            return true;
        }).sorted(Comparator.comparing(this::getSignature).reversed()).map(this::toProposal).forEach(this.requestor::accept);
    }

    private Set<String> findAlreadyDocumentedParameters(Javadoc javadoc) {
        HashSet<String> alreadyDocumentedParameters = new HashSet<String>();
        for (TagElement tagElement : javadoc.tags()) {
            Name name;
            String str;
            List fragments;
            if (!"@param".equals(tagElement.getTagName()) || (fragments = tagElement.fragments()).isEmpty()) continue;
            Object e = fragments.get(0);
            if (e instanceof TextElement) {
                TextElement textElement = (TextElement)e;
                if (fragments.size() >= 3 && fragments.get(1) instanceof Name) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(fragments.get(0));
                    builder.append(fragments.get(1));
                    builder.append(fragments.get(2));
                    alreadyDocumentedParameters.add(builder.toString());
                    continue;
                }
                if (textElement.getText().isEmpty()) continue;
                alreadyDocumentedParameters.add(textElement.getText());
                continue;
            }
            Object e2 = fragments.get(0);
            if (e2 instanceof String && !(str = (String)e2).isBlank()) {
                alreadyDocumentedParameters.add(str);
                continue;
            }
            Object e3 = fragments.get(0);
            if (!(e3 instanceof Name) || (name = (Name)e3).toString().isBlank()) continue;
            alreadyDocumentedParameters.add(name.toString());
        }
        return alreadyDocumentedParameters;
    }

    private CompletionProposal toAtParamProposal(String paramName, TagElement tagElement) {
        int realStart;
        InternalCompletionProposal res = this.createProposal(18);
        boolean isTypeParam = paramName.startsWith("<");
        res.setCompletion(paramName.toCharArray());
        if (isTypeParam) {
            res.setName(paramName.substring(1, paramName.length() - 1).toCharArray());
        } else {
            res.setName(paramName.toCharArray());
        }
        int relevance = 30 + (isTypeParam ? 0 : 10) + 3;
        res.setRelevance(relevance);
        int tagStart = tagElement.getStartPosition();
        int endPos = realStart = tagStart + "@param".length() + 1;
        if (this.cuBuffer != null) {
            while (endPos < this.cuBuffer.getLength() && !Character.isWhitespace(this.cuBuffer.getChar(endPos))) {
                ++endPos;
            }
        }
        res.setReplaceRange(realStart, endPos);
        res.setTokenRange(realStart, endPos);
        return res;
    }

    private boolean shouldSuggestPackages(ASTNode context) {
        PackageDeclaration decl;
        if (context instanceof CompilationUnit) {
            return false;
        }
        if (context instanceof PackageDeclaration && (decl = (PackageDeclaration)context).getName() != null && !Arrays.equals(decl.getName().toString().toCharArray(), RecoveryScanner.FAKE_IDENTIFIER)) {
            return false;
        }
        boolean inExtendsOrImplements = false;
        while (context != null) {
            ChildListPropertyDescriptor childList;
            StructuralPropertyDescriptor structuralPropertyDescriptor;
            ChildPropertyDescriptor child;
            StructuralPropertyDescriptor structuralPropertyDescriptor2;
            if (context instanceof SimpleName && (context.getLocationInParent() == QualifiedName.NAME_PROPERTY || (structuralPropertyDescriptor2 = context.getLocationInParent()) instanceof ChildPropertyDescriptor && (child = (ChildPropertyDescriptor)structuralPropertyDescriptor2).getChildType() == Expression.class || (structuralPropertyDescriptor = context.getLocationInParent()) instanceof ChildListPropertyDescriptor && (childList = (ChildListPropertyDescriptor)structuralPropertyDescriptor).getElementType() == Expression.class)) {
                return true;
            }
            if (context instanceof QualifiedName) {
                return true;
            }
            if (context instanceof Type || context instanceof Name) {
                context = context.getParent();
                continue;
            }
            structuralPropertyDescriptor2 = context.getLocationInParent();
            return structuralPropertyDescriptor2 instanceof ChildPropertyDescriptor && (child = (ChildPropertyDescriptor)structuralPropertyDescriptor2).getChildType() == Type.class || (structuralPropertyDescriptor = context.getLocationInParent()) instanceof ChildListPropertyDescriptor && (childList = (ChildListPropertyDescriptor)structuralPropertyDescriptor).getElementType() == Type.class;
        }
        return !inExtendsOrImplements;
    }

    private void suggestTypeKeywords(boolean includeVoid) {
        for (char[] keyword : TYPE_KEYWORDS_EXCEPT_VOID) {
            if (this.isFailedMatch(this.prefix.toCharArray(), keyword)) continue;
            this.requestor.accept(this.createKeywordProposal(keyword, -1, -1));
        }
        if (includeVoid && !this.isFailedMatch(this.prefix.toCharArray(), VOID)) {
            this.requestor.accept(this.createKeywordProposal(VOID, -1, -1));
        }
    }

    private void scrapeAccessibleBindings(Bindings scope) {
        ASTNode current = this.toComplete;
        while (current != null) {
            Collection<? extends IBinding> gottenVisibleBindings = this.visibleBindings(current);
            scope.addAll(gottenVisibleBindings);
            if (current instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)current;
                this.processMembers(this.toComplete, typeDecl.resolveBinding(), scope, false);
            }
            current = current.getParent();
        }
        if (this.requestor.getFavoriteReferences() == null) {
            return;
        }
        Set scopedMethods = scope.methods().map(IBinding::getName).collect(Collectors.toSet());
        Set scopedVariables = scope.all().filter(IVariableBinding.class::isInstance).map(IBinding::getName).collect(Collectors.toSet());
        Set scopedTypes = scope.all().filter(ITypeBinding.class::isInstance).map(IBinding::getName).collect(Collectors.toSet());
        HashSet keysToResolve = new HashSet();
        IJavaProject project = this.modelUnit.getJavaProject();
        String[] stringArray = this.requestor.getFavoriteReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String favouriteReference = stringArray[n2];
            if (favouriteReference.endsWith(".*")) {
                String packageName = (favouriteReference = favouriteReference.substring(0, favouriteReference.length() - 2)).indexOf(46) < 0 ? "" : favouriteReference.substring(0, favouriteReference.lastIndexOf(46));
                String typeName = favouriteReference.indexOf(46) < 0 ? favouriteReference : favouriteReference.substring(favouriteReference.lastIndexOf(46) + 1);
                this.findTypes(typeName, 0, packageName).filter(type -> type.getElementName().equals(typeName)).forEach(keysToResolve::add);
            } else if (favouriteReference.lastIndexOf(46) >= 0) {
                String memberName = favouriteReference.substring(favouriteReference.lastIndexOf(46) + 1);
                String typeFqn = favouriteReference.substring(0, favouriteReference.lastIndexOf(46));
                String packageName = typeFqn.indexOf(46) < 0 ? "" : typeFqn.substring(0, typeFqn.lastIndexOf(46));
                String typeName = typeFqn.indexOf(46) < 0 ? typeFqn : typeFqn.substring(typeFqn.lastIndexOf(46) + 1);
                this.findTypes(typeName, 0, packageName).filter(type -> type.getElementName().equals(typeName)).findFirst().ifPresent(type -> {
                    try {
                        IMethod[] iMethodArray = type.getMethods();
                        int n = iMethodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            if (method.exists() && (method.getFlags() & 8) != 0 && memberName.equals(method.getElementName())) {
                                keysToResolve.add(method);
                            }
                            ++n2;
                        }
                        IField field = type.getField(memberName);
                        if (field.exists() && (field.getFlags() & 8) != 0) {
                            keysToResolve.add(type.getField(memberName));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                });
            }
            ++n2;
        }
        Bindings favoriteBindings = new Bindings();
        ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
        parser.setProject(project);
        if (!keysToResolve.isEmpty()) {
            IBinding[] bindings;
            IBinding[] iBindingArray = bindings = parser.createBindings((IJavaElement[])keysToResolve.toArray(IJavaElement[]::new), this.monitor);
            int n3 = bindings.length;
            int n4 = 0;
            while (n4 < n3) {
                IBinding binding2 = iBindingArray[n4];
                if (binding2 instanceof ITypeBinding) {
                    ITypeBinding typeBinding = (ITypeBinding)binding2;
                    this.processMembers(this.toComplete, typeBinding, favoriteBindings, true);
                } else if (binding2 instanceof IMethodBinding) {
                    IMethodBinding methodBinding = (IMethodBinding)binding2;
                    favoriteBindings.add(methodBinding);
                } else {
                    favoriteBindings.add(binding2);
                }
                ++n4;
            }
        }
        favoriteBindings.all().filter(binding -> {
            if (binding instanceof IMethodBinding) {
                return !scopedMethods.contains(binding.getName());
            }
            if (binding instanceof IVariableBinding) {
                return !scopedVariables.contains(binding.getName());
            }
            return !scopedTypes.contains(binding.getName());
        }).forEach(scope::add);
    }

    private void completeMethodModifiers(MethodDeclaration methodDeclaration) {
        ArrayList<char[]> keywords = new ArrayList<char[]>();
        if ((methodDeclaration.getModifiers() & 0x400) == 0) {
            keywords.add(Keywords.ABSTRACT);
        }
        if ((methodDeclaration.getModifiers() & 7) == 0) {
            keywords.add(Keywords.PUBLIC);
            keywords.add(Keywords.PRIVATE);
            keywords.add(Keywords.PROTECTED);
        }
        if ((methodDeclaration.getModifiers() & 0x10000) == 0) {
            keywords.add(Keywords.DEFAULT);
        }
        if ((methodDeclaration.getModifiers() & 0x10) == 0) {
            keywords.add(Keywords.FINAL);
        }
        if ((methodDeclaration.getModifiers() & 0x100) == 0) {
            keywords.add(Keywords.NATIVE);
        }
        if ((methodDeclaration.getModifiers() & 0x800) == 0) {
            keywords.add(Keywords.STRICTFP);
        }
        if ((methodDeclaration.getModifiers() & 0x20) == 0) {
            keywords.add(Keywords.SYNCHRONIZED);
        }
        for (char[] keyword : keywords) {
            if (this.isFailedMatch(this.prefix.toCharArray(), keyword)) continue;
            this.requestor.accept(this.createKeywordProposal(keyword, this.offset, this.offset));
        }
    }

    private void checkCancelled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void statementLikeKeywords() {
        ASTNode prevStatement;
        Block block;
        int exprIndex;
        ASTNode statementParent;
        ExpressionStatement exprStatement;
        ArrayList<char[]> keywords = new ArrayList<char[]>();
        keywords.add(Keywords.ASSERT);
        keywords.add(Keywords.RETURN);
        keywords.add(Keywords.SUPER);
        if (DOMCompletionUtil.findParent(this.toComplete, new int[]{61, 19, 24}) != null) {
            keywords.add(Keywords.BREAK);
            keywords.add(Keywords.CONTINUE);
        }
        if ((exprStatement = (ExpressionStatement)DOMCompletionUtil.findParent(this.toComplete, new int[]{21})) != null && (statementParent = exprStatement.getParent()) instanceof Block && (exprIndex = (block = (Block)statementParent).statements().indexOf(exprStatement)) > 0 && (prevStatement = (ASTNode)block.statements().get(exprIndex - 1)).getNodeType() == 25) {
            keywords.add(Keywords.ELSE);
        }
        for (char[] keyword : keywords) {
            if (this.isFailedMatch(this.toComplete.toString().toCharArray(), keyword)) continue;
            this.requestor.accept(this.createKeywordProposal(keyword, this.toComplete.getStartPosition(), this.offset));
        }
    }

    private void completeJavadocBlockTags(TagElement tagNode) {
        if (this.requestor.isIgnored(19)) {
            return;
        }
        for (char[] blockTag : DOMCompletionEngineJavadocUtil.getJavadocBlockTags(this.modelUnit.getJavaProject(), tagNode)) {
            if (this.isFailedMatch(this.prefix.toCharArray(), blockTag)) continue;
            this.requestor.accept(this.toJavadocBlockTagProposal(blockTag));
        }
    }

    private void completeJavadocInlineTags(TagElement tagNode) {
        if (this.requestor.isIgnored(20)) {
            return;
        }
        for (char[] blockTag : DOMCompletionEngineJavadocUtil.getJavadocInlineTags(this.modelUnit.getJavaProject(), tagNode)) {
            if (this.isFailedMatch(this.prefix.toCharArray(), blockTag)) continue;
            this.requestor.accept(this.toJavadocInlineTagProposal(blockTag));
        }
    }

    private void completeThrowsClause(MethodDeclaration methodDeclaration, Bindings scope) {
        if (methodDeclaration.thrownExceptionTypes().size() == 0) {
            int startScanIndex = Math.max(methodDeclaration.getName().getStartPosition() + methodDeclaration.getName().getLength(), methodDeclaration.getReturnType2().getStartPosition() + methodDeclaration.getReturnType2().getLength());
            if (!methodDeclaration.parameters().isEmpty()) {
                SingleVariableDeclaration lastParam = (SingleVariableDeclaration)methodDeclaration.parameters().get(methodDeclaration.parameters().size() - 1);
                startScanIndex = lastParam.getName().getStartPosition() + lastParam.getName().getLength();
            }
            if (this.cuBuffer != null) {
                String text = this.cuBuffer.getText(startScanIndex, this.offset - startScanIndex);
                int firstThrow = text.indexOf("throw");
                if (!(firstThrow != -1 && firstThrow < this.offset - this.prefix.length() || this.isFailedMatch(this.prefix.toCharArray(), Keywords.THROWS))) {
                    this.requestor.accept(this.createKeywordProposal(Keywords.THROWS, -1, -1));
                }
            } else if (!this.isFailedMatch(this.prefix.toCharArray(), Keywords.THROWS)) {
                this.requestor.accept(this.createKeywordProposal(Keywords.THROWS, -1, -1));
            }
        }
    }

    private void suggestPackages(ASTNode context) {
        String prefix;
        this.checkCancelled();
        while (context != null && context.getParent() instanceof Name) {
            context = context.getParent();
        }
        if (context instanceof Name) {
            Name name = (Name)context;
            v0 = name.toString();
        } else {
            v0 = prefix = this.prefix;
        }
        if (prefix != null && !prefix.isBlank()) {
            this.nameEnvironment.findPackages(prefix.toCharArray(), this.nestedEngine);
        }
    }

    private void suggestTypesInPackage(String packageName) {
        if (!this.requestor.isIgnored(9)) {
            List<IType> foundTypes = this.findTypes(this.prefix, packageName).toList();
            ExtendsOrImplementsInfo extendsOrImplementsInfo = DOMCompletionEngine.isInExtendsOrImplements(this.toComplete);
            for (IType foundType : foundTypes) {
                if (!this.pattern.matchesName(this.prefix.toCharArray(), foundType.getElementName().toCharArray()) || !this.filterBasedOnExtendsOrImplementsInfo(foundType, extendsOrImplementsInfo)) continue;
                this.requestor.accept(this.toProposal(foundType));
            }
        }
    }

    private boolean filterBasedOnExtendsOrImplementsInfo(IType toFilter, ExtendsOrImplementsInfo info) {
        TypeDeclaration typeDeclaration;
        block7: {
            block6: {
                if (info == null) {
                    return true;
                }
                try {
                    if (info.typeDecl instanceof TypeDeclaration) {
                        typeDeclaration = (TypeDeclaration)info.typeDecl;
                        if ((toFilter.getFlags() & 0x10) == 0 && !typeDeclaration.resolveBinding().getKey().equals(toFilter.getKey())) break block6;
                    }
                    return false;
                }
                catch (JavaModelException e) {
                    return true;
                }
            }
            if (!typeDeclaration.isInterface() || !toFilter.isInterface() || DOMCompletionEngine.extendsOrImplementsGivenType(typeDeclaration, toFilter)) break block7;
            return true;
        }
        return !typeDeclaration.isInterface() && info.isImplements == toFilter.isInterface() && !DOMCompletionEngine.extendsOrImplementsGivenType(typeDeclaration, toFilter);
    }

    private static ExtendsOrImplementsInfo isInExtendsOrImplements(ASTNode completion) {
        ASTNode cursor = completion;
        while (cursor != null && cursor.getNodeType() != 55 && cursor.getNodeType() != 71 && cursor.getNodeType() != 103 && cursor.getNodeType() != 81) {
            StructuralPropertyDescriptor locationInParent = cursor.getLocationInParent();
            if (locationInParent == null) {
                return null;
            }
            if (locationInParent.isChildListProperty()) {
                locationId = locationInParent.getId();
                if (TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY.getId().equals(locationId) || EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY.getId().equals(locationId) || RecordDeclaration.SUPER_INTERFACE_TYPES_PROPERTY.getId().equals(locationId)) {
                    return new ExtendsOrImplementsInfo((AbstractTypeDeclaration)cursor.getParent(), true);
                }
            } else if (locationInParent.isChildProperty()) {
                locationId = locationInParent.getId();
                if (TypeDeclaration.SUPERCLASS_TYPE_PROPERTY.getId().equals(locationId)) {
                    return new ExtendsOrImplementsInfo((AbstractTypeDeclaration)cursor.getParent(), false);
                }
            }
            cursor = cursor.getParent();
        }
        return null;
    }

    private static boolean extendsOrImplementsGivenType(TypeDeclaration typeDecl, IType typeRef) {
        String refKey = typeRef.getKey();
        if (typeDecl.getSuperclassType() != null && typeDecl.getSuperclassType().resolveBinding() != null && refKey.equals(typeDecl.getSuperclassType().resolveBinding().getKey())) {
            return true;
        }
        for (Object superInterface : typeDecl.superInterfaceTypes()) {
            ITypeBinding superInterfaceBinding = ((Type)superInterface).resolveBinding();
            if (superInterfaceBinding == null || !refKey.equals(superInterfaceBinding.getKey())) continue;
            return true;
        }
        return false;
    }

    private void completeMarkerAnnotation(String completeAfter) {
        this.findTypes(completeAfter, 8, null).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).map(this::toProposal).forEach(this.requestor::accept);
    }

    private void completeNormalAnnotationParams(NormalAnnotation normalAnnotation, Bindings scope) {
        Set<String> definedKeys = normalAnnotation.values().stream().map(mvp -> mvp.getName().toString()).collect(Collectors.toSet());
        this.completeAnnotationParams(normalAnnotation, definedKeys, scope);
    }

    private void completeAnnotationParams(Annotation annotation, Set<String> definedKeys, Bindings scope) {
        Arrays.stream(annotation.resolveTypeBinding().getDeclaredMethods()).filter(declaredMethod -> (declaredMethod.getModifiers() & 8) == 0 && !definedKeys.contains(declaredMethod.getName().toString())).forEach(scope::add);
        scope.methods().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).map(binding -> this.toAnnotationAttributeRefProposal((IMethodBinding)binding)).forEach(this.requestor::accept);
    }

    private void publishFromScope(Bindings scope) {
        scope.all().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).map(binding -> this.toProposal((IBinding)binding)).forEach(this.requestor::accept);
    }

    private void completeConstructor(ITypeBinding typeBinding, ASTNode referencedFrom, IJavaProject javaProject) {
        boolean isArray = typeBinding.isArray();
        IType typeHandle = (IType)typeBinding.getJavaElement();
        AbstractTypeDeclaration enclosingType = (AbstractTypeDeclaration)DOMCompletionUtil.findParent(referencedFrom, new int[]{55, 71, 103, 81});
        ITypeBinding enclosingTypeBinding = enclosingType.resolveBinding();
        IType enclosingTypeElement = (IType)enclosingTypeBinding.getJavaElement();
        if (typeHandle != null) {
            try {
                ITypeHierarchy newTypeHierarchy = typeHandle.newTypeHierarchy(javaProject, null);
                ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
                parser.setProject(javaProject);
                ArrayList<IType> subtypes = new ArrayList<IType>();
                subtypes.add(typeHandle);
                IType[] iTypeArray = newTypeHierarchy.getSubtypes(typeHandle);
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType subtype = iTypeArray[n2];
                    subtypes.add(subtype);
                    ++n2;
                }
                if (enclosingTypeElement != null) {
                    boolean alreadyThere = false;
                    for (IType subtype : subtypes) {
                        if (!subtype.getKey().equals(enclosingTypeElement.getKey())) continue;
                        alreadyThere = true;
                    }
                    if (!alreadyThere) {
                        subtypes.add(enclosingTypeElement);
                    }
                }
                if (isArray) {
                    for (IType subtype : subtypes) {
                        if (this.isFailedMatch(this.prefix.toCharArray(), subtype.getElementName().toCharArray())) continue;
                        InternalCompletionProposal typeProposal = (InternalCompletionProposal)this.toProposal(subtype);
                        typeProposal.setArrayDimensions(typeBinding.getDimensions());
                        typeProposal.setRelevance(typeProposal.getRelevance() + 30);
                        this.requestor.accept(typeProposal);
                    }
                } else {
                    for (IType subtype : subtypes) {
                        if (this.isFailedMatch(this.prefix.toCharArray(), subtype.getElementName().toCharArray())) continue;
                        List<CompletionProposal> proposals = this.toConstructorProposals(subtype, referencedFrom, true);
                        for (CompletionProposal proposal : proposals) {
                            this.requestor.accept(proposal);
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                ILog.get().error("Unable to compute type hierarchy while performing completion", (Throwable)((Object)e));
            }
        } else if (enclosingTypeElement != null) {
            if (isArray) {
                this.suggestTypeKeywords(false);
            }
            if (!this.isFailedMatch(this.prefix.toCharArray(), enclosingTypeElement.getElementName().toCharArray())) {
                List<CompletionProposal> proposals = this.toConstructorProposals(enclosingTypeElement, referencedFrom, true);
                for (CompletionProposal proposal : proposals) {
                    this.requestor.accept(proposal);
                }
            }
        }
    }

    private void findOverridableMethods(ITypeBinding typeBinding, IJavaProject javaProject, ASTNode toReplace) {
        String originalPackageKey = typeBinding.getPackage().getKey();
        HashSet<String> alreadySuggestedMethodKeys = new HashSet<String>();
        if (typeBinding.getSuperclass() != null) {
            this.findOverridableMethods0(typeBinding.getSuperclass(), alreadySuggestedMethodKeys, javaProject, originalPackageKey, toReplace);
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            this.findOverridableMethods0(superInterface, alreadySuggestedMethodKeys, javaProject, originalPackageKey, toReplace);
            ++n2;
        }
    }

    private void findOverridableMethods0(ITypeBinding typeBinding, Set<String> alreadySuggestedKeys, IJavaProject javaProject, String originalPackageKey, ASTNode toReplace) {
        IBinding[] iBindingArray = typeBinding.getDeclaredMethods();
        int n2 = iBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IMethodBinding method = iBindingArray[n3];
            if (!(alreadySuggestedKeys.contains(method.getKey()) || method.isSynthetic() || method.isConstructor() || this.assistOptions.checkDeprecation && method.isDeprecated() || Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers()) || (method.getModifiers() & 7) == 0 && !typeBinding.getPackage().getKey().equals(originalPackageKey))) {
                alreadySuggestedKeys.add(method.getKey());
                if (!Modifier.isFinal(method.getModifiers()) && !this.isFailedMatch(this.prefix.toCharArray(), method.getName().toCharArray())) {
                    InternalCompletionProposal proposal = this.createProposal(7);
                    proposal.setReplaceRange(this.offset, this.offset);
                    if (toReplace != null) {
                        proposal.setReplaceRange(toReplace.getStartPosition(), toReplace.getStartPosition() + toReplace.getLength());
                    }
                    proposal.setName(method.getName().toCharArray());
                    proposal.setFlags(method.getModifiers());
                    proposal.setTypeName(method.getReturnType().getName().toCharArray());
                    proposal.setDeclarationPackageName(typeBinding.getPackage().getName().toCharArray());
                    proposal.setDeclarationTypeName(typeBinding.getQualifiedName().toCharArray());
                    proposal.setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(method.getDeclaringClass()));
                    proposal.setKey(method.getKey().toCharArray());
                    proposal.setSignature(DOMCompletionEngineBuilder.getSignature(method));
                    proposal.setParameterNames((char[][])Stream.of(method.getParameterNames()).map(name -> name.toCharArray()).toArray(n -> new char[n][]));
                    int relevance = 39 + (Modifier.isAbstract(method.getModifiers()) ? 20 : 0) + 3;
                    proposal.setRelevance(relevance);
                    StringBuilder completion = new StringBuilder();
                    DOMCompletionEngineBuilder.createMethod(method, completion);
                    proposal.setCompletion(completion.toString().toCharArray());
                    this.requestor.accept(proposal);
                }
            }
            ++n3;
        }
        if (typeBinding.getSuperclass() != null) {
            this.findOverridableMethods0(typeBinding.getSuperclass(), alreadySuggestedKeys, javaProject, originalPackageKey, toReplace);
        }
        iBindingArray = typeBinding.getInterfaces();
        n2 = iBindingArray.length;
        n3 = 0;
        while (n3 < n2) {
            IBinding superInterface = iBindingArray[n3];
            this.findOverridableMethods0((ITypeBinding)superInterface, alreadySuggestedKeys, javaProject, originalPackageKey, toReplace);
            ++n3;
        }
    }

    private Stream<IType> findTypes(String namePrefix, String packageName) {
        return this.findTypes(namePrefix, 0, packageName);
    }

    private Stream<IType> findTypes(String namePrefix, int typeMatchRule, String packageName) {
        if (namePrefix == null) {
            namePrefix = "";
        }
        final ArrayList types = new ArrayList();
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope(new IJavaElement[]{this.modelUnit.getJavaProject()});
        TypeNameMatchRequestor typeRequestor = new TypeNameMatchRequestor(){

            @Override
            public void acceptTypeNameMatch(TypeNameMatch match) {
                types.add(match.getType());
            }
        };
        try {
            new SearchEngine(this.modelUnit.getOwner()).searchAllTypeNames(packageName == null ? null : packageName.toCharArray(), 0, namePrefix.toCharArray(), 1 | (this.assistOptions.substringMatch ? 512 : 0) | (this.assistOptions.subwordMatch ? 1024 : 0) | (this.assistOptions.camelCaseMatch ? 128 : 0), typeMatchRule, searchScope, typeRequestor, 3, null);
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
        }
        return types.stream();
    }

    private void processMembers(ASTNode referencedFrom, ITypeBinding typeBinding, Bindings scope, boolean isStaticContext) {
        AbstractTypeDeclaration parentType = (AbstractTypeDeclaration)DOMCompletionUtil.findParent(referencedFrom, new int[]{81, 55, 71, 103});
        if (parentType == null) {
            return;
        }
        ITypeBinding referencedFromBinding = parentType.resolveBinding();
        boolean includePrivate = referencedFromBinding.getKey().equals(typeBinding.getKey());
        MethodDeclaration methodDeclaration = (MethodDeclaration)DOMCompletionUtil.findParent(referencedFrom, new int[]{31});
        boolean includeProtected = referencedFromBinding.getKey().equals(typeBinding.getKey()) ? true : (methodDeclaration != null && (methodDeclaration.getModifiers() & 8) != 0 ? false : DOMCompletionEngine.findInSupers(referencedFromBinding, typeBinding));
        this.processMembers(typeBinding, scope, includePrivate, includeProtected, referencedFromBinding.getPackage().getKey(), isStaticContext, typeBinding.isInterface(), new HashSet<String>(), new HashSet<String>());
    }

    private void processMembers(ITypeBinding typeBinding, Bindings scope, boolean includePrivate, boolean includeProtected, String originalPackageKey, boolean isStaticContext, boolean canUseAbstract, Set<String> impossibleMethods, Set<String> impossibleFields) {
        ITypeBinding superclassBinding;
        Object object;
        if (typeBinding == null) {
            return;
        }
        Predicate<IBinding> accessFilter = binding -> {
            if (binding == null) {
                return false;
            }
            boolean field = binding instanceof IVariableBinding;
            if (field) {
                if (impossibleFields.contains(binding.getName())) {
                    return false;
                }
            } else {
                if (impossibleMethods.contains(binding.getName())) {
                    return false;
                }
                if (((IMethodBinding)binding).isConstructor()) {
                    return false;
                }
            }
            if (!includePrivate && (binding.getModifiers() & 2) != 0 || !includeProtected && (binding.getModifiers() & 4) != 0 || (binding.getModifiers() & 7) == 0 && !originalPackageKey.equals(typeBinding.getPackage().getKey()) || isStaticContext && (binding.getModifiers() & 8) == 0 || !canUseAbstract && (binding.getModifiers() & 0x400) != 0) {
                if (field) {
                    impossibleFields.add(binding.getName());
                } else {
                    impossibleMethods.add(binding.getName());
                }
                return false;
            }
            return true;
        };
        ASTNode foundDecl = DOMCompletionUtil.findParent(this.toComplete, new int[]{23, 31, 86, 8});
        if (includePrivate && foundDecl instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)foundDecl;
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)DOMCompletionUtil.findParent(this.toComplete, new int[]{59});
            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)((CompilationUnit)this.toComplete.getRoot()).findDeclaringNode(typeBinding);
            int indexOfField = typeDecl.bodyDeclarations().indexOf(fieldDeclaration);
            if (indexOfField < 0) {
                Arrays.stream(typeBinding.getDeclaredFields()).filter(accessFilter).forEach(scope::add);
            } else {
                int i = 0;
                while (i < indexOfField + 1) {
                    object = typeDecl.bodyDeclarations().get(i);
                    if (object instanceof FieldDeclaration) {
                        FieldDeclaration fieldDecl = (FieldDeclaration)object;
                        List frags = fieldDecl.fragments();
                        int fragIterEndpoint = frags.indexOf(fragment);
                        if (fragIterEndpoint == -1) {
                            fragIterEndpoint = frags.size();
                        }
                        int j = 0;
                        while (j < fragIterEndpoint) {
                            IVariableBinding varBinding = ((VariableDeclarationFragment)frags.get(j)).resolveBinding();
                            if (accessFilter.test(varBinding)) {
                                scope.add(varBinding);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        } else {
            Arrays.stream(typeBinding.getDeclaredFields()).filter(accessFilter).forEach(scope::add);
        }
        Arrays.stream(typeBinding.getDeclaredMethods()).filter(accessFilter).sorted(Comparator.comparing(this::getSignature).reversed()).forEach(scope::add);
        if (typeBinding.getInterfaces() != null) {
            object = typeBinding.getInterfaces();
            int n = ((ITypeBinding[])object).length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding superinterfaceBinding = object[n2];
                this.processMembers(superinterfaceBinding, scope, false, includeProtected, originalPackageKey, isStaticContext, true, impossibleMethods, impossibleFields);
                ++n2;
            }
        }
        if ((superclassBinding = typeBinding.getSuperclass()) != null) {
            this.processMembers(superclassBinding, scope, false, includeProtected, originalPackageKey, isStaticContext, true, impossibleMethods, impossibleFields);
        }
    }

    private String getSignature(IMethodBinding method) {
        return method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(ITypeBinding::getName).collect(Collectors.joining(",")) + ")";
    }

    private static boolean findInSupers(ITypeBinding root, ITypeBinding toFind) {
        ITypeBinding superFind = toFind.getErasure();
        if (superFind != null) {
            String keyToFind = superFind.getKey();
            return DOMCompletionEngine.findInSupers(root, keyToFind);
        }
        return false;
    }

    private static boolean findInSupers(ITypeBinding root, String keyOfTypeToFind) {
        String keyToFind = keyOfTypeToFind;
        LinkedList<ITypeBinding> toCheck = new LinkedList<ITypeBinding>();
        HashSet<String> alreadyChecked = new HashSet<String>();
        toCheck.add(root.getErasure());
        while (!toCheck.isEmpty()) {
            ITypeBinding current = (ITypeBinding)toCheck.poll();
            String currentKey = current.getErasure().getKey();
            if (alreadyChecked.contains(currentKey)) continue;
            alreadyChecked.add(currentKey);
            if (currentKey.equals(keyToFind)) {
                return true;
            }
            ITypeBinding[] iTypeBindingArray = current.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding superInterface = iTypeBindingArray[n2];
                toCheck.add(superInterface);
                ++n2;
            }
            if (current.getSuperclass() == null) continue;
            toCheck.add(current.getSuperclass());
        }
        return false;
    }

    private CompletionProposal toProposal(IBinding binding) {
        return this.toProposal(binding, binding.getName());
    }

    private CompletionProposal toProposal(IBinding binding, String completion) {
        IVariableBinding field;
        ITypeBinding iTypeBinding;
        boolean inJavadoc;
        IJavaElement iJavaElement;
        if (binding instanceof ITypeBinding && (iJavaElement = binding.getJavaElement()) instanceof IType) {
            IType type = (IType)iJavaElement;
            return this.toProposal(type);
        }
        int kind = -1;
        boolean bl = inJavadoc = DOMCompletionUtil.findParent(this.toComplete, new int[]{29}) != null;
        if (binding instanceof ITypeBinding) {
            kind = 9;
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding m = (IMethodBinding)binding;
            kind = DOMCompletionUtil.findParent(this.toComplete, new int[]{90}) != null ? 12 : (m.getDeclaringClass() != null && m.getDeclaringClass().isAnnotation() ? 13 : 6);
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            kind = variableBinding.isField() ? 2 : 5;
        }
        InternalCompletionProposal res = new InternalCompletionProposal(kind, this.offset);
        res.setName(binding.getName().toCharArray());
        if (kind == 6) {
            completion = (String)completion + "()";
        }
        res.setCompletion(((String)completion).toCharArray());
        res.setFlags(binding.getModifiers());
        boolean inheritedValue = false;
        if (kind == 6 || kind == 12) {
            List<String> paramNames;
            methodBinding = (IMethodBinding)binding;
            if (inJavadoc) {
                StringBuilder javadocCompletion = new StringBuilder();
                javadocCompletion.append(binding.getName().toCharArray());
                javadocCompletion.append('(');
                boolean isVarargs = methodBinding.isVarargs();
                int p = 0;
                int ln = methodBinding.getParameterTypes().length;
                while (p < ln) {
                    if (p > 0) {
                        javadocCompletion.append(", ");
                    }
                    ITypeBinding argTypeBinding = methodBinding.getParameterTypes()[p];
                    if (isVarargs && p == ln - 1) {
                        javadocCompletion.append(argTypeBinding.getElementType().getName());
                        javadocCompletion.append("...");
                    } else {
                        javadocCompletion.append(argTypeBinding.getName());
                    }
                    ++p;
                }
                javadocCompletion.append(')');
                res.setCompletion(javadocCompletion.toString().toCharArray());
            }
            if (methodBinding.isConstructor()) {
                res.setIsContructor(true);
            }
            if ((paramNames = DOMCompletionEngineMethodDeclHandler.findVariableNames(methodBinding)).isEmpty()) {
                res.setParameterNames(null);
            } else {
                res.setParameterNames((char[][])paramNames.stream().map(String::toCharArray).toArray(i -> new char[i][]));
            }
            res.setParameterTypeNames((char[][])Stream.of(methodBinding.getParameterNames()).map(String::toCharArray).toArray(n -> new char[n][]));
            res.setSignature(DOMCompletionEngineBuilder.getSignature(methodBinding));
            if (!methodBinding.getDeclaringClass().getQualifiedName().isEmpty()) {
                res.setDeclarationSignature(Signature.createTypeSignature(methodBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray());
            }
            if (Modifier.isStatic(methodBinding.getModifiers()) && this.toComplete.getLocationInParent() != QualifiedName.NAME_PROPERTY && this.toComplete.getLocationInParent() != FieldAccess.NAME_PROPERTY && !this.isStaticallyImported(binding)) {
                ITypeBinding topLevelClass = methodBinding.getDeclaringClass();
                while (topLevelClass.getDeclaringClass() != null) {
                    topLevelClass = topLevelClass.getDeclaringClass();
                }
                ITypeBinding methodTypeBinding = methodBinding.getDeclaringClass();
                AbstractTypeDeclaration parentTypeDecl = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete);
                if (parentTypeDecl != null) {
                    completionContextTypeBinding = parentTypeDecl.resolveBinding();
                    while (completionContextTypeBinding != null) {
                        if (completionContextTypeBinding.getErasure().getKey().equals(methodTypeBinding.getErasure().getKey())) {
                            inheritedValue = true;
                            break;
                        }
                        completionContextTypeBinding = completionContextTypeBinding.getSuperclass();
                    }
                }
                if (!inheritedValue && !this.modelUnit.getType(topLevelClass.getName()).exists()) {
                    if (this.qualifiedPrefix.equals(this.prefix) && !this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.codeComplete.suggestStaticImports", true).equals("disabled")) {
                        res.setRequiredProposals(new CompletionProposal[]{this.toStaticImportProposal(methodBinding)});
                    } else {
                        directParentClass = methodBinding.getDeclaringClass();
                        res.setRequiredProposals(new CompletionProposal[]{this.toStaticImportProposal(directParentClass)});
                        builder = new StringBuilder(new String(res.getCompletion()));
                        builder.insert(0, '.');
                        builder.insert(0, directParentClass.getName());
                        res.setCompletion(builder.toString().toCharArray());
                    }
                }
            }
        } else if (kind == 5) {
            variableBinding = (IVariableBinding)binding;
            res.setSignature(Signature.createTypeSignature(variableBinding.getType().getQualifiedName().toCharArray(), true).toCharArray());
        } else if (kind == 2) {
            variableBinding = (IVariableBinding)binding;
            ITypeBinding declaringClass = variableBinding.getDeclaringClass();
            res.setSignature(Signature.createTypeSignature(variableBinding.getType().getQualifiedName().toCharArray(), true).toCharArray());
            if (declaringClass != null && !declaringClass.getQualifiedName().isEmpty()) {
                char[] declSignature = Signature.createTypeSignature(declaringClass.getQualifiedName().toCharArray(), true).toCharArray();
                res.setDeclarationSignature(declSignature);
            } else {
                res.setDeclarationSignature(new char[0]);
            }
            if ((variableBinding.getModifiers() & 8) != 0) {
                ITypeBinding topLevelClass = variableBinding.getDeclaringClass();
                while (topLevelClass.getDeclaringClass() != null) {
                    topLevelClass = topLevelClass.getDeclaringClass();
                }
                ITypeBinding variableTypeBinding = variableBinding.getDeclaringClass();
                AbstractTypeDeclaration parentTypeDecl = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete);
                if (parentTypeDecl != null) {
                    completionContextTypeBinding = parentTypeDecl.resolveBinding();
                    while (completionContextTypeBinding != null) {
                        if (completionContextTypeBinding.getErasure().getKey().equals(variableTypeBinding.getErasure().getKey())) {
                            inheritedValue = true;
                            break;
                        }
                        completionContextTypeBinding = completionContextTypeBinding.getSuperclass();
                    }
                }
                if (!inheritedValue && !this.modelUnit.getType(topLevelClass.getName()).exists()) {
                    if (this.qualifiedPrefix.equals(this.prefix) && !this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.codeComplete.suggestStaticImports", true).equals("disabled")) {
                        if (!(this.isStaticallyImported(variableBinding) || variableBinding.isEnumConstant() && Set.of(SwitchCase.EXPRESSION_PROPERTY, SwitchCase.EXPRESSIONS2_PROPERTY).contains(this.toComplete.getLocationInParent()))) {
                            res.setRequiredProposals(new CompletionProposal[]{this.toStaticImportProposal(variableBinding)});
                        }
                    } else {
                        directParentClass = variableBinding.getDeclaringClass();
                        res.setRequiredProposals(new CompletionProposal[]{this.toStaticImportProposal(directParentClass)});
                        if (this.toComplete.getLocationInParent() != QualifiedName.NAME_PROPERTY && this.toComplete.getLocationInParent() != FieldAccess.NAME_PROPERTY && this.toComplete.getLocationInParent() != NameQualifiedType.NAME_PROPERTY) {
                            builder = new StringBuilder(new String(res.getCompletion()));
                            builder.insert(0, '.');
                            builder.insert(0, directParentClass.getName());
                            res.setCompletion(builder.toString().toCharArray());
                        }
                    }
                }
            }
        } else if (kind == 9) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            res.setSignature(Signature.createTypeSignature(typeBinding.getQualifiedName().toCharArray(), true).toCharArray());
        } else if (kind == 13) {
            methodBinding = (IMethodBinding)binding;
            StringBuilder annotationCompletion = new StringBuilder((String)completion);
            boolean surroundWithSpaces = "insert".equals(this.unit.getJavaElement().getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true));
            if (surroundWithSpaces) {
                annotationCompletion.append(' ');
            }
            annotationCompletion.append('=');
            if (surroundWithSpaces) {
                annotationCompletion.append(' ');
            }
            res.setCompletion(annotationCompletion.toString().toCharArray());
            res.setSignature(Signature.createTypeSignature(this.qualifiedTypeName(methodBinding.getReturnType()), true).toCharArray());
            res.setReceiverSignature(Signature.createTypeSignature(methodBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray());
            res.setDeclarationSignature(Signature.createTypeSignature(methodBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray());
        } else {
            res.setSignature(new char[0]);
            res.setReceiverSignature(new char[0]);
            res.setDeclarationSignature(new char[0]);
        }
        if (this.toComplete instanceof SimpleName && !this.toComplete.getLocationInParent().getId().equals(QualifiedName.QUALIFIER_PROPERTY.getId()) && !this.prefix.isEmpty() && !inJavadoc) {
            res.setReplaceRange(this.toComplete.getStartPosition(), this.offset);
        } else {
            this.setRange(res);
        }
        IJavaElement element = binding.getJavaElement();
        if (element != null) {
            res.setDeclarationTypeName(((IType)element.getAncestor(7)).getFullyQualifiedName().toCharArray());
            res.setDeclarationPackageName(element.getAncestor(4).getElementName().toCharArray());
        }
        res.completionEngine = this.nestedEngine;
        res.nameLookup = this.nameEnvironment.nameLookup;
        boolean isInQualifiedName = this.toComplete.getLocationInParent() == QualifiedName.NAME_PROPERTY || this.toComplete.getLocationInParent() == FieldAccess.NAME_PROPERTY;
        int n2 = CompletionEngine.computeBaseRelevance() + CompletionEngine.computeRelevanceForResolution() + this.nestedEngine.computeRelevanceForInterestingProposal() + (res.isConstructor ? 0 : CompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), binding.getName().toCharArray(), this.assistOptions));
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding;
            iTypeBinding = typeBinding = (ITypeBinding)binding;
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            iTypeBinding = methodBinding.getReturnType();
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            iTypeBinding = variableBinding.getType();
        } else {
            iTypeBinding = this.toComplete.getAST().resolveWellKnownType(Object.class.getName());
        }
        res.setRelevance(n2 + this.computeRelevanceForExpectingType(iTypeBinding) + (isInQualifiedName || res.getRequiredProposals() != null || inJavadoc ? 0 : this.computeRelevanceForQualification(false)) + CompletionEngine.computeRelevanceForRestrictions(0) + (this.insideQualifiedReference() && !this.staticOnly() && !Modifier.isStatic(binding.getModifiers()) || inJavadoc && !res.isConstructor ? 11 : 0) + (!this.staticOnly() || inheritedValue ? 0 : 2) + (binding instanceof IVariableBinding && (field = (IVariableBinding)binding).isEnumConstant() ? 25 : 0));
        if (res.getRequiredProposals() != null) {
            CompletionProposal[] completionProposalArray = res.getRequiredProposals();
            int n3 = completionProposalArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CompletionProposal req = completionProposalArray[n4];
                req.setRelevance(res.getRelevance());
                ++n4;
            }
        }
        return res;
    }

    private boolean isStaticallyImported(IBinding binding) {
        return this.unit.imports().stream().filter(ImportDeclaration::isStatic).map(ImportDeclaration::resolveBinding).anyMatch(importBinding -> binding.isEqualTo((IBinding)importBinding) || this.getDeclaringClass(binding).isEqualTo((IBinding)importBinding));
    }

    private boolean insideQualifiedReference() {
        SimpleName simple;
        ASTNode aSTNode;
        return this.toComplete instanceof QualifiedName || (aSTNode = this.toComplete) instanceof SimpleName && ((simple = (SimpleName)aSTNode).getParent() instanceof QualifiedName || simple.getParent() instanceof FieldAccess);
    }

    private boolean staticOnly() {
        if (this.toComplete.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            return DOMCodeSelector.resolveBinding(((QualifiedName)this.toComplete.getParent()).getQualifier()) instanceof ITypeBinding;
        }
        return false;
    }

    private String qualifiedTypeName(ITypeBinding typeBinding) {
        if (typeBinding.isTypeVariable()) {
            return typeBinding.getName();
        }
        return typeBinding.getQualifiedName();
    }

    private CompletionProposal toProposal(IType type) {
        InternalCompletionProposal res = new InternalCompletionProposal(9, this.offset);
        char[] simpleName = type.getElementName().toCharArray();
        char[] signature = Signature.createTypeSignature(type.getFullyQualifiedName(), true).toCharArray();
        res.setSignature(signature);
        IJavaElement cursor = type;
        while (cursor != null && !(cursor instanceof IPackageFragment)) {
            cursor = cursor.getParent();
        }
        IPackageFragment packageFrag = (IPackageFragment)cursor;
        if (packageFrag != null) {
            res.setDeclarationSignature(packageFrag.getElementName().toCharArray());
        }
        cursor = type;
        StringBuilder completion = new StringBuilder();
        AbstractTypeDeclaration parentTypeDeclaration = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete);
        if (parentTypeDeclaration != null && type.getFullyQualifiedName().equals(((IType)parentTypeDeclaration.resolveBinding().getJavaElement()).getFullyQualifiedName())) {
            completion.insert(0, cursor.getElementName());
        } else {
            ASTNode currentName;
            ASTNode aSTNode = currentName = this.toComplete instanceof Name ? this.toComplete : null;
            while (cursor instanceof IType) {
                IJavaElement currentType = cursor;
                if (currentName != null && Objects.equals(currentName.toString(), currentType.getFullyQualifiedName())) break;
                if (!completion.isEmpty()) {
                    completion.insert(0, '.');
                }
                completion.insert(0, cursor.getElementName());
                cursor = cursor.getParent();
                if (currentName != null && currentName.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                    currentName = ((QualifiedName)currentName.getParent()).getQualifier();
                    continue;
                }
                currentName = null;
            }
        }
        AbstractTypeDeclaration parentType = DOMCompletionUtil.findParentTypeDeclaration(this.toComplete);
        Javadoc javadoc = (Javadoc)DOMCompletionUtil.findParent(this.toComplete, new int[]{29});
        if (parentType != null || javadoc != null) {
            IPackageBinding currentPackageBinding;
            IPackageBinding iPackageBinding = currentPackageBinding = parentType == null ? null : parentType.resolveBinding().getPackage();
            if (packageFrag != null && (currentPackageBinding == null || !packageFrag.getElementName().equals(currentPackageBinding.getName()) && !packageFrag.getElementName().equals("java.lang"))) {
                completion.insert(0, '.');
                completion.insert(0, packageFrag.getElementName());
            }
        } else {
            int lastOffset = this.toComplete.getStartPosition() + this.toComplete.getLength();
            if (lastOffset >= this.cuBuffer.getLength() || this.cuBuffer.getChar(lastOffset) != ';') {
                completion.append(';');
            }
        }
        res.setCompletion(completion.toString().toCharArray());
        if (this.toComplete instanceof FieldAccess || this.prefix.isEmpty()) {
            res.setReplaceRange(this.offset, this.offset);
        } else if (this.toComplete instanceof MarkerAnnotation) {
            res.setReplaceRange(this.toComplete.getStartPosition() + 1, this.toComplete.getStartPosition() + this.toComplete.getLength());
        } else {
            SimpleName currentName;
            ASTNode aSTNode = this.toComplete;
            if (aSTNode instanceof SimpleName && FAKE_IDENTIFIER.equals((currentName = (SimpleName)aSTNode).toString())) {
                res.setReplaceRange(this.offset, this.offset);
            } else if (this.toComplete instanceof SimpleName) {
                res.setReplaceRange(this.toComplete.getStartPosition(), this.toComplete.getStartPosition() + this.toComplete.getLength());
            } else {
                res.setReplaceRange(this.toComplete.getStartPosition(), this.offset);
            }
        }
        try {
            res.setFlags(type.getFlags());
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
        }
        if (this.toComplete instanceof SimpleName) {
            res.setTokenRange(this.toComplete.getStartPosition(), this.toComplete.getStartPosition() + this.toComplete.getLength());
        } else if (this.toComplete instanceof MarkerAnnotation) {
            res.setTokenRange(this.offset, this.offset);
        }
        boolean nodeInImports = DOMCompletionUtil.findParent(this.toComplete, new int[]{26}) != null;
        boolean fromCurrentCU = this.modelUnit.equals(type.getCompilationUnit());
        boolean typeIsImported = false;
        boolean inSamePackage = false;
        try {
            typeIsImported = Stream.of(this.modelUnit.getImports()).anyMatch(id -> id.getElementName().equals(type.getFullyQualifiedName()));
            IPackageDeclaration[] packageDecls = this.modelUnit.getPackageDeclarations();
            inSamePackage = packageDecls != null && packageDecls.length > 0 ? this.modelUnit.getPackageDeclarations()[0].getElementName().equals(type.getPackageFragment().getElementName()) : type.getPackageFragment().getElementName().isEmpty();
        }
        catch (JavaModelException packageDecls) {
            // empty catch block
        }
        res.completionEngine = this.nestedEngine;
        res.nameLookup = this.nameEnvironment.nameLookup;
        int relevance = 39 + this.computeRelevanceForQualification(!type.getFullyQualifiedName().startsWith("java.") && !nodeInImports && !fromCurrentCU && !inSamePackage && !typeIsImported) + (type.getFullyQualifiedName().startsWith("java.") ? 2 : 0) + (this.expectedTypes.getExpectedTypes().stream().map(ITypeBinding::getQualifiedName).anyMatch(type.getFullyQualifiedName()::equals) ? 30 : (this.expectedTypes.getExpectedTypes().stream().map(ITypeBinding::getQualifiedName).anyMatch(Object.class.getName()::equals) ? 20 : 0)) + DOMCompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), simpleName, this.assistOptions);
        try {
            if (type.isAnnotation()) {
                ASTNode current = this.toComplete;
                while (current instanceof Name) {
                    current = current.getParent();
                }
                if (current instanceof Annotation) {
                    Annotation annotation = (Annotation)current;
                    relevance += 20;
                    IAnnotation targetAnnotation = type.getAnnotation(Target.class.getName());
                    if (targetAnnotation == null || !targetAnnotation.exists()) {
                        relevance += 5;
                    } else {
                        IMemberValuePair[] memberValuePairs = targetAnnotation.getMemberValuePairs();
                        if (memberValuePairs != null && Stream.of(memberValuePairs).filter(memberValue -> "value".equals(memberValue.getMemberName())).map(IMemberValuePair::getValue).anyMatch(target -> DOMCompletionEngine.matchHostType(annotation.getParent(), target))) {
                            relevance += 5;
                        }
                    }
                }
            }
        }
        catch (JavaModelException ex) {
            ILog.get().warn(ex.getMessage(), (Throwable)((Object)ex));
        }
        if (DOMCompletionEngine.isInExtendsOrImplements(this.toComplete) != null) {
            try {
                if (type.isAnnotation()) {
                    relevance += 20;
                }
                if (type.isInterface()) {
                    relevance += 20;
                }
                if (type.isClass()) {
                    relevance += 20;
                }
            }
            catch (JavaModelException ex) {
                // empty catch block
            }
        }
        res.setRelevance(relevance);
        if (parentType != null) {
            String packageName = "";
            try {
                if (this.modelUnit.getPackageDeclarations() != null && this.modelUnit.getPackageDeclarations().length > 0) {
                    packageName = this.modelUnit.getPackageDeclarations()[0].getElementName();
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (!packageName.equals(type.getPackageFragment().getElementName())) {
                res.setRequiredProposals(new CompletionProposal[]{this.toImportProposal(simpleName, signature, type.getPackageFragment().getElementName().toCharArray())});
            }
        }
        return res;
    }

    private static boolean matchHostType(ASTNode host, Object targetAnnotationElementValue) {
        return false;
    }

    private CompletionProposal toNewMethodProposal(ITypeBinding parentType, String newMethodName) {
        InternalCompletionProposal res = this.createProposal(11);
        res.setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(parentType));
        res.setSignature(Signature.createMethodSignature(CharOperation.NO_CHAR_CHAR, Signature.createCharArrayTypeSignature(VOID, true)));
        res.setDeclarationPackageName(parentType.getPackage().getName().toCharArray());
        res.setDeclarationTypeName(parentType.getQualifiedName().toCharArray());
        res.setTypeName(VOID);
        res.setName(newMethodName.toCharArray());
        res.setCompletion(newMethodName.toCharArray());
        res.setFlags(1);
        this.setRange(res);
        int relevance = 30;
        ++relevance;
        relevance += 5;
        res.setRelevance(relevance += 3);
        return res;
    }

    private List<CompletionProposal> toConstructorProposals(IType type, ASTNode referencedFrom, boolean exactType) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        AbstractTypeDeclaration parentType = (AbstractTypeDeclaration)DOMCompletionUtil.findParent(referencedFrom, new int[]{81, 55, 71, 103});
        if (parentType == null) {
            return proposals;
        }
        ITypeBinding referencedFromBinding = parentType.resolveBinding();
        boolean includePrivate = referencedFromBinding.getKey().equals(type.getKey());
        MethodDeclaration methodDeclaration = (MethodDeclaration)DOMCompletionUtil.findParent(referencedFrom, new int[]{31});
        boolean includeProtected = referencedFromBinding.getKey().equals(type.getKey()) ? true : (methodDeclaration != null && (methodDeclaration.getModifiers() & 8) != 0 ? false : DOMCompletionEngine.findInSupers(referencedFromBinding, type.getKey()));
        IPackageFragment packageFragment = (IPackageFragment)type.getAncestor(4);
        String packageKey = packageFragment == null ? "" : packageFragment.getElementName().replace('.', '/');
        boolean isInterface = false;
        try {
            isInterface = type.isInterface();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (!this.requestor.isIgnored(27) && isInterface) {
            proposals.add(this.toAnonymousConstructorProposal(type));
        } else {
            try {
                List<IMethod> constructors = Stream.of(type.getMethods()).filter(method -> {
                    try {
                        return method.isConstructor();
                    }
                    catch (JavaModelException e) {
                        return false;
                    }
                }).toList();
                if (!constructors.isEmpty()) {
                    for (IMethod constructor : constructors) {
                        if (!((constructor.getFlags() & 1) != 0 || includeProtected && (constructor.getFlags() & 4) != 0 || includePrivate && (constructor.getFlags() & 2) != 0) && ((constructor.getFlags() & 7) != 0 || !packageKey.equals(referencedFromBinding.getPackage().getKey()))) continue;
                        proposals.add(this.toConstructorProposal(constructor, exactType));
                    }
                } else {
                    proposals.add(this.toDefaultConstructorProposal(type, exactType));
                }
            }
            catch (JavaModelException e) {
                ILog.get().error("Model exception while trying to collect constructors for completion", (Throwable)((Object)e));
            }
        }
        return proposals;
    }

    private CompletionProposal toConstructorProposal(IMethod method, boolean isExactType) throws JavaModelException {
        InternalCompletionProposal res = this.createProposal(26);
        IType declaringClass = method.getDeclaringType();
        char[] simpleName = method.getElementName().toCharArray();
        res.setCompletion(new char[]{'(', ')'});
        res.setName(simpleName);
        char[] signature = method.getKey().substring(method.getKey().indexOf(46) + 1).toCharArray();
        res.setSignature(signature);
        res.setOriginalSignature(signature);
        IPackageFragment packageFragment = (IPackageFragment)declaringClass.getAncestor(4);
        res.setDeclarationSignature(Signature.createTypeSignature(declaringClass.getFullyQualifiedName(), true).toCharArray());
        res.setDeclarationTypeName(simpleName);
        res.setDeclarationPackageName(packageFragment.getElementName().toCharArray());
        res.setParameterPackageNames(CharOperation.NO_CHAR_CHAR);
        res.setParameterTypeNames(CharOperation.NO_CHAR_CHAR);
        if (method.getParameterNames().length == 0) {
            res.setParameterNames(CharOperation.NO_CHAR_CHAR);
        } else {
            char[][] paramNamesCharChar = (char[][])Stream.of(method.getParameterNames()).map(String::toCharArray).toArray(n -> new char[n][]);
            res.setParameterNames(paramNamesCharChar);
        }
        res.setIsContructor(true);
        if (declaringClass.getTypeParameters() != null && declaringClass.getTypeParameters().length > 0) {
            res.setDeclarationTypeVariables((char[][])Stream.of(declaringClass.getTypeParameters()).map(a -> a.getElementName().toCharArray()).toArray(n -> new char[n][]));
        }
        res.setCompatibleProposal(true);
        res.setReplaceRange(this.offset, this.offset);
        res.setTokenRange(this.toComplete.getStartPosition(), this.offset);
        res.setFlags(method.getFlags());
        int relevance = 36 + (isExactType ? 30 : 0) + 3 + 3 + 3 + DOMCompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), simpleName, this.assistOptions);
        res.setRelevance(relevance);
        CompletionProposal typeProposal = this.toProposal(declaringClass);
        if (this.toComplete instanceof SimpleName) {
            typeProposal.setReplaceRange(this.toComplete.getStartPosition(), this.offset);
            typeProposal.setTokenRange(this.toComplete.getStartPosition(), this.offset);
        } else {
            typeProposal.setReplaceRange(this.offset, this.offset);
            typeProposal.setTokenRange(this.offset, this.offset);
        }
        typeProposal.setRequiredProposals(null);
        typeProposal.setRelevance(relevance);
        res.setRequiredProposals(new CompletionProposal[]{typeProposal});
        return res;
    }

    private CompletionProposal toDefaultConstructorProposal(IType type, boolean isExactType) throws JavaModelException {
        InternalCompletionProposal res = this.createProposal(26);
        char[] simpleName = type.getElementName().toCharArray();
        res.setCompletion(new char[]{'(', ')'});
        res.setName(simpleName);
        char[] signature = Signature.createMethodSignature(CharOperation.NO_CHAR_CHAR, new char[]{'V'});
        res.setSignature(signature);
        res.setOriginalSignature(signature);
        IPackageFragment packageFragment = (IPackageFragment)type.getAncestor(4);
        res.setDeclarationSignature(Signature.createTypeSignature(type.getFullyQualifiedName(), true).toCharArray());
        res.setDeclarationTypeName(simpleName);
        res.setDeclarationPackageName(packageFragment.getElementName().toCharArray());
        res.setParameterPackageNames(CharOperation.NO_CHAR_CHAR);
        res.setParameterTypeNames(CharOperation.NO_CHAR_CHAR);
        res.setParameterNames(CharOperation.NO_CHAR_CHAR);
        res.setIsContructor(true);
        if (type.getTypeParameters() != null && type.getTypeParameters().length > 0) {
            res.setDeclarationTypeVariables((char[][])Stream.of(type.getTypeParameters()).map(a -> a.getElementName().toCharArray()).toArray(n -> new char[n][]));
        }
        res.setCompatibleProposal(true);
        res.setReplaceRange(this.offset, this.offset);
        res.setTokenRange(this.toComplete.getStartPosition(), this.offset);
        res.setFlags(type.getFlags() & 7);
        int relevance = 36 + (isExactType ? 30 : 0) + 3 + 3 + 3;
        res.setRelevance(relevance);
        CompletionProposal typeProposal = this.toProposal(type);
        if (this.toComplete instanceof SimpleName) {
            typeProposal.setReplaceRange(this.toComplete.getStartPosition(), this.offset);
            typeProposal.setTokenRange(this.toComplete.getStartPosition(), this.offset);
        } else {
            typeProposal.setReplaceRange(this.offset, this.offset);
            typeProposal.setTokenRange(this.offset, this.offset);
        }
        typeProposal.setRequiredProposals(null);
        typeProposal.setRelevance(relevance);
        res.setRequiredProposals(new CompletionProposal[]{typeProposal});
        return res;
    }

    private CompletionProposal toAnonymousConstructorProposal(IType type) {
        InternalCompletionProposal res = this.createProposal(27);
        res.setDeclarationSignature(Signature.createTypeSignature(type.getFullyQualifiedName(), true).toCharArray());
        res.setDeclarationKey(type.getKey().toCharArray());
        res.setSignature(CompletionEngine.createMethodSignature(CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR, CharOperation.NO_CHAR));
        IPackageFragment packageFragment = (IPackageFragment)type.getAncestor(4);
        res.setDeclarationPackageName(packageFragment.getElementName().toCharArray());
        res.setDeclarationTypeName(type.getElementName().toCharArray());
        res.setName(type.getElementName().toCharArray());
        int relevance = 30;
        ++relevance;
        relevance += 5;
        relevance += DOMCompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), type.getElementName().toCharArray(), this.assistOptions);
        relevance += 30;
        relevance += 3;
        relevance += 3;
        if (packageFragment.getElementName().startsWith("java.")) {
            relevance += 2;
        }
        try {
            if (type.isClass()) {
                relevance += 20;
            } else if (type.isEnum()) {
                relevance += 20;
            } else if (type.isInterface()) {
                relevance += 20;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        InternalCompletionProposal typeProposal = this.createProposal(9);
        typeProposal.setDeclarationSignature(packageFragment.getElementName().toCharArray());
        typeProposal.setSignature(Signature.createTypeSignature(type.getFullyQualifiedName(), true).toCharArray());
        typeProposal.setPackageName(packageFragment.getElementName().toCharArray());
        typeProposal.setTypeName(type.getElementName().toCharArray());
        typeProposal.setCompletion(type.getElementName().toCharArray());
        try {
            typeProposal.setFlags(type.getFlags());
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.setRange(typeProposal);
        typeProposal.setRelevance(relevance);
        res.setRequiredProposals(new CompletionProposal[]{typeProposal});
        res.setCompletion(new char[]{'(', ')'});
        res.setFlags(1);
        res.setReplaceRange(this.offset, this.offset);
        res.setTokenRange(this.toComplete.getStartPosition(), this.offset);
        res.setRelevance(relevance);
        return res;
    }

    private CompletionProposal toImportProposal(char[] simpleName, char[] signature, char[] packageName) {
        InternalCompletionProposal res = new InternalCompletionProposal(23, this.offset);
        res.setName(simpleName);
        res.setSignature(signature);
        res.setPackageName(packageName);
        res.completionEngine = this.nestedEngine;
        res.nameLookup = this.nameEnvironment.nameLookup;
        return res;
    }

    private CompletionProposal toStaticImportProposal(IBinding binding) {
        InternalCompletionProposal res = null;
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            res = this.createProposal(22);
            res.setName(methodBinding.getName().toCharArray());
            res.setSignature(DOMCompletionEngineBuilder.getSignature(methodBinding));
            res.setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(methodBinding.getDeclaringClass()));
            res.setSignature(DOMCompletionEngineBuilder.getSignature(methodBinding));
            if (methodBinding != methodBinding.getMethodDeclaration()) {
                res.setOriginalSignature(DOMCompletionEngineBuilder.getSignature(methodBinding.getMethodDeclaration()));
            }
            res.setDeclarationPackageName(methodBinding.getDeclaringClass().getPackage().getName().toCharArray());
            res.setDeclarationTypeName(methodBinding.getDeclaringClass().getQualifiedName().toCharArray());
            res.setParameterPackageNames((char[][])Stream.of(methodBinding.getParameterTypes()).map(typeBinding -> {
                if (typeBinding.getPackage() != null) {
                    return typeBinding.getPackage().getName().toCharArray();
                }
                return CharOperation.NO_CHAR;
            }).toArray(n -> new char[n][]));
            res.setParameterTypeNames((char[][])Stream.of(methodBinding.getParameterTypes()).map(typeBinding -> typeBinding.getName().toCharArray()).toArray(n -> new char[n][]));
            if (methodBinding.getReturnType().getPackage() != null) {
                res.setPackageName(methodBinding.getReturnType().getPackage().getName().toCharArray());
            }
            res.setTypeName(methodBinding.getReturnType().getQualifiedName().toCharArray());
            res.setName(methodBinding.getName().toCharArray());
            res.setCompletion(("import static " + methodBinding.getDeclaringClass().getQualifiedName() + "." + methodBinding.getName() + ";\n").toCharArray());
            res.setFlags(methodBinding.getModifiers());
            res.setAdditionalFlags(1);
            res.setParameterNames((char[][])Stream.of(methodBinding.getParameterNames()).map(String::toCharArray).toArray(n -> new char[n][]));
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            res = this.createProposal(21);
            res.setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(variableBinding.getDeclaringClass()));
            res.setSignature(Signature.createTypeSignature(variableBinding.getType().getQualifiedName().toCharArray(), true).toCharArray());
            res.setDeclarationPackageName(variableBinding.getDeclaringClass().getPackage().getName().toCharArray());
            res.setDeclarationTypeName(variableBinding.getDeclaringClass().getQualifiedName().toCharArray());
            if (variableBinding.getType().getPackage() != null) {
                res.setPackageName(variableBinding.getType().getPackage().getName().toCharArray());
            }
            res.setTypeName(variableBinding.getType().getQualifiedName().toCharArray());
            res.setName(variableBinding.getName().toCharArray());
            res.setCompletion(("import static " + variableBinding.getDeclaringClass().getQualifiedName() + "." + variableBinding.getName() + ";\n").toCharArray());
            res.setFlags(variableBinding.getModifiers());
            res.setAdditionalFlags(1);
        } else if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding2 = (ITypeBinding)binding;
            res = this.createProposal(23);
            res.setDeclarationSignature(typeBinding2.getPackage().getName().toCharArray());
            res.setSignature(DOMCompletionEngineBuilder.getSignature(typeBinding2));
            res.setPackageName(typeBinding2.getPackage().getName().toCharArray());
            res.setTypeName(typeBinding2.getQualifiedName().toCharArray());
            res.setAdditionalFlags(0);
            StringBuilder importCompletionBuilder = new StringBuilder("import ");
            importCompletionBuilder.append(typeBinding2.getQualifiedName().replace('$', '.'));
            importCompletionBuilder.append(';');
            importCompletionBuilder.append('\n');
            res.setCompletion(importCompletionBuilder.toString().toCharArray());
        }
        if (res != null) {
            int place;
            CompilationUnit cu = (CompilationUnit)this.toComplete.getRoot();
            List imports = cu.imports();
            if (!imports.isEmpty()) {
                int lastIndex = imports.size() - 1;
                place = ((ASTNode)imports.get(lastIndex)).getStartPosition() + ((ASTNode)imports.get(lastIndex)).getLength();
            } else {
                place = cu.getPackage() != null ? cu.getPackage().getStartPosition() + cu.getPackage().getLength() : 0;
            }
            if (this.cuBuffer != null && place != 0) {
                if (this.cuBuffer.getChar(place) == '\n') {
                    ++place;
                } else if (this.cuBuffer.getChar(place) == '\r' && this.cuBuffer.getChar(place + 1) == '\n') {
                    place += 2;
                }
            }
            res.setReplaceRange(place, place);
            res.setTokenRange(place, place);
            return res;
        }
        throw new IllegalArgumentException("unexpected binding type: " + String.valueOf(binding.getClass()));
    }

    private CompletionProposal toAnnotationAttributeRefProposal(IMethodBinding method) {
        InternalCompletionProposal proposal = this.createProposal(13);
        ((CompletionProposal)proposal).setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(method.getDeclaringClass()));
        ((CompletionProposal)proposal).setSignature(DOMCompletionEngineBuilder.getSignature(method.getReturnType()));
        ((CompletionProposal)proposal).setName(method.getName().toCharArray());
        char[] completion = method.getName().toCharArray();
        if ("insert".equals(this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true))) {
            completion = CharOperation.concat((char[])completion, (char[])new char[]{' '});
        }
        completion = CharOperation.concat((char[])completion, (char[])new char[]{'='});
        if ("insert".equals(this.modelUnit.getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", true))) {
            completion = CharOperation.concat((char[])completion, (char[])new char[]{' '});
        }
        ((CompletionProposal)proposal).setCompletion(completion);
        ((CompletionProposal)proposal).setFlags(method.getModifiers());
        this.setRange(proposal);
        ASTNode aSTNode = this.toComplete;
        if (aSTNode instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)aSTNode;
            ((CompletionProposal)proposal).setReplaceRange(simpleName.getStartPosition(), simpleName.getStartPosition() + simpleName.getLength());
            ((CompletionProposal)proposal).setTokenRange(simpleName.getStartPosition(), simpleName.getStartPosition() + simpleName.getLength());
        }
        int relevance = 36 + DOMCompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), method.getName().toCharArray(), this.assistOptions) + 3 + 3;
        ((CompletionProposal)proposal).setRelevance(relevance);
        return proposal;
    }

    private CompletionProposal toJavadocBlockTagProposal(char[] blockTag) {
        InternalCompletionProposal res = this.createProposal(19);
        res.setName(blockTag);
        StringBuilder completion = new StringBuilder();
        completion.append('@');
        completion.append(blockTag);
        res.setCompletion(completion.toString().toCharArray());
        this.setRange(res);
        ASTNode replaceNode = this.toComplete;
        if (replaceNode instanceof TextElement) {
            replaceNode = replaceNode.getParent();
        }
        res.setReplaceRange(replaceNode.getStartPosition(), replaceNode.getStartPosition() + replaceNode.getLength());
        res.setRelevance(38);
        return res;
    }

    private CompletionProposal toJavadocInlineTagProposal(char[] inlineTag) {
        InternalCompletionProposal res = this.createProposal(20);
        res.setName(inlineTag);
        StringBuilder completion = new StringBuilder();
        completion.append('{');
        completion.append('@');
        completion.append(inlineTag);
        completion.append('}');
        res.setCompletion(completion.toString().toCharArray());
        this.setRange(res);
        ASTNode replaceNode = this.toComplete;
        if (replaceNode instanceof TextElement) {
            replaceNode = replaceNode.getParent();
        }
        res.setReplaceRange(replaceNode.getStartPosition(), replaceNode.getStartPosition() + replaceNode.getLength());
        res.setRelevance(38);
        return res;
    }

    private int computeRelevanceForExpectingType(ITypeBinding proposalType) {
        if (proposalType != null) {
            int relevance = 0;
            if (!this.expectedTypes.getExpectedTypes().isEmpty() && PrimitiveType.VOID.toString().equals(proposalType.getName())) {
                return -5;
            }
            for (ITypeBinding expectedType : this.expectedTypes.getExpectedTypes()) {
                if (this.expectedTypes.allowsSubtypes() && proposalType.getErasure().isSubTypeCompatible(expectedType.getErasure())) {
                    if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                        return 30;
                    }
                    if (proposalType.getPackage() != null && proposalType.getPackage().isUnnamed()) {
                        return 25;
                    }
                    relevance = 20;
                }
                if (!this.expectedTypes.allowsSupertypes() || !expectedType.isSubTypeCompatible(proposalType)) continue;
                if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                    return 30;
                }
                relevance = 20;
            }
            return relevance;
        }
        return 0;
    }

    private Map<String, IModuleDescription> getAllJarModuleNames(IJavaProject project) {
        HashMap<String, IModuleDescription> modules = new HashMap<String, IModuleDescription>();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root instanceof JarPackageFragmentRoot) {
                    String name;
                    IModuleDescription desc = root.getModuleDescription();
                    desc = desc == null ? ((JarPackageFragmentRoot)root).getAutomaticModuleDescription() : desc;
                    String string = name = desc != null ? desc.getElementName() : null;
                    if (name != null && name.length() > 0) {
                        modules.putIfAbsent(name, desc);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return modules;
    }

    private void findModules(char[] prefix, IJavaProject project, AssistOptions options, Set<String> skip) {
        if (this.requestor.isIgnored(29)) {
            return;
        }
        HashMap<String, IModuleDescription> probableModules = new HashMap<String, IModuleDescription>();
        ModuleSourcePathManager mManager = JavaModelManager.getModulePathManager();
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        try {
            IModuleDescription[] modules;
            mManager.seekModule(prefix, true, javaElementRequestor);
            IModuleDescription[] iModuleDescriptionArray = modules = javaElementRequestor.getModules();
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleDescription module = iModuleDescriptionArray[n2];
                String name = module.getElementName();
                if (name != null && !name.equals("")) {
                    probableModules.putIfAbsent(name, module);
                }
                ++n2;
            }
        }
        catch (JavaModelException modules) {
            // empty catch block
        }
        probableModules.putAll(this.getAllJarModuleNames(project));
        Set<String> requiredModules = this.collectRequiredModules(probableModules);
        ArrayList<String> removeList = new ArrayList<String>();
        if (prefix != CharOperation.ALL_PREFIX && prefix != null && prefix.length > 0) {
            for (String key : probableModules.keySet()) {
                if (!CompletionEngine.isFailedMatch(prefix, key.toCharArray(), options)) continue;
                removeList.add(key);
            }
        }
        for (String key : removeList) {
            probableModules.remove(key);
        }
        removeList.clear();
        for (String key : skip) {
            probableModules.remove(key);
        }
        probableModules.entrySet().forEach(m -> this.requestor.accept(this.toModuleCompletion((String)m.getKey(), prefix, requiredModules)));
    }

    private Set<String> collectRequiredModules(Map<String, IModuleDescription> reachableModules) {
        HashSet<String> requiredModules;
        block7: {
            requiredModules = new HashSet<String>();
            requiredModules.add("java.base");
            try {
                IModuleDescription ownDescription = this.modelUnit.getJavaProject().getModuleDescription();
                if (ownDescription != null && !ownDescription.getElementName().isEmpty()) {
                    ArrayDeque<String> moduleQueue = new ArrayDeque<String>();
                    requiredModules.add(ownDescription.getElementName());
                    String[] stringArray = ownDescription.getRequiredModuleNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String moduleName = stringArray[n2];
                        moduleQueue.add(moduleName);
                        ++n2;
                    }
                    while (!moduleQueue.isEmpty()) {
                        String top = (String)moduleQueue.pollFirst();
                        requiredModules.add(top);
                        if (!reachableModules.containsKey(top)) continue;
                        String[] stringArray2 = reachableModules.get(top).getRequiredModuleNames();
                        int n3 = stringArray2.length;
                        n = 0;
                        while (n < n3) {
                            String moduleName = stringArray2[n];
                            if (!requiredModules.contains(moduleName)) {
                                moduleQueue.add(moduleName);
                            }
                            ++n;
                        }
                    }
                    break block7;
                }
                return reachableModules.keySet();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return requiredModules;
    }

    private CompletionProposal toModuleCompletion(String moduleName, char[] prefix, Set<String> requiredModules) {
        char[] completion = moduleName.toCharArray();
        int relevance = CompletionEngine.computeBaseRelevance();
        relevance += CompletionEngine.computeRelevanceForResolution();
        relevance += this.nestedEngine.computeRelevanceForInterestingProposal();
        relevance += this.nestedEngine.computeRelevanceForCaseMatching(prefix, completion);
        relevance += this.nestedEngine.computeRelevanceForQualification(true);
        if (requiredModules.contains(moduleName)) {
            relevance += CompletionEngine.computeRelevanceForRestrictions(0);
        }
        InternalCompletionProposal proposal = this.createProposal(29);
        proposal.setModuleName(completion);
        proposal.setDeclarationSignature(completion);
        proposal.setCompletion(completion);
        ImportDeclaration importDecl = (ImportDeclaration)DOMCompletionUtil.findParent(this.toComplete, new int[]{26});
        proposal.setReplaceRange(importDecl.getName().getStartPosition(), importDecl.getName().getStartPosition() + importDecl.getName().getLength());
        proposal.setRelevance(relevance);
        return proposal;
    }

    protected InternalCompletionProposal createProposal(int kind) {
        DOMInternalCompletionProposal proposal = new DOMInternalCompletionProposal(kind, this.offset);
        proposal.nameLookup = this.nameEnvironment.nameLookup;
        proposal.completionEngine = this.nestedEngine;
        return proposal;
    }

    protected boolean isFailedMatch(char[] orphanedContent, char[] name) {
        if (name.length < orphanedContent.length) {
            return true;
        }
        return !(this.assistOptions.substringMatch && CharOperation.substringMatch((char[])orphanedContent, (char[])name) || this.assistOptions.camelCaseMatch && CharOperation.camelCaseMatch((char[])orphanedContent, (char[])name) || CharOperation.prefixEquals((char[])orphanedContent, (char[])name, (boolean)false) || this.assistOptions.subwordMatch && CharOperation.subWordMatch((char[])orphanedContent, (char[])name));
    }

    static int computeRelevanceForCaseMatching(char[] token, char[] proposalName, AssistOptions options) {
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)true)) {
            return 14;
        }
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)false)) {
            return 4;
        }
        if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)false)) {
            if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)true)) {
                return 10;
            }
        } else {
            if (options.camelCaseMatch && CharOperation.camelCaseMatch((char[])token, (char[])proposalName)) {
                return 5;
            }
            if (options.substringMatch && CharOperation.substringMatch((char[])token, (char[])proposalName)) {
                return -21;
            }
            if (options.subwordMatch && CharOperation.subWordMatch((char[])token, (char[])proposalName)) {
                return -22;
            }
        }
        return 0;
    }

    private CompletionProposal createKeywordProposal(char[] keyword, int startPos, int endPos) {
        int relevance = 39 + CompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), keyword, this.assistOptions);
        InternalCompletionProposal keywordProposal = this.createProposal(3);
        ((CompletionProposal)keywordProposal).setCompletion(keyword);
        ((CompletionProposal)keywordProposal).setName(keyword);
        if (startPos == -1 && endPos == -1) {
            this.setRange(keywordProposal);
        } else {
            ((CompletionProposal)keywordProposal).setReplaceRange(startPos, endPos);
        }
        ((CompletionProposal)keywordProposal).setRelevance(relevance);
        return keywordProposal;
    }

    private CompletionProposal createClassKeywordProposal(ITypeBinding typeBinding, int startPos, int endPos) {
        int relevance = 59;
        if (!this.isFailedMatch(this.prefix.toCharArray(), Keywords.CLASS)) {
            relevance -= 21;
        }
        InternalCompletionProposal keywordProposal = this.createProposal(2);
        keywordProposal.setCompletion(Keywords.CLASS);
        keywordProposal.setReplaceRange(startPos, endPos);
        keywordProposal.setRelevance(relevance);
        keywordProposal.setPackageName(CharOperation.concatWith((char[][])TypeConstants.JAVA_LANG, (char)'.'));
        keywordProposal.setTypeName("Class".toCharArray());
        keywordProposal.setName(Keywords.CLASS);
        StringBuilder builder = new StringBuilder();
        builder.append("Ljava.lang.Class<");
        String typeBindingKey = typeBinding.getKey().replace('/', '.');
        builder.append(typeBindingKey);
        builder.append(">;");
        keywordProposal.setSignature(builder.toString().toCharArray());
        return keywordProposal;
    }

    private CompletionProposal createLambdaExpressionProposal(IMethodBinding method) {
        InternalCompletionProposal res = this.createProposal(30);
        int relevance = 30;
        relevance += 30;
        relevance += 20;
        ++relevance;
        relevance += 5;
        relevance += 3;
        int length = method.getParameterTypes().length;
        char[][] parameterTypeNames = new char[length][];
        int j = 0;
        while (j < length) {
            ITypeBinding p = method.getParameterTypes()[j];
            parameterTypeNames[j] = p.getQualifiedName().toCharArray();
            ++j;
        }
        char[][] parameterNames = (char[][])Stream.of(method.getParameterNames()).map(s -> s.toCharArray()).toArray(n -> new char[n][]);
        res.setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(method.getDeclaringClass()));
        res.setSignature(DOMCompletionEngineBuilder.getSignature(method));
        IMethodBinding original = method.getMethodDeclaration();
        if (original != method) {
            res.setOriginalSignature(DOMCompletionEngineBuilder.getSignature(original));
        }
        this.setRange(res);
        res.setRelevance(relevance);
        res.setCompletion(LAMBDA);
        res.setParameterTypeNames(parameterTypeNames);
        res.setFlags(method.getModifiers());
        res.setDeclarationPackageName(method.getDeclaringClass().getPackage().getName().toCharArray());
        res.setDeclarationTypeName(method.getDeclaringClass().getQualifiedName().toCharArray());
        res.setName(method.getName().toCharArray());
        res.setTypeName(method.getReturnType().getQualifiedName().toCharArray());
        if (parameterNames != null) {
            res.setParameterNames(parameterNames);
        }
        return res;
    }

    private int computeRelevanceForQualification(boolean prefixRequired) {
        boolean insideQualifiedReference;
        boolean bl = insideQualifiedReference = !this.prefix.equals(this.qualifiedPrefix);
        if (!prefixRequired && !insideQualifiedReference) {
            return 3;
        }
        if (prefixRequired && insideQualifiedReference) {
            return 2;
        }
        return 0;
    }

    private void setRange(CompletionProposal completionProposal) {
        int startPos = this.offset - this.prefix.length();
        int cursor = this.offset;
        while (cursor < this.cuBuffer.getLength() && Character.isJavaIdentifierPart(this.cuBuffer.getChar(cursor))) {
            ++cursor;
        }
        completionProposal.setReplaceRange(startPos, cursor);
        completionProposal.setTokenRange(startPos, cursor);
    }

    private boolean isVisible(IBinding binding) {
        if (binding == null) {
            return false;
        }
        if (Modifier.isPublic(binding.getModifiers())) {
            return true;
        }
        if (Modifier.isPrivate(binding.getModifiers())) {
            return binding.isEqualTo(DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding());
        }
        ITypeBinding declaringClass = this.getDeclaringClass(binding);
        if (declaringClass == null) {
            return false;
        }
        if (Modifier.isProtected(binding.getModifiers())) {
            return declaringClass.isSubTypeCompatible(DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding());
        }
        return declaringClass.getPackage().isEqualTo(DOMCompletionUtil.findParentTypeDeclaration(this.toComplete).resolveBinding().getPackage());
    }

    private ITypeBinding getDeclaringClass(IBinding binding) {
        ITypeBinding iTypeBinding;
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding;
            iTypeBinding = typeBinding = (ITypeBinding)binding;
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            iTypeBinding = methodBinding.getDeclaringClass();
        } else {
            IVariableBinding variableBinding;
            iTypeBinding = binding instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).isField() ? variableBinding.getDeclaringClass() : null;
        }
        return iTypeBinding;
    }

    private /* synthetic */ boolean lambda$28(ExtendsOrImplementsInfo extendsOrImplementsInfo, IType type) {
        return this.filterBasedOnExtendsOrImplementsInfo(type, extendsOrImplementsInfo);
    }

    private static /* synthetic */ boolean lambda$82(Bindings bindings, IType type) {
        return bindings.all().map(typeBinding -> typeBinding.getJavaElement()).noneMatch(elt -> type.equals(elt));
    }

    static class Bindings {
        private List<IBinding> others = new ArrayList<IBinding>();

        Bindings() {
        }

        public void add(IBinding binding) {
            if (binding instanceof IMethodBinding) {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                if (methodBinding.isConstructor()) {
                    return;
                }
                if (this.methods().anyMatch(method -> method.overrides(methodBinding))) {
                    return;
                }
                this.others.removeIf(existing -> {
                    IMethodBinding existingMethod;
                    return existing instanceof IMethodBinding && methodBinding.overrides(existingMethod = (IMethodBinding)existing);
                });
            }
            if (binding != null) {
                this.others.add(binding);
            }
        }

        public void addAll(Collection<? extends IBinding> bindings) {
            bindings.forEach(this::add);
        }

        public Stream<IBinding> all() {
            return this.others.stream().distinct();
        }

        public Stream<IMethodBinding> methods() {
            return this.all().filter(IMethodBinding.class::isInstance).map(IMethodBinding.class::cast);
        }
    }

    private static class DOMInternalCompletionProposal
    extends InternalCompletionProposal {
        public DOMInternalCompletionProposal(int kind, int completionLocation) {
            super(kind, completionLocation);
        }

        @Override
        public boolean canUseDiamond(CompletionContext coreContext) {
            if (!coreContext.isExtended()) {
                return false;
            }
            if (coreContext instanceof DOMCompletionContext) {
                char[] sign;
                DOMCompletionContext domCompletionContext = (DOMCompletionContext)coreContext;
                char[] name1 = this.declarationPackageName;
                char[] name2 = this.declarationTypeName;
                char[] declarationType = CharOperation.concat((char[])name1, (char[])name2, (char)'.');
                char[] cArray = sign = this.originalSignature != null ? this.originalSignature : this.getSignature();
                if (sign != null && sign.length >= 2) {
                    sign = Signature.removeCapture(sign);
                }
                char[][] types = Signature.getParameterTypes(sign);
                String[] paramTypeNames = new String[types.length];
                int i = 0;
                while (i < types.length) {
                    paramTypeNames[i] = new String(Signature.toCharArray(types[i]));
                    ++i;
                }
                if (this.getDeclarationTypeVariables() != null) {
                    return domCompletionContext.canUseDiamond(paramTypeNames, this.getDeclarationTypeVariables());
                }
                return domCompletionContext.canUseDiamond(paramTypeNames, declarationType);
            }
            return false;
        }
    }

    private record ExtendsOrImplementsInfo(AbstractTypeDeclaration typeDecl, boolean isImplements) {
    }

    private static enum JavadocMethodReferenceParseState {
        BEFORE_IDENTIFIER,
        IN_IDENTIFIER,
        AFTER_IDENTIFIER;

    }

    record TrueFalseBindings(List<IVariableBinding> trueBindings, List<IVariableBinding> falseBindings) {
    }
}

