/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtil;
import org.eclipse.jdt.internal.compiler.parser.JavadocTagConstants;

class DOMCompletionEngineJavadocUtil {
    private static final List<char[]> JAVA_8_BLOCK_TAGS;
    private static final List<char[]> JAVA_9_BLOCK_TAGS;
    private static final List<char[]> JAVA_8_INLINE_TAGS;
    private static final List<char[]> JAVA_9_INLINE_TAGS;
    private static final List<char[]> JAVA_10_INLINE_TAGS;
    private static final List<char[]> JAVA_12_INLINE_TAGS;
    private static final List<char[]> JAVA_16_INLINE_TAGS;
    private static final List<char[]> JAVA_18_INLINE_TAGS;
    private static final Set<char[]> FIELD_TAGS_SET;
    private static final Set<char[]> CLASS_TAGS_SET;
    private static final Set<char[]> METHOD_TAGS_SET;
    private static final Set<char[]> PACKAGE_TAGS_SET;

    static {
        int n;
        char[][] cArray;
        JAVA_8_BLOCK_TAGS = new ArrayList<char[]>();
        int i = 0;
        while (i < 4) {
            cArray = JavadocTagConstants.BLOCK_TAGS_RAW[i].tags();
            int n2 = cArray.length;
            n = 0;
            while (n < n2) {
                char[] entry = cArray[n];
                JAVA_8_BLOCK_TAGS.add(entry);
                ++n;
            }
            ++i;
        }
        JAVA_9_BLOCK_TAGS = new ArrayList<char[]>();
        JAVA_9_BLOCK_TAGS.addAll(JAVA_8_BLOCK_TAGS);
        char[][] cArray2 = JavadocTagConstants.BLOCK_TAGS_RAW[4].tags();
        n = cArray2.length;
        int entry = 0;
        while (entry < n) {
            char[] entry2 = cArray2[entry];
            JAVA_9_BLOCK_TAGS.add(entry2);
            ++entry;
        }
        JAVA_8_INLINE_TAGS = new ArrayList<char[]>();
        i = 0;
        while (i < 4) {
            cArray = JavadocTagConstants.INLINE_TAGS_RAW[i].tags();
            int n3 = cArray.length;
            n = 0;
            while (n < n3) {
                char[] entry3 = cArray[n];
                JAVA_8_INLINE_TAGS.add(entry3);
                ++n;
            }
            ++i;
        }
        JAVA_9_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_9_INLINE_TAGS.addAll(JAVA_8_INLINE_TAGS);
        char[][] cArray3 = JavadocTagConstants.INLINE_TAGS_RAW[4].tags();
        n = cArray3.length;
        int n4 = 0;
        while (n4 < n) {
            char[] entry4 = cArray3[n4];
            JAVA_9_INLINE_TAGS.add(entry4);
            ++n4;
        }
        JAVA_10_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_10_INLINE_TAGS.addAll(JAVA_9_INLINE_TAGS);
        cArray3 = JavadocTagConstants.INLINE_TAGS_RAW[5].tags();
        n = cArray3.length;
        n4 = 0;
        while (n4 < n) {
            char[] entry5 = cArray3[n4];
            JAVA_10_INLINE_TAGS.add(entry5);
            ++n4;
        }
        JAVA_12_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_12_INLINE_TAGS.addAll(JAVA_10_INLINE_TAGS);
        cArray3 = JavadocTagConstants.INLINE_TAGS_RAW[6].tags();
        n = cArray3.length;
        n4 = 0;
        while (n4 < n) {
            char[] entry6 = cArray3[n4];
            JAVA_12_INLINE_TAGS.add(entry6);
            ++n4;
        }
        JAVA_16_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_16_INLINE_TAGS.addAll(JAVA_12_INLINE_TAGS);
        cArray3 = JavadocTagConstants.INLINE_TAGS_RAW[7].tags();
        n = cArray3.length;
        n4 = 0;
        while (n4 < n) {
            char[] entry7 = cArray3[n4];
            JAVA_16_INLINE_TAGS.add(entry7);
            ++n4;
        }
        JAVA_18_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_18_INLINE_TAGS.addAll(JAVA_16_INLINE_TAGS);
        cArray3 = JavadocTagConstants.INLINE_TAGS_RAW[8].tags();
        n = cArray3.length;
        n4 = 0;
        while (n4 < n) {
            char[] entry8 = cArray3[n4];
            JAVA_18_INLINE_TAGS.add(entry8);
            ++n4;
        }
        FIELD_TAGS_SET = Stream.of(JavadocTagConstants.FIELD_TAGS).collect(Collectors.toSet());
        CLASS_TAGS_SET = Stream.of(JavadocTagConstants.CLASS_TAGS).collect(Collectors.toSet());
        METHOD_TAGS_SET = Stream.of(JavadocTagConstants.METHOD_TAGS).collect(Collectors.toSet());
        PACKAGE_TAGS_SET = Stream.of(JavadocTagConstants.PACKAGE_TAGS).collect(Collectors.toSet());
    }

    DOMCompletionEngineJavadocUtil() {
    }

    public static List<char[]> getJavadocBlockTags(IJavaProject project, TagElement tagNode) {
        String projectVersion = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        List<char[]> tagsForVersion = projectVersion.contains(".") || Integer.parseInt(projectVersion) < 9 ? JAVA_8_BLOCK_TAGS : JAVA_9_BLOCK_TAGS;
        return DOMCompletionEngineJavadocUtil.tagsForNode(tagsForVersion, tagNode);
    }

    public static List<char[]> getJavadocInlineTags(IJavaProject project, TagElement tagNode) {
        int versionNumber;
        String projectVersion = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        List<char[]> tagsForVersion = projectVersion.contains(".") ? JAVA_8_INLINE_TAGS : ((versionNumber = Integer.parseInt(projectVersion)) < 9 ? JAVA_8_INLINE_TAGS : (versionNumber < 10 ? JAVA_9_INLINE_TAGS : (versionNumber < 12 ? JAVA_10_INLINE_TAGS : (versionNumber < 16 ? JAVA_12_INLINE_TAGS : (versionNumber < 18 ? JAVA_16_INLINE_TAGS : JAVA_18_INLINE_TAGS)))));
        return DOMCompletionEngineJavadocUtil.tagsForNode(tagsForVersion, tagNode);
    }

    private static List<char[]> tagsForNode(List<char[]> tagsForVersion, TagElement tagNode) {
        boolean isPackage;
        boolean isType;
        boolean isMethod;
        boolean isField;
        boolean bl = isField = DOMCompletionUtil.findParent(tagNode, new int[]{23}) != null;
        if (isField) {
            return tagsForVersion.stream().filter(tag -> FIELD_TAGS_SET.contains(tag)).toList();
        }
        ASTNode astNode = DOMCompletionUtil.findParent(tagNode, new int[]{31, 55, 71, 103, 81, 56});
        boolean bl2 = isMethod = astNode != null && astNode.getNodeType() == 31;
        if (isMethod) {
            return tagsForVersion.stream().filter(tag -> METHOD_TAGS_SET.contains(tag)).toList();
        }
        boolean bl3 = isType = astNode != null;
        if (isType) {
            return tagsForVersion.stream().filter(tag -> CLASS_TAGS_SET.contains(tag)).filter(tag -> {
                if (JavadocTagConstants.TAG_PARAM.equals(tag)) {
                    return ((AbstractTypeDeclaration)astNode).resolveBinding().isGenericType();
                }
                return true;
            }).toList();
        }
        boolean bl4 = isPackage = DOMCompletionUtil.findParent(tagNode, new int[]{35}) != null;
        if (isPackage) {
            return tagsForVersion.stream().filter(tag -> PACKAGE_TAGS_SET.contains(tag)).toList();
        }
        throw new IllegalStateException("I was expecting one of the above nodes to be documented");
    }
}

