/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BasicModule;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;

public class ClasspathMultiDirectory
extends ClasspathDirectory {
    IContainer sourceFolder;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;
    boolean hasIndependentOutputFolder;
    public boolean ignoreOptionalProblems;

    ClasspathMultiDirectory(IContainer sourceFolder, IContainer binaryFolder, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean ignoreOptionalProblems, IPath externalAnnotationPath) {
        super(binaryFolder, true, null, externalAnnotationPath, false);
        this.sourceFolder = sourceFolder;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.hasIndependentOutputFolder = false;
        this.ignoreOptionalProblems = ignoreOptionalProblems;
        if (this.inclusionPatterns != null && this.inclusionPatterns.length == 0) {
            this.inclusionPatterns = null;
        }
        if (this.exclusionPatterns != null && this.exclusionPatterns.length == 0) {
            this.exclusionPatterns = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathMultiDirectory)) {
            return false;
        }
        ClasspathMultiDirectory md = (ClasspathMultiDirectory)o;
        return this.ignoreOptionalProblems == md.ignoreOptionalProblems && this.sourceFolder.equals((Object)md.sourceFolder) && this.binaryFolder.equals((Object)md.binaryFolder) && CharOperation.equals((char[][])this.inclusionPatterns, (char[][])md.inclusionPatterns) && CharOperation.equals((char[][])this.exclusionPatterns, (char[][])md.exclusionPatterns);
    }

    @Override
    protected boolean isExcluded(IResource resource) {
        if ((this.exclusionPatterns != null || this.inclusionPatterns != null) && this.sourceFolder.equals((Object)this.binaryFolder)) {
            return org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, this.inclusionPatterns, this.exclusionPatterns);
        }
        return false;
    }

    @Override
    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                String name;
                IResource m;
                int n;
                int n2;
                IResource[] iResourceArray;
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                boolean foundClass = false;
                if (members.length > 0) {
                    iResourceArray = members;
                    n2 = members.length;
                    n = 0;
                    while (n < n2) {
                        boolean isClass;
                        m = iResourceArray[n];
                        name = m.getName();
                        boolean bl = isClass = m.getType() == 1 && Util.isClassFileName((String)name);
                        if (m.getType() == 2 || isClass) {
                            dirList[index++] = name;
                            foundClass |= isClass;
                        }
                        ++n;
                    }
                }
                if (!foundClass && (container = this.sourceFolder.findMember(qualifiedPackageName)) instanceof IContainer && (members = ((IContainer)container).members()).length > 0) {
                    dirList = new String[members.length];
                    index = 0;
                    iResourceArray = members;
                    n2 = members.length;
                    n = 0;
                    while (n < n2) {
                        m = iResourceArray[n];
                        name = m.getName();
                        if (m.getType() == 2 || m.getType() == 1 && Util.isJavaFileName((String)name)) {
                            dirList[index++] = name;
                        }
                        ++n;
                    }
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString() + " with " + super.toString();
    }

    public void acceptModuleInfo(ICompilationUnit cu, Parser parser) {
        CompilationResult compilationResult = new CompilationResult(cu, 0, 1, 10);
        CompilationUnitDeclaration unit = parser.parse(cu, compilationResult);
        if (unit.isModuleInfo() && unit.moduleDeclaration != null) {
            this.module = new BasicModule(unit.moduleDeclaration, null);
        }
    }

    @Override
    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule module() {
        return this.module;
    }
}

