/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddImportCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ReplaceCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.corrections.ReturnTypeSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.SerialVersionSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.SuppressWarningsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.UnInitializedFinalFieldSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.GetterSetterCorrectionSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.GradleCompatibilityProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LocalCorrectionsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ReorgCorrectionsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeMismatchSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.OrganizeImportsHandler;
import org.eclipse.jdt.ls.core.internal.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.lsp4j.CodeActionParams;

public class QuickFixProcessor {
    private static int moveBack(int offset, int start, String ignoreCharacters, ICompilationUnit cu) {
        try {
            IBuffer buf = cu.getBuffer();
            while (offset >= start) {
                if (ignoreCharacters.indexOf(buf.getChar(offset - 1)) == -1) {
                    return offset;
                }
                --offset;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return start;
    }

    public List<ProposalKindWrapper> getCorrections(CodeActionParams params, IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProposalKindWrapper> resultingCollections = new ArrayList<ProposalKindWrapper>();
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            if (QuickFixProcessor.handledProblems(curr, locations, handledProblems)) {
                this.process(params, context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections;
    }

    private static boolean handledProblems(IProblemLocation location, IProblemLocation[] locations, Set<Integer> handledProblems) {
        int problemId = location.getProblemId();
        if (handledProblems.contains(problemId)) {
            return false;
        }
        if (problemId == 0x22000032) {
            IProblemLocation[] iProblemLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemLocation l = iProblemLocationArray[n2];
                if (l.getProblemId() == 0x1000002 && Arrays.deepEquals(l.getProblemArguments(), location.getProblemArguments())) {
                    handledProblems.add(problemId);
                    return false;
                }
                ++n2;
            }
        }
        return handledProblems.add(problemId);
    }

    private void process(CodeActionParams params, IInvocationContext context, IProblemLocation problem, Collection<ProposalKindWrapper> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 1610612995: {
                String quoteLabel = CorrectionMessages.JavaCorrectionProcessor_addquote_description;
                int pos = QuickFixProcessor.moveBack(problem.getOffset() + problem.getLength(), problem.getOffset(), "\n\r", context.getCompilationUnit());
                ReplaceCorrectionProposalCore prop = new ReplaceCorrectionProposalCore(quoteLabel, context.getCompilationUnit(), pos, 0, "\"", 0);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)prop, "quickfix"));
                break;
            }
            case 0x10000181: 
            case 268435842: 
            case 268435843: 
            case 268435844: 
            case 268435846: {
                ReorgCorrectionsSubProcessor.removeImportStatementProposals(context, problem, proposals);
                break;
            }
            case 16777541: {
                ReorgCorrectionsSubProcessor.getWrongTypeNameProposals(context, problem, proposals);
                break;
            }
            case 536871240: {
                ReorgCorrectionsSubProcessor.getWrongPackageDeclNameProposals(context, problem, proposals);
                break;
            }
            case 0x4000064: {
                UnresolvedElementsSubProcessor.getMethodProposals(context, problem, false, proposals);
                break;
            }
            case 0x8000082: {
                UnresolvedElementsSubProcessor.getConstructorProposals(context, problem, proposals);
                break;
            }
            case 67109475: {
                UnresolvedElementsSubProcessor.getAnnotationMemberProposals(context, problem, proposals);
                break;
            }
            case 67108979: {
                UnresolvedElementsSubProcessor.getMethodProposals(context, problem, true, proposals);
                break;
            }
            case 33554502: 
            case 33554515: 
            case 0x22000032: {
                UnresolvedElementsSubProcessor.getVariableProposals(context, problem, null, proposals);
                break;
            }
            case 33554513: {
                UnInitializedFinalFieldSubProcessor processor = new UnInitializedFinalFieldSubProcessor();
                processor.addProposals(context, problem, proposals);
                break;
            }
            case -1610612231: 
            case 0x1000004: {
                UnresolvedElementsSubProcessor.getAmbiguousTypeReferenceProposals(context, problem, proposals);
                break;
            }
            case -1610612233: 
            case 0x1000002: {
                UnresolvedElementsSubProcessor.getTypeProposals(context, problem, proposals);
                break;
            }
            case 0x1000011: 
            case 0x1000013: {
                TypeMismatchSubProcessor.addTypeMismatchProposals(context, problem, proposals);
                break;
            }
            case 16777796: {
                TypeMismatchSubProcessor.addTypeMismatchInForEachProposals(context, problem, proposals);
                break;
            }
            case 67109268: {
                TypeMismatchSubProcessor.addIncompatibleReturnTypeProposals(context, problem, proposals);
                break;
            }
            case 67109266: {
                TypeMismatchSubProcessor.addIncompatibleThrowsProposals(context, problem, proposals);
                break;
            }
            case 16777384: 
            case 16778098: {
                LocalCorrectionsSubProcessor.addUncaughtExceptionProposals(context, problem, proposals);
                break;
            }
            case 83886247: 
            case 553648315: 
            case 553649001: {
                LocalCorrectionsSubProcessor.addUnreachableCatchProposals(context, problem, proposals);
                break;
            }
            case 16777547: {
                LocalCorrectionsSubProcessor.addRedundantSuperInterfaceProposal(context, problem, proposals);
                break;
            }
            case 67108969: {
                ReturnTypeSubProcessor.addVoidMethodReturnsProposals(context, problem, proposals);
                break;
            }
            case 67108970: {
                ReturnTypeSubProcessor.addMethodReturnsVoidProposals(context, problem, proposals);
                break;
            }
            case 16777327: {
                ReturnTypeSubProcessor.addMissingReturnTypeProposals(context, problem, proposals);
                break;
            }
            case 0x4000303: 
            case 603979884: {
                ReturnTypeSubProcessor.addMissingReturnStatementProposals(context, problem, proposals);
                break;
            }
            case 0x4000054: 
            case 570425420: 
            case 570425422: 
            case 603979893: 
            case 603979895: {
                LocalCorrectionsSubProcessor.addCorrectAccessToStaticProposals(context, problem, proposals);
                break;
            }
            case 16779066: 
            case 16779071: {
                ModifierCorrectionSubProcessor.addSealedMissingModifierProposal(context, problem, proposals);
                break;
            }
            case 16779073: 
            case 16779079: {
                LocalCorrectionsSubProcessor.addSealedAsDirectSuperTypeProposal(context, problem, proposals);
                break;
            }
            case 16779068: 
            case 16779069: {
                LocalCorrectionsSubProcessor.addTypeAsPermittedSubTypeProposal(context, problem, proposals);
                break;
            }
            case 33554506: 
            case 603979977: {
                LocalCorrectionsSubProcessor.addObjectReferenceProposal(context, problem, proposals);
                LocalCorrectionsSubProcessor.addVariableReferenceProposal(context, problem, proposals);
                LocalCorrectionsSubProcessor.addNewObjectProposal(context, problem, proposals);
            }
            case 0x8000087: 
            case 0x8000088: {
                ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal(context, problem, proposals, 1, 5);
                break;
            }
            case 0x100001D: 
            case 16777529: 
            case 0x2000050: 
            case 0x2000052: 
            case 536870969: 
            case 536870970: {
                ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal(context, problem, proposals, 5, 9);
                break;
            }
            case 67109269: 
            case 67109273: 
            case 67109274: {
                ModifierCorrectionSubProcessor.addChangeOverriddenModifierProposal(context, problem, proposals, 2);
                break;
            }
            case 67109265: {
                ModifierCorrectionSubProcessor.addChangeOverriddenModifierProposal(context, problem, proposals, 5);
                break;
            }
            case 67109270: {
                ModifierCorrectionSubProcessor.addChangeOverriddenModifierProposal(context, problem, proposals, 4);
                break;
            }
            case 16777518: 
            case 16777519: 
            case 0x1000130: 
            case 0x1000131: 
            case 16777522: 
            case 16777525: 
            case 16777966: 
            case 16777969: 
            case 33554774: 
            case 33554775: 
            case 33554777: 
            case 33554778: 
            case 33555183: 
            case 67109220: 
            case 67109222: 
            case 67109223: 
            case 67109225: 
            case 67109233: 
            case 67109260: 
            case 67109271: 
            case 67109624: 
            case 67109914: {
                ModifierCorrectionSubProcessor.addRemoveInvalidModifiersProposal(context, problem, proposals, 5);
                break;
            }
            case 33554503: {
                GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, problem, proposals, 9);
                ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal(context, problem, proposals, 2, 10);
                break;
            }
            case -1610612232: 
            case 0x1000003: 
            case 67108965: 
            case 0x8000083: {
                ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal(context, problem, proposals, 2, 10);
                break;
            }
            case 67109227: 
            case 67109622: 
            case 67109629: 
            case 603979889: {
                ModifierCorrectionSubProcessor.addAbstractMethodProposals(context, problem, proposals);
                break;
            }
            case 16777549: {
                ModifierCorrectionSubProcessor.addAbstractTypeProposals(context, problem, proposals);
                break;
            }
            case 67109264: 
            case 67109627: {
                LocalCorrectionsSubProcessor.addUnimplementedMethodsProposals(context, problem, proposals);
                break;
            }
            case 16777825: {
                LocalCorrectionsSubProcessor.addValueForAnnotationProposals(context, problem, proposals);
                break;
            }
            case 16777362: 
            case 0x800008C: 
            case 0x800008D: {
                LocalCorrectionsSubProcessor.addConstructorFromSuperclassProposal(context, problem, proposals);
                break;
            }
            case 536870973: 
            case 536870974: 
            case 536871193: 
            case 553648135: 
            case 570425421: 
            case 603979894: 
            case 603979910: {
                LocalCorrectionsSubProcessor.addUnusedMemberProposal(context, problem, proposals);
                break;
            }
            case 536871092: {
                LocalCorrectionsSubProcessor.addSuperfluousSemicolonProposal(context, problem, proposals);
                break;
            }
            case 553648309: {
                LocalCorrectionsSubProcessor.addUnnecessaryCastProposal(context, problem, proposals);
                break;
            }
            case 553648311: {
                LocalCorrectionsSubProcessor.addUnnecessaryInstanceofProposal(context, problem, proposals);
                break;
            }
            case 570425423: {
                LocalCorrectionsSubProcessor.addUnqualifiedFieldAccessProposal(context, problem, proposals);
                break;
            }
            case -1610612250: {
                ASTNode node = problem.getCoveringNode(context.getASTRoot());
                JavadocTagsSubProcessor.getMissingJavadocCommentProposals(context, node, proposals, "quickfix");
                break;
            }
            case -1610612265: 
            case -1610612261: 
            case -1610612259: {
                JavadocTagsSubProcessor.getMissingJavadocTagProposals(context, problem, proposals);
                break;
            }
            case -1610612266: 
            case -1610612263: 
            case -1610612262: 
            case -1610612260: 
            case -1610612256: 
            case -1610612255: 
            case -1610612249: {
                JavadocTagsSubProcessor.getRemoveJavadocTagProposals(context, problem, proposals);
                break;
            }
            case -1610612270: {
                JavadocTagsSubProcessor.getInvalidQualificationProposals(context, problem, proposals);
                break;
            }
            case 0x4000074: {
                UnresolvedElementsSubProcessor.getArrayAccessProposals(context, problem, proposals);
                break;
            }
            case 0x20000060: {
                SerialVersionSubProcessor.getSerialVersionProposals(context, problem, proposals);
                break;
            }
            case 536871101: {
                LocalCorrectionsSubProcessor.addUnnecessaryElseProposals(context, problem, proposals);
                break;
            }
            case 16777528: {
                LocalCorrectionsSubProcessor.addInterfaceExtendsClassProposals(context, problem, proposals);
                break;
            }
            case 536871061: 
            case 536871073: {
                LocalCorrectionsSubProcessor.getUnreachableCodeProposals(context, problem, proposals);
                break;
            }
            case 0x200000B2: {
                LocalCorrectionsSubProcessor.addAssignmentHasNoEffectProposals(context, problem, proposals);
                break;
            }
            case 16777747: 
            case 16777748: 
            case 16777788: {
                LocalCorrectionsSubProcessor.addDeprecatedFieldsToMethodsProposals(context, problem, proposals);
                break;
            }
            case 0x200000C2: {
                LocalCorrectionsSubProcessor.addFallThroughProposals(context, problem, proposals);
                break;
            }
            case 1102: 
            case 536871547: {
                SuppressWarningsSubProcessor.addRemoveUnusedSuppressWarningProposals(context, problem, proposals);
                break;
            }
            case 33555193: 
            case 536871678: 
            case 1073743533: {
                LocalCorrectionsSubProcessor.getMissingEnumConstantCaseProposals(context, problem, proposals);
                break;
            }
            case 2099060: 
            case 1073743531: {
                LocalCorrectionsSubProcessor.addPermittedTypesProposal(context, problem, proposals);
                break;
            }
            case 0x200002FF: {
                LocalCorrectionsSubProcessor.addMissingDefaultCaseProposal(context, problem, proposals);
                break;
            }
            case 2099059: {
                LocalCorrectionsSubProcessor.addRemoveDefaultCaseProposal(context, problem, proposals);
                break;
            }
            case 2099054: {
                LocalCorrectionsSubProcessor.addFallThroughProposals(context, problem, proposals);
                break;
            }
            case 0x2000300: {
                LocalCorrectionsSubProcessor.getMissingEnumConstantCaseProposals(context, problem, proposals);
                LocalCorrectionsSubProcessor.addCasesOmittedProposals(context, problem, proposals);
                break;
            }
            case 536871797: 
            case 536871799: {
                LocalCorrectionsSubProcessor.getTryWithResourceProposals(context, problem, proposals);
                break;
            }
            case 16778666: {
                GradleCompatibilityProcessor.getGradleCompatibilityProposals(context, problem, proposals);
                break;
            }
            case 16778522: 
            case 16778523: 
            case 16778524: {
                LocalCorrectionsSubProcessor.addServiceProviderConstructorProposals(context, problem, proposals);
                break;
            }
            case 33555187: {
                LocalCorrectionsSubProcessor.addIllegalQualifiedEnumConstantLabelProposal(context, problem, proposals);
                break;
            }
            default: {
                String str = problem.toString();
                System.out.println(str);
            }
        }
        SuppressWarningsSubProcessor.addSuppressWarningsProposals(context, problem, proposals);
    }

    public void addAddAllMissingImportsProposal(IInvocationContext context, Collection<ProposalKindWrapper> proposals) {
        CUCorrectionProposalCore proposal;
        if (proposals.size() == 0) {
            return;
        }
        Optional<Integer> minRelevance = proposals.stream().filter(w -> w.getProposal() instanceof AddImportCorrectionProposalCore).map(w -> w.getProposal().getRelevance()).min(Comparator.naturalOrder());
        if (minRelevance.isPresent() && (proposal = OrganizeImportsHandler.getOrganizeImportsProposal(CorrectionMessages.UnresolvedElementsSubProcessor_add_allMissing_imports_description, context.getCompilationUnit(), minRelevance.get() - 1, context.getASTRoot(), JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isAdvancedOrganizeImportsSupported(), true)) != null) {
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        }
    }
}

